/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class BroadcastResponseStats
implements Parcelable {
    private final String mPackageName;
    private final long mId;
    private int mBroadcastsDispatchedCount;
    private int mNotificationsPostedCount;
    private int mNotificationsUpdatedCount;
    private int mNotificationsCancelledCount;
    public static final Parcelable.Creator<BroadcastResponseStats> CREATOR = new Parcelable.Creator<BroadcastResponseStats>(){

        @Override
        public BroadcastResponseStats createFromParcel(Parcel source) {
            return new BroadcastResponseStats(source);
        }

        public BroadcastResponseStats[] newArray(int size) {
            return new BroadcastResponseStats[size];
        }
    };

    public BroadcastResponseStats(String packageName, long id2) {
        this.mPackageName = packageName;
        this.mId = id2;
    }

    private BroadcastResponseStats(Parcel in) {
        this.mPackageName = in.readString8();
        this.mId = in.readLong();
        this.mBroadcastsDispatchedCount = in.readInt();
        this.mNotificationsPostedCount = in.readInt();
        this.mNotificationsUpdatedCount = in.readInt();
        this.mNotificationsCancelledCount = in.readInt();
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public long getId() {
        return this.mId;
    }

    public int getBroadcastsDispatchedCount() {
        return this.mBroadcastsDispatchedCount;
    }

    public int getNotificationsPostedCount() {
        return this.mNotificationsPostedCount;
    }

    public int getNotificationsUpdatedCount() {
        return this.mNotificationsUpdatedCount;
    }

    public int getNotificationsCancelledCount() {
        return this.mNotificationsCancelledCount;
    }

    public void incrementBroadcastsDispatchedCount(int count) {
        this.mBroadcastsDispatchedCount += count;
    }

    public void incrementNotificationsPostedCount(int count) {
        this.mNotificationsPostedCount += count;
    }

    public void incrementNotificationsUpdatedCount(int count) {
        this.mNotificationsUpdatedCount += count;
    }

    public void incrementNotificationsCancelledCount(int count) {
        this.mNotificationsCancelledCount += count;
    }

    public void addCounts(BroadcastResponseStats stats) {
        this.incrementBroadcastsDispatchedCount(stats.getBroadcastsDispatchedCount());
        this.incrementNotificationsPostedCount(stats.getNotificationsPostedCount());
        this.incrementNotificationsUpdatedCount(stats.getNotificationsUpdatedCount());
        this.incrementNotificationsCancelledCount(stats.getNotificationsCancelledCount());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof BroadcastResponseStats)) {
            return false;
        }
        BroadcastResponseStats other = (BroadcastResponseStats)obj;
        return this.mBroadcastsDispatchedCount == other.mBroadcastsDispatchedCount && this.mNotificationsPostedCount == other.mNotificationsPostedCount && this.mNotificationsUpdatedCount == other.mNotificationsUpdatedCount && this.mNotificationsCancelledCount == other.mNotificationsCancelledCount && this.mId == other.mId && this.mPackageName.equals(other.mPackageName);
    }

    public int hashCode() {
        return Objects.hash(this.mPackageName, this.mId, this.mBroadcastsDispatchedCount, this.mNotificationsPostedCount, this.mNotificationsUpdatedCount, this.mNotificationsCancelledCount);
    }

    public String toString() {
        return "stats {package=" + this.mPackageName + ",id=" + this.mId + ",broadcastsSent=" + this.mBroadcastsDispatchedCount + ",notificationsPosted=" + this.mNotificationsPostedCount + ",notificationsUpdated=" + this.mNotificationsUpdatedCount + ",notificationsCancelled=" + this.mNotificationsCancelledCount + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString8(this.mPackageName);
        dest.writeLong(this.mId);
        dest.writeInt(this.mBroadcastsDispatchedCount);
        dest.writeInt(this.mNotificationsPostedCount);
        dest.writeInt(this.mNotificationsUpdatedCount);
        dest.writeInt(this.mNotificationsCancelledCount);
    }
}

