/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothCodecConfig;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class BluetoothCodecStatus
implements Parcelable {
    public static final String EXTRA_CODEC_STATUS = "android.bluetooth.extra.CODEC_STATUS";
    private final BluetoothCodecConfig mCodecConfig;
    private final List<BluetoothCodecConfig> mCodecsLocalCapabilities;
    private final List<BluetoothCodecConfig> mCodecsSelectableCapabilities;
    public static final Parcelable.Creator<BluetoothCodecStatus> CREATOR = new Parcelable.Creator<BluetoothCodecStatus>(){

        @Override
        public BluetoothCodecStatus createFromParcel(Parcel in) {
            return new BluetoothCodecStatus(in);
        }

        public BluetoothCodecStatus[] newArray(int size) {
            return new BluetoothCodecStatus[size];
        }
    };

    public BluetoothCodecStatus(BluetoothCodecConfig codecConfig, List<BluetoothCodecConfig> codecsLocalCapabilities, List<BluetoothCodecConfig> codecsSelectableCapabilities) {
        this.mCodecConfig = codecConfig;
        this.mCodecsLocalCapabilities = codecsLocalCapabilities;
        this.mCodecsSelectableCapabilities = codecsSelectableCapabilities;
    }

    private BluetoothCodecStatus(Parcel in) {
        this.mCodecConfig = in.readTypedObject(BluetoothCodecConfig.CREATOR);
        this.mCodecsLocalCapabilities = in.createTypedArrayList(BluetoothCodecConfig.CREATOR);
        this.mCodecsSelectableCapabilities = in.createTypedArrayList(BluetoothCodecConfig.CREATOR);
    }

    public boolean equals(Object o) {
        if (o instanceof BluetoothCodecStatus) {
            BluetoothCodecStatus other = (BluetoothCodecStatus)o;
            return Objects.equals(other.mCodecConfig, this.mCodecConfig) && BluetoothCodecStatus.sameCapabilities(other.mCodecsLocalCapabilities, this.mCodecsLocalCapabilities) && BluetoothCodecStatus.sameCapabilities(other.mCodecsSelectableCapabilities, this.mCodecsSelectableCapabilities);
        }
        return false;
    }

    private static boolean sameCapabilities(List<BluetoothCodecConfig> c1, List<BluetoothCodecConfig> c2) {
        if (c1 == null) {
            return c2 == null;
        }
        if (c2 == null) {
            return false;
        }
        if (c1.size() != c2.size()) {
            return false;
        }
        return c1.containsAll(c2);
    }

    public boolean isCodecConfigSelectable(BluetoothCodecConfig codecConfig) {
        if (!(codecConfig != null && codecConfig.hasSingleSampleRate() && codecConfig.hasSingleBitsPerSample() && codecConfig.hasSingleChannelMode())) {
            return false;
        }
        for (BluetoothCodecConfig selectableConfig : this.mCodecsSelectableCapabilities) {
            int channelMode;
            int bitsPerSample;
            int sampleRate;
            if (codecConfig.getCodecType() != selectableConfig.getCodecType() || ((sampleRate = codecConfig.getSampleRate()) & selectableConfig.getSampleRate()) == 0 && sampleRate != 0 || ((bitsPerSample = codecConfig.getBitsPerSample()) & selectableConfig.getBitsPerSample()) == 0 && bitsPerSample != 0 || ((channelMode = codecConfig.getChannelMode()) & selectableConfig.getChannelMode()) == 0 && channelMode != 0) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mCodecConfig, this.mCodecsLocalCapabilities, this.mCodecsLocalCapabilities);
    }

    public String toString() {
        return "{mCodecConfig:" + this.mCodecConfig + ",mCodecsLocalCapabilities:" + this.mCodecsLocalCapabilities + ",mCodecsSelectableCapabilities:" + this.mCodecsSelectableCapabilities + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeTypedObject(this.mCodecConfig, 0);
        out.writeTypedList(this.mCodecsLocalCapabilities);
        out.writeTypedList(this.mCodecsSelectableCapabilities);
    }

    public BluetoothCodecConfig getCodecConfig() {
        return this.mCodecConfig;
    }

    public List<BluetoothCodecConfig> getCodecsLocalCapabilities() {
        return this.mCodecsLocalCapabilities == null ? Collections.emptyList() : this.mCodecsLocalCapabilities;
    }

    public List<BluetoothCodecConfig> getCodecsSelectableCapabilities() {
        return this.mCodecsSelectableCapabilities == null ? Collections.emptyList() : this.mCodecsSelectableCapabilities;
    }

    public static class Builder {
        private BluetoothCodecConfig mCodecConfig = null;
        private List<BluetoothCodecConfig> mCodecsLocalCapabilities = null;
        private List<BluetoothCodecConfig> mCodecsSelectableCapabilities = null;

        public Builder setCodecConfig(BluetoothCodecConfig codecConfig) {
            this.mCodecConfig = codecConfig;
            return this;
        }

        public Builder setCodecsLocalCapabilities(List<BluetoothCodecConfig> codecsLocalCapabilities) {
            this.mCodecsLocalCapabilities = codecsLocalCapabilities;
            return this;
        }

        public Builder setCodecsSelectableCapabilities(List<BluetoothCodecConfig> codecsSelectableCapabilities) {
            this.mCodecsSelectableCapabilities = codecsSelectableCapabilities;
            return this;
        }

        public BluetoothCodecStatus build() {
            return new BluetoothCodecStatus(this.mCodecConfig, this.mCodecsLocalCapabilities, this.mCodecsSelectableCapabilities);
        }
    }
}

