/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.bluetooth.Attributable;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHapPresetInfo;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothProfileConnector;
import android.bluetooth.BluetoothUtils;
import android.bluetooth.IBluetoothHapClient;
import android.bluetooth.IBluetoothHapClientCallback;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.AttributionSource;
import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.CloseGuard;
import android.util.Log;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;

@SystemApi
public class BluetoothHapClient
implements BluetoothProfile,
AutoCloseable {
    private static final String TAG = "BluetoothHapClient";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    private final Map<Callback, Executor> mCallbackExecutorMap = new HashMap<Callback, Executor>();
    private CloseGuard mCloseGuard;
    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private final IBluetoothHapClientCallback mCallback = new IBluetoothHapClientCallback.Stub(){

        @Override
        public void onPresetSelected(BluetoothDevice device, int presetIndex, int reasonCode) {
            Attributable.setAttributionSource(device, BluetoothHapClient.this.mAttributionSource);
            for (Map.Entry<Callback, Executor> callbackExecutorEntry : BluetoothHapClient.this.mCallbackExecutorMap.entrySet()) {
                Callback callback2 = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback2.onPresetSelected(device, presetIndex, reasonCode));
            }
        }

        @Override
        public void onPresetSelectionFailed(BluetoothDevice device, int status) {
            Attributable.setAttributionSource(device, BluetoothHapClient.this.mAttributionSource);
            for (Map.Entry<Callback, Executor> callbackExecutorEntry : BluetoothHapClient.this.mCallbackExecutorMap.entrySet()) {
                Callback callback2 = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback2.onPresetSelectionFailed(device, status));
            }
        }

        @Override
        public void onPresetSelectionForGroupFailed(int hapGroupId, int statusCode) {
            for (Map.Entry<Callback, Executor> callbackExecutorEntry : BluetoothHapClient.this.mCallbackExecutorMap.entrySet()) {
                Callback callback2 = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback2.onPresetSelectionForGroupFailed(hapGroupId, statusCode));
            }
        }

        @Override
        public void onPresetInfoChanged(BluetoothDevice device, List<BluetoothHapPresetInfo> presetInfoList, int statusCode) {
            Attributable.setAttributionSource(device, BluetoothHapClient.this.mAttributionSource);
            for (Map.Entry<Callback, Executor> callbackExecutorEntry : BluetoothHapClient.this.mCallbackExecutorMap.entrySet()) {
                Callback callback2 = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback2.onPresetInfoChanged(device, presetInfoList, statusCode));
            }
        }

        @Override
        public void onSetPresetNameFailed(BluetoothDevice device, int status) {
            Attributable.setAttributionSource(device, BluetoothHapClient.this.mAttributionSource);
            for (Map.Entry<Callback, Executor> callbackExecutorEntry : BluetoothHapClient.this.mCallbackExecutorMap.entrySet()) {
                Callback callback2 = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback2.onSetPresetNameFailed(device, status));
            }
        }

        @Override
        public void onSetPresetNameForGroupFailed(int hapGroupId, int status) {
            for (Map.Entry<Callback, Executor> callbackExecutorEntry : BluetoothHapClient.this.mCallbackExecutorMap.entrySet()) {
                Callback callback2 = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback2.onSetPresetNameForGroupFailed(hapGroupId, status));
            }
        }
    };
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public static final String ACTION_HAP_CONNECTION_STATE_CHANGED = "android.bluetooth.action.HAP_CONNECTION_STATE_CHANGED";
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public static final String ACTION_HAP_DEVICE_AVAILABLE = "android.bluetooth.action.HAP_DEVICE_AVAILABLE";
    public static final String EXTRA_HAP_FEATURES = "android.bluetooth.extra.HAP_FEATURES";
    public static final int PRESET_INDEX_UNAVAILABLE = 0;
    public static final int FEATURE_TYPE_MONAURAL = 1;
    public static final int FEATURE_TYPE_BANDED = 2;
    public static final int FEATURE_SYNCHRONIZATED_PRESETS = 4;
    public static final int FEATURE_INDEPENDENT_PRESETS = 8;
    public static final int FEATURE_DYNAMIC_PRESETS = 16;
    public static final int FEATURE_WRITABLE_PRESETS = 32;
    private final BluetoothAdapter mAdapter;
    private final AttributionSource mAttributionSource;
    private final BluetoothProfileConnector<IBluetoothHapClient> mProfileConnector = new BluetoothProfileConnector(this, 28, "BluetoothHapClient", IBluetoothHapClient.class.getName()){

        public IBluetoothHapClient getServiceInterface(IBinder service) {
            return IBluetoothHapClient.Stub.asInterface(service);
        }
    };
    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private final IBluetoothStateChangeCallback mBluetoothStateChangeCallback = new IBluetoothStateChangeCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBluetoothStateChange(boolean up) {
            if (up) {
                Map<Callback, Executor> map2 = BluetoothHapClient.this.mCallbackExecutorMap;
                synchronized (map2) {
                    if (BluetoothHapClient.this.mCallbackExecutorMap.isEmpty()) {
                        return;
                    }
                    try {
                        IBluetoothHapClient service = BluetoothHapClient.this.getService();
                        if (service != null) {
                            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                            service.registerCallback(BluetoothHapClient.this.mCallback, BluetoothHapClient.this.mAttributionSource, recv);
                            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
                        }
                    }
                    catch (TimeoutException e) {
                        Log.e(BluetoothHapClient.TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                }
            }
        }
    };

    BluetoothHapClient(Context context, BluetoothProfile.ServiceListener listener2) {
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mAttributionSource = this.mAdapter.getAttributionSource();
        this.mProfileConnector.connect(context, listener2);
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        this.mCloseGuard = new CloseGuard();
        this.mCloseGuard.open("close");
    }

    protected void finalize() {
        if (this.mCloseGuard != null) {
            this.mCloseGuard.warnIfOpen();
        }
        this.close();
    }

    @Override
    public void close() {
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
            }
        }
        this.mProfileConnector.disconnect();
    }

    private IBluetoothHapClient getService() {
        return this.mProfileConnector.getService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void registerCallback(Executor executor, Callback callback2) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback2, "callback cannot be null");
        Map<Callback, Executor> map2 = this.mCallbackExecutorMap;
        synchronized (map2) {
            if (this.mCallbackExecutorMap.isEmpty()) {
                if (!this.isEnabled()) {
                    this.mCallbackExecutorMap.put(callback2, executor);
                    return;
                }
                try {
                    IBluetoothHapClient service = this.getService();
                    if (service != null) {
                        SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                        service.registerCallback(this.mCallback, this.mAttributionSource, recv);
                        recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
                    }
                }
                catch (TimeoutException e) {
                    Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            if (this.mCallbackExecutorMap.containsKey(callback2)) {
                throw new IllegalArgumentException("This callback has already been registered");
            }
            this.mCallbackExecutorMap.put(callback2, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void unregisterCallback(Callback callback2) {
        Objects.requireNonNull(callback2, "callback cannot be null");
        Map<Callback, Executor> map2 = this.mCallbackExecutorMap;
        synchronized (map2) {
            if (this.mCallbackExecutorMap.remove(callback2) == null) {
                throw new IllegalArgumentException("This callback has not been registered");
            }
        }
        if (this.mCallbackExecutorMap.isEmpty()) {
            try {
                IBluetoothHapClient service = this.getService();
                if (service != null) {
                    SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                    service.unregisterCallback(this.mCallback, this.mAttributionSource, recv);
                    recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
                }
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setConnectionPolicy(BluetoothDevice device, int connectionPolicy) {
        Objects.requireNonNull(device, "BluetoothDevice cannot be null");
        IBluetoothHapClient service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.mAdapter.isEnabled() && this.isValidDevice(device) && (connectionPolicy == 0 || connectionPolicy == 100)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setConnectionPolicy(device, connectionPolicy, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getConnectionPolicy(BluetoothDevice device) {
        IBluetoothHapClient service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.mAdapter.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectionPolicy(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    @Override
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public List<BluetoothDevice> getConnectedDevices() {
        IBluetoothHapClient service = this.getService();
        ArrayList<BluetoothDevice> defaultValue = new ArrayList<BluetoothDevice>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectedDevices(this.mAttributionSource, recv);
                return Attributable.setAttributionSource((List)recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue), this.mAttributionSource);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return defaultValue;
    }

    @Override
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        IBluetoothHapClient service = this.getService();
        ArrayList<BluetoothDevice> defaultValue = new ArrayList<BluetoothDevice>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getDevicesMatchingConnectionStates(states, this.mAttributionSource, recv);
                return Attributable.setAttributionSource((List)recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue), this.mAttributionSource);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return defaultValue;
    }

    @Override
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getConnectionState(BluetoothDevice device) {
        IBluetoothHapClient service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectionState(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getHapGroup(BluetoothDevice device) {
        IBluetoothHapClient service = this.getService();
        int defaultValue = -1;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getHapGroup(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(-1);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return -1;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getActivePresetIndex(BluetoothDevice device) {
        IBluetoothHapClient service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getActivePresetIndex(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public BluetoothHapPresetInfo getActivePresetInfo(BluetoothDevice device) {
        IBluetoothHapClient service = this.getService();
        BluetoothHapPresetInfo defaultValue = null;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getActivePresetInfo(device, this.mAttributionSource, recv);
                recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return defaultValue;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void selectPreset(BluetoothDevice device, int presetIndex) {
        IBluetoothHapClient service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                service.selectPreset(device, presetIndex, this.mAttributionSource);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void selectPresetForGroup(int groupId, int presetIndex) {
        IBluetoothHapClient service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled()) {
            try {
                service.selectPresetForGroup(groupId, presetIndex, this.mAttributionSource);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void switchToNextPreset(BluetoothDevice device) {
        IBluetoothHapClient service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                service.switchToNextPreset(device, this.mAttributionSource);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void switchToNextPresetForGroup(int groupId) {
        IBluetoothHapClient service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled()) {
            try {
                service.switchToNextPresetForGroup(groupId, this.mAttributionSource);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void switchToPreviousPreset(BluetoothDevice device) {
        IBluetoothHapClient service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                service.switchToPreviousPreset(device, this.mAttributionSource);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void switchToPreviousPresetForGroup(int groupId) {
        IBluetoothHapClient service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled()) {
            try {
                service.switchToPreviousPresetForGroup(groupId, this.mAttributionSource);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public BluetoothHapPresetInfo getPresetInfo(BluetoothDevice device, int presetIndex) {
        IBluetoothHapClient service = this.getService();
        BluetoothHapPresetInfo defaultValue = null;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getPresetInfo(device, presetIndex, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return defaultValue;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public List<BluetoothHapPresetInfo> getAllPresetInfo(BluetoothDevice device) {
        IBluetoothHapClient service = this.getService();
        ArrayList<BluetoothHapPresetInfo> defaultValue = new ArrayList<BluetoothHapPresetInfo>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getAllPresetInfo(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return defaultValue;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getFeatures(BluetoothDevice device) {
        IBluetoothHapClient service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getFeatures(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setPresetName(BluetoothDevice device, int presetIndex, String name) {
        IBluetoothHapClient service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                service.setPresetName(device, presetIndex, name, this.mAttributionSource);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setPresetNameForGroup(int groupId, int presetIndex, String name) {
        IBluetoothHapClient service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled()) {
            try {
                service.setPresetNameForGroup(groupId, presetIndex, name, this.mAttributionSource);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private boolean isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private boolean isValidDevice(BluetoothDevice device) {
        if (device == null) {
            return false;
        }
        return BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface Feature {
    }

    @SystemApi
    public static interface Callback {
        @SystemApi
        public void onPresetSelected(BluetoothDevice var1, int var2, int var3);

        @SystemApi
        public void onPresetSelectionFailed(BluetoothDevice var1, int var2);

        @SystemApi
        public void onPresetSelectionForGroupFailed(int var1, int var2);

        @SystemApi
        public void onPresetInfoChanged(BluetoothDevice var1, List<BluetoothHapPresetInfo> var2, int var3);

        @SystemApi
        public void onSetPresetNameFailed(BluetoothDevice var1, int var2);

        @SystemApi
        public void onSetPresetNameForGroupFailed(int var1, int var2);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface GroupPresetNameChangeFailureReason {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface PresetNameChangeFailureReason {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface PresetInfoChangeReason {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface GroupPresetSelectionFailureReason {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface PresetSelectionFailureReason {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface PresetSelectionReason {
        }
    }
}

