/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.SystemApi;
import android.bluetooth.BluetoothUtils;
import android.os.Parcel;
import android.os.Parcelable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@SystemApi
public class BluetoothLeAudioContentMetadata
implements Parcelable {
    private static final int PROGRAM_INFO_TYPE = 3;
    private static final int LANGUAGE_TYPE = 4;
    private static final int LANGUAGE_LENGTH = 3;
    private final String mProgramInfo;
    private final String mLanguage;
    private final byte[] mRawMetadata;
    @SystemApi
    public static final Parcelable.Creator<BluetoothLeAudioContentMetadata> CREATOR = new Parcelable.Creator<BluetoothLeAudioContentMetadata>(){

        @Override
        public BluetoothLeAudioContentMetadata createFromParcel(Parcel in) {
            String programInfo = in.readString();
            String language = in.readString();
            int rawMetadataLength = in.readInt();
            byte[] rawMetadata = new byte[rawMetadataLength];
            in.readByteArray(rawMetadata);
            return new BluetoothLeAudioContentMetadata(programInfo, language, rawMetadata);
        }

        public BluetoothLeAudioContentMetadata[] newArray(int size) {
            return new BluetoothLeAudioContentMetadata[size];
        }
    };

    private BluetoothLeAudioContentMetadata(String programInfo, String language, byte[] rawMetadata) {
        this.mProgramInfo = programInfo;
        this.mLanguage = language;
        this.mRawMetadata = rawMetadata;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BluetoothLeAudioContentMetadata)) {
            return false;
        }
        BluetoothLeAudioContentMetadata other = (BluetoothLeAudioContentMetadata)o;
        return Objects.equals(this.mProgramInfo, other.getProgramInfo()) && Objects.equals(this.mLanguage, other.getLanguage()) && Arrays.equals(this.mRawMetadata, other.getRawMetadata());
    }

    public int hashCode() {
        return Objects.hash(this.mProgramInfo, this.mLanguage, Arrays.hashCode(this.mRawMetadata));
    }

    @SystemApi
    public String getProgramInfo() {
        return this.mProgramInfo;
    }

    @SystemApi
    public String getLanguage() {
        return this.mLanguage;
    }

    public byte[] getRawMetadata() {
        return this.mRawMetadata;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mProgramInfo);
        out.writeString(this.mLanguage);
        out.writeInt(this.mRawMetadata.length);
        out.writeByteArray(this.mRawMetadata);
    }

    @SystemApi
    public static BluetoothLeAudioContentMetadata fromRawBytes(byte[] rawBytes) {
        if (rawBytes == null) {
            throw new IllegalArgumentException("Raw bytes cannot be null");
        }
        List<BluetoothUtils.TypeValueEntry> entries = BluetoothUtils.parseLengthTypeValueBytes(rawBytes);
        if (rawBytes.length > 0 && rawBytes[0] > 0 && entries.isEmpty()) {
            throw new IllegalArgumentException("No LTV entries are found from rawBytes of size " + rawBytes.length);
        }
        String programInfo = null;
        String language = null;
        for (BluetoothUtils.TypeValueEntry entry : entries) {
            byte[] bytes;
            if (programInfo == null && entry.getType() == 3) {
                bytes = entry.getValue();
                programInfo = new String(bytes, StandardCharsets.UTF_8);
                continue;
            }
            if (language != null || entry.getType() != 4) continue;
            bytes = entry.getValue();
            if (bytes.length != 3) {
                throw new IllegalArgumentException("Language byte size " + bytes.length + " is less than " + 3 + ", needed for ISO 639-3");
            }
            language = new String(bytes, 0, 3, StandardCharsets.US_ASCII);
        }
        return new BluetoothLeAudioContentMetadata(programInfo, language, rawBytes);
    }

    @SystemApi
    public static class Builder {
        private String mProgramInfo = null;
        private String mLanguage = null;
        private byte[] mRawMetadata = null;

        @SystemApi
        public Builder() {
        }

        @SystemApi
        public Builder(BluetoothLeAudioContentMetadata original) {
            this.mProgramInfo = original.getProgramInfo();
            this.mLanguage = original.getLanguage();
            this.mRawMetadata = original.getRawMetadata();
        }

        @SystemApi
        public Builder setProgramInfo(String programInfo) {
            this.mProgramInfo = programInfo;
            return this;
        }

        @SystemApi
        public Builder setLanguage(String language) {
            this.mLanguage = language;
            return this;
        }

        @SystemApi
        public BluetoothLeAudioContentMetadata build() {
            byte[] rawBytes;
            List<Object> entries = new ArrayList();
            if (this.mRawMetadata != null) {
                entries = BluetoothUtils.parseLengthTypeValueBytes(this.mRawMetadata);
                if (this.mRawMetadata.length > 0 && this.mRawMetadata[0] > 0 && entries.isEmpty()) {
                    throw new IllegalArgumentException("No LTV entries are found from rawBytes of size " + this.mRawMetadata.length + " please check the original object passed to Builder's copy constructor");
                }
            }
            if (this.mProgramInfo != null) {
                entries.removeIf(entry -> entry.getType() == 3);
                entries.add(new BluetoothUtils.TypeValueEntry(3, this.mProgramInfo.getBytes(StandardCharsets.UTF_8)));
            }
            if (this.mLanguage != null) {
                String cleanedLanguage = this.mLanguage.toLowerCase().strip();
                byte[] languageBytes = cleanedLanguage.getBytes(StandardCharsets.US_ASCII);
                if (languageBytes.length != 3) {
                    throw new IllegalArgumentException("Language byte size " + languageBytes.length + " is less than " + 3 + ", needed ISO 639-3, to build");
                }
                entries.removeIf(entry -> entry.getType() == 4);
                entries.add(new BluetoothUtils.TypeValueEntry(4, languageBytes));
            }
            if ((rawBytes = BluetoothUtils.serializeTypeValue(entries)) == null) {
                throw new IllegalArgumentException("Failed to serialize entries to bytes");
            }
            return new BluetoothLeAudioContentMetadata(this.mProgramInfo, this.mLanguage, rawBytes);
        }
    }
}

