/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothLeBroadcastAssistantCallback;
import android.bluetooth.BluetoothLeBroadcastMetadata;
import android.bluetooth.BluetoothLeBroadcastReceiveState;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothProfileConnector;
import android.bluetooth.IBluetoothLeBroadcastAssistant;
import android.bluetooth.le.ScanFilter;
import android.content.AttributionSource;
import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.CloseGuard;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi
public class BluetoothLeBroadcastAssistant
implements BluetoothProfile,
AutoCloseable {
    private static final String TAG = "BluetoothLeBroadcastAssistant";
    private static final boolean DBG = true;
    private final Map<Callback, Executor> mCallbackMap = new HashMap<Callback, Executor>();
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.action.CONNECTION_STATE_CHANGED";
    private CloseGuard mCloseGuard;
    private Context mContext;
    private BluetoothAdapter mBluetoothAdapter;
    private final AttributionSource mAttributionSource;
    private BluetoothLeBroadcastAssistantCallback mCallback;
    private final BluetoothProfileConnector<IBluetoothLeBroadcastAssistant> mProfileConnector = new BluetoothProfileConnector(this, 29, "BluetoothLeBroadcastAssistant", IBluetoothLeBroadcastAssistant.class.getName()){

        public IBluetoothLeBroadcastAssistant getServiceInterface(IBinder service) {
            return IBluetoothLeBroadcastAssistant.Stub.asInterface(service);
        }
    };

    BluetoothLeBroadcastAssistant(Context context, BluetoothProfile.ServiceListener listener2) {
        this.mContext = context;
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mAttributionSource = this.mBluetoothAdapter.getAttributionSource();
        this.mProfileConnector.connect(context, listener2);
        this.mCloseGuard = new CloseGuard();
        this.mCloseGuard.open("close");
    }

    protected void finalize() {
        if (this.mCloseGuard != null) {
            this.mCloseGuard.warnIfOpen();
        }
        this.close();
    }

    @Override
    public void close() {
        this.mProfileConnector.disconnect();
    }

    private IBluetoothLeBroadcastAssistant getService() {
        return this.mProfileConnector.getService();
    }

    @Override
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getConnectionState(BluetoothDevice sink) {
        BluetoothLeBroadcastAssistant.log("getConnectionState(" + sink + ")");
        Objects.requireNonNull(sink, "sink cannot be null");
        IBluetoothLeBroadcastAssistant service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcastAssistant.log(Log.getStackTraceString(new Throwable()));
        } else if (this.mBluetoothAdapter.isEnabled() && BluetoothLeBroadcastAssistant.isValidDevice(sink)) {
            try {
                return service.getConnectionState(sink);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    @Override
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        BluetoothLeBroadcastAssistant.log("getDevicesMatchingConnectionStates()");
        Objects.requireNonNull(states, "states cannot be null");
        IBluetoothLeBroadcastAssistant service = this.getService();
        ArrayList<BluetoothDevice> defaultValue = new ArrayList<BluetoothDevice>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcastAssistant.log(Log.getStackTraceString(new Throwable()));
        } else if (this.mBluetoothAdapter.isEnabled()) {
            try {
                return service.getDevicesMatchingConnectionStates(states);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @Override
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public List<BluetoothDevice> getConnectedDevices() {
        BluetoothLeBroadcastAssistant.log("getConnectedDevices()");
        IBluetoothLeBroadcastAssistant service = this.getService();
        ArrayList<BluetoothDevice> defaultValue = new ArrayList<BluetoothDevice>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcastAssistant.log(Log.getStackTraceString(new Throwable()));
        } else if (this.mBluetoothAdapter.isEnabled()) {
            try {
                return service.getConnectedDevices();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setConnectionPolicy(BluetoothDevice device, int connectionPolicy) {
        BluetoothLeBroadcastAssistant.log("setConnectionPolicy()");
        Objects.requireNonNull(device, "device cannot be null");
        IBluetoothLeBroadcastAssistant service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcastAssistant.log(Log.getStackTraceString(new Throwable()));
        } else if (this.mBluetoothAdapter.isEnabled() && BluetoothLeBroadcastAssistant.isValidDevice(device) && (connectionPolicy == 0 || connectionPolicy == 100)) {
            try {
                return service.setConnectionPolicy(device, connectionPolicy);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getConnectionPolicy(BluetoothDevice device) {
        BluetoothLeBroadcastAssistant.log("getConnectionPolicy()");
        Objects.requireNonNull(device, "device cannot be null");
        IBluetoothLeBroadcastAssistant service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcastAssistant.log(Log.getStackTraceString(new Throwable()));
        } else if (this.mBluetoothAdapter.isEnabled() && BluetoothLeBroadcastAssistant.isValidDevice(device)) {
            try {
                return service.getConnectionPolicy(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void registerCallback(Executor executor, Callback callback2) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback2, "callback cannot be null");
        BluetoothLeBroadcastAssistant.log("registerCallback");
        IBluetoothLeBroadcastAssistant service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcastAssistant.log(Log.getStackTraceString(new Throwable()));
        } else if (this.mBluetoothAdapter.isEnabled()) {
            if (this.mCallback == null) {
                this.mCallback = new BluetoothLeBroadcastAssistantCallback(service);
            }
            this.mCallback.register(executor, callback2);
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void unregisterCallback(Callback callback2) {
        Objects.requireNonNull(callback2, "callback cannot be null");
        BluetoothLeBroadcastAssistant.log("unregisterCallback");
        IBluetoothLeBroadcastAssistant service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcastAssistant.log(Log.getStackTraceString(new Throwable()));
        } else if (this.mBluetoothAdapter.isEnabled()) {
            if (this.mCallback == null) {
                throw new IllegalArgumentException("no callback was ever registered");
            }
            this.mCallback.unregister(callback2);
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void startSearchingForSources(List<ScanFilter> filters) {
        BluetoothLeBroadcastAssistant.log("searchForBroadcastSources");
        Objects.requireNonNull(filters, "filters can be empty, but not null");
        if (this.mCallback == null) {
            throw new IllegalStateException("No callback was ever registered");
        }
        if (!this.mCallback.isAtLeastOneCallbackRegistered()) {
            throw new IllegalStateException("All callbacks are unregistered");
        }
        IBluetoothLeBroadcastAssistant service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcastAssistant.log(Log.getStackTraceString(new Throwable()));
        } else if (this.mBluetoothAdapter.isEnabled()) {
            try {
                service.startSearchingForSources(filters);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void stopSearchingForSources() {
        BluetoothLeBroadcastAssistant.log("stopSearchingForSources:");
        if (this.mCallback == null) {
            throw new IllegalStateException("No callback was ever registered");
        }
        if (!this.mCallback.isAtLeastOneCallbackRegistered()) {
            throw new IllegalStateException("All callbacks are unregistered");
        }
        IBluetoothLeBroadcastAssistant service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcastAssistant.log(Log.getStackTraceString(new Throwable()));
        } else if (this.mBluetoothAdapter.isEnabled()) {
            try {
                service.stopSearchingForSources();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean isSearchInProgress() {
        BluetoothLeBroadcastAssistant.log("stopSearchingForSources:");
        IBluetoothLeBroadcastAssistant service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcastAssistant.log(Log.getStackTraceString(new Throwable()));
        } else if (this.mBluetoothAdapter.isEnabled()) {
            try {
                return service.isSearchInProgress();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void addSource(BluetoothDevice sink, BluetoothLeBroadcastMetadata sourceMetadata, boolean isGroupOp) {
        BluetoothLeBroadcastAssistant.log("addBroadcastSource: " + sourceMetadata + " on " + sink);
        Objects.requireNonNull(sink, "sink cannot be null");
        Objects.requireNonNull(sourceMetadata, "sourceMetadata cannot be null");
        if (this.mCallback == null) {
            throw new IllegalStateException("No callback was ever registered");
        }
        if (!this.mCallback.isAtLeastOneCallbackRegistered()) {
            throw new IllegalStateException("All callbacks are unregistered");
        }
        IBluetoothLeBroadcastAssistant service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcastAssistant.log(Log.getStackTraceString(new Throwable()));
        } else if (this.mBluetoothAdapter.isEnabled() && BluetoothLeBroadcastAssistant.isValidDevice(sink)) {
            try {
                service.addSource(sink, sourceMetadata, isGroupOp);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void modifySource(BluetoothDevice sink, int sourceId, BluetoothLeBroadcastMetadata updatedMetadata) {
        BluetoothLeBroadcastAssistant.log("updateBroadcastSource: " + updatedMetadata + " on " + sink);
        Objects.requireNonNull(sink, "sink cannot be null");
        Objects.requireNonNull(updatedMetadata, "updatedMetadata cannot be null");
        if (this.mCallback == null) {
            throw new IllegalStateException("No callback was ever registered");
        }
        if (!this.mCallback.isAtLeastOneCallbackRegistered()) {
            throw new IllegalStateException("All callbacks are unregistered");
        }
        IBluetoothLeBroadcastAssistant service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcastAssistant.log(Log.getStackTraceString(new Throwable()));
        } else if (this.mBluetoothAdapter.isEnabled() && BluetoothLeBroadcastAssistant.isValidDevice(sink)) {
            try {
                service.modifySource(sink, sourceId, updatedMetadata);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void removeSource(BluetoothDevice sink, int sourceId) {
        BluetoothLeBroadcastAssistant.log("removeBroadcastSource: " + sourceId + " from " + sink);
        Objects.requireNonNull(sink, "sink cannot be null");
        if (this.mCallback == null) {
            throw new IllegalStateException("No callback was ever registered");
        }
        if (!this.mCallback.isAtLeastOneCallbackRegistered()) {
            throw new IllegalStateException("All callbacks are unregistered");
        }
        IBluetoothLeBroadcastAssistant service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcastAssistant.log(Log.getStackTraceString(new Throwable()));
        } else if (this.mBluetoothAdapter.isEnabled() && BluetoothLeBroadcastAssistant.isValidDevice(sink)) {
            try {
                service.removeSource(sink, sourceId);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public List<BluetoothLeBroadcastReceiveState> getAllSources(BluetoothDevice sink) {
        BluetoothLeBroadcastAssistant.log("getAllSources()");
        Objects.requireNonNull(sink, "sink cannot be null");
        IBluetoothLeBroadcastAssistant service = this.getService();
        ArrayList<BluetoothLeBroadcastReceiveState> defaultValue = new ArrayList<BluetoothLeBroadcastReceiveState>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcastAssistant.log(Log.getStackTraceString(new Throwable()));
        } else if (this.mBluetoothAdapter.isEnabled()) {
            try {
                return service.getAllSources(sink);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @SystemApi
    public int getMaximumSourceCapacity(BluetoothDevice sink) {
        Objects.requireNonNull(sink, "sink cannot be null");
        IBluetoothLeBroadcastAssistant service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcastAssistant.log(Log.getStackTraceString(new Throwable()));
        } else if (this.mBluetoothAdapter.isEnabled() && BluetoothLeBroadcastAssistant.isValidDevice(sink)) {
            try {
                return service.getMaximumSourceCapacity(sink);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    private static boolean isValidDevice(BluetoothDevice device) {
        return device != null && BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    @SystemApi
    public static interface Callback {
        @SystemApi
        public void onSearchStarted(int var1);

        @SystemApi
        public void onSearchStartFailed(int var1);

        @SystemApi
        public void onSearchStopped(int var1);

        @SystemApi
        public void onSearchStopFailed(int var1);

        @SystemApi
        public void onSourceFound(BluetoothLeBroadcastMetadata var1);

        @SystemApi
        public void onSourceAdded(BluetoothDevice var1, int var2, int var3);

        @SystemApi
        public void onSourceAddFailed(BluetoothDevice var1, BluetoothLeBroadcastMetadata var2, int var3);

        @SystemApi
        public void onSourceModified(BluetoothDevice var1, int var2, int var3);

        @SystemApi
        public void onSourceModifyFailed(BluetoothDevice var1, int var2, int var3);

        @SystemApi
        public void onSourceRemoved(BluetoothDevice var1, int var2, int var3);

        @SystemApi
        public void onSourceRemoveFailed(BluetoothDevice var1, int var2, int var3);

        @SystemApi
        public void onReceiveStateChanged(BluetoothDevice var1, int var2, BluetoothLeBroadcastReceiveState var3);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Reason {
        }
    }
}

