/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothLeBroadcastAssistant;
import android.bluetooth.BluetoothLeBroadcastMetadata;
import android.bluetooth.BluetoothLeBroadcastReceiveState;
import android.bluetooth.IBluetoothLeBroadcastAssistant;
import android.bluetooth.IBluetoothLeBroadcastAssistantCallback;
import android.os.Binder;
import android.os.RemoteException;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class BluetoothLeBroadcastAssistantCallback
extends IBluetoothLeBroadcastAssistantCallback.Stub {
    private static final String TAG = BluetoothLeBroadcastAssistantCallback.class.getSimpleName();
    private boolean mIsRegistered = false;
    private final Map<BluetoothLeBroadcastAssistant.Callback, Executor> mCallbackMap = new HashMap<BluetoothLeBroadcastAssistant.Callback, Executor>();
    IBluetoothLeBroadcastAssistant mAdapter;

    public BluetoothLeBroadcastAssistantCallback(IBluetoothLeBroadcastAssistant adapter) {
        this.mAdapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Executor executor, BluetoothLeBroadcastAssistant.Callback callback2) {
        BluetoothLeBroadcastAssistantCallback bluetoothLeBroadcastAssistantCallback = this;
        synchronized (bluetoothLeBroadcastAssistantCallback) {
            if (this.mCallbackMap.containsKey(callback2)) {
                throw new IllegalArgumentException("callback is already registered");
            }
            this.mCallbackMap.put(callback2, executor);
            if (!this.mIsRegistered) {
                try {
                    this.mAdapter.registerCallback(this);
                    this.mIsRegistered = true;
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to register broadcast assistant callback");
                    Log.e(TAG, Log.getStackTraceString(new Throwable()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(BluetoothLeBroadcastAssistant.Callback callback2) {
        BluetoothLeBroadcastAssistantCallback bluetoothLeBroadcastAssistantCallback = this;
        synchronized (bluetoothLeBroadcastAssistantCallback) {
            if (!this.mCallbackMap.containsKey(callback2)) {
                throw new IllegalArgumentException("callback was not registered before");
            }
            this.mCallbackMap.remove(callback2);
            if (this.mCallbackMap.isEmpty() && this.mIsRegistered) {
                try {
                    this.mAdapter.unregisterCallback(this);
                    this.mIsRegistered = false;
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to unregister callback with service");
                    Log.e(TAG, Log.getStackTraceString(new Throwable()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAtLeastOneCallbackRegistered() {
        BluetoothLeBroadcastAssistantCallback bluetoothLeBroadcastAssistantCallback = this;
        synchronized (bluetoothLeBroadcastAssistantCallback) {
            return !this.mCallbackMap.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSearchStarted(int reason) {
        BluetoothLeBroadcastAssistantCallback bluetoothLeBroadcastAssistantCallback = this;
        synchronized (bluetoothLeBroadcastAssistantCallback) {
            for (BluetoothLeBroadcastAssistant.Callback cb : this.mCallbackMap.keySet()) {
                Executor executor = this.mCallbackMap.get(cb);
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> cb.onSearchStarted(reason));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSearchStartFailed(int reason) {
        BluetoothLeBroadcastAssistantCallback bluetoothLeBroadcastAssistantCallback = this;
        synchronized (bluetoothLeBroadcastAssistantCallback) {
            for (BluetoothLeBroadcastAssistant.Callback cb : this.mCallbackMap.keySet()) {
                Executor executor = this.mCallbackMap.get(cb);
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> cb.onSearchStartFailed(reason));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSearchStopped(int reason) {
        BluetoothLeBroadcastAssistantCallback bluetoothLeBroadcastAssistantCallback = this;
        synchronized (bluetoothLeBroadcastAssistantCallback) {
            for (BluetoothLeBroadcastAssistant.Callback cb : this.mCallbackMap.keySet()) {
                Executor executor = this.mCallbackMap.get(cb);
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> cb.onSearchStopped(reason));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSearchStopFailed(int reason) {
        BluetoothLeBroadcastAssistantCallback bluetoothLeBroadcastAssistantCallback = this;
        synchronized (bluetoothLeBroadcastAssistantCallback) {
            for (BluetoothLeBroadcastAssistant.Callback cb : this.mCallbackMap.keySet()) {
                Executor executor = this.mCallbackMap.get(cb);
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> cb.onSearchStopFailed(reason));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSourceFound(BluetoothLeBroadcastMetadata source) {
        BluetoothLeBroadcastAssistantCallback bluetoothLeBroadcastAssistantCallback = this;
        synchronized (bluetoothLeBroadcastAssistantCallback) {
            for (BluetoothLeBroadcastAssistant.Callback cb : this.mCallbackMap.keySet()) {
                Executor executor = this.mCallbackMap.get(cb);
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> cb.onSourceFound(source));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSourceAdded(BluetoothDevice sink, int sourceId, int reason) {
        BluetoothLeBroadcastAssistantCallback bluetoothLeBroadcastAssistantCallback = this;
        synchronized (bluetoothLeBroadcastAssistantCallback) {
            for (BluetoothLeBroadcastAssistant.Callback cb : this.mCallbackMap.keySet()) {
                Executor executor = this.mCallbackMap.get(cb);
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> cb.onSourceAdded(sink, sourceId, reason));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSourceAddFailed(BluetoothDevice sink, BluetoothLeBroadcastMetadata source, int reason) {
        BluetoothLeBroadcastAssistantCallback bluetoothLeBroadcastAssistantCallback = this;
        synchronized (bluetoothLeBroadcastAssistantCallback) {
            for (BluetoothLeBroadcastAssistant.Callback cb : this.mCallbackMap.keySet()) {
                Executor executor = this.mCallbackMap.get(cb);
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> cb.onSourceAddFailed(sink, source, reason));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSourceModified(BluetoothDevice sink, int sourceId, int reason) {
        BluetoothLeBroadcastAssistantCallback bluetoothLeBroadcastAssistantCallback = this;
        synchronized (bluetoothLeBroadcastAssistantCallback) {
            for (BluetoothLeBroadcastAssistant.Callback cb : this.mCallbackMap.keySet()) {
                Executor executor = this.mCallbackMap.get(cb);
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> cb.onSourceModified(sink, sourceId, reason));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSourceModifyFailed(BluetoothDevice sink, int sourceId, int reason) {
        BluetoothLeBroadcastAssistantCallback bluetoothLeBroadcastAssistantCallback = this;
        synchronized (bluetoothLeBroadcastAssistantCallback) {
            for (BluetoothLeBroadcastAssistant.Callback cb : this.mCallbackMap.keySet()) {
                Executor executor = this.mCallbackMap.get(cb);
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> cb.onSourceModifyFailed(sink, sourceId, reason));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSourceRemoved(BluetoothDevice sink, int sourceId, int reason) {
        BluetoothLeBroadcastAssistantCallback bluetoothLeBroadcastAssistantCallback = this;
        synchronized (bluetoothLeBroadcastAssistantCallback) {
            for (BluetoothLeBroadcastAssistant.Callback cb : this.mCallbackMap.keySet()) {
                Executor executor = this.mCallbackMap.get(cb);
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> cb.onSourceRemoved(sink, sourceId, reason));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSourceRemoveFailed(BluetoothDevice sink, int sourceId, int reason) {
        BluetoothLeBroadcastAssistantCallback bluetoothLeBroadcastAssistantCallback = this;
        synchronized (bluetoothLeBroadcastAssistantCallback) {
            for (BluetoothLeBroadcastAssistant.Callback cb : this.mCallbackMap.keySet()) {
                Executor executor = this.mCallbackMap.get(cb);
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> cb.onSourceRemoveFailed(sink, sourceId, reason));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReceiveStateChanged(BluetoothDevice sink, int sourceId, BluetoothLeBroadcastReceiveState state) {
        BluetoothLeBroadcastAssistantCallback bluetoothLeBroadcastAssistantCallback = this;
        synchronized (bluetoothLeBroadcastAssistantCallback) {
            for (BluetoothLeBroadcastAssistant.Callback cb : this.mCallbackMap.keySet()) {
                Executor executor = this.mCallbackMap.get(cb);
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> cb.onReceiveStateChanged(sink, sourceId, state));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }
    }
}

