/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.SystemApi;
import android.bluetooth.BluetoothLeAudioCodecConfigMetadata;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class BluetoothLeBroadcastChannel
implements Parcelable {
    private static final int UNKNOWN_VALUE_PLACEHOLDER = -1;
    private final boolean mIsSelected;
    private final int mChannelIndex;
    private final BluetoothLeAudioCodecConfigMetadata mCodecMetadata;
    @SystemApi
    public static final Parcelable.Creator<BluetoothLeBroadcastChannel> CREATOR = new Parcelable.Creator<BluetoothLeBroadcastChannel>(){

        @Override
        public BluetoothLeBroadcastChannel createFromParcel(Parcel in) {
            Builder builder2 = new Builder();
            builder2.setSelected(in.readBoolean());
            builder2.setChannelIndex(in.readInt());
            builder2.setCodecMetadata(in.readTypedObject(BluetoothLeAudioCodecConfigMetadata.CREATOR));
            return builder2.build();
        }

        public BluetoothLeBroadcastChannel[] newArray(int size) {
            return new BluetoothLeBroadcastChannel[size];
        }
    };

    private BluetoothLeBroadcastChannel(boolean isSelected, int channelIndex, BluetoothLeAudioCodecConfigMetadata codecMetadata) {
        this.mIsSelected = isSelected;
        this.mChannelIndex = channelIndex;
        this.mCodecMetadata = codecMetadata;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BluetoothLeBroadcastChannel)) {
            return false;
        }
        BluetoothLeBroadcastChannel other = (BluetoothLeBroadcastChannel)o;
        return this.mIsSelected == other.isSelected() && this.mChannelIndex == other.getChannelIndex() && this.mCodecMetadata.equals(other.getCodecMetadata());
    }

    public int hashCode() {
        return Objects.hash(this.mIsSelected, this.mChannelIndex, this.mCodecMetadata);
    }

    @SystemApi
    public boolean isSelected() {
        return this.mIsSelected;
    }

    @SystemApi
    public int getChannelIndex() {
        return this.mChannelIndex;
    }

    @SystemApi
    public BluetoothLeAudioCodecConfigMetadata getCodecMetadata() {
        return this.mCodecMetadata;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeBoolean(this.mIsSelected);
        out.writeInt(this.mChannelIndex);
        out.writeTypedObject(this.mCodecMetadata, 0);
    }

    @SystemApi
    public static class Builder {
        private boolean mIsSelected = false;
        private int mChannelIndex = -1;
        private BluetoothLeAudioCodecConfigMetadata mCodecMetadata = null;

        @SystemApi
        public Builder() {
        }

        @SystemApi
        public Builder(BluetoothLeBroadcastChannel original) {
            this.mIsSelected = original.isSelected();
            this.mChannelIndex = original.getChannelIndex();
            this.mCodecMetadata = original.getCodecMetadata();
        }

        @SystemApi
        public Builder setSelected(boolean isSelected) {
            this.mIsSelected = isSelected;
            return this;
        }

        @SystemApi
        public Builder setChannelIndex(int channelIndex) {
            if (channelIndex == -1) {
                throw new IllegalArgumentException("channelIndex cannot be -1");
            }
            this.mChannelIndex = channelIndex;
            return this;
        }

        @SystemApi
        public Builder setCodecMetadata(BluetoothLeAudioCodecConfigMetadata codecMetadata) {
            Objects.requireNonNull(codecMetadata, "codecMetadata cannot be null");
            this.mCodecMetadata = codecMetadata;
            return this;
        }

        @SystemApi
        public BluetoothLeBroadcastChannel build() {
            Objects.requireNonNull(this.mCodecMetadata, "codec metadata cannot be null");
            if (this.mChannelIndex == -1) {
                throw new IllegalArgumentException("mChannelIndex cannot be -1");
            }
            return new BluetoothLeBroadcastChannel(this.mIsSelected, this.mChannelIndex, this.mCodecMetadata);
        }
    }
}

