/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.SystemApi;
import android.bluetooth.BluetoothLeAudioCodecConfigMetadata;
import android.bluetooth.BluetoothLeAudioContentMetadata;
import android.bluetooth.BluetoothLeBroadcastChannel;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@SystemApi
public class BluetoothLeBroadcastSubgroup
implements Parcelable {
    private final long mCodecId;
    private final BluetoothLeAudioCodecConfigMetadata mCodecSpecificConfig;
    private final BluetoothLeAudioContentMetadata mContentMetadata;
    private final List<BluetoothLeBroadcastChannel> mChannels;
    @SystemApi
    public static final Parcelable.Creator<BluetoothLeBroadcastSubgroup> CREATOR = new Parcelable.Creator<BluetoothLeBroadcastSubgroup>(){

        @Override
        public BluetoothLeBroadcastSubgroup createFromParcel(Parcel in) {
            Builder builder2 = new Builder();
            builder2.setCodecId(in.readLong());
            builder2.setCodecSpecificConfig(in.readTypedObject(BluetoothLeAudioCodecConfigMetadata.CREATOR));
            builder2.setContentMetadata(in.readTypedObject(BluetoothLeAudioContentMetadata.CREATOR));
            ArrayList channels = new ArrayList();
            in.readTypedList(channels, BluetoothLeBroadcastChannel.CREATOR);
            for (BluetoothLeBroadcastChannel channel : channels) {
                builder2.addChannel(channel);
            }
            return builder2.build();
        }

        public BluetoothLeBroadcastSubgroup[] newArray(int size) {
            return new BluetoothLeBroadcastSubgroup[size];
        }
    };
    private static final int UNKNOWN_VALUE_PLACEHOLDER = -1;

    private BluetoothLeBroadcastSubgroup(long codecId, BluetoothLeAudioCodecConfigMetadata codecSpecificConfig, BluetoothLeAudioContentMetadata contentMetadata, List<BluetoothLeBroadcastChannel> channels) {
        this.mCodecId = codecId;
        this.mCodecSpecificConfig = codecSpecificConfig;
        this.mContentMetadata = contentMetadata;
        this.mChannels = channels;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BluetoothLeBroadcastSubgroup)) {
            return false;
        }
        BluetoothLeBroadcastSubgroup other = (BluetoothLeBroadcastSubgroup)o;
        return this.mCodecId == other.getCodecId() && this.mCodecSpecificConfig.equals(other.getCodecSpecificConfig()) && this.mContentMetadata.equals(other.getContentMetadata()) && this.mChannels.equals(other.getChannels());
    }

    public int hashCode() {
        return Objects.hash(this.mCodecId, this.mCodecSpecificConfig, this.mContentMetadata, this.mChannels);
    }

    @SystemApi
    public long getCodecId() {
        return this.mCodecId;
    }

    @SystemApi
    public BluetoothLeAudioCodecConfigMetadata getCodecSpecificConfig() {
        return this.mCodecSpecificConfig;
    }

    @SystemApi
    public BluetoothLeAudioContentMetadata getContentMetadata() {
        return this.mContentMetadata;
    }

    @SystemApi
    public boolean hasChannelPreference() {
        return this.mChannels.stream().anyMatch(BluetoothLeBroadcastChannel::isSelected);
    }

    @SystemApi
    public List<BluetoothLeBroadcastChannel> getChannels() {
        return this.mChannels;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.mCodecId);
        out.writeTypedObject(this.mCodecSpecificConfig, 0);
        out.writeTypedObject(this.mContentMetadata, 0);
        out.writeTypedList(this.mChannels);
    }

    @SystemApi
    public static class Builder {
        private long mCodecId = -1L;
        private BluetoothLeAudioCodecConfigMetadata mCodecSpecificConfig = null;
        private BluetoothLeAudioContentMetadata mContentMetadata = null;
        private List<BluetoothLeBroadcastChannel> mChannels = new ArrayList<BluetoothLeBroadcastChannel>();

        @SystemApi
        public Builder() {
        }

        @SystemApi
        public Builder(BluetoothLeBroadcastSubgroup original) {
            this.mCodecId = original.getCodecId();
            this.mCodecSpecificConfig = original.getCodecSpecificConfig();
            this.mContentMetadata = original.getContentMetadata();
            this.mChannels = original.getChannels();
        }

        @SystemApi
        public Builder setCodecId(long codecId) {
            this.mCodecId = codecId;
            return this;
        }

        @SystemApi
        public Builder setCodecSpecificConfig(BluetoothLeAudioCodecConfigMetadata codecSpecificConfig) {
            Objects.requireNonNull(codecSpecificConfig, "codecSpecificConfig cannot be null");
            this.mCodecSpecificConfig = codecSpecificConfig;
            return this;
        }

        @SystemApi
        public Builder setContentMetadata(BluetoothLeAudioContentMetadata contentMetadata) {
            Objects.requireNonNull(contentMetadata, "contentMetadata cannot be null");
            this.mContentMetadata = contentMetadata;
            return this;
        }

        @SystemApi
        public Builder addChannel(BluetoothLeBroadcastChannel channel) {
            Objects.requireNonNull(channel, "channel cannot be null");
            this.mChannels.add(channel);
            return this;
        }

        @SystemApi
        public Builder clearChannel() {
            this.mChannels.clear();
            return this;
        }

        @SystemApi
        public BluetoothLeBroadcastSubgroup build() {
            Objects.requireNonNull(this.mCodecSpecificConfig, "CodecSpecificConfig is null");
            Objects.requireNonNull(this.mContentMetadata, "ContentMetadata is null");
            if (this.mChannels.isEmpty()) {
                throw new IllegalArgumentException("Must have at least one channel");
            }
            return new BluetoothLeBroadcastSubgroup(this.mCodecId, this.mCodecSpecificConfig, this.mContentMetadata, this.mChannels);
        }
    }
}

