/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.UUID;

public class BluetoothLeCall
implements Parcelable {
    public static final int STATE_INCOMING = 0;
    public static final int STATE_DIALING = 1;
    public static final int STATE_ALERTING = 2;
    public static final int STATE_ACTIVE = 3;
    public static final int STATE_LOCALLY_HELD = 4;
    public static final int STATE_REMOTELY_HELD = 5;
    public static final int STATE_LOCALLY_AND_REMOTELY_HELD = 6;
    public static final int FLAG_OUTGOING_CALL = 1;
    public static final int FLAG_WITHHELD_BY_SERVER = 2;
    public static final int FLAG_WITHHELD_BY_NETWORK = 4;
    private UUID mUuid;
    private String mUri;
    private String mFriendlyName;
    private int mState;
    private int mCallFlags;
    public static final Parcelable.Creator<BluetoothLeCall> CREATOR = new Parcelable.Creator<BluetoothLeCall>(){

        @Override
        public BluetoothLeCall createFromParcel(Parcel in) {
            return new BluetoothLeCall(in);
        }

        public BluetoothLeCall[] newArray(int size) {
            return new BluetoothLeCall[size];
        }
    };

    public BluetoothLeCall(BluetoothLeCall that) {
        this.mUuid = new UUID(that.getUuid().getMostSignificantBits(), that.getUuid().getLeastSignificantBits());
        this.mUri = that.mUri;
        this.mFriendlyName = that.mFriendlyName;
        this.mState = that.mState;
        this.mCallFlags = that.mCallFlags;
    }

    public BluetoothLeCall(UUID uuid, String uri, String friendlyName, int state, int callFlags) {
        this.mUuid = uuid;
        this.mUri = uri;
        this.mFriendlyName = friendlyName;
        this.mState = state;
        this.mCallFlags = callFlags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BluetoothLeCall that = (BluetoothLeCall)o;
        return this.mUuid.equals(that.mUuid) && this.mUri.equals(that.mUri) && this.mFriendlyName.equals(that.mFriendlyName) && this.mState == that.mState && this.mCallFlags == that.mCallFlags;
    }

    public int hashCode() {
        return Objects.hash(this.mUuid, this.mUri, this.mFriendlyName, this.mState, this.mCallFlags);
    }

    public String toString() {
        return this.mUuid.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(new ParcelUuid(this.mUuid), 0);
        out.writeString(this.mUri);
        out.writeString(this.mFriendlyName);
        out.writeInt(this.mState);
        out.writeInt(this.mCallFlags);
    }

    private BluetoothLeCall(Parcel in) {
        this.mUuid = ((ParcelUuid)in.readParcelable(null)).getUuid();
        this.mUri = in.readString();
        this.mFriendlyName = in.readString();
        this.mState = in.readInt();
        this.mCallFlags = in.readInt();
    }

    public UUID getUuid() {
        return this.mUuid;
    }

    public String getUri() {
        return this.mUri;
    }

    public String getFriendlyName() {
        return this.mFriendlyName;
    }

    public int getState() {
        return this.mState;
    }

    public int getCallFlags() {
        return this.mCallFlags;
    }

    public boolean isIncomingCall() {
        return (this.mCallFlags & 1) == 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

