/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.bluetooth.Attributable;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.BluetoothUtils;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.content.AttributionSource;
import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class BluetoothManager {
    private static final String TAG = "BluetoothManager";
    private static final boolean DBG = false;
    private final AttributionSource mAttributionSource;
    private final BluetoothAdapter mAdapter;

    public BluetoothManager(Context context) {
        this.mAttributionSource = context != null ? context.getAttributionSource() : AttributionSource.myAttributionSource();
        this.mAdapter = BluetoothAdapter.createAdapter(this.mAttributionSource);
    }

    @RequiresNoPermission
    public BluetoothAdapter getAdapter() {
        return this.mAdapter;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getConnectionState(BluetoothDevice device, int profile) {
        List<BluetoothDevice> connectedDevices = this.getConnectedDevices(profile);
        for (BluetoothDevice connectedDevice : connectedDevices) {
            if (!device.equals(connectedDevice)) continue;
            return 2;
        }
        return 0;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getConnectedDevices(int profile) {
        return this.getDevicesMatchingConnectionStates(profile, new int[]{2});
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int profile, int[] states) {
        if (profile != 7 && profile != 8) {
            throw new IllegalArgumentException("Profile not supported: " + profile);
        }
        List<BluetoothDevice> devices = new ArrayList<BluetoothDevice>();
        try {
            IBluetoothManager managerService = this.mAdapter.getBluetoothManager();
            IBluetoothGatt iGatt = managerService.getBluetoothGatt();
            if (iGatt == null) {
                return devices;
            }
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            iGatt.getDevicesMatchingConnectionStates(states, this.mAttributionSource, recv);
            devices = Attributable.setAttributionSource((List)recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue((ArrayList<BluetoothDevice>)devices), this.mAttributionSource);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "", e);
        }
        return devices;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGattServer openGattServer(Context context, BluetoothGattServerCallback callback2) {
        return this.openGattServer(context, callback2, 0);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGattServer openGattServer(Context context, BluetoothGattServerCallback callback2, boolean eatt_support) {
        return this.openGattServer(context, callback2, 0, eatt_support);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGattServer openGattServer(Context context, BluetoothGattServerCallback callback2, int transport) {
        return this.openGattServer(context, callback2, transport, false);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGattServer openGattServer(Context context, BluetoothGattServerCallback callback2, int transport, boolean eatt_support) {
        if (context == null || callback2 == null) {
            throw new IllegalArgumentException("null parameter: " + context + " " + callback2);
        }
        try {
            IBluetoothManager managerService = this.mAdapter.getBluetoothManager();
            IBluetoothGatt iGatt = managerService.getBluetoothGatt();
            if (iGatt == null) {
                Log.e(TAG, "Fail to get GATT Server connection");
                return null;
            }
            BluetoothGattServer mGattServer = new BluetoothGattServer(iGatt, transport, this.mAdapter);
            Boolean regStatus = mGattServer.registerCallback(callback2, eatt_support);
            return regStatus != false ? mGattServer : null;
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }
}

