/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.os.UserHandle;
import android.util.Log;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BluetoothUtils {
    private static final String TAG = "BluetoothUtils";
    private static final Duration SYNC_CALLS_TIMEOUT = Duration.ofSeconds(5L);
    public static final UserHandle USER_HANDLE_NULL = UserHandle.of(-10000);

    private BluetoothUtils() {
    }

    static Duration getSyncTimeout() {
        return SYNC_CALLS_TIMEOUT;
    }

    private static byte[] extractBytes(byte[] rawBytes, int start, int length) {
        int remainingLength = rawBytes.length - start;
        if (remainingLength < length) {
            Log.w(TAG, "extractBytes() remaining length " + remainingLength + " is less than copying length " + length + ", array length is " + rawBytes.length + " start is " + start);
            return null;
        }
        byte[] bytes = new byte[length];
        System.arraycopy(rawBytes, start, bytes, 0, length);
        return bytes;
    }

    public static List<TypeValueEntry> parseLengthTypeValueBytes(byte[] rawBytes) {
        int length;
        int dataLength;
        if (rawBytes == null) {
            return Collections.emptyList();
        }
        if (rawBytes.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<TypeValueEntry> result = new ArrayList<TypeValueEntry>();
        for (int currentPos = 0; currentPos < rawBytes.length && (length = rawBytes[currentPos] & 0xFF) != 0; currentPos += dataLength) {
            if (++currentPos >= rawBytes.length) {
                Log.w(TAG, "parseLtv() no type and value after length, rawBytes length = " + rawBytes.length + ", currentPost = " + currentPos);
                break;
            }
            dataLength = length - 1;
            int type = rawBytes[currentPos] & 0xFF;
            if (++currentPos >= rawBytes.length) {
                Log.w(TAG, "parseLtv() no value after length, rawBytes length = " + rawBytes.length + ", currentPost = " + currentPos);
                break;
            }
            byte[] value2 = BluetoothUtils.extractBytes(rawBytes, currentPos, dataLength);
            if (value2 == null) {
                Log.w(TAG, "failed to extract bytes, currentPost = " + currentPos);
                break;
            }
            result.add(new TypeValueEntry(type, value2));
        }
        return result;
    }

    public static byte[] serializeTypeValue(List<TypeValueEntry> typeValueEntries) {
        int length = 0;
        for (TypeValueEntry entry : typeValueEntries) {
            length += 2;
            if (entry.getType() - (entry.getType() & 0xFF) != 0) {
                Log.w(TAG, "serializeTypeValue() type " + entry.getType() + " is out of range of 0-0xFF");
                return null;
            }
            if (entry.getValue() == null) {
                Log.w(TAG, "serializeTypeValue() value is null");
                return null;
            }
            int lengthValue = entry.getValue().length + 1;
            if (lengthValue - (lengthValue & 0xFF) != 0) {
                Log.w(TAG, "serializeTypeValue() entry length " + entry.getValue().length + " is not in range of 0 to 254");
                return null;
            }
            length += entry.getValue().length;
        }
        byte[] result = new byte[length];
        int currentPos = 0;
        for (TypeValueEntry entry : typeValueEntries) {
            result[currentPos] = (byte)(entry.getValue().length + 1 & 0xFF);
            result[++currentPos] = (byte)(entry.getType() & 0xFF);
            System.arraycopy(entry.getValue(), 0, result, ++currentPos, entry.getValue().length);
            currentPos += entry.getValue().length;
        }
        return result;
    }

    static class TypeValueEntry {
        private final int mType;
        private final byte[] mValue;

        TypeValueEntry(int type, byte[] value2) {
            this.mType = type;
            this.mValue = value2;
        }

        public int getType() {
            return this.mType;
        }

        public byte[] getValue() {
            return this.mValue;
        }
    }
}

