/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.bluetooth.Attributable;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothProfileConnector;
import android.bluetooth.BluetoothUtils;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.bluetooth.IBluetoothVolumeControl;
import android.bluetooth.IBluetoothVolumeControlCallback;
import android.content.AttributionSource;
import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.CloseGuard;
import android.util.Log;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;

@SystemApi
public class BluetoothVolumeControl
implements BluetoothProfile,
AutoCloseable {
    private static final String TAG = "BluetoothVolumeControl";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private CloseGuard mCloseGuard;
    private final Map<Callback, Executor> mCallbackExecutorMap = new HashMap<Callback, Executor>();
    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private final IBluetoothVolumeControlCallback mCallback = new IBluetoothVolumeControlCallback.Stub(){

        @Override
        public void onVolumeOffsetChanged(BluetoothDevice device, int volumeOffset) {
            Attributable.setAttributionSource(device, BluetoothVolumeControl.this.mAttributionSource);
            for (Map.Entry<Callback, Executor> callbackExecutorEntry : BluetoothVolumeControl.this.mCallbackExecutorMap.entrySet()) {
                Callback callback2 = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback2.onVolumeOffsetChanged(device, volumeOffset));
            }
        }
    };
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.volume-control.profile.action.CONNECTION_STATE_CHANGED";
    private BluetoothAdapter mAdapter;
    private final AttributionSource mAttributionSource;
    private final BluetoothProfileConnector<IBluetoothVolumeControl> mProfileConnector = new BluetoothProfileConnector(this, 23, "BluetoothVolumeControl", IBluetoothVolumeControl.class.getName()){

        public IBluetoothVolumeControl getServiceInterface(IBinder service) {
            return IBluetoothVolumeControl.Stub.asInterface(service);
        }
    };
    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private final IBluetoothStateChangeCallback mBluetoothStateChangeCallback = new IBluetoothStateChangeCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBluetoothStateChange(boolean up) {
            Log.d(BluetoothVolumeControl.TAG, "onBluetoothStateChange: up=" + up);
            if (!up) {
                return;
            }
            Map<Callback, Executor> map2 = BluetoothVolumeControl.this.mCallbackExecutorMap;
            synchronized (map2) {
                if (!BluetoothVolumeControl.this.mCallbackExecutorMap.isEmpty()) {
                    try {
                        IBluetoothVolumeControl service = BluetoothVolumeControl.this.getService();
                        if (service != null) {
                            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                            service.registerCallback(BluetoothVolumeControl.this.mCallback, BluetoothVolumeControl.this.mAttributionSource, recv);
                            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
                        }
                    }
                    catch (RemoteException e) {
                        Log.e(BluetoothVolumeControl.TAG, "onBluetoothServiceUp: Failed to registerVolume Control callback", e);
                    }
                    catch (TimeoutException e) {
                        Log.e(BluetoothVolumeControl.TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                    }
                }
            }
        }
    };

    BluetoothVolumeControl(Context context, BluetoothProfile.ServiceListener listener2, BluetoothAdapter adapter) {
        this.mAdapter = adapter;
        this.mAttributionSource = adapter.getAttributionSource();
        this.mProfileConnector.connect(context, listener2);
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                throw e.rethrowFromSystemServer();
            }
        }
        this.mCloseGuard = new CloseGuard();
        this.mCloseGuard.open("close");
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    protected void finalize() {
        if (this.mCloseGuard != null) {
            this.mCloseGuard.warnIfOpen();
        }
        this.close();
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void close() {
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        this.mProfileConnector.disconnect();
    }

    private IBluetoothVolumeControl getService() {
        return this.mProfileConnector.getService();
    }

    @Override
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public List<BluetoothDevice> getConnectedDevices() {
        BluetoothVolumeControl.log("getConnectedDevices()");
        IBluetoothVolumeControl service = this.getService();
        ArrayList<BluetoothDevice> defaultValue = new ArrayList<BluetoothDevice>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothVolumeControl.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectedDevices(this.mAttributionSource, recv);
                return Attributable.setAttributionSource((List)recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue), this.mAttributionSource);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        BluetoothVolumeControl.log("getDevicesMatchingStates()");
        IBluetoothVolumeControl service = this.getService();
        ArrayList<BluetoothDevice> defaultValue = new ArrayList<BluetoothDevice>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothVolumeControl.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getDevicesMatchingConnectionStates(states, this.mAttributionSource, recv);
                return Attributable.setAttributionSource((List)recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue), this.mAttributionSource);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getConnectionState(BluetoothDevice device) {
        BluetoothVolumeControl.log("getConnectionState(" + device + ")");
        IBluetoothVolumeControl service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothVolumeControl.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && BluetoothVolumeControl.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectionState(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void registerCallback(Executor executor, Callback callback2) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback2, "callback cannot be null");
        BluetoothVolumeControl.log("registerCallback");
        Map<Callback, Executor> map2 = this.mCallbackExecutorMap;
        synchronized (map2) {
            if (this.mCallbackExecutorMap.isEmpty()) {
                if (!this.mAdapter.isEnabled()) {
                    this.mCallbackExecutorMap.put(callback2, executor);
                    return;
                }
                try {
                    IBluetoothVolumeControl service = this.getService();
                    if (service != null) {
                        SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                        service.registerCallback(this.mCallback, this.mAttributionSource, recv);
                        recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
                    }
                }
                catch (RemoteException e) {
                    Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                    throw e.rethrowFromSystemServer();
                }
                catch (TimeoutException e) {
                    Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                }
            }
            if (this.mCallbackExecutorMap.containsKey(callback2)) {
                throw new IllegalArgumentException("This callback has already been registered");
            }
            this.mCallbackExecutorMap.put(callback2, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void unregisterCallback(Callback callback2) {
        Objects.requireNonNull(callback2, "callback cannot be null");
        BluetoothVolumeControl.log("unregisterCallback");
        Map<Callback, Executor> map2 = this.mCallbackExecutorMap;
        synchronized (map2) {
            if (this.mCallbackExecutorMap.remove(callback2) == null) {
                throw new IllegalArgumentException("This callback has not been registered");
            }
        }
        if (this.mCallbackExecutorMap.isEmpty()) {
            try {
                IBluetoothVolumeControl service = this.getService();
                if (service != null) {
                    SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                    service.unregisterCallback(this.mCallback, this.mAttributionSource, recv);
                    recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                throw e.rethrowFromSystemServer();
            }
            catch (IllegalStateException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setVolumeOffset(BluetoothDevice device, int volumeOffset) {
        BluetoothVolumeControl.log("setVolumeOffset(" + device + " volumeOffset: " + volumeOffset + ")");
        IBluetoothVolumeControl service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothVolumeControl.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setVolumeOffset(device, volumeOffset, this.mAttributionSource, recv);
                recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean isVolumeOffsetAvailable(BluetoothDevice device) {
        BluetoothVolumeControl.log("isVolumeOffsetAvailable(" + device + ")");
        IBluetoothVolumeControl service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothVolumeControl.log(Log.getStackTraceString(new Throwable()));
            return false;
        }
        if (!this.isEnabled()) {
            return false;
        }
        boolean defaultValue = false;
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            service.isVolumeOffsetAvailable(device, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setConnectionPolicy(BluetoothDevice device, int connectionPolicy) {
        BluetoothVolumeControl.log("setConnectionPolicy(" + device + ", " + connectionPolicy + ")");
        IBluetoothVolumeControl service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothVolumeControl.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && BluetoothVolumeControl.isValidDevice(device) && (connectionPolicy == 0 || connectionPolicy == 100)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setConnectionPolicy(device, connectionPolicy, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getConnectionPolicy(BluetoothDevice device) {
        IBluetoothVolumeControl service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothVolumeControl.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && BluetoothVolumeControl.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectionPolicy(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    private boolean isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private static boolean isValidDevice(BluetoothDevice device) {
        return device != null && BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    @SystemApi
    public static interface Callback {
        @SystemApi
        public void onVolumeOffsetChanged(BluetoothDevice var1, int var2);
    }
}

