/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothGattService;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBluetoothGattServerCallback
extends IInterface {
    public void onServerRegistered(int var1, int var2) throws RemoteException;

    public void onServerConnectionState(int var1, int var2, boolean var3, String var4) throws RemoteException;

    public void onServiceAdded(int var1, BluetoothGattService var2) throws RemoteException;

    public void onCharacteristicReadRequest(String var1, int var2, int var3, boolean var4, int var5) throws RemoteException;

    public void onDescriptorReadRequest(String var1, int var2, int var3, boolean var4, int var5) throws RemoteException;

    public void onCharacteristicWriteRequest(String var1, int var2, int var3, int var4, boolean var5, boolean var6, int var7, byte[] var8) throws RemoteException;

    public void onDescriptorWriteRequest(String var1, int var2, int var3, int var4, boolean var5, boolean var6, int var7, byte[] var8) throws RemoteException;

    public void onExecuteWrite(String var1, int var2, boolean var3) throws RemoteException;

    public void onNotificationSent(String var1, int var2) throws RemoteException;

    public void onMtuChanged(String var1, int var2) throws RemoteException;

    public void onPhyUpdate(String var1, int var2, int var3, int var4) throws RemoteException;

    public void onPhyRead(String var1, int var2, int var3, int var4) throws RemoteException;

    public void onConnectionUpdated(String var1, int var2, int var3, int var4, int var5) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothGattServerCallback {
        public static final String DESCRIPTOR = "android.bluetooth.IBluetoothGattServerCallback";
        static final int TRANSACTION_onServerRegistered = 1;
        static final int TRANSACTION_onServerConnectionState = 2;
        static final int TRANSACTION_onServiceAdded = 3;
        static final int TRANSACTION_onCharacteristicReadRequest = 4;
        static final int TRANSACTION_onDescriptorReadRequest = 5;
        static final int TRANSACTION_onCharacteristicWriteRequest = 6;
        static final int TRANSACTION_onDescriptorWriteRequest = 7;
        static final int TRANSACTION_onExecuteWrite = 8;
        static final int TRANSACTION_onNotificationSent = 9;
        static final int TRANSACTION_onMtuChanged = 10;
        static final int TRANSACTION_onPhyUpdate = 11;
        static final int TRANSACTION_onPhyRead = 12;
        static final int TRANSACTION_onConnectionUpdated = 13;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBluetoothGattServerCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothGattServerCallback) {
                return (IBluetoothGattServerCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onServerRegistered(_arg0, _arg1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.onServerConnectionState(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    BluetoothGattService _arg1 = data.readTypedObject(BluetoothGattService.CREATOR);
                    data.enforceNoDataAvail();
                    this.onServiceAdded(_arg0, _arg1);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    boolean _arg3 = data.readBoolean();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCharacteristicReadRequest(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    boolean _arg3 = data.readBoolean();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDescriptorReadRequest(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    boolean _arg4 = data.readBoolean();
                    boolean _arg5 = data.readBoolean();
                    int _arg6 = data.readInt();
                    byte[] _arg7 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onCharacteristicWriteRequest(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    boolean _arg4 = data.readBoolean();
                    boolean _arg5 = data.readBoolean();
                    int _arg6 = data.readInt();
                    byte[] _arg7 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onDescriptorWriteRequest(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onExecuteWrite(_arg0, _arg1, _arg2);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onNotificationSent(_arg0, _arg1);
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onMtuChanged(_arg0, _arg1);
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onPhyUpdate(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onPhyRead(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 13: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onConnectionUpdated(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IBluetoothGattServerCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServerRegistered(int status, int serverIf) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status);
                    _data.writeInt(serverIf);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServerConnectionState(int status, int serverIf, boolean connected, String address) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status);
                    _data.writeInt(serverIf);
                    _data.writeBoolean(connected);
                    _data.writeString(address);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServiceAdded(int status, BluetoothGattService service) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status);
                    _data.writeTypedObject(service, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCharacteristicReadRequest(String address, int transId, int offset2, boolean isLong, int handle) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    _data.writeInt(transId);
                    _data.writeInt(offset2);
                    _data.writeBoolean(isLong);
                    _data.writeInt(handle);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDescriptorReadRequest(String address, int transId, int offset2, boolean isLong, int handle) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    _data.writeInt(transId);
                    _data.writeInt(offset2);
                    _data.writeBoolean(isLong);
                    _data.writeInt(handle);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCharacteristicWriteRequest(String address, int transId, int offset2, int length, boolean isPrep, boolean needRsp, int handle, byte[] value2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    _data.writeInt(transId);
                    _data.writeInt(offset2);
                    _data.writeInt(length);
                    _data.writeBoolean(isPrep);
                    _data.writeBoolean(needRsp);
                    _data.writeInt(handle);
                    _data.writeByteArray(value2);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDescriptorWriteRequest(String address, int transId, int offset2, int length, boolean isPrep, boolean needRsp, int handle, byte[] value2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    _data.writeInt(transId);
                    _data.writeInt(offset2);
                    _data.writeInt(length);
                    _data.writeBoolean(isPrep);
                    _data.writeBoolean(needRsp);
                    _data.writeInt(handle);
                    _data.writeByteArray(value2);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onExecuteWrite(String address, int transId, boolean execWrite) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    _data.writeInt(transId);
                    _data.writeBoolean(execWrite);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationSent(String address, int status) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMtuChanged(String address, int mtu) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    _data.writeInt(mtu);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPhyUpdate(String address, int txPhy, int rxPhy, int status) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    _data.writeInt(txPhy);
                    _data.writeInt(rxPhy);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPhyRead(String address, int txPhy, int rxPhy, int status) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    _data.writeInt(txPhy);
                    _data.writeInt(rxPhy);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnectionUpdated(String address, int interval, int latency, int timeout, int status) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    _data.writeInt(interval);
                    _data.writeInt(latency);
                    _data.writeInt(timeout);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothGattServerCallback {
        @Override
        public void onServerRegistered(int status, int serverIf) throws RemoteException {
        }

        @Override
        public void onServerConnectionState(int status, int serverIf, boolean connected, String address) throws RemoteException {
        }

        @Override
        public void onServiceAdded(int status, BluetoothGattService service) throws RemoteException {
        }

        @Override
        public void onCharacteristicReadRequest(String address, int transId, int offset2, boolean isLong, int handle) throws RemoteException {
        }

        @Override
        public void onDescriptorReadRequest(String address, int transId, int offset2, boolean isLong, int handle) throws RemoteException {
        }

        @Override
        public void onCharacteristicWriteRequest(String address, int transId, int offset2, int length, boolean isPrep, boolean needRsp, int handle, byte[] value2) throws RemoteException {
        }

        @Override
        public void onDescriptorWriteRequest(String address, int transId, int offset2, int length, boolean isPrep, boolean needRsp, int handle, byte[] value2) throws RemoteException {
        }

        @Override
        public void onExecuteWrite(String address, int transId, boolean execWrite) throws RemoteException {
        }

        @Override
        public void onNotificationSent(String address, int status) throws RemoteException {
        }

        @Override
        public void onMtuChanged(String address, int mtu) throws RemoteException {
        }

        @Override
        public void onPhyUpdate(String address, int txPhy, int rxPhy, int status) throws RemoteException {
        }

        @Override
        public void onPhyRead(String address, int txPhy, int rxPhy, int status) throws RemoteException {
        }

        @Override
        public void onConnectionUpdated(String address, int interval, int latency, int timeout, int status) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

