/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothHapClientCallback;
import android.content.AttributionSource;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;

public interface IBluetoothHapClient
extends IInterface {
    public static final String DESCRIPTOR = "android.bluetooth.IBluetoothHapClient";
    public static final int PRESET_INDEX_UNAVAILABLE = 0;
    public static final int GROUP_ID_UNAVAILABLE = -1;
    public static final int FEATURE_BIT_NUM_TYPE_MONAURAL = 0;
    public static final int FEATURE_BIT_NUM_TYPE_BANDED = 1;
    public static final int FEATURE_BIT_NUM_SYNCHRONIZATED_PRESETS = 2;
    public static final int FEATURE_BIT_NUM_INDEPENDENT_PRESETS = 3;
    public static final int FEATURE_BIT_NUM_DYNAMIC_PRESETS = 4;
    public static final int FEATURE_BIT_NUM_WRITABLE_PRESETS = 5;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getConnectedDevices(AttributionSource var1, SynchronousResultReceiver var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getDevicesMatchingConnectionStates(int[] var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getConnectionState(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setConnectionPolicy(BluetoothDevice var1, int var2, AttributionSource var3, SynchronousResultReceiver var4) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getConnectionPolicy(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getHapGroup(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getActivePresetIndex(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getActivePresetInfo(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void selectPreset(BluetoothDevice var1, int var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void selectPresetForGroup(int var1, int var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void switchToNextPreset(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void switchToNextPresetForGroup(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void switchToPreviousPreset(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void switchToPreviousPresetForGroup(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getPresetInfo(BluetoothDevice var1, int var2, AttributionSource var3, SynchronousResultReceiver var4) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getAllPresetInfo(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getFeatures(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setPresetName(BluetoothDevice var1, int var2, String var3, AttributionSource var4) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setPresetNameForGroup(int var1, int var2, String var3, AttributionSource var4) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void registerCallback(IBluetoothHapClientCallback var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void unregisterCallback(IBluetoothHapClientCallback var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothHapClient {
        static final int TRANSACTION_getConnectedDevices = 1;
        static final int TRANSACTION_getDevicesMatchingConnectionStates = 2;
        static final int TRANSACTION_getConnectionState = 3;
        static final int TRANSACTION_setConnectionPolicy = 4;
        static final int TRANSACTION_getConnectionPolicy = 5;
        static final int TRANSACTION_getHapGroup = 6;
        static final int TRANSACTION_getActivePresetIndex = 7;
        static final int TRANSACTION_getActivePresetInfo = 8;
        static final int TRANSACTION_selectPreset = 9;
        static final int TRANSACTION_selectPresetForGroup = 10;
        static final int TRANSACTION_switchToNextPreset = 11;
        static final int TRANSACTION_switchToNextPresetForGroup = 12;
        static final int TRANSACTION_switchToPreviousPreset = 13;
        static final int TRANSACTION_switchToPreviousPresetForGroup = 14;
        static final int TRANSACTION_getPresetInfo = 15;
        static final int TRANSACTION_getAllPresetInfo = 16;
        static final int TRANSACTION_getFeatures = 17;
        static final int TRANSACTION_setPresetName = 18;
        static final int TRANSACTION_setPresetNameForGroup = 19;
        static final int TRANSACTION_registerCallback = 20;
        static final int TRANSACTION_unregisterCallback = 21;

        public Stub() {
            this.attachInterface(this, IBluetoothHapClient.DESCRIPTOR);
        }

        public static IBluetoothHapClient asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBluetoothHapClient.DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothHapClient) {
                return (IBluetoothHapClient)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBluetoothHapClient.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg1 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getConnectedDevices(_arg0, _arg1);
                    break;
                }
                case 2: {
                    int[] _arg0 = data.createIntArray();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getDevicesMatchingConnectionStates(_arg0, _arg1, _arg2);
                    break;
                }
                case 3: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getConnectionState(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg3 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.setConnectionPolicy(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 5: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getConnectionPolicy(_arg0, _arg1, _arg2);
                    break;
                }
                case 6: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getHapGroup(_arg0, _arg1, _arg2);
                    break;
                }
                case 7: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getActivePresetIndex(_arg0, _arg1, _arg2);
                    break;
                }
                case 8: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getActivePresetInfo(_arg0, _arg1, _arg2);
                    break;
                }
                case 9: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.selectPreset(_arg0, _arg1, _arg2);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.selectPresetForGroup(_arg0, _arg1, _arg2);
                    break;
                }
                case 11: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.switchToNextPreset(_arg0, _arg1);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.switchToNextPresetForGroup(_arg0, _arg1);
                    break;
                }
                case 13: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.switchToPreviousPreset(_arg0, _arg1);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.switchToPreviousPresetForGroup(_arg0, _arg1);
                    break;
                }
                case 15: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg3 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getPresetInfo(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 16: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getAllPresetInfo(_arg0, _arg1, _arg2);
                    break;
                }
                case 17: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getFeatures(_arg0, _arg1, _arg2);
                    break;
                }
                case 18: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    AttributionSource _arg3 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.setPresetName(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    AttributionSource _arg3 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.setPresetNameForGroup(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 20: {
                    IBluetoothHapClientCallback _arg0 = IBluetoothHapClientCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.registerCallback(_arg0, _arg1, _arg2);
                    break;
                }
                case 21: {
                    IBluetoothHapClientCallback _arg0 = IBluetoothHapClientCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.unregisterCallback(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IBluetoothHapClient {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBluetoothHapClient.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getConnectedDevices(AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClient.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getDevicesMatchingConnectionStates(int[] states, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClient.DESCRIPTOR);
                    _data.writeIntArray(states);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getConnectionState(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClient.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setConnectionPolicy(BluetoothDevice device, int connectionPolicy, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClient.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(connectionPolicy);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getConnectionPolicy(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClient.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getHapGroup(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClient.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getActivePresetIndex(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClient.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getActivePresetInfo(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClient.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void selectPreset(BluetoothDevice device, int presetIndex, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClient.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(presetIndex);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void selectPresetForGroup(int groupId, int presetIndex, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClient.DESCRIPTOR);
                    _data.writeInt(groupId);
                    _data.writeInt(presetIndex);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void switchToNextPreset(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClient.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void switchToNextPresetForGroup(int groupId, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClient.DESCRIPTOR);
                    _data.writeInt(groupId);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void switchToPreviousPreset(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClient.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void switchToPreviousPresetForGroup(int groupId, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClient.DESCRIPTOR);
                    _data.writeInt(groupId);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getPresetInfo(BluetoothDevice device, int presetIndex, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClient.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(presetIndex);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getAllPresetInfo(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClient.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getFeatures(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClient.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPresetName(BluetoothDevice device, int presetIndex, String name, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClient.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(presetIndex);
                    _data.writeString(name);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPresetNameForGroup(int groupId, int presetIndex, String name, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClient.DESCRIPTOR);
                    _data.writeInt(groupId);
                    _data.writeInt(presetIndex);
                    _data.writeString(name);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCallback(IBluetoothHapClientCallback callback2, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClient.DESCRIPTOR);
                    _data.writeStrongInterface(callback2);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(20, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCallback(IBluetoothHapClientCallback callback2, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClient.DESCRIPTOR);
                    _data.writeStrongInterface(callback2);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothHapClient {
        @Override
        public void getConnectedDevices(AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getDevicesMatchingConnectionStates(int[] states, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getConnectionState(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void setConnectionPolicy(BluetoothDevice device, int connectionPolicy, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getConnectionPolicy(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getHapGroup(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getActivePresetIndex(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getActivePresetInfo(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void selectPreset(BluetoothDevice device, int presetIndex, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void selectPresetForGroup(int groupId, int presetIndex, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void switchToNextPreset(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void switchToNextPresetForGroup(int groupId, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void switchToPreviousPreset(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void switchToPreviousPresetForGroup(int groupId, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void getPresetInfo(BluetoothDevice device, int presetIndex, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getAllPresetInfo(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getFeatures(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void setPresetName(BluetoothDevice device, int presetIndex, String name, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void setPresetNameForGroup(int groupId, int presetIndex, String name, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void registerCallback(IBluetoothHapClientCallback callback2, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void unregisterCallback(IBluetoothHapClientCallback callback2, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

