/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothLeBroadcastMetadata;
import android.bluetooth.BluetoothLeBroadcastReceiveState;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBluetoothLeBroadcastAssistantCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.bluetooth.IBluetoothLeBroadcastAssistantCallback";

    public void onSearchStarted(int var1) throws RemoteException;

    public void onSearchStartFailed(int var1) throws RemoteException;

    public void onSearchStopped(int var1) throws RemoteException;

    public void onSearchStopFailed(int var1) throws RemoteException;

    public void onSourceFound(BluetoothLeBroadcastMetadata var1) throws RemoteException;

    public void onSourceAdded(BluetoothDevice var1, int var2, int var3) throws RemoteException;

    public void onSourceAddFailed(BluetoothDevice var1, BluetoothLeBroadcastMetadata var2, int var3) throws RemoteException;

    public void onSourceModified(BluetoothDevice var1, int var2, int var3) throws RemoteException;

    public void onSourceModifyFailed(BluetoothDevice var1, int var2, int var3) throws RemoteException;

    public void onSourceRemoved(BluetoothDevice var1, int var2, int var3) throws RemoteException;

    public void onSourceRemoveFailed(BluetoothDevice var1, int var2, int var3) throws RemoteException;

    public void onReceiveStateChanged(BluetoothDevice var1, int var2, BluetoothLeBroadcastReceiveState var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothLeBroadcastAssistantCallback {
        static final int TRANSACTION_onSearchStarted = 1;
        static final int TRANSACTION_onSearchStartFailed = 2;
        static final int TRANSACTION_onSearchStopped = 3;
        static final int TRANSACTION_onSearchStopFailed = 4;
        static final int TRANSACTION_onSourceFound = 5;
        static final int TRANSACTION_onSourceAdded = 6;
        static final int TRANSACTION_onSourceAddFailed = 7;
        static final int TRANSACTION_onSourceModified = 8;
        static final int TRANSACTION_onSourceModifyFailed = 9;
        static final int TRANSACTION_onSourceRemoved = 10;
        static final int TRANSACTION_onSourceRemoveFailed = 11;
        static final int TRANSACTION_onReceiveStateChanged = 12;

        public Stub() {
            this.attachInterface(this, IBluetoothLeBroadcastAssistantCallback.DESCRIPTOR);
        }

        public static IBluetoothLeBroadcastAssistantCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBluetoothLeBroadcastAssistantCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothLeBroadcastAssistantCallback) {
                return (IBluetoothLeBroadcastAssistantCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBluetoothLeBroadcastAssistantCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSearchStarted(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSearchStartFailed(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSearchStopped(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSearchStopFailed(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    BluetoothLeBroadcastMetadata _arg0 = data.readTypedObject(BluetoothLeBroadcastMetadata.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSourceFound(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSourceAdded(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    BluetoothLeBroadcastMetadata _arg1 = data.readTypedObject(BluetoothLeBroadcastMetadata.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSourceAddFailed(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSourceModified(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSourceModifyFailed(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSourceRemoved(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSourceRemoveFailed(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    BluetoothLeBroadcastReceiveState _arg2 = data.readTypedObject(BluetoothLeBroadcastReceiveState.CREATOR);
                    data.enforceNoDataAvail();
                    this.onReceiveStateChanged(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IBluetoothLeBroadcastAssistantCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBluetoothLeBroadcastAssistantCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSearchStarted(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeBroadcastAssistantCallback.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSearchStartFailed(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeBroadcastAssistantCallback.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSearchStopped(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeBroadcastAssistantCallback.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSearchStopFailed(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeBroadcastAssistantCallback.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSourceFound(BluetoothLeBroadcastMetadata source) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeBroadcastAssistantCallback.DESCRIPTOR);
                    _data.writeTypedObject(source, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSourceAdded(BluetoothDevice sink, int sourceId, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeBroadcastAssistantCallback.DESCRIPTOR);
                    _data.writeTypedObject(sink, 0);
                    _data.writeInt(sourceId);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSourceAddFailed(BluetoothDevice sink, BluetoothLeBroadcastMetadata source, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeBroadcastAssistantCallback.DESCRIPTOR);
                    _data.writeTypedObject(sink, 0);
                    _data.writeTypedObject(source, 0);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSourceModified(BluetoothDevice sink, int sourceId, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeBroadcastAssistantCallback.DESCRIPTOR);
                    _data.writeTypedObject(sink, 0);
                    _data.writeInt(sourceId);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSourceModifyFailed(BluetoothDevice sink, int sourceId, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeBroadcastAssistantCallback.DESCRIPTOR);
                    _data.writeTypedObject(sink, 0);
                    _data.writeInt(sourceId);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSourceRemoved(BluetoothDevice sink, int sourceId, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeBroadcastAssistantCallback.DESCRIPTOR);
                    _data.writeTypedObject(sink, 0);
                    _data.writeInt(sourceId);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSourceRemoveFailed(BluetoothDevice sink, int sourceId, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeBroadcastAssistantCallback.DESCRIPTOR);
                    _data.writeTypedObject(sink, 0);
                    _data.writeInt(sourceId);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceiveStateChanged(BluetoothDevice sink, int sourceId, BluetoothLeBroadcastReceiveState state) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeBroadcastAssistantCallback.DESCRIPTOR);
                    _data.writeTypedObject(sink, 0);
                    _data.writeInt(sourceId);
                    _data.writeTypedObject(state, 0);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothLeBroadcastAssistantCallback {
        @Override
        public void onSearchStarted(int reason) throws RemoteException {
        }

        @Override
        public void onSearchStartFailed(int reason) throws RemoteException {
        }

        @Override
        public void onSearchStopped(int reason) throws RemoteException {
        }

        @Override
        public void onSearchStopFailed(int reason) throws RemoteException {
        }

        @Override
        public void onSourceFound(BluetoothLeBroadcastMetadata source) throws RemoteException {
        }

        @Override
        public void onSourceAdded(BluetoothDevice sink, int sourceId, int reason) throws RemoteException {
        }

        @Override
        public void onSourceAddFailed(BluetoothDevice sink, BluetoothLeBroadcastMetadata source, int reason) throws RemoteException {
        }

        @Override
        public void onSourceModified(BluetoothDevice sink, int sourceId, int reason) throws RemoteException {
        }

        @Override
        public void onSourceModifyFailed(BluetoothDevice sink, int sourceId, int reason) throws RemoteException {
        }

        @Override
        public void onSourceRemoved(BluetoothDevice sink, int sourceId, int reason) throws RemoteException {
        }

        @Override
        public void onSourceRemoveFailed(BluetoothDevice sink, int sourceId, int reason) throws RemoteException {
        }

        @Override
        public void onReceiveStateChanged(BluetoothDevice sink, int sourceId, BluetoothLeBroadcastReceiveState state) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

