/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.bluetooth.BluetoothLeBroadcastMetadata;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBluetoothLeBroadcastCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.bluetooth.IBluetoothLeBroadcastCallback";

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void onBroadcastStarted(int var1, int var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void onBroadcastStartFailed(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void onBroadcastStopped(int var1, int var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void onBroadcastStopFailed(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void onPlaybackStarted(int var1, int var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void onPlaybackStopped(int var1, int var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void onBroadcastUpdated(int var1, int var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void onBroadcastUpdateFailed(int var1, int var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void onBroadcastMetadataChanged(int var1, BluetoothLeBroadcastMetadata var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothLeBroadcastCallback {
        static final int TRANSACTION_onBroadcastStarted = 1;
        static final int TRANSACTION_onBroadcastStartFailed = 2;
        static final int TRANSACTION_onBroadcastStopped = 3;
        static final int TRANSACTION_onBroadcastStopFailed = 4;
        static final int TRANSACTION_onPlaybackStarted = 5;
        static final int TRANSACTION_onPlaybackStopped = 6;
        static final int TRANSACTION_onBroadcastUpdated = 7;
        static final int TRANSACTION_onBroadcastUpdateFailed = 8;
        static final int TRANSACTION_onBroadcastMetadataChanged = 9;

        public Stub() {
            this.attachInterface(this, IBluetoothLeBroadcastCallback.DESCRIPTOR);
        }

        public static IBluetoothLeBroadcastCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBluetoothLeBroadcastCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothLeBroadcastCallback) {
                return (IBluetoothLeBroadcastCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBluetoothLeBroadcastCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBroadcastStarted(_arg0, _arg1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBroadcastStartFailed(_arg0);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBroadcastStopped(_arg0, _arg1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBroadcastStopFailed(_arg0);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onPlaybackStarted(_arg0, _arg1);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onPlaybackStopped(_arg0, _arg1);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBroadcastUpdated(_arg0, _arg1);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBroadcastUpdateFailed(_arg0, _arg1);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    BluetoothLeBroadcastMetadata _arg1 = data.readTypedObject(BluetoothLeBroadcastMetadata.CREATOR);
                    data.enforceNoDataAvail();
                    this.onBroadcastMetadataChanged(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IBluetoothLeBroadcastCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBluetoothLeBroadcastCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBroadcastStarted(int reason, int broadcastId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeBroadcastCallback.DESCRIPTOR);
                    _data.writeInt(reason);
                    _data.writeInt(broadcastId);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBroadcastStartFailed(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeBroadcastCallback.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBroadcastStopped(int reason, int broadcastId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeBroadcastCallback.DESCRIPTOR);
                    _data.writeInt(reason);
                    _data.writeInt(broadcastId);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBroadcastStopFailed(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeBroadcastCallback.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPlaybackStarted(int reason, int broadcastId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeBroadcastCallback.DESCRIPTOR);
                    _data.writeInt(reason);
                    _data.writeInt(broadcastId);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPlaybackStopped(int reason, int broadcastId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeBroadcastCallback.DESCRIPTOR);
                    _data.writeInt(reason);
                    _data.writeInt(broadcastId);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBroadcastUpdated(int reason, int broadcastId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeBroadcastCallback.DESCRIPTOR);
                    _data.writeInt(reason);
                    _data.writeInt(broadcastId);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBroadcastUpdateFailed(int reason, int broadcastId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeBroadcastCallback.DESCRIPTOR);
                    _data.writeInt(reason);
                    _data.writeInt(broadcastId);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBroadcastMetadataChanged(int broadcastId, BluetoothLeBroadcastMetadata metadata) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeBroadcastCallback.DESCRIPTOR);
                    _data.writeInt(broadcastId);
                    _data.writeTypedObject(metadata, 0);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothLeBroadcastCallback {
        @Override
        public void onBroadcastStarted(int reason, int broadcastId) throws RemoteException {
        }

        @Override
        public void onBroadcastStartFailed(int reason) throws RemoteException {
        }

        @Override
        public void onBroadcastStopped(int reason, int broadcastId) throws RemoteException {
        }

        @Override
        public void onBroadcastStopFailed(int reason) throws RemoteException {
        }

        @Override
        public void onPlaybackStarted(int reason, int broadcastId) throws RemoteException {
        }

        @Override
        public void onPlaybackStopped(int reason, int broadcastId) throws RemoteException {
        }

        @Override
        public void onBroadcastUpdated(int reason, int broadcastId) throws RemoteException {
        }

        @Override
        public void onBroadcastUpdateFailed(int reason, int broadcastId) throws RemoteException {
        }

        @Override
        public void onBroadcastMetadataChanged(int broadcastId, BluetoothLeBroadcastMetadata metadata) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

