/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class AdvertisingSetParameters
implements Parcelable {
    public static final int INTERVAL_HIGH = 1600;
    public static final int INTERVAL_MEDIUM = 400;
    public static final int INTERVAL_LOW = 160;
    public static final int INTERVAL_MIN = 160;
    public static final int INTERVAL_MAX = 0xFFFFFF;
    public static final int TX_POWER_ULTRA_LOW = -21;
    public static final int TX_POWER_LOW = -15;
    public static final int TX_POWER_MEDIUM = -7;
    public static final int TX_POWER_HIGH = 1;
    public static final int TX_POWER_MIN = -127;
    public static final int TX_POWER_MAX = 1;
    private static final int LIMITED_ADVERTISING_MAX_MILLIS = 180000;
    @SystemApi
    public static final int ADDRESS_TYPE_DEFAULT = -1;
    @SystemApi
    public static final int ADDRESS_TYPE_PUBLIC = 0;
    @SystemApi
    public static final int ADDRESS_TYPE_RANDOM = 1;
    private final boolean mIsLegacy;
    private final boolean mIsAnonymous;
    private final boolean mIncludeTxPower;
    private final int mPrimaryPhy;
    private final int mSecondaryPhy;
    private final boolean mConnectable;
    private final boolean mScannable;
    private final int mInterval;
    private final int mTxPowerLevel;
    private final int mOwnAddressType;
    public static final Parcelable.Creator<AdvertisingSetParameters> CREATOR = new Parcelable.Creator<AdvertisingSetParameters>(){

        public AdvertisingSetParameters[] newArray(int size) {
            return new AdvertisingSetParameters[size];
        }

        @Override
        public AdvertisingSetParameters createFromParcel(Parcel in) {
            return new AdvertisingSetParameters(in);
        }
    };

    private AdvertisingSetParameters(boolean connectable, boolean scannable, boolean isLegacy, boolean isAnonymous, boolean includeTxPower, int primaryPhy, int secondaryPhy, int interval, int txPowerLevel, int ownAddressType) {
        this.mConnectable = connectable;
        this.mScannable = scannable;
        this.mIsLegacy = isLegacy;
        this.mIsAnonymous = isAnonymous;
        this.mIncludeTxPower = includeTxPower;
        this.mPrimaryPhy = primaryPhy;
        this.mSecondaryPhy = secondaryPhy;
        this.mInterval = interval;
        this.mTxPowerLevel = txPowerLevel;
        this.mOwnAddressType = ownAddressType;
    }

    private AdvertisingSetParameters(Parcel in) {
        this.mConnectable = in.readInt() != 0;
        this.mScannable = in.readInt() != 0;
        this.mIsLegacy = in.readInt() != 0;
        this.mIsAnonymous = in.readInt() != 0;
        this.mIncludeTxPower = in.readInt() != 0;
        this.mPrimaryPhy = in.readInt();
        this.mSecondaryPhy = in.readInt();
        this.mInterval = in.readInt();
        this.mTxPowerLevel = in.readInt();
        this.mOwnAddressType = in.readInt();
    }

    public boolean isConnectable() {
        return this.mConnectable;
    }

    public boolean isScannable() {
        return this.mScannable;
    }

    public boolean isLegacy() {
        return this.mIsLegacy;
    }

    public boolean isAnonymous() {
        return this.mIsAnonymous;
    }

    public boolean includeTxPower() {
        return this.mIncludeTxPower;
    }

    public int getPrimaryPhy() {
        return this.mPrimaryPhy;
    }

    public int getSecondaryPhy() {
        return this.mSecondaryPhy;
    }

    public int getInterval() {
        return this.mInterval;
    }

    public int getTxPowerLevel() {
        return this.mTxPowerLevel;
    }

    @SystemApi
    public int getOwnAddressType() {
        return this.mOwnAddressType;
    }

    public String toString() {
        return "AdvertisingSetParameters [connectable=" + this.mConnectable + ", isLegacy=" + this.mIsLegacy + ", isAnonymous=" + this.mIsAnonymous + ", includeTxPower=" + this.mIncludeTxPower + ", primaryPhy=" + this.mPrimaryPhy + ", secondaryPhy=" + this.mSecondaryPhy + ", interval=" + this.mInterval + ", txPowerLevel=" + this.mTxPowerLevel + ", ownAddressType=" + this.mOwnAddressType + "]";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mConnectable ? 1 : 0);
        dest.writeInt(this.mScannable ? 1 : 0);
        dest.writeInt(this.mIsLegacy ? 1 : 0);
        dest.writeInt(this.mIsAnonymous ? 1 : 0);
        dest.writeInt(this.mIncludeTxPower ? 1 : 0);
        dest.writeInt(this.mPrimaryPhy);
        dest.writeInt(this.mSecondaryPhy);
        dest.writeInt(this.mInterval);
        dest.writeInt(this.mTxPowerLevel);
        dest.writeInt(this.mOwnAddressType);
    }

    public static class Builder {
        private boolean mConnectable = false;
        private boolean mScannable = false;
        private boolean mIsLegacy = false;
        private boolean mIsAnonymous = false;
        private boolean mIncludeTxPower = false;
        private int mPrimaryPhy = 1;
        private int mSecondaryPhy = 1;
        private int mInterval = 160;
        private int mTxPowerLevel = -7;
        private int mOwnAddressType = -1;

        public Builder setConnectable(boolean connectable) {
            this.mConnectable = connectable;
            return this;
        }

        public Builder setScannable(boolean scannable) {
            this.mScannable = scannable;
            return this;
        }

        public Builder setLegacyMode(boolean isLegacy) {
            this.mIsLegacy = isLegacy;
            return this;
        }

        public Builder setAnonymous(boolean isAnonymous) {
            this.mIsAnonymous = isAnonymous;
            return this;
        }

        public Builder setIncludeTxPower(boolean includeTxPower) {
            this.mIncludeTxPower = includeTxPower;
            return this;
        }

        public Builder setPrimaryPhy(int primaryPhy) {
            if (primaryPhy != 1 && primaryPhy != 3) {
                throw new IllegalArgumentException("bad primaryPhy " + primaryPhy);
            }
            this.mPrimaryPhy = primaryPhy;
            return this;
        }

        public Builder setSecondaryPhy(int secondaryPhy) {
            if (secondaryPhy != 1 && secondaryPhy != 2 && secondaryPhy != 3) {
                throw new IllegalArgumentException("bad secondaryPhy " + secondaryPhy);
            }
            this.mSecondaryPhy = secondaryPhy;
            return this;
        }

        public Builder setInterval(int interval) {
            if (interval < 160 || interval > 0xFFFFFF) {
                throw new IllegalArgumentException("unknown interval " + interval);
            }
            this.mInterval = interval;
            return this;
        }

        public Builder setTxPowerLevel(int txPowerLevel) {
            if (txPowerLevel < -127 || txPowerLevel > 1) {
                throw new IllegalArgumentException("unknown txPowerLevel " + txPowerLevel);
            }
            this.mTxPowerLevel = txPowerLevel;
            return this;
        }

        @SystemApi
        public Builder setOwnAddressType(int ownAddressType) {
            if (ownAddressType < -1 || ownAddressType > 1) {
                throw new IllegalArgumentException("unknown address type " + ownAddressType);
            }
            this.mOwnAddressType = ownAddressType;
            return this;
        }

        public AdvertisingSetParameters build() {
            if (this.mIsLegacy) {
                if (this.mIsAnonymous) {
                    throw new IllegalArgumentException("Legacy advertising can't be anonymous");
                }
                if (this.mConnectable && !this.mScannable) {
                    throw new IllegalStateException("Legacy advertisement can't be connectable and non-scannable");
                }
                if (this.mIncludeTxPower) {
                    throw new IllegalStateException("Legacy advertising can't include TX power level in header");
                }
            } else {
                if (this.mConnectable && this.mScannable) {
                    throw new IllegalStateException("Advertising can't be both connectable and scannable");
                }
                if (this.mIsAnonymous && this.mConnectable) {
                    throw new IllegalStateException("Advertising can't be both connectable and anonymous");
                }
            }
            return new AdvertisingSetParameters(this.mConnectable, this.mScannable, this.mIsLegacy, this.mIsAnonymous, this.mIncludeTxPower, this.mPrimaryPhy, this.mSecondaryPhy, this.mInterval, this.mTxPowerLevel, this.mOwnAddressType);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AddressTypeStatus {
    }
}

