/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.bluetooth.Attributable;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.le.BluetoothLeUtils;
import android.bluetooth.le.IScannerCallback;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.bluetooth.le.TruncatedFilter;
import android.content.AttributionSource;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.os.WorkSource;
import android.util.Log;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;

public class BluetoothLeScanner {
    private static final String TAG = "BluetoothLeScanner";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    public static final String EXTRA_LIST_SCAN_RESULT = "android.bluetooth.le.extra.LIST_SCAN_RESULT";
    public static final String EXTRA_ERROR_CODE = "android.bluetooth.le.extra.ERROR_CODE";
    public static final String EXTRA_CALLBACK_TYPE = "android.bluetooth.le.extra.CALLBACK_TYPE";
    private final BluetoothAdapter mBluetoothAdapter;
    private final IBluetoothManager mBluetoothManager;
    private final AttributionSource mAttributionSource;
    private final Handler mHandler;
    private final Map<ScanCallback, BleScanCallbackWrapper> mLeScanClients;

    public BluetoothLeScanner(BluetoothAdapter bluetoothAdapter) {
        this.mBluetoothAdapter = Objects.requireNonNull(bluetoothAdapter);
        this.mBluetoothManager = this.mBluetoothAdapter.getBluetoothManager();
        this.mAttributionSource = this.mBluetoothAdapter.getAttributionSource();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mLeScanClients = new HashMap<ScanCallback, BleScanCallbackWrapper>();
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void startScan(ScanCallback callback2) {
        this.startScan(null, new ScanSettings.Builder().build(), callback2);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void startScan(List<ScanFilter> filters, ScanSettings settings, ScanCallback callback2) {
        this.startScan(filters, settings, null, callback2, null);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public int startScan(List<ScanFilter> filters, ScanSettings settings, PendingIntent callbackIntent) {
        return this.startScan(filters, settings != null ? settings : new ScanSettings.Builder().build(), null, null, callbackIntent);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_SCAN", "android.permission.UPDATE_DEVICE_STATS"})
    public void startScanFromSource(WorkSource workSource, ScanCallback callback2) {
        this.startScanFromSource(null, new ScanSettings.Builder().build(), workSource, callback2);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_SCAN", "android.permission.UPDATE_DEVICE_STATS"})
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public void startScanFromSource(List<ScanFilter> filters, ScanSettings settings, WorkSource workSource, ScanCallback callback2) {
        this.startScan(filters, settings, workSource, callback2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    private int startScan(List<ScanFilter> filters, ScanSettings settings, WorkSource workSource, ScanCallback callback2, PendingIntent callbackIntent) {
        BluetoothLeUtils.checkAdapterStateOn(this.mBluetoothAdapter);
        if (callback2 == null && callbackIntent == null) {
            throw new IllegalArgumentException("callback is null");
        }
        if (settings == null) {
            throw new IllegalArgumentException("settings is null");
        }
        Map<ScanCallback, BleScanCallbackWrapper> map2 = this.mLeScanClients;
        synchronized (map2) {
            IBluetoothGatt gatt;
            if (callback2 != null && this.mLeScanClients.containsKey(callback2)) {
                return this.postCallbackErrorOrReturn(callback2, 1);
            }
            try {
                gatt = this.mBluetoothManager.getBluetoothGatt();
            }
            catch (RemoteException e) {
                gatt = null;
            }
            if (gatt == null) {
                return this.postCallbackErrorOrReturn(callback2, 3);
            }
            if (!this.isSettingsConfigAllowedForScan(settings)) {
                return this.postCallbackErrorOrReturn(callback2, 4);
            }
            if (!this.isHardwareResourcesAvailableForScan(settings)) {
                return this.postCallbackErrorOrReturn(callback2, 5);
            }
            if (!this.isSettingsAndFilterComboAllowed(settings, filters)) {
                return this.postCallbackErrorOrReturn(callback2, 4);
            }
            if (callback2 != null) {
                BleScanCallbackWrapper wrapper = new BleScanCallbackWrapper(gatt, filters, settings, workSource, callback2);
                wrapper.startRegistration();
            } else {
                try {
                    SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                    gatt.startScanForIntent(callbackIntent, settings, filters, this.mAttributionSource, recv);
                    recv.awaitResultNoInterrupt(BluetoothLeUtils.getSyncTimeout()).getValue(null);
                }
                catch (RemoteException | TimeoutException e) {
                    return 3;
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void stopScan(ScanCallback callback2) {
        BluetoothLeUtils.checkAdapterStateOn(this.mBluetoothAdapter);
        Map<ScanCallback, BleScanCallbackWrapper> map2 = this.mLeScanClients;
        synchronized (map2) {
            BleScanCallbackWrapper wrapper = this.mLeScanClients.remove(callback2);
            if (wrapper == null) {
                Log.d(TAG, "could not find callback wrapper");
                return;
            }
            wrapper.stopLeScan();
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void stopScan(PendingIntent callbackIntent) {
        BluetoothLeUtils.checkAdapterStateOn(this.mBluetoothAdapter);
        try {
            IBluetoothGatt gatt = this.mBluetoothManager.getBluetoothGatt();
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            gatt.stopScanForIntent(callbackIntent, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothLeUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void flushPendingScanResults(ScanCallback callback2) {
        BluetoothLeUtils.checkAdapterStateOn(this.mBluetoothAdapter);
        if (callback2 == null) {
            throw new IllegalArgumentException("callback cannot be null!");
        }
        Map<ScanCallback, BleScanCallbackWrapper> map2 = this.mLeScanClients;
        synchronized (map2) {
            BleScanCallbackWrapper wrapper = this.mLeScanClients.get(callback2);
            if (wrapper == null) {
                return;
            }
            wrapper.flushPendingBatchResults();
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void startTruncatedScan(List<TruncatedFilter> truncatedFilters, ScanSettings settings, ScanCallback callback2) {
        int filterSize = truncatedFilters.size();
        ArrayList<ScanFilter> scanFilters = new ArrayList<ScanFilter>(filterSize);
        for (TruncatedFilter filter2 : truncatedFilters) {
            scanFilters.add(filter2.getFilter());
        }
        this.startScan(scanFilters, settings, null, callback2, null);
    }

    @RequiresNoPermission
    public void cleanup() {
        this.mLeScanClients.clear();
    }

    private int postCallbackErrorOrReturn(ScanCallback callback2, int errorCode) {
        if (callback2 == null) {
            return errorCode;
        }
        this.postCallbackError(callback2, errorCode);
        return 0;
    }

    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private void postCallbackError(final ScanCallback callback2, final int errorCode) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                callback2.onScanFailed(errorCode);
            }
        });
    }

    private boolean isSettingsConfigAllowedForScan(ScanSettings settings) {
        if (this.mBluetoothAdapter.isOffloadedFilteringSupported()) {
            return true;
        }
        int callbackType = settings.getCallbackType();
        return callbackType == 1 && settings.getReportDelayMillis() == 0L;
    }

    private boolean isSettingsAndFilterComboAllowed(ScanSettings settings, List<ScanFilter> filterList) {
        int callbackType = settings.getCallbackType();
        if ((callbackType & 6) != 0) {
            if (filterList == null) {
                return false;
            }
            for (ScanFilter filter2 : filterList) {
                if (!filter2.isAllFieldsEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    private boolean isHardwareResourcesAvailableForScan(ScanSettings settings) {
        int callbackType = settings.getCallbackType();
        if ((callbackType & 2) != 0 || (callbackType & 4) != 0) {
            return this.mBluetoothAdapter.isOffloadedFilteringSupported() && this.mBluetoothAdapter.isHardwareTrackingFiltersAvailable();
        }
        return true;
    }

    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    private class BleScanCallbackWrapper
    extends IScannerCallback.Stub {
        private static final int REGISTRATION_CALLBACK_TIMEOUT_MILLIS = 2000;
        private final ScanCallback mScanCallback;
        private final List<ScanFilter> mFilters;
        private final WorkSource mWorkSource;
        private ScanSettings mSettings;
        private IBluetoothGatt mBluetoothGatt;
        private int mScannerId;

        public BleScanCallbackWrapper(IBluetoothGatt bluetoothGatt, List<ScanFilter> filters, ScanSettings settings, WorkSource workSource, ScanCallback scanCallback) {
            this.mBluetoothGatt = bluetoothGatt;
            this.mFilters = filters;
            this.mSettings = settings;
            this.mWorkSource = workSource;
            this.mScanCallback = scanCallback;
            this.mScannerId = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startRegistration() {
            BleScanCallbackWrapper bleScanCallbackWrapper = this;
            synchronized (bleScanCallbackWrapper) {
                if (this.mScannerId == -1 || this.mScannerId == -2) {
                    return;
                }
                try {
                    SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                    this.mBluetoothGatt.registerScanner(this, this.mWorkSource, BluetoothLeScanner.this.mAttributionSource, recv);
                    recv.awaitResultNoInterrupt(BluetoothLeUtils.getSyncTimeout()).getValue(null);
                    this.wait(2000L);
                }
                catch (RemoteException | InterruptedException | TimeoutException e) {
                    Log.e(BluetoothLeScanner.TAG, "application registeration exception", e);
                    BluetoothLeScanner.this.postCallbackError(this.mScanCallback, 3);
                }
                if (this.mScannerId > 0) {
                    BluetoothLeScanner.this.mLeScanClients.put(this.mScanCallback, this);
                } else {
                    if (this.mScannerId == 0) {
                        this.mScannerId = -1;
                    }
                    if (this.mScannerId == -2) {
                        return;
                    }
                    BluetoothLeScanner.this.postCallbackError(this.mScanCallback, 2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
        public void stopLeScan() {
            BleScanCallbackWrapper bleScanCallbackWrapper = this;
            synchronized (bleScanCallbackWrapper) {
                if (this.mScannerId <= 0) {
                    Log.e(BluetoothLeScanner.TAG, "Error state, mLeHandle: " + this.mScannerId);
                    return;
                }
                try {
                    SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                    this.mBluetoothGatt.stopScan(this.mScannerId, BluetoothLeScanner.this.mAttributionSource, recv);
                    recv.awaitResultNoInterrupt(BluetoothLeUtils.getSyncTimeout()).getValue(null);
                    SynchronousResultReceiver recv2 = SynchronousResultReceiver.get();
                    this.mBluetoothGatt.unregisterScanner(this.mScannerId, BluetoothLeScanner.this.mAttributionSource, recv2);
                    recv2.awaitResultNoInterrupt(BluetoothLeUtils.getSyncTimeout()).getValue(null);
                }
                catch (RemoteException | TimeoutException e) {
                    Log.e(BluetoothLeScanner.TAG, "Failed to stop scan and unregister", e);
                }
                this.mScannerId = -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
        void flushPendingBatchResults() {
            BleScanCallbackWrapper bleScanCallbackWrapper = this;
            synchronized (bleScanCallbackWrapper) {
                if (this.mScannerId <= 0) {
                    Log.e(BluetoothLeScanner.TAG, "Error state, mLeHandle: " + this.mScannerId);
                    return;
                }
                try {
                    SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                    this.mBluetoothGatt.flushPendingBatchResults(this.mScannerId, BluetoothLeScanner.this.mAttributionSource, recv);
                    recv.awaitResultNoInterrupt(BluetoothLeUtils.getSyncTimeout()).getValue(null);
                }
                catch (RemoteException | TimeoutException e) {
                    Log.e(BluetoothLeScanner.TAG, "Failed to get pending scan results", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onScannerRegistered(int status, int scannerId) {
            Log.d(BluetoothLeScanner.TAG, "onScannerRegistered() - status=" + status + " scannerId=" + scannerId + " mScannerId=" + this.mScannerId);
            BleScanCallbackWrapper bleScanCallbackWrapper = this;
            synchronized (bleScanCallbackWrapper) {
                if (status == 0) {
                    try {
                        SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                        if (this.mScannerId == -1) {
                            this.mBluetoothGatt.unregisterScanner(scannerId, BluetoothLeScanner.this.mAttributionSource, recv);
                        } else {
                            this.mScannerId = scannerId;
                            this.mBluetoothGatt.startScan(this.mScannerId, this.mSettings, this.mFilters, BluetoothLeScanner.this.mAttributionSource, recv);
                        }
                        recv.awaitResultNoInterrupt(BluetoothLeUtils.getSyncTimeout()).getValue(null);
                    }
                    catch (RemoteException | TimeoutException e) {
                        Log.e(BluetoothLeScanner.TAG, "fail to start le scan: " + e);
                        this.mScannerId = -1;
                    }
                } else {
                    this.mScannerId = status == 6 ? -2 : -1;
                }
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onScanResult(final ScanResult scanResult) {
            Attributable.setAttributionSource(scanResult, BluetoothLeScanner.this.mAttributionSource);
            if (Log.isLoggable(BluetoothLeScanner.TAG, 3)) {
                Log.d(BluetoothLeScanner.TAG, "onScanResult() - mScannerId=" + this.mScannerId);
            }
            BleScanCallbackWrapper bleScanCallbackWrapper = this;
            synchronized (bleScanCallbackWrapper) {
                if (this.mScannerId <= 0) {
                    if (Log.isLoggable(BluetoothLeScanner.TAG, 3)) {
                        Log.d(BluetoothLeScanner.TAG, "Ignoring result as scan stopped.");
                    }
                    return;
                }
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (Log.isLoggable(BluetoothLeScanner.TAG, 3)) {
                        Log.d(BluetoothLeScanner.TAG, "onScanResult() - handler run");
                    }
                    BleScanCallbackWrapper.this.mScanCallback.onScanResult(1, scanResult);
                }
            });
        }

        @Override
        public void onBatchScanResults(final List<ScanResult> results) {
            Attributable.setAttributionSource(results, BluetoothLeScanner.this.mAttributionSource);
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    BleScanCallbackWrapper.this.mScanCallback.onBatchScanResults(results);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFoundOrLost(final boolean onFound, final ScanResult scanResult) {
            Attributable.setAttributionSource(scanResult, BluetoothLeScanner.this.mAttributionSource);
            BleScanCallbackWrapper bleScanCallbackWrapper = this;
            synchronized (bleScanCallbackWrapper) {
                if (this.mScannerId <= 0) {
                    return;
                }
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (onFound) {
                        BleScanCallbackWrapper.this.mScanCallback.onScanResult(2, scanResult);
                    } else {
                        BleScanCallbackWrapper.this.mScanCallback.onScanResult(4, scanResult);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onScanManagerErrorCallback(int errorCode) {
            BleScanCallbackWrapper bleScanCallbackWrapper = this;
            synchronized (bleScanCallbackWrapper) {
                if (this.mScannerId <= 0) {
                    return;
                }
            }
            BluetoothLeScanner.this.postCallbackError(this.mScanCallback, errorCode);
        }
    }
}

