/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.bluetooth.Attributable;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.le.BluetoothLeUtils;
import android.bluetooth.le.IPeriodicAdvertisingCallback;
import android.bluetooth.le.PeriodicAdvertisingCallback;
import android.bluetooth.le.PeriodicAdvertisingReport;
import android.bluetooth.le.ScanResult;
import android.content.AttributionSource;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;

public class PeriodicAdvertisingManager {
    private static final String TAG = "PeriodicAdvertisingManager";
    private static final int SKIP_MIN = 0;
    private static final int SKIP_MAX = 499;
    private static final int TIMEOUT_MIN = 10;
    private static final int TIMEOUT_MAX = 16384;
    private static final int SYNC_STARTING = -1;
    private final BluetoothAdapter mBluetoothAdapter;
    private final IBluetoothManager mBluetoothManager;
    private final AttributionSource mAttributionSource;
    Map<PeriodicAdvertisingCallback, IPeriodicAdvertisingCallback> mCallbackWrappers;

    public PeriodicAdvertisingManager(BluetoothAdapter bluetoothAdapter) {
        this.mBluetoothAdapter = Objects.requireNonNull(bluetoothAdapter);
        this.mBluetoothManager = this.mBluetoothAdapter.getBluetoothManager();
        this.mAttributionSource = this.mBluetoothAdapter.getAttributionSource();
        this.mCallbackWrappers = new IdentityHashMap<PeriodicAdvertisingCallback, IPeriodicAdvertisingCallback>();
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void registerSync(ScanResult scanResult, int skip, int timeout, PeriodicAdvertisingCallback callback2) {
        this.registerSync(scanResult, skip, timeout, callback2, null);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void registerSync(ScanResult scanResult, int skip, int timeout, PeriodicAdvertisingCallback callback2, Handler handler) {
        IBluetoothGatt gatt;
        if (callback2 == null) {
            throw new IllegalArgumentException("callback can't be null");
        }
        if (scanResult == null) {
            throw new IllegalArgumentException("scanResult can't be null");
        }
        if (scanResult.getAdvertisingSid() == 255) {
            throw new IllegalArgumentException("scanResult must contain a valid sid");
        }
        if (skip < 0 || skip > 499) {
            throw new IllegalArgumentException("timeout must be between 10 and 16384");
        }
        if (timeout < 10 || timeout > 16384) {
            throw new IllegalArgumentException("timeout must be between 10 and 16384");
        }
        try {
            gatt = this.mBluetoothManager.getBluetoothGatt();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get Bluetooth gatt - ", e);
            callback2.onSyncEstablished(0, scanResult.getDevice(), scanResult.getAdvertisingSid(), skip, timeout, 2);
            return;
        }
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        IPeriodicAdvertisingCallback wrapped = this.wrap(callback2, handler);
        this.mCallbackWrappers.put(callback2, wrapped);
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            gatt.registerSync(scanResult, skip, timeout, wrapped, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothLeUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "Failed to register sync - ", e);
            return;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void unregisterSync(PeriodicAdvertisingCallback callback2) {
        IBluetoothGatt gatt;
        if (callback2 == null) {
            throw new IllegalArgumentException("callback can't be null");
        }
        try {
            gatt = this.mBluetoothManager.getBluetoothGatt();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get Bluetooth gatt - ", e);
            return;
        }
        IPeriodicAdvertisingCallback wrapper = this.mCallbackWrappers.remove(callback2);
        if (wrapper == null) {
            throw new IllegalArgumentException("callback was not properly registered");
        }
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            gatt.unregisterSync(wrapper, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothLeUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "Failed to cancel sync creation - ", e);
            return;
        }
    }

    public void transferSync(BluetoothDevice bda, int serviceData, int syncHandle) {
        IBluetoothGatt gatt;
        try {
            gatt = this.mBluetoothManager.getBluetoothGatt();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get Bluetooth gatt - ", e);
            PeriodicAdvertisingCallback callback2 = null;
            Iterator<PeriodicAdvertisingCallback> iterator = this.mCallbackWrappers.keySet().iterator();
            while (iterator.hasNext()) {
                PeriodicAdvertisingCallback cb;
                callback2 = cb = iterator.next();
            }
            if (callback2 != null) {
                callback2.onSyncTransferred(bda, 2);
            }
            return;
        }
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            gatt.transferSync(bda, serviceData, syncHandle, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothLeUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "Failed to register sync - ", e);
            return;
        }
    }

    public void transferSetInfo(BluetoothDevice bda, int serviceData, int advHandle, PeriodicAdvertisingCallback callback2) {
        this.transferSetInfo(bda, serviceData, advHandle, callback2, null);
    }

    public void transferSetInfo(BluetoothDevice bda, int serviceData, int advHandle, PeriodicAdvertisingCallback callback2, Handler handler) {
        IPeriodicAdvertisingCallback wrapper;
        IBluetoothGatt gatt;
        if (callback2 == null) {
            throw new IllegalArgumentException("callback can't be null");
        }
        try {
            gatt = this.mBluetoothManager.getBluetoothGatt();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get Bluetooth gatt - ", e);
            return;
        }
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        if ((wrapper = this.wrap(callback2, handler)) == null) {
            throw new IllegalArgumentException("callback was not properly registered");
        }
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            gatt.transferSetInfo(bda, serviceData, advHandle, wrapper, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothLeUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "Failed to register sync - ", e);
            return;
        }
    }

    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private IPeriodicAdvertisingCallback wrap(final PeriodicAdvertisingCallback callback2, final Handler handler) {
        return new IPeriodicAdvertisingCallback.Stub(){

            @Override
            public void onSyncEstablished(final int syncHandle, final BluetoothDevice device, final int advertisingSid, final int skip, final int timeout, final int status) {
                Attributable.setAttributionSource(device, PeriodicAdvertisingManager.this.mAttributionSource);
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback2.onSyncEstablished(syncHandle, device, advertisingSid, skip, timeout, status);
                        if (status != 0) {
                            PeriodicAdvertisingManager.this.mCallbackWrappers.remove(callback2);
                        }
                    }
                });
            }

            @Override
            public void onPeriodicAdvertisingReport(final PeriodicAdvertisingReport report) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback2.onPeriodicAdvertisingReport(report);
                    }
                });
            }

            @Override
            public void onSyncLost(final int syncHandle) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback2.onSyncLost(syncHandle);
                        PeriodicAdvertisingManager.this.mCallbackWrappers.remove(callback2);
                    }
                });
            }

            @Override
            public void onSyncTransferred(final BluetoothDevice device, final int status) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback2.onSyncTransferred(device, status);
                    }
                });
            }
        };
    }
}

