/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.UserIdInt;
import android.companion.DeviceFilter;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.OneTimeUseBuilder;
import com.android.internal.lang.System_Delegate;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.CollectionUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AssociationRequest
implements Parcelable {
    public static final String DEVICE_PROFILE_WATCH = "android.app.role.COMPANION_DEVICE_WATCH";
    @RequiresPermission(value="android.permission.REQUEST_COMPANION_PROFILE_APP_STREAMING")
    public static final String DEVICE_PROFILE_APP_STREAMING = "android.app.role.COMPANION_DEVICE_APP_STREAMING";
    @RequiresPermission(value="android.permission.REQUEST_COMPANION_PROFILE_AUTOMOTIVE_PROJECTION")
    public static final String DEVICE_PROFILE_AUTOMOTIVE_PROJECTION = "android.app.role.SYSTEM_AUTOMOTIVE_PROJECTION";
    @RequiresPermission(value="android.permission.REQUEST_COMPANION_PROFILE_COMPUTER")
    public static final String DEVICE_PROFILE_COMPUTER = "android.app.role.COMPANION_DEVICE_COMPUTER";
    private final boolean mSingleDevice;
    private final List<DeviceFilter<?>> mDeviceFilters;
    private final String mDeviceProfile;
    private final CharSequence mDisplayName;
    private final boolean mSelfManaged;
    private final boolean mForceConfirmation;
    private String mPackageName;
    private int mUserId;
    private String mDeviceProfilePrivilegesDescription;
    private final long mCreationTime;
    private boolean mSkipPrompt;
    public static final Parcelable.Creator<AssociationRequest> CREATOR = new Parcelable.Creator<AssociationRequest>(){

        public AssociationRequest[] newArray(int size) {
            return new AssociationRequest[size];
        }

        @Override
        public AssociationRequest createFromParcel(Parcel in) {
            return new AssociationRequest(in);
        }
    };

    private AssociationRequest(boolean singleDevice, List<DeviceFilter<?>> deviceFilters, String deviceProfile, CharSequence displayName, boolean selfManaged, boolean forceConfirmation) {
        this.mSingleDevice = singleDevice;
        this.mDeviceFilters = Objects.requireNonNull(deviceFilters);
        this.mDeviceProfile = deviceProfile;
        this.mDisplayName = displayName;
        this.mSelfManaged = selfManaged;
        this.mForceConfirmation = forceConfirmation;
        this.mCreationTime = System_Delegate.currentTimeMillis();
    }

    public String getDeviceProfile() {
        return this.mDeviceProfile;
    }

    public CharSequence getDisplayName() {
        return this.mDisplayName;
    }

    public boolean isSelfManaged() {
        return this.mSelfManaged;
    }

    public boolean isForceConfirmation() {
        return this.mForceConfirmation;
    }

    public boolean isSingleDevice() {
        return this.mSingleDevice;
    }

    public void setPackageName(String packageName) {
        this.mPackageName = packageName;
    }

    public void setUserId(int userId) {
        this.mUserId = userId;
    }

    public void setDeviceProfilePrivilegesDescription(String desc) {
        this.mDeviceProfilePrivilegesDescription = desc;
    }

    public void setSkipPrompt(boolean value2) {
        this.mSkipPrompt = value2;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public List<DeviceFilter<?>> getDeviceFilters() {
        return this.mDeviceFilters;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public int getUserId() {
        return this.mUserId;
    }

    public String getDeviceProfilePrivilegesDescription() {
        return this.mDeviceProfilePrivilegesDescription;
    }

    public long getCreationTime() {
        return this.mCreationTime;
    }

    public boolean isSkipPrompt() {
        return this.mSkipPrompt;
    }

    public String toString() {
        return "AssociationRequest { singleDevice = " + this.mSingleDevice + ", deviceFilters = " + this.mDeviceFilters + ", deviceProfile = " + this.mDeviceProfile + ", displayName = " + this.mDisplayName + ", selfManaged = " + this.mSelfManaged + ", forceConfirmation = " + this.mForceConfirmation + ", packageName = " + this.mPackageName + ", userId = " + this.mUserId + ", deviceProfilePrivilegesDescription = " + this.mDeviceProfilePrivilegesDescription + ", creationTime = " + this.mCreationTime + ", skipPrompt = " + this.mSkipPrompt + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssociationRequest that = (AssociationRequest)o;
        return this.mSingleDevice == that.mSingleDevice && Objects.equals(this.mDeviceFilters, that.mDeviceFilters) && Objects.equals(this.mDeviceProfile, that.mDeviceProfile) && Objects.equals(this.mDisplayName, that.mDisplayName) && this.mSelfManaged == that.mSelfManaged && this.mForceConfirmation == that.mForceConfirmation && Objects.equals(this.mPackageName, that.mPackageName) && this.mUserId == that.mUserId && Objects.equals(this.mDeviceProfilePrivilegesDescription, that.mDeviceProfilePrivilegesDescription) && this.mCreationTime == that.mCreationTime && this.mSkipPrompt == that.mSkipPrompt;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Boolean.hashCode(this.mSingleDevice);
        _hash = 31 * _hash + Objects.hashCode(this.mDeviceFilters);
        _hash = 31 * _hash + Objects.hashCode(this.mDeviceProfile);
        _hash = 31 * _hash + Objects.hashCode(this.mDisplayName);
        _hash = 31 * _hash + Boolean.hashCode(this.mSelfManaged);
        _hash = 31 * _hash + Boolean.hashCode(this.mForceConfirmation);
        _hash = 31 * _hash + Objects.hashCode(this.mPackageName);
        _hash = 31 * _hash + this.mUserId;
        _hash = 31 * _hash + Objects.hashCode(this.mDeviceProfilePrivilegesDescription);
        _hash = 31 * _hash + Long.hashCode(this.mCreationTime);
        _hash = 31 * _hash + Boolean.hashCode(this.mSkipPrompt);
        return _hash;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int flg = 0;
        if (this.mSingleDevice) {
            flg |= 1;
        }
        if (this.mSelfManaged) {
            flg |= 0x10;
        }
        if (this.mForceConfirmation) {
            flg |= 0x20;
        }
        if (this.mSkipPrompt) {
            flg |= 0x400;
        }
        if (this.mDeviceProfile != null) {
            flg |= 4;
        }
        if (this.mDisplayName != null) {
            flg |= 8;
        }
        if (this.mPackageName != null) {
            flg |= 0x40;
        }
        if (this.mDeviceProfilePrivilegesDescription != null) {
            flg |= 0x100;
        }
        dest.writeInt(flg);
        dest.writeParcelableList(this.mDeviceFilters, flags);
        if (this.mDeviceProfile != null) {
            dest.writeString(this.mDeviceProfile);
        }
        if (this.mDisplayName != null) {
            dest.writeCharSequence(this.mDisplayName);
        }
        if (this.mPackageName != null) {
            dest.writeString(this.mPackageName);
        }
        dest.writeInt(this.mUserId);
        if (this.mDeviceProfilePrivilegesDescription != null) {
            dest.writeString(this.mDeviceProfilePrivilegesDescription);
        }
        dest.writeLong(this.mCreationTime);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    AssociationRequest(Parcel in) {
        int flg = in.readInt();
        boolean singleDevice = (flg & 1) != 0;
        boolean selfManaged = (flg & 0x10) != 0;
        boolean forceConfirmation = (flg & 0x20) != 0;
        boolean skipPrompt = (flg & 0x400) != 0;
        ArrayList deviceFilters = new ArrayList();
        in.readParcelableList(deviceFilters, DeviceFilter.class.getClassLoader(), DeviceFilter.class);
        String deviceProfile = (flg & 4) == 0 ? null : in.readString();
        CharSequence displayName = (flg & 8) == 0 ? null : in.readCharSequence();
        String packageName = (flg & 0x40) == 0 ? null : in.readString();
        int userId = in.readInt();
        String deviceProfilePrivilegesDescription = (flg & 0x100) == 0 ? null : in.readString();
        long creationTime = in.readLong();
        this.mSingleDevice = singleDevice;
        this.mDeviceFilters = deviceFilters;
        AnnotationValidations.validate(NonNull.class, null, this.mDeviceFilters);
        this.mDeviceProfile = deviceProfile;
        AnnotationValidations.validate(DeviceProfile.class, null, (Object)this.mDeviceProfile);
        this.mDisplayName = displayName;
        this.mSelfManaged = selfManaged;
        this.mForceConfirmation = forceConfirmation;
        this.mPackageName = packageName;
        this.mUserId = userId;
        AnnotationValidations.validate(UserIdInt.class, null, this.mUserId);
        this.mDeviceProfilePrivilegesDescription = deviceProfilePrivilegesDescription;
        this.mCreationTime = creationTime;
        this.mSkipPrompt = skipPrompt;
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder
    extends OneTimeUseBuilder<AssociationRequest> {
        private boolean mSingleDevice = false;
        private ArrayList<DeviceFilter<?>> mDeviceFilters = null;
        private String mDeviceProfile;
        private CharSequence mDisplayName;
        private boolean mSelfManaged = false;
        private boolean mForceConfirmation = false;

        public Builder setSingleDevice(boolean singleDevice) {
            this.checkNotUsed();
            this.mSingleDevice = singleDevice;
            return this;
        }

        public Builder addDeviceFilter(DeviceFilter<?> deviceFilter) {
            this.checkNotUsed();
            if (deviceFilter != null) {
                this.mDeviceFilters = ArrayUtils.add(this.mDeviceFilters, deviceFilter);
            }
            return this;
        }

        public Builder setDeviceProfile(String deviceProfile) {
            this.checkNotUsed();
            this.mDeviceProfile = deviceProfile;
            return this;
        }

        public Builder setDisplayName(CharSequence displayName) {
            this.checkNotUsed();
            this.mDisplayName = Objects.requireNonNull(displayName);
            return this;
        }

        @RequiresPermission(value="android.permission.REQUEST_COMPANION_SELF_MANAGED")
        public Builder setSelfManaged(boolean selfManaged) {
            this.checkNotUsed();
            this.mSelfManaged = selfManaged;
            return this;
        }

        @RequiresPermission(value="android.permission.REQUEST_COMPANION_SELF_MANAGED")
        public Builder setForceConfirmation(boolean forceConfirmation) {
            this.checkNotUsed();
            this.mForceConfirmation = forceConfirmation;
            return this;
        }

        @Override
        public AssociationRequest build() {
            this.markUsed();
            if (this.mSelfManaged && this.mDisplayName == null) {
                throw new IllegalStateException("Request for a self-managed association MUST provide the display name of the device");
            }
            return new AssociationRequest(this.mSingleDevice, CollectionUtils.emptyIfNull(this.mDeviceFilters), this.mDeviceProfile, this.mDisplayName, this.mSelfManaged, this.mForceConfirmation);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceProfile {
    }
}

