/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.app.PendingIntent;
import android.companion.AssociationInfo;
import android.companion.AssociationRequest;
import android.companion.IAssociationRequestCallback;
import android.companion.IOnAssociationsChangedListener;
import android.content.ComponentName;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ICompanionDeviceManager
extends IInterface {
    public void associate(AssociationRequest var1, IAssociationRequestCallback var2, String var3, int var4) throws RemoteException;

    public List<AssociationInfo> getAssociations(String var1, int var2) throws RemoteException;

    public List<AssociationInfo> getAllAssociationsForUser(int var1) throws RemoteException;

    @Deprecated
    public void legacyDisassociate(String var1, String var2, int var3) throws RemoteException;

    public void disassociate(int var1) throws RemoteException;

    @Deprecated
    public boolean hasNotificationAccess(ComponentName var1) throws RemoteException;

    public PendingIntent requestNotificationAccess(ComponentName var1, int var2) throws RemoteException;

    @Deprecated
    public boolean isDeviceAssociatedForWifiConnection(String var1, String var2, int var3) throws RemoteException;

    public void registerDevicePresenceListenerService(String var1, String var2, int var3) throws RemoteException;

    public void unregisterDevicePresenceListenerService(String var1, String var2, int var3) throws RemoteException;

    @Deprecated
    public boolean canPairWithoutPrompt(String var1, String var2, int var3) throws RemoteException;

    @Deprecated
    public void createAssociation(String var1, String var2, int var3, byte[] var4) throws RemoteException;

    public void dispatchMessage(int var1, int var2, byte[] var3) throws RemoteException;

    public void addOnAssociationsChangedListener(IOnAssociationsChangedListener var1, int var2) throws RemoteException;

    public void removeOnAssociationsChangedListener(IOnAssociationsChangedListener var1, int var2) throws RemoteException;

    public void notifyDeviceAppeared(int var1) throws RemoteException;

    public void notifyDeviceDisappeared(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICompanionDeviceManager {
        public static final String DESCRIPTOR = "android.companion.ICompanionDeviceManager";
        static final int TRANSACTION_associate = 1;
        static final int TRANSACTION_getAssociations = 2;
        static final int TRANSACTION_getAllAssociationsForUser = 3;
        static final int TRANSACTION_legacyDisassociate = 4;
        static final int TRANSACTION_disassociate = 5;
        static final int TRANSACTION_hasNotificationAccess = 6;
        static final int TRANSACTION_requestNotificationAccess = 7;
        static final int TRANSACTION_isDeviceAssociatedForWifiConnection = 8;
        static final int TRANSACTION_registerDevicePresenceListenerService = 9;
        static final int TRANSACTION_unregisterDevicePresenceListenerService = 10;
        static final int TRANSACTION_canPairWithoutPrompt = 11;
        static final int TRANSACTION_createAssociation = 12;
        static final int TRANSACTION_dispatchMessage = 13;
        static final int TRANSACTION_addOnAssociationsChangedListener = 14;
        static final int TRANSACTION_removeOnAssociationsChangedListener = 15;
        static final int TRANSACTION_notifyDeviceAppeared = 16;
        static final int TRANSACTION_notifyDeviceDisappeared = 17;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ICompanionDeviceManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ICompanionDeviceManager) {
                return (ICompanionDeviceManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "associate";
                }
                case 2: {
                    return "getAssociations";
                }
                case 3: {
                    return "getAllAssociationsForUser";
                }
                case 4: {
                    return "legacyDisassociate";
                }
                case 5: {
                    return "disassociate";
                }
                case 6: {
                    return "hasNotificationAccess";
                }
                case 7: {
                    return "requestNotificationAccess";
                }
                case 8: {
                    return "isDeviceAssociatedForWifiConnection";
                }
                case 9: {
                    return "registerDevicePresenceListenerService";
                }
                case 10: {
                    return "unregisterDevicePresenceListenerService";
                }
                case 11: {
                    return "canPairWithoutPrompt";
                }
                case 12: {
                    return "createAssociation";
                }
                case 13: {
                    return "dispatchMessage";
                }
                case 14: {
                    return "addOnAssociationsChangedListener";
                }
                case 15: {
                    return "removeOnAssociationsChangedListener";
                }
                case 16: {
                    return "notifyDeviceAppeared";
                }
                case 17: {
                    return "notifyDeviceDisappeared";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    AssociationRequest _arg0 = data.readTypedObject(AssociationRequest.CREATOR);
                    IAssociationRequestCallback _arg1 = IAssociationRequestCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.associate(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    List<AssociationInfo> _result = this.getAssociations(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<AssociationInfo> _result = this.getAllAssociationsForUser(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.legacyDisassociate(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.disassociate(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.hasNotificationAccess(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    PendingIntent _result = this.requestNotificationAccess(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isDeviceAssociatedForWifiConnection(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.registerDevicePresenceListenerService(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterDevicePresenceListenerService(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.canPairWithoutPrompt(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    byte[] _arg3 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.createAssociation(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    byte[] _arg2 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.dispatchMessage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    IOnAssociationsChangedListener _arg0 = IOnAssociationsChangedListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.addOnAssociationsChangedListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    IOnAssociationsChangedListener _arg0 = IOnAssociationsChangedListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeOnAssociationsChangedListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyDeviceAppeared(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyDeviceDisappeared(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 16;
        }

        private static class Proxy
        implements ICompanionDeviceManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void associate(AssociationRequest request, IAssociationRequestCallback callback2, String callingPackage, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback2);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AssociationInfo> getAssociations(String callingPackage, int userId) throws RemoteException {
                ArrayList<AssociationInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AssociationInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AssociationInfo> getAllAssociationsForUser(int userId) throws RemoteException {
                ArrayList<AssociationInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AssociationInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void legacyDisassociate(String deviceMacAddress, String callingPackage, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(deviceMacAddress);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disassociate(int associationId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(associationId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNotificationAccess(ComponentName component2) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(component2, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PendingIntent requestNotificationAccess(ComponentName component2, int userId) throws RemoteException {
                PendingIntent _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(component2, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PendingIntent.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDeviceAssociatedForWifiConnection(String packageName, String macAddress, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(macAddress);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerDevicePresenceListenerService(String deviceAddress, String callingPackage, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(deviceAddress);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterDevicePresenceListenerService(String deviceAddress, String callingPackage, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(deviceAddress);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canPairWithoutPrompt(String packageName, String deviceMacAddress, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(deviceMacAddress);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createAssociation(String packageName, String macAddress, int userId, byte[] certificate) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(macAddress);
                    _data.writeInt(userId);
                    _data.writeByteArray(certificate);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchMessage(int messageId, int associationId, byte[] message) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(messageId);
                    _data.writeInt(associationId);
                    _data.writeByteArray(message);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnAssociationsChangedListener(IOnAssociationsChangedListener listener2, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnAssociationsChangedListener(IOnAssociationsChangedListener listener2, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyDeviceAppeared(int associationId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(associationId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyDeviceDisappeared(int associationId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(associationId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICompanionDeviceManager {
        @Override
        public void associate(AssociationRequest request, IAssociationRequestCallback callback2, String callingPackage, int userId) throws RemoteException {
        }

        @Override
        public List<AssociationInfo> getAssociations(String callingPackage, int userId) throws RemoteException {
            return null;
        }

        @Override
        public List<AssociationInfo> getAllAssociationsForUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void legacyDisassociate(String deviceMacAddress, String callingPackage, int userId) throws RemoteException {
        }

        @Override
        public void disassociate(int associationId) throws RemoteException {
        }

        @Override
        public boolean hasNotificationAccess(ComponentName component2) throws RemoteException {
            return false;
        }

        @Override
        public PendingIntent requestNotificationAccess(ComponentName component2, int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isDeviceAssociatedForWifiConnection(String packageName, String macAddress, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void registerDevicePresenceListenerService(String deviceAddress, String callingPackage, int userId) throws RemoteException {
        }

        @Override
        public void unregisterDevicePresenceListenerService(String deviceAddress, String callingPackage, int userId) throws RemoteException {
        }

        @Override
        public boolean canPairWithoutPrompt(String packageName, String deviceMacAddress, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void createAssociation(String packageName, String macAddress, int userId, byte[] certificate) throws RemoteException {
        }

        @Override
        public void dispatchMessage(int messageId, int associationId, byte[] message) throws RemoteException {
        }

        @Override
        public void addOnAssociationsChangedListener(IOnAssociationsChangedListener listener2, int userId) throws RemoteException {
        }

        @Override
        public void removeOnAssociationsChangedListener(IOnAssociationsChangedListener listener2, int userId) throws RemoteException {
        }

        @Override
        public void notifyDeviceAppeared(int associationId) throws RemoteException {
        }

        @Override
        public void notifyDeviceDisappeared(int associationId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

