/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual;

import android.companion.virtual.IVirtualDevice;
import android.companion.virtual.IVirtualDeviceActivityListener;
import android.companion.virtual.VirtualDeviceParams;
import android.hardware.display.IVirtualDisplayCallback;
import android.hardware.display.VirtualDisplayConfig;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IVirtualDeviceManager
extends IInterface {
    public static final String DESCRIPTOR = "android.companion.virtual.IVirtualDeviceManager";

    public IVirtualDevice createVirtualDevice(IBinder var1, String var2, int var3, VirtualDeviceParams var4, IVirtualDeviceActivityListener var5) throws RemoteException;

    public int createVirtualDisplay(VirtualDisplayConfig var1, IVirtualDisplayCallback var2, IVirtualDevice var3, String var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVirtualDeviceManager {
        static final int TRANSACTION_createVirtualDevice = 1;
        static final int TRANSACTION_createVirtualDisplay = 2;

        public Stub() {
            this.attachInterface(this, IVirtualDeviceManager.DESCRIPTOR);
        }

        public static IVirtualDeviceManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IVirtualDeviceManager.DESCRIPTOR);
            if (iin != null && iin instanceof IVirtualDeviceManager) {
                return (IVirtualDeviceManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "createVirtualDevice";
                }
                case 2: {
                    return "createVirtualDisplay";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IVirtualDeviceManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    VirtualDeviceParams _arg3 = data.readTypedObject(VirtualDeviceParams.CREATOR);
                    IVirtualDeviceActivityListener _arg4 = IVirtualDeviceActivityListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    IVirtualDevice _result = this.createVirtualDevice(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    VirtualDisplayConfig _arg0 = data.readTypedObject(VirtualDisplayConfig.CREATOR);
                    IVirtualDisplayCallback _arg1 = IVirtualDisplayCallback.Stub.asInterface(data.readStrongBinder());
                    IVirtualDevice _arg2 = IVirtualDevice.Stub.asInterface(data.readStrongBinder());
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.createVirtualDisplay(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IVirtualDeviceManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IVirtualDeviceManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IVirtualDevice createVirtualDevice(IBinder token, String packageName, int associationId, VirtualDeviceParams params, IVirtualDeviceActivityListener activityListener) throws RemoteException {
                IVirtualDevice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(packageName);
                    _data.writeInt(associationId);
                    _data.writeTypedObject(params, 0);
                    _data.writeStrongInterface(activityListener);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = IVirtualDevice.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int createVirtualDisplay(VirtualDisplayConfig virtualDisplayConfig, IVirtualDisplayCallback callback2, IVirtualDevice virtualDevice, String packageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeTypedObject(virtualDisplayConfig, 0);
                    _data.writeStrongInterface(callback2);
                    _data.writeStrongInterface(virtualDevice);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IVirtualDeviceManager {
        @Override
        public IVirtualDevice createVirtualDevice(IBinder token, String packageName, int associationId, VirtualDeviceParams params, IVirtualDeviceActivityListener activityListener) throws RemoteException {
            return null;
        }

        @Override
        public int createVirtualDisplay(VirtualDisplayConfig virtualDisplayConfig, IVirtualDisplayCallback callback2, IVirtualDevice virtualDevice, String packageName) throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

