/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.companion.virtual.IVirtualDevice;
import android.companion.virtual.IVirtualDeviceActivityListener;
import android.companion.virtual.IVirtualDeviceManager;
import android.companion.virtual.VirtualDeviceParams;
import android.companion.virtual.audio.VirtualAudioDevice;
import android.content.ComponentName;
import android.content.Context;
import android.graphics.Point;
import android.hardware.display.DisplayManagerGlobal;
import android.hardware.display.VirtualDisplay;
import android.hardware.display.VirtualDisplayConfig;
import android.hardware.input.VirtualKeyboard;
import android.hardware.input.VirtualMouse;
import android.hardware.input.VirtualTouchscreen;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.util.ArrayMap;
import android.view.Surface;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.Executor;
import java.util.function.IntConsumer;

@SystemApi
public class VirtualDeviceManager {
    private static final boolean DEBUG = false;
    private static final String TAG = "VirtualDeviceManager";
    private static final int DEFAULT_VIRTUAL_DISPLAY_FLAGS = 2505;
    public static final int LAUNCH_SUCCESS = 0;
    public static final int LAUNCH_FAILURE_PENDING_INTENT_CANCELED = 1;
    public static final int LAUNCH_FAILURE_NO_ACTIVITY = 2;
    private final IVirtualDeviceManager mService;
    private final Context mContext;

    public VirtualDeviceManager(IVirtualDeviceManager service, Context context) {
        this.mService = service;
        this.mContext = context;
    }

    @RequiresPermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public VirtualDevice createVirtualDevice(int associationId, VirtualDeviceParams params) {
        try {
            return new VirtualDevice(this.mService, this.mContext, associationId, params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static class ActivityListenerDelegate {
        private final ActivityListener mActivityListener;
        private final Executor mExecutor;

        ActivityListenerDelegate(ActivityListener listener2, Executor executor) {
            this.mActivityListener = listener2;
            this.mExecutor = executor;
        }

        public void onTopActivityChanged(int displayId, ComponentName topActivity) {
            this.mExecutor.execute(() -> this.mActivityListener.onTopActivityChanged(displayId, topActivity));
        }

        public void onDisplayEmpty(int displayId) {
            this.mExecutor.execute(() -> this.mActivityListener.onDisplayEmpty(displayId));
        }
    }

    public static interface ActivityListener {
        public void onTopActivityChanged(int var1, ComponentName var2);

        public void onDisplayEmpty(int var1);
    }

    public static class VirtualDevice
    implements AutoCloseable {
        private final Context mContext;
        private final IVirtualDeviceManager mService;
        private final IVirtualDevice mVirtualDevice;
        private final ArrayMap<ActivityListener, ActivityListenerDelegate> mActivityListeners = new ArrayMap();
        private final IVirtualDeviceActivityListener mActivityListenerBinder = new IVirtualDeviceActivityListener.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTopActivityChanged(int displayId, ComponentName topActivity) {
                long token = Binder.clearCallingIdentity();
                try {
                    for (int i = 0; i < mActivityListeners.size(); ++i) {
                        mActivityListeners.valueAt(i).onTopActivityChanged(displayId, topActivity);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisplayEmpty(int displayId) {
                long token = Binder.clearCallingIdentity();
                try {
                    for (int i = 0; i < mActivityListeners.size(); ++i) {
                        mActivityListeners.valueAt(i).onDisplayEmpty(displayId);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        };
        private VirtualAudioDevice mVirtualAudioDevice;

        private VirtualDevice(IVirtualDeviceManager service, Context context, int associationId, VirtualDeviceParams params) throws RemoteException {
            this.mService = service;
            this.mContext = context.getApplicationContext();
            this.mVirtualDevice = service.createVirtualDevice(new Binder(), this.mContext.getPackageName(), associationId, params, this.mActivityListenerBinder);
        }

        public void launchPendingIntent(int displayId, PendingIntent pendingIntent, final Executor executor, final IntConsumer listener2) {
            try {
                this.mVirtualDevice.launchPendingIntent(displayId, pendingIntent, new ResultReceiver(new Handler(Looper.getMainLooper())){

                    @Override
                    protected void onReceiveResult(int resultCode, Bundle resultData) {
                        super.onReceiveResult(resultCode, resultData);
                        executor.execute(() -> listener2.accept(resultCode));
                    }
                });
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }

        public VirtualDisplay createVirtualDisplay(int width2, int height2, int densityDpi, Surface surface2, int flags, Executor executor, VirtualDisplay.Callback callback2) {
            int displayId;
            VirtualDisplayConfig config = new VirtualDisplayConfig.Builder(this.getVirtualDisplayName(), width2, height2, densityDpi).setSurface(surface2).setFlags(this.getVirtualDisplayFlags(flags)).build();
            DisplayManagerGlobal.VirtualDisplayCallback callbackWrapper = new DisplayManagerGlobal.VirtualDisplayCallback(callback2, executor);
            try {
                displayId = this.mService.createVirtualDisplay(config, callbackWrapper, this.mVirtualDevice, this.mContext.getPackageName());
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
            DisplayManagerGlobal displayManager = DisplayManagerGlobal.getInstance();
            return displayManager.createVirtualDisplayWrapper(config, this.mContext, callbackWrapper, displayId);
        }

        @Override
        @RequiresPermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
        public void close() {
            try {
                this.mVirtualDevice.close();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            if (this.mVirtualAudioDevice != null) {
                this.mVirtualAudioDevice.close();
                this.mVirtualAudioDevice = null;
            }
        }

        @RequiresPermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
        public VirtualKeyboard createVirtualKeyboard(VirtualDisplay display, String inputDeviceName, int vendorId, int productId) {
            try {
                Binder token = new Binder("android.hardware.input.VirtualKeyboard:" + inputDeviceName);
                this.mVirtualDevice.createVirtualKeyboard(display.getDisplay().getDisplayId(), inputDeviceName, vendorId, productId, token);
                return new VirtualKeyboard(this.mVirtualDevice, token);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        @RequiresPermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
        public VirtualMouse createVirtualMouse(VirtualDisplay display, String inputDeviceName, int vendorId, int productId) {
            try {
                Binder token = new Binder("android.hardware.input.VirtualMouse:" + inputDeviceName);
                this.mVirtualDevice.createVirtualMouse(display.getDisplay().getDisplayId(), inputDeviceName, vendorId, productId, token);
                return new VirtualMouse(this.mVirtualDevice, token);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        @RequiresPermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
        public VirtualTouchscreen createVirtualTouchscreen(VirtualDisplay display, String inputDeviceName, int vendorId, int productId) {
            try {
                Binder token = new Binder("android.hardware.input.VirtualTouchscreen:" + inputDeviceName);
                Point size = new Point();
                display.getDisplay().getSize(size);
                this.mVirtualDevice.createVirtualTouchscreen(display.getDisplay().getDisplayId(), inputDeviceName, vendorId, productId, token, size);
                return new VirtualTouchscreen(this.mVirtualDevice, token);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        @RequiresPermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
        public VirtualAudioDevice createVirtualAudioDevice(VirtualDisplay display, Executor executor, VirtualAudioDevice.AudioConfigurationChangeCallback callback2) {
            if (this.mVirtualAudioDevice == null) {
                this.mVirtualAudioDevice = new VirtualAudioDevice(this.mContext, this.mVirtualDevice, display, executor, callback2);
            }
            return this.mVirtualAudioDevice;
        }

        @RequiresPermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
        public void setShowPointerIcon(boolean showPointerIcon) {
            try {
                this.mVirtualDevice.setShowPointerIcon(showPointerIcon);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private int getVirtualDisplayFlags(int flags) {
            return 0x9C9 | flags;
        }

        private String getVirtualDisplayName() {
            try {
                return "VirtualDevice_" + this.mVirtualDevice.getAssociationId();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public void addActivityListener(Executor executor, ActivityListener listener2) {
            this.mActivityListeners.put(listener2, new ActivityListenerDelegate(listener2, executor));
        }

        public void removeActivityListener(ActivityListener listener2) {
            this.mActivityListeners.remove(listener2);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface PendingIntentLaunchStatus {
    }
}

