/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual.audio;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.UserManager;
import com.android.internal.annotations.GuardedBy;

class UserRestrictionsDetector
extends BroadcastReceiver {
    private static final String TAG = "UserRestrictionsDetector";
    private final Context mContext;
    private final UserManager mUserManager;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private boolean mIsUnmuteMicDisallowed;
    private UserRestrictionsCallback mUserRestrictionsCallback;

    UserRestrictionsDetector(Context context) {
        this.mContext = context;
        this.mUserManager = context.getSystemService(UserManager.class);
    }

    boolean isUnmuteMicrophoneDisallowed() {
        Bundle bundle = this.mUserManager.getUserRestrictions();
        return bundle.getBoolean("no_unmute_microphone");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(UserRestrictionsCallback callback2) {
        this.mUserRestrictionsCallback = callback2;
        IntentFilter filter2 = new IntentFilter();
        filter2.addAction("android.os.action.USER_RESTRICTIONS_CHANGED");
        this.mContext.registerReceiver(this, filter2);
        Object object = this.mLock;
        synchronized (object) {
            this.mIsUnmuteMicDisallowed = this.isUnmuteMicrophoneDisallowed();
        }
    }

    void unregister() {
        if (this.mUserRestrictionsCallback != null) {
            this.mUserRestrictionsCallback = null;
            this.mContext.unregisterReceiver(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReceive(Context context, Intent intent) {
        String action2 = intent.getAction();
        if ("android.os.action.USER_RESTRICTIONS_CHANGED".equals(action2)) {
            boolean isUnmuteMicDisallowed = this.isUnmuteMicrophoneDisallowed();
            Object object = this.mLock;
            synchronized (object) {
                if (isUnmuteMicDisallowed == this.mIsUnmuteMicDisallowed) {
                    return;
                }
                this.mIsUnmuteMicDisallowed = isUnmuteMicDisallowed;
            }
            if (this.mUserRestrictionsCallback != null) {
                this.mUserRestrictionsCallback.onMicrophoneRestrictionChanged(isUnmuteMicDisallowed);
            }
        }
    }

    static interface UserRestrictionsCallback {
        public void onMicrophoneRestrictionChanged(boolean var1);
    }
}

