/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual.audio;

import android.annotation.RequiresPermission;
import android.companion.virtual.audio.AudioCapture;
import android.companion.virtual.audio.AudioInjection;
import android.companion.virtual.audio.IAudioConfigChangedCallback;
import android.companion.virtual.audio.IAudioRoutingCallback;
import android.companion.virtual.audio.UserRestrictionsDetector;
import android.companion.virtual.audio.VirtualAudioDevice;
import android.content.Context;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioPlaybackConfiguration;
import android.media.AudioRecord;
import android.media.AudioRecordingConfiguration;
import android.media.AudioTrack;
import android.media.audiopolicy.AudioMix;
import android.media.audiopolicy.AudioMixingRule;
import android.media.audiopolicy.AudioPolicy;
import android.util.IntArray;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

@VisibleForTesting
public class VirtualAudioSession
extends IAudioRoutingCallback.Stub
implements UserRestrictionsDetector.UserRestrictionsCallback,
Closeable {
    private static final String TAG = "VirtualAudioSession";
    private final Context mContext;
    private final UserRestrictionsDetector mUserRestrictionsDetector;
    private final AudioConfigChangedCallback mAudioConfigChangedCallback;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final IntArray mReroutedAppUids = new IntArray();
    @GuardedBy(value={"mLock"})
    private AudioPolicy mAudioPolicy;
    @GuardedBy(value={"mLock"})
    private AudioCapture mAudioCapture;
    @GuardedBy(value={"mLock"})
    private AudioInjection mAudioInjection;

    @VisibleForTesting
    public VirtualAudioSession(Context context, VirtualAudioDevice.AudioConfigurationChangeCallback callback2, Executor executor) {
        this.mContext = context;
        this.mUserRestrictionsDetector = new UserRestrictionsDetector(context);
        this.mAudioConfigChangedCallback = callback2 == null ? null : new AudioConfigChangedCallback(context, executor, callback2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public AudioCapture startAudioCapture(AudioFormat captureFormat) {
        Objects.requireNonNull(captureFormat, "captureFormat must not be null");
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAudioCapture != null) {
                throw new IllegalStateException("Cannot start capture while another capture is ongoing.");
            }
            this.mAudioCapture = new AudioCapture(captureFormat);
            this.mAudioCapture.startRecording();
            return this.mAudioCapture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public AudioInjection startAudioInjection(AudioFormat injectionFormat) {
        Objects.requireNonNull(injectionFormat, "injectionFormat must not be null");
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAudioInjection != null) {
                throw new IllegalStateException("Cannot start injection while injection is already ongoing.");
            }
            this.mAudioInjection = new AudioInjection(injectionFormat);
            this.mAudioInjection.play();
            this.mUserRestrictionsDetector.register(this);
            this.mAudioInjection.setSilent(this.mUserRestrictionsDetector.isUnmuteMicrophoneDisallowed());
            return this.mAudioInjection;
        }
    }

    @VisibleForTesting
    public AudioConfigChangedCallback getAudioConfigChangedListener() {
        return this.mAudioConfigChangedCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public AudioCapture getAudioCapture() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mAudioCapture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public AudioInjection getAudioInjection() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mAudioInjection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void onAppsNeedingAudioRoutingChanged(int[] appUids) {
        Object object = this.mLock;
        synchronized (object) {
            if (Arrays.equals(this.mReroutedAppUids.toArray(), appUids)) {
                return;
            }
        }
        this.releaseAudioStreams();
        if (appUids.length == 0) {
            return;
        }
        this.createAudioStreams(appUids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void close() {
        this.mUserRestrictionsDetector.unregister();
        this.releaseAudioStreams();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAudioCapture != null) {
                this.mAudioCapture.close();
                this.mAudioCapture = null;
            }
            if (this.mAudioInjection != null) {
                this.mAudioInjection.close();
                this.mAudioInjection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMicrophoneRestrictionChanged(boolean isUnmuteMicDisallowed) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAudioInjection != null) {
                this.mAudioInjection.setSilent(isUnmuteMicDisallowed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    private void createAudioStreams(int[] appUids) {
        Object object = this.mLock;
        synchronized (object) {
            AudioTrack audioTrack;
            if (this.mAudioCapture == null && this.mAudioInjection == null) {
                throw new IllegalStateException("At least one of AudioCapture and AudioInjection must be started.");
            }
            if (this.mAudioPolicy != null) {
                throw new IllegalStateException("Cannot create audio streams while the audio policy is registered. Call releaseAudioStreams() first to unregister the previous audio policy.");
            }
            this.mReroutedAppUids.clear();
            for (int appUid : appUids) {
                this.mReroutedAppUids.add(appUid);
            }
            AudioMix audioRecordMix = null;
            AudioMix audioTrackMix = null;
            AudioPolicy.Builder builder2 = new AudioPolicy.Builder(this.mContext);
            if (this.mAudioCapture != null) {
                audioRecordMix = VirtualAudioSession.createAudioRecordMix(this.mAudioCapture.getFormat(), appUids);
                builder2.addMix(audioRecordMix);
            }
            if (this.mAudioInjection != null) {
                audioTrackMix = VirtualAudioSession.createAudioTrackMix(this.mAudioInjection.getFormat(), appUids);
                builder2.addMix(audioTrackMix);
            }
            this.mAudioPolicy = builder2.build();
            AudioManager audioManager = this.mContext.getSystemService(AudioManager.class);
            if (audioManager.registerAudioPolicy(this.mAudioPolicy) == -1) {
                Log.e(TAG, "Failed to register audio policy!");
            }
            AudioRecord audioRecord = audioRecordMix != null ? this.mAudioPolicy.createAudioRecordSink(audioRecordMix) : null;
            AudioTrack audioTrack2 = audioTrack = audioTrackMix != null ? this.mAudioPolicy.createAudioTrackSource(audioTrackMix) : null;
            if (this.mAudioCapture != null) {
                this.mAudioCapture.setAudioRecord(audioRecord);
            }
            if (this.mAudioInjection != null) {
                this.mAudioInjection.setAudioTrack(audioTrack);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    private void releaseAudioStreams() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAudioCapture != null) {
                this.mAudioCapture.setAudioRecord(null);
            }
            if (this.mAudioInjection != null) {
                this.mAudioInjection.setAudioTrack(null);
            }
            this.mReroutedAppUids.clear();
            if (this.mAudioPolicy != null) {
                AudioManager audioManager = this.mContext.getSystemService(AudioManager.class);
                audioManager.unregisterAudioPolicy(this.mAudioPolicy);
                this.mAudioPolicy = null;
                Log.i(TAG, "AudioPolicy unregistered");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public IntArray getReroutedAppUids() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mReroutedAppUids;
        }
    }

    private static AudioMix createAudioRecordMix(AudioFormat audioFormat, int[] appUids) {
        AudioMixingRule.Builder builder2 = new AudioMixingRule.Builder();
        builder2.setTargetMixRole(0);
        for (int uid : appUids) {
            builder2.addMixRule(4, uid);
        }
        AudioMixingRule audioMixingRule = builder2.allowPrivilegedPlaybackCapture(false).build();
        AudioMix audioMix = new AudioMix.Builder(audioMixingRule).setFormat(audioFormat).setRouteFlags(2).build();
        return audioMix;
    }

    private static AudioMix createAudioTrackMix(AudioFormat audioFormat, int[] appUids) {
        AudioMixingRule.Builder builder2 = new AudioMixingRule.Builder();
        builder2.setTargetMixRole(1);
        for (int uid : appUids) {
            builder2.addMixRule(4, uid);
        }
        AudioMixingRule audioMixingRule = builder2.build();
        AudioMix audioMix = new AudioMix.Builder(audioMixingRule).setFormat(audioFormat).setRouteFlags(2).build();
        return audioMix;
    }

    @VisibleForTesting
    public static class AudioConfigChangedCallback
    extends IAudioConfigChangedCallback.Stub {
        private final Executor mExecutor;
        private final VirtualAudioDevice.AudioConfigurationChangeCallback mCallback;

        AudioConfigChangedCallback(Context context, Executor executor, VirtualAudioDevice.AudioConfigurationChangeCallback callback2) {
            this.mExecutor = executor != null ? executor : context.getMainExecutor();
            this.mCallback = callback2;
        }

        @Override
        public void onPlaybackConfigChanged(List<AudioPlaybackConfiguration> configs) {
            if (this.mCallback != null) {
                this.mExecutor.execute(() -> this.mCallback.onPlaybackConfigChanged(configs));
            }
        }

        @Override
        public void onRecordingConfigChanged(List<AudioRecordingConfiguration> configs) {
            if (this.mCallback != null) {
                this.mExecutor.execute(() -> this.mCallback.onRecordingConfigChanged(configs));
            }
        }
    }
}

