/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ISyncAdapter;
import android.content.ISyncAdapterUnsyncableAccountCallback;
import android.content.ISyncContext;
import android.content.SyncContext;
import android.content.SyncResult;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.Trace;
import android.os._Original_Build;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.util.function.pooled.PooledLambda;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractThreadedSyncAdapter {
    private static final String TAG = "SyncAdapter";
    @Deprecated
    public static final int LOG_SYNC_DETAILS = 2743;
    private static final boolean ENABLE_LOG = _Original_Build.IS_DEBUGGABLE && Log.isLoggable("SyncAdapter", 3);
    private final Context mContext;
    private final AtomicInteger mNumSyncStarts;
    private final ISyncAdapterImpl mISyncAdapterImpl;
    private final HashMap<Account, SyncThread> mSyncThreads = new HashMap();
    private final Object mSyncThreadLock = new Object();
    private final boolean mAutoInitialize;
    private boolean mAllowParallelSyncs;

    public AbstractThreadedSyncAdapter(Context context, boolean autoInitialize) {
        this(context, autoInitialize, false);
    }

    public AbstractThreadedSyncAdapter(Context context, boolean autoInitialize, boolean allowParallelSyncs) {
        this.mContext = context;
        this.mISyncAdapterImpl = new ISyncAdapterImpl();
        this.mNumSyncStarts = new AtomicInteger(0);
        this.mAutoInitialize = autoInitialize;
        this.mAllowParallelSyncs = allowParallelSyncs;
    }

    public Context getContext() {
        return this.mContext;
    }

    private Account toSyncKey(Account account) {
        if (this.mAllowParallelSyncs) {
            return account;
        }
        return null;
    }

    public IBinder getSyncAdapterBinder() {
        return this.mISyncAdapterImpl.asBinder();
    }

    private void handleOnUnsyncableAccount(ISyncAdapterUnsyncableAccountCallback cb) {
        boolean doSync;
        try {
            doSync = this.onUnsyncableAccount();
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Exception while calling onUnsyncableAccount, assuming 'true'", e);
            doSync = true;
        }
        try {
            cb.onUnsyncableAccountDone(doSync);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Could not report result of onUnsyncableAccount", e);
        }
    }

    public boolean onUnsyncableAccount() {
        return true;
    }

    public abstract void onPerformSync(Account var1, Bundle var2, String var3, ContentProviderClient var4, SyncResult var5);

    public void onSecurityException(Account account, Bundle extras, String authority, SyncResult syncResult) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSyncCanceled() {
        SyncThread syncThread;
        Object object = this.mSyncThreadLock;
        synchronized (object) {
            syncThread = this.mSyncThreads.get(null);
        }
        if (syncThread != null) {
            syncThread.interrupt();
        }
    }

    public void onSyncCanceled(Thread thread) {
        thread.interrupt();
    }

    private class SyncThread
    extends Thread {
        private final SyncContext mSyncContext;
        private final String mAuthority;
        private final Account mAccount;
        private final Bundle mExtras;
        private final Account mThreadsKey;

        private SyncThread(String name, SyncContext syncContext, String authority, Account account, Bundle extras) {
            super(name);
            this.mSyncContext = syncContext;
            this.mAuthority = authority;
            this.mAccount = account;
            this.mExtras = extras;
            this.mThreadsKey = AbstractThreadedSyncAdapter.this.toSyncKey(account);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Process.setThreadPriority(10);
            if (ENABLE_LOG) {
                Log.d(AbstractThreadedSyncAdapter.TAG, "Thread started");
            }
            Trace.traceBegin(128L, this.mAuthority);
            SyncResult syncResult = new SyncResult();
            ContentProviderClient provider2 = null;
            try {
                if (this.isCanceled()) {
                    if (ENABLE_LOG) {
                        Log.d(AbstractThreadedSyncAdapter.TAG, "Already canceled");
                    }
                    return;
                }
                if (ENABLE_LOG) {
                    Log.d(AbstractThreadedSyncAdapter.TAG, "Calling onPerformSync...");
                }
                if ((provider2 = AbstractThreadedSyncAdapter.this.mContext.getContentResolver().acquireContentProviderClient(this.mAuthority)) != null) {
                    AbstractThreadedSyncAdapter.this.onPerformSync(this.mAccount, this.mExtras, this.mAuthority, provider2, syncResult);
                } else {
                    syncResult.databaseError = true;
                }
                if (ENABLE_LOG) {
                    Log.d(AbstractThreadedSyncAdapter.TAG, "onPerformSync done");
                }
            }
            catch (SecurityException e) {
                if (ENABLE_LOG) {
                    Log.d(AbstractThreadedSyncAdapter.TAG, "SecurityException", e);
                }
                AbstractThreadedSyncAdapter.this.onSecurityException(this.mAccount, this.mExtras, this.mAuthority, syncResult);
                syncResult.databaseError = true;
            }
            catch (Error | RuntimeException th) {
                if (ENABLE_LOG) {
                    Log.d(AbstractThreadedSyncAdapter.TAG, "caught exception", th);
                }
                throw th;
            }
            finally {
                Trace.traceEnd(128L);
                if (provider2 != null) {
                    provider2.release();
                }
                if (!this.isCanceled()) {
                    this.mSyncContext.onFinished(syncResult);
                }
                Object e = AbstractThreadedSyncAdapter.this.mSyncThreadLock;
                synchronized (e) {
                    AbstractThreadedSyncAdapter.this.mSyncThreads.remove(this.mThreadsKey);
                }
                if (ENABLE_LOG) {
                    Log.d(AbstractThreadedSyncAdapter.TAG, "Thread finished");
                }
            }
        }

        private boolean isCanceled() {
            return Thread.currentThread().isInterrupted();
        }
    }

    private class ISyncAdapterImpl
    extends ISyncAdapter.Stub {
        private ISyncAdapterImpl() {
        }

        private boolean isCallerSystem() {
            long callingUid = Binder.getCallingUid();
            if (callingUid != 1000L) {
                EventLog.writeEvent(1397638484, "203229608", -1, "");
                return false;
            }
            return true;
        }

        @Override
        public void onUnsyncableAccount(ISyncAdapterUnsyncableAccountCallback cb) {
            if (!this.isCallerSystem()) {
                return;
            }
            Handler.getMain().sendMessage(PooledLambda.obtainMessage((rec$, x$0) -> ((AbstractThreadedSyncAdapter)rec$).handleOnUnsyncableAccount((ISyncAdapterUnsyncableAccountCallback)x$0), AbstractThreadedSyncAdapter.this, cb));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void startSync(ISyncContext syncContext, String authority, Account account, Bundle extras) {
            if (!this.isCallerSystem()) {
                return;
            }
            if (ENABLE_LOG) {
                if (extras != null) {
                    extras.size();
                }
                Log.d(AbstractThreadedSyncAdapter.TAG, "startSync() start " + authority + " " + account + " " + extras);
            }
            try {
                boolean alreadyInProgress;
                SyncContext syncContextClient = new SyncContext(syncContext);
                Account threadsKey = AbstractThreadedSyncAdapter.this.toSyncKey(account);
                Object object = AbstractThreadedSyncAdapter.this.mSyncThreadLock;
                synchronized (object) {
                    if (!AbstractThreadedSyncAdapter.this.mSyncThreads.containsKey(threadsKey)) {
                        if (AbstractThreadedSyncAdapter.this.mAutoInitialize && extras != null && extras.getBoolean("initialize", false)) {
                            try {
                                if (ContentResolver.getIsSyncable(account, authority) >= 0) return;
                                ContentResolver.setIsSyncable(account, authority, 1);
                            }
                            finally {
                                syncContextClient.onFinished(new SyncResult());
                            }
                            return;
                        }
                        SyncThread syncThread = new SyncThread("SyncAdapterThread-" + AbstractThreadedSyncAdapter.this.mNumSyncStarts.incrementAndGet(), syncContextClient, authority, account, extras);
                        AbstractThreadedSyncAdapter.this.mSyncThreads.put(threadsKey, syncThread);
                        syncThread.start();
                        alreadyInProgress = false;
                    } else {
                        if (ENABLE_LOG) {
                            Log.d(AbstractThreadedSyncAdapter.TAG, "  alreadyInProgress");
                        }
                        alreadyInProgress = true;
                    }
                }
                if (!alreadyInProgress) return;
                syncContextClient.onFinished(SyncResult.ALREADY_IN_PROGRESS);
                return;
            }
            catch (Error | RuntimeException th) {
                if (!ENABLE_LOG) throw th;
                Log.d(AbstractThreadedSyncAdapter.TAG, "startSync() caught exception", th);
                throw th;
            }
            finally {
                if (ENABLE_LOG) {
                    Log.d(AbstractThreadedSyncAdapter.TAG, "startSync() finishing");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelSync(ISyncContext syncContext) {
            if (!this.isCallerSystem()) {
                return;
            }
            try {
                SyncThread info = null;
                Object object = AbstractThreadedSyncAdapter.this.mSyncThreadLock;
                synchronized (object) {
                    for (SyncThread current : AbstractThreadedSyncAdapter.this.mSyncThreads.values()) {
                        if (current.mSyncContext.getSyncContextBinder() != syncContext.asBinder()) continue;
                        info = current;
                        break;
                    }
                }
                if (info != null) {
                    if (ENABLE_LOG) {
                        Log.d(AbstractThreadedSyncAdapter.TAG, "cancelSync() " + info.mAuthority + " " + info.mAccount);
                    }
                    if (AbstractThreadedSyncAdapter.this.mAllowParallelSyncs) {
                        AbstractThreadedSyncAdapter.this.onSyncCanceled(info);
                    } else {
                        AbstractThreadedSyncAdapter.this.onSyncCanceled();
                    }
                } else if (ENABLE_LOG) {
                    Log.w(AbstractThreadedSyncAdapter.TAG, "cancelSync() unknown context");
                }
            }
            catch (Error | RuntimeException th) {
                if (ENABLE_LOG) {
                    Log.d(AbstractThreadedSyncAdapter.TAG, "cancelSync() caught exception", th);
                }
                throw th;
            }
            finally {
                if (ENABLE_LOG) {
                    Log.d(AbstractThreadedSyncAdapter.TAG, "cancelSync() finishing");
                }
            }
        }
    }
}

