/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.ContentProvider;
import android.content.ContentProviderResult;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.OperationApplicationException;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;

public class ContentProviderOperation
implements Parcelable {
    @UnsupportedAppUsage
    public static final int TYPE_INSERT = 1;
    @UnsupportedAppUsage
    public static final int TYPE_UPDATE = 2;
    @UnsupportedAppUsage
    public static final int TYPE_DELETE = 3;
    public static final int TYPE_ASSERT = 4;
    public static final int TYPE_CALL = 5;
    @UnsupportedAppUsage
    private final int mType;
    @UnsupportedAppUsage
    private final Uri mUri;
    private final String mMethod;
    private final String mArg;
    private final ArrayMap<String, Object> mValues;
    private final ArrayMap<String, Object> mExtras;
    @UnsupportedAppUsage
    private final String mSelection;
    private final SparseArray<Object> mSelectionArgs;
    private final Integer mExpectedCount;
    private final boolean mYieldAllowed;
    private final boolean mExceptionAllowed;
    private static final String TAG = "ContentProviderOperation";
    public static final Parcelable.Creator<ContentProviderOperation> CREATOR = new Parcelable.Creator<ContentProviderOperation>(){

        @Override
        public ContentProviderOperation createFromParcel(Parcel source) {
            return new ContentProviderOperation(source);
        }

        public ContentProviderOperation[] newArray(int size) {
            return new ContentProviderOperation[size];
        }
    };

    private ContentProviderOperation(Builder builder2) {
        this.mType = builder2.mType;
        this.mUri = builder2.mUri;
        this.mMethod = builder2.mMethod;
        this.mArg = builder2.mArg;
        this.mValues = builder2.mValues;
        this.mExtras = builder2.mExtras;
        this.mSelection = builder2.mSelection;
        this.mSelectionArgs = builder2.mSelectionArgs;
        this.mExpectedCount = builder2.mExpectedCount;
        this.mYieldAllowed = builder2.mYieldAllowed;
        this.mExceptionAllowed = builder2.mExceptionAllowed;
    }

    private ContentProviderOperation(Parcel source) {
        this.mType = source.readInt();
        this.mUri = Uri.CREATOR.createFromParcel(source);
        this.mMethod = source.readInt() != 0 ? source.readString8() : null;
        this.mArg = source.readInt() != 0 ? source.readString8() : null;
        int valuesSize = source.readInt();
        if (valuesSize != -1) {
            this.mValues = new ArrayMap(valuesSize);
            source.readArrayMap(this.mValues, null);
        } else {
            this.mValues = null;
        }
        int extrasSize = source.readInt();
        if (extrasSize != -1) {
            this.mExtras = new ArrayMap(extrasSize);
            source.readArrayMap(this.mExtras, null);
        } else {
            this.mExtras = null;
        }
        this.mSelection = source.readInt() != 0 ? source.readString8() : null;
        this.mSelectionArgs = source.readSparseArray(null, Object.class);
        this.mExpectedCount = source.readInt() != 0 ? Integer.valueOf(source.readInt()) : null;
        this.mYieldAllowed = source.readInt() != 0;
        this.mExceptionAllowed = source.readInt() != 0;
    }

    public ContentProviderOperation(ContentProviderOperation cpo, Uri withUri) {
        this.mType = cpo.mType;
        this.mUri = withUri;
        this.mMethod = cpo.mMethod;
        this.mArg = cpo.mArg;
        this.mValues = cpo.mValues;
        this.mExtras = cpo.mExtras;
        this.mSelection = cpo.mSelection;
        this.mSelectionArgs = cpo.mSelectionArgs;
        this.mExpectedCount = cpo.mExpectedCount;
        this.mYieldAllowed = cpo.mYieldAllowed;
        this.mExceptionAllowed = cpo.mExceptionAllowed;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mType);
        Uri.writeToParcel(dest, this.mUri);
        if (this.mMethod != null) {
            dest.writeInt(1);
            dest.writeString8(this.mMethod);
        } else {
            dest.writeInt(0);
        }
        if (this.mArg != null) {
            dest.writeInt(1);
            dest.writeString8(this.mArg);
        } else {
            dest.writeInt(0);
        }
        if (this.mValues != null) {
            dest.writeInt(this.mValues.size());
            dest.writeArrayMap(this.mValues);
        } else {
            dest.writeInt(-1);
        }
        if (this.mExtras != null) {
            dest.writeInt(this.mExtras.size());
            dest.writeArrayMap(this.mExtras);
        } else {
            dest.writeInt(-1);
        }
        if (this.mSelection != null) {
            dest.writeInt(1);
            dest.writeString8(this.mSelection);
        } else {
            dest.writeInt(0);
        }
        dest.writeSparseArray(this.mSelectionArgs);
        if (this.mExpectedCount != null) {
            dest.writeInt(1);
            dest.writeInt(this.mExpectedCount);
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.mYieldAllowed ? 1 : 0);
        dest.writeInt(this.mExceptionAllowed ? 1 : 0);
    }

    public static Builder newInsert(Uri uri) {
        return new Builder(1, uri);
    }

    public static Builder newUpdate(Uri uri) {
        return new Builder(2, uri);
    }

    public static Builder newDelete(Uri uri) {
        return new Builder(3, uri);
    }

    public static Builder newAssertQuery(Uri uri) {
        return new Builder(4, uri);
    }

    public static Builder newCall(Uri uri, String method, String arg) {
        return new Builder(5, uri, method, arg);
    }

    public Uri getUri() {
        return this.mUri;
    }

    public boolean isYieldAllowed() {
        return this.mYieldAllowed;
    }

    public boolean isExceptionAllowed() {
        return this.mExceptionAllowed;
    }

    @UnsupportedAppUsage
    public int getType() {
        return this.mType;
    }

    public boolean isInsert() {
        return this.mType == 1;
    }

    public boolean isDelete() {
        return this.mType == 3;
    }

    public boolean isUpdate() {
        return this.mType == 2;
    }

    public boolean isAssertQuery() {
        return this.mType == 4;
    }

    public boolean isCall() {
        return this.mType == 5;
    }

    public boolean isWriteOperation() {
        return this.mType == 3 || this.mType == 1 || this.mType == 2;
    }

    public boolean isReadOperation() {
        return this.mType == 4;
    }

    public ContentProviderResult apply(ContentProvider provider2, ContentProviderResult[] backRefs, int numBackRefs) throws OperationApplicationException {
        if (this.mExceptionAllowed) {
            try {
                return this.applyInternal(provider2, backRefs, numBackRefs);
            }
            catch (Exception e) {
                return new ContentProviderResult(e);
            }
        }
        return this.applyInternal(provider2, backRefs, numBackRefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ContentProviderResult applyInternal(ContentProvider provider2, ContentProviderResult[] backRefs, int numBackRefs) throws OperationApplicationException {
        int numRows;
        ContentValues values2 = this.resolveValueBackReferences(backRefs, numBackRefs);
        Bundle extras = this.resolveExtrasBackReferences(backRefs, numBackRefs);
        if (this.mSelection != null) {
            extras = extras != null ? extras : new Bundle();
            extras.putString("android:query-arg-sql-selection", this.mSelection);
        }
        if (this.mSelectionArgs != null) {
            extras = extras != null ? extras : new Bundle();
            extras.putStringArray("android:query-arg-sql-selection-args", this.resolveSelectionArgsBackReferences(backRefs, numBackRefs));
        }
        if (this.mType == 1) {
            Uri newUri = provider2.insert(this.mUri, values2, extras);
            if (newUri == null) throw new OperationApplicationException("Insert into " + this.mUri + " returned no result");
            return new ContentProviderResult(newUri);
        }
        if (this.mType == 5) {
            Bundle res = provider2.call(this.mUri.getAuthority(), this.mMethod, this.mArg, extras);
            return new ContentProviderResult(res);
        }
        if (this.mType == 3) {
            numRows = provider2.delete(this.mUri, extras);
        } else if (this.mType == 2) {
            numRows = provider2.update(this.mUri, values2, extras);
        } else {
            if (this.mType != 4) throw new IllegalStateException("bad type, " + this.mType);
            String[] projection = null;
            if (values2 != null) {
                ArrayList<String> projectionList = new ArrayList<String>();
                for (Map.Entry<String, Object> entry : values2.valueSet()) {
                    projectionList.add(entry.getKey());
                }
                projection = projectionList.toArray(new String[projectionList.size()]);
            }
            try (Cursor cursor = provider2.query(this.mUri, projection, extras, null);){
                numRows = cursor.getCount();
                if (projection != null) {
                    while (cursor.moveToNext()) {
                        for (int i = 0; i < projection.length; ++i) {
                            String expectedValue;
                            String cursorValue = cursor.getString(i);
                            if (TextUtils.equals(cursorValue, expectedValue = values2.getAsString(projection[i]))) continue;
                            throw new OperationApplicationException("Found value " + cursorValue + " when expected " + expectedValue + " for column " + projection[i]);
                        }
                    }
                }
            }
        }
        if (this.mExpectedCount == null || this.mExpectedCount == numRows) return new ContentProviderResult(numRows);
        throw new OperationApplicationException("Expected " + this.mExpectedCount + " rows but actual " + numRows);
    }

    public ContentValues resolveValueBackReferences(ContentProviderResult[] backRefs, int numBackRefs) {
        if (this.mValues != null) {
            ContentValues values2 = new ContentValues();
            for (int i = 0; i < this.mValues.size(); ++i) {
                Object value2 = this.mValues.valueAt(i);
                Object resolved = value2 instanceof BackReference ? ((BackReference)value2).resolve(backRefs, numBackRefs) : value2;
                values2.putObject(this.mValues.keyAt(i), resolved);
            }
            return values2;
        }
        return null;
    }

    public Bundle resolveExtrasBackReferences(ContentProviderResult[] backRefs, int numBackRefs) {
        if (this.mExtras != null) {
            Bundle extras = new Bundle();
            for (int i = 0; i < this.mExtras.size(); ++i) {
                Object value2 = this.mExtras.valueAt(i);
                Object resolved = value2 instanceof BackReference ? ((BackReference)value2).resolve(backRefs, numBackRefs) : value2;
                extras.putObject(this.mExtras.keyAt(i), resolved);
            }
            return extras;
        }
        return null;
    }

    public String[] resolveSelectionArgsBackReferences(ContentProviderResult[] backRefs, int numBackRefs) {
        if (this.mSelectionArgs != null) {
            int max = -1;
            for (int i = 0; i < this.mSelectionArgs.size(); ++i) {
                max = Math.max(max, this.mSelectionArgs.keyAt(i));
            }
            String[] selectionArgs = new String[max + 1];
            for (int i = 0; i < this.mSelectionArgs.size(); ++i) {
                Object value2 = this.mSelectionArgs.valueAt(i);
                Object resolved = value2 instanceof BackReference ? ((BackReference)value2).resolve(backRefs, numBackRefs) : value2;
                selectionArgs[this.mSelectionArgs.keyAt((int)i)] = String.valueOf(resolved);
            }
            return selectionArgs;
        }
        return null;
    }

    public static String typeToString(int type) {
        switch (type) {
            case 1: {
                return "insert";
            }
            case 2: {
                return "update";
            }
            case 3: {
                return "delete";
            }
            case 4: {
                return "assert";
            }
            case 5: {
                return "call";
            }
        }
        return Integer.toString(type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ContentProviderOperation(");
        sb.append("type=").append(ContentProviderOperation.typeToString(this.mType)).append(' ');
        if (this.mUri != null) {
            sb.append("uri=").append(this.mUri).append(' ');
        }
        if (this.mValues != null) {
            sb.append("values=").append(this.mValues).append(' ');
        }
        if (this.mSelection != null) {
            sb.append("selection=").append(this.mSelection).append(' ');
        }
        if (this.mSelectionArgs != null) {
            sb.append("selectionArgs=").append(this.mSelectionArgs).append(' ');
        }
        if (this.mExpectedCount != null) {
            sb.append("expectedCount=").append(this.mExpectedCount).append(' ');
        }
        if (this.mYieldAllowed) {
            sb.append("yieldAllowed ");
        }
        if (this.mExceptionAllowed) {
            sb.append("exceptionAllowed ");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        private final int mType;
        private final Uri mUri;
        private final String mMethod;
        private final String mArg;
        private ArrayMap<String, Object> mValues;
        private ArrayMap<String, Object> mExtras;
        private String mSelection;
        private SparseArray<Object> mSelectionArgs;
        private Integer mExpectedCount;
        private boolean mYieldAllowed;
        private boolean mExceptionAllowed;

        private Builder(int type, Uri uri) {
            this(type, uri, null, null);
        }

        private Builder(int type, Uri uri, String method, String arg) {
            this.mType = type;
            this.mUri = Objects.requireNonNull(uri);
            this.mMethod = method;
            this.mArg = arg;
        }

        public ContentProviderOperation build() {
            if (this.mType == 2 && (this.mValues == null || this.mValues.isEmpty())) {
                throw new IllegalArgumentException("Empty values");
            }
            if (this.mType == 4 && (this.mValues == null || this.mValues.isEmpty()) && this.mExpectedCount == null) {
                throw new IllegalArgumentException("Empty values");
            }
            return new ContentProviderOperation(this);
        }

        private void ensureValues() {
            if (this.mValues == null) {
                this.mValues = new ArrayMap();
            }
        }

        private void ensureExtras() {
            if (this.mExtras == null) {
                this.mExtras = new ArrayMap();
            }
        }

        private void ensureSelectionArgs() {
            if (this.mSelectionArgs == null) {
                this.mSelectionArgs = new SparseArray();
            }
        }

        private void setValue(String key, Object value2) {
            this.ensureValues();
            boolean oldReference = this.mValues.get(key) instanceof BackReference;
            boolean newReference = value2 instanceof BackReference;
            if (!oldReference || newReference) {
                this.mValues.put(key, value2);
            }
        }

        private void setExtra(String key, Object value2) {
            this.ensureExtras();
            boolean oldReference = this.mExtras.get(key) instanceof BackReference;
            boolean newReference = value2 instanceof BackReference;
            if (!oldReference || newReference) {
                this.mExtras.put(key, value2);
            }
        }

        private void setSelectionArg(int index, Object value2) {
            this.ensureSelectionArgs();
            boolean oldReference = this.mSelectionArgs.get(index) instanceof BackReference;
            boolean newReference = value2 instanceof BackReference;
            if (!oldReference || newReference) {
                this.mSelectionArgs.put(index, value2);
            }
        }

        public Builder withValues(ContentValues values2) {
            this.assertValuesAllowed();
            this.ensureValues();
            ArrayMap<String, Object> rawValues = values2.getValues();
            for (int i = 0; i < rawValues.size(); ++i) {
                this.setValue(rawValues.keyAt(i), rawValues.valueAt(i));
            }
            return this;
        }

        public Builder withValue(String key, Object value2) {
            this.assertValuesAllowed();
            if (!ContentValues.isSupportedValue(value2)) {
                throw new IllegalArgumentException("bad value type: " + value2.getClass().getName());
            }
            this.setValue(key, value2);
            return this;
        }

        public Builder withValueBackReferences(ContentValues backReferences) {
            this.assertValuesAllowed();
            ArrayMap<String, Object> rawValues = backReferences.getValues();
            for (int i = 0; i < rawValues.size(); ++i) {
                this.setValue(rawValues.keyAt(i), new BackReference((Integer)rawValues.valueAt(i), null));
            }
            return this;
        }

        public Builder withValueBackReference(String key, int fromIndex) {
            this.assertValuesAllowed();
            this.setValue(key, new BackReference(fromIndex, null));
            return this;
        }

        public Builder withValueBackReference(String key, int fromIndex, String fromKey) {
            this.assertValuesAllowed();
            this.setValue(key, new BackReference(fromIndex, fromKey));
            return this;
        }

        public Builder withExtras(Bundle extras) {
            this.assertExtrasAllowed();
            this.ensureExtras();
            for (String key : extras.keySet()) {
                this.setExtra(key, extras.get(key));
            }
            return this;
        }

        public Builder withExtra(String key, Object value2) {
            this.assertExtrasAllowed();
            this.setExtra(key, value2);
            return this;
        }

        public Builder withExtraBackReference(String key, int fromIndex) {
            this.assertExtrasAllowed();
            this.setExtra(key, new BackReference(fromIndex, null));
            return this;
        }

        public Builder withExtraBackReference(String key, int fromIndex, String fromKey) {
            this.assertExtrasAllowed();
            this.setExtra(key, new BackReference(fromIndex, fromKey));
            return this;
        }

        public Builder withSelection(String selection, String[] selectionArgs) {
            this.assertSelectionAllowed();
            this.mSelection = selection;
            if (selectionArgs != null) {
                this.ensureSelectionArgs();
                for (int i = 0; i < selectionArgs.length; ++i) {
                    this.setSelectionArg(i, selectionArgs[i]);
                }
            }
            return this;
        }

        public Builder withSelectionBackReference(int index, int fromIndex) {
            this.assertSelectionAllowed();
            this.setSelectionArg(index, new BackReference(fromIndex, null));
            return this;
        }

        public Builder withSelectionBackReference(int index, int fromIndex, String fromKey) {
            this.assertSelectionAllowed();
            this.setSelectionArg(index, new BackReference(fromIndex, fromKey));
            return this;
        }

        public Builder withExpectedCount(int count) {
            if (this.mType != 2 && this.mType != 3 && this.mType != 4) {
                throw new IllegalArgumentException("only updates, deletes, and asserts can have expected counts");
            }
            this.mExpectedCount = count;
            return this;
        }

        public Builder withYieldAllowed(boolean yieldAllowed) {
            this.mYieldAllowed = yieldAllowed;
            return this;
        }

        public Builder withExceptionAllowed(boolean exceptionAllowed) {
            this.mExceptionAllowed = exceptionAllowed;
            return this;
        }

        public Builder withFailureAllowed(boolean failureAllowed) {
            return this.withExceptionAllowed(failureAllowed);
        }

        private void assertValuesAllowed() {
            switch (this.mType) {
                case 1: 
                case 2: 
                case 4: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Values not supported for " + ContentProviderOperation.typeToString(this.mType));
                }
            }
        }

        private void assertSelectionAllowed() {
            switch (this.mType) {
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Selection not supported for " + ContentProviderOperation.typeToString(this.mType));
                }
            }
        }

        private void assertExtrasAllowed() {
            switch (this.mType) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Extras not supported for " + ContentProviderOperation.typeToString(this.mType));
                }
            }
        }
    }

    public static class BackReference
    implements Parcelable {
        private final int fromIndex;
        private final String fromKey;
        public static final Parcelable.Creator<BackReference> CREATOR = new Parcelable.Creator<BackReference>(){

            @Override
            public BackReference createFromParcel(Parcel source) {
                return new BackReference(source);
            }

            public BackReference[] newArray(int size) {
                return new BackReference[size];
            }
        };

        private BackReference(int fromIndex, String fromKey) {
            this.fromIndex = fromIndex;
            this.fromKey = fromKey;
        }

        public BackReference(Parcel src) {
            this.fromIndex = src.readInt();
            this.fromKey = src.readInt() != 0 ? src.readString8() : null;
        }

        public Object resolve(ContentProviderResult[] backRefs, int numBackRefs) {
            if (this.fromIndex >= numBackRefs) {
                Log.e(ContentProviderOperation.TAG, this.toString());
                throw new ArrayIndexOutOfBoundsException("asked for back ref " + this.fromIndex + " but there are only " + numBackRefs + " back refs");
            }
            ContentProviderResult backRef = backRefs[this.fromIndex];
            Object backRefValue = backRef.extras != null ? backRef.extras.get(this.fromKey) : (backRef.uri != null ? Long.valueOf(ContentUris.parseId(backRef.uri)) : Long.valueOf(backRef.count.intValue()));
            return backRefValue;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.fromIndex);
            if (this.fromKey != null) {
                dest.writeInt(1);
                dest.writeString8(this.fromKey);
            } else {
                dest.writeInt(0);
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }
}

