/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ContentValues
implements Parcelable {
    public static final String TAG = "ContentValues";
    @Deprecated
    @UnsupportedAppUsage
    private HashMap<String, Object> mValues;
    private final ArrayMap<String, Object> mMap;
    public static final Parcelable.Creator<ContentValues> CREATOR = new Parcelable.Creator<ContentValues>(){

        @Override
        public ContentValues createFromParcel(Parcel in) {
            return new ContentValues(in);
        }

        public ContentValues[] newArray(int size) {
            return new ContentValues[size];
        }
    };

    public ContentValues() {
        this.mMap = new ArrayMap();
    }

    public ContentValues(int size) {
        Preconditions.checkArgumentNonnegative(size);
        this.mMap = new ArrayMap(size);
    }

    public ContentValues(ContentValues from) {
        Objects.requireNonNull(from);
        this.mMap = new ArrayMap<String, Object>(from.mMap);
    }

    @Deprecated
    @UnsupportedAppUsage
    private ContentValues(HashMap<String, Object> from) {
        this.mMap = new ArrayMap();
        this.mMap.putAll(from);
    }

    private ContentValues(Parcel in) {
        this.mMap = new ArrayMap(in.readInt());
        in.readArrayMap(this.mMap, null);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ContentValues)) {
            return false;
        }
        return this.mMap.equals(((ContentValues)object).mMap);
    }

    public ArrayMap<String, Object> getValues() {
        return this.mMap;
    }

    public int hashCode() {
        return this.mMap.hashCode();
    }

    public void put(String key, String value2) {
        this.mMap.put(key, value2);
    }

    public void putAll(ContentValues other) {
        this.mMap.putAll(other.mMap);
    }

    public void put(String key, Byte value2) {
        this.mMap.put(key, value2);
    }

    public void put(String key, Short value2) {
        this.mMap.put(key, value2);
    }

    public void put(String key, Integer value2) {
        this.mMap.put(key, value2);
    }

    public void put(String key, Long value2) {
        this.mMap.put(key, value2);
    }

    public void put(String key, Float value2) {
        this.mMap.put(key, value2);
    }

    public void put(String key, Double value2) {
        this.mMap.put(key, value2);
    }

    public void put(String key, Boolean value2) {
        this.mMap.put(key, value2);
    }

    public void put(String key, byte[] value2) {
        this.mMap.put(key, value2);
    }

    public void putNull(String key) {
        this.mMap.put(key, null);
    }

    public void putObject(String key, Object value2) {
        if (value2 == null) {
            this.putNull(key);
        } else if (value2 instanceof String) {
            this.put(key, (String)value2);
        } else if (value2 instanceof Byte) {
            this.put(key, (Byte)value2);
        } else if (value2 instanceof Short) {
            this.put(key, (Short)value2);
        } else if (value2 instanceof Integer) {
            this.put(key, (Integer)value2);
        } else if (value2 instanceof Long) {
            this.put(key, (Long)value2);
        } else if (value2 instanceof Float) {
            this.put(key, (Float)value2);
        } else if (value2 instanceof Double) {
            this.put(key, (Double)value2);
        } else if (value2 instanceof Boolean) {
            this.put(key, (Boolean)value2);
        } else if (value2 instanceof byte[]) {
            this.put(key, (byte[])value2);
        } else {
            throw new IllegalArgumentException("Unsupported type " + value2.getClass());
        }
    }

    public int size() {
        return this.mMap.size();
    }

    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    public void remove(String key) {
        this.mMap.remove(key);
    }

    public void clear() {
        this.mMap.clear();
    }

    public boolean containsKey(String key) {
        return this.mMap.containsKey(key);
    }

    public Object get(String key) {
        return this.mMap.get(key);
    }

    public String getAsString(String key) {
        Object value2 = this.mMap.get(key);
        return value2 != null ? value2.toString() : null;
    }

    public Long getAsLong(String key) {
        Object value2 = this.mMap.get(key);
        try {
            return value2 != null ? Long.valueOf(((Number)value2).longValue()) : null;
        }
        catch (ClassCastException e) {
            if (value2 instanceof CharSequence) {
                try {
                    return Long.valueOf(value2.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e(TAG, "Cannot parse Long value for " + value2 + " at key " + key);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for " + key + " to a Long: " + value2, e);
            return null;
        }
    }

    public Integer getAsInteger(String key) {
        Object value2 = this.mMap.get(key);
        try {
            return value2 != null ? Integer.valueOf(((Number)value2).intValue()) : null;
        }
        catch (ClassCastException e) {
            if (value2 instanceof CharSequence) {
                try {
                    return Integer.valueOf(value2.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e(TAG, "Cannot parse Integer value for " + value2 + " at key " + key);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for " + key + " to a Integer: " + value2, e);
            return null;
        }
    }

    public Short getAsShort(String key) {
        Object value2 = this.mMap.get(key);
        try {
            return value2 != null ? Short.valueOf(((Number)value2).shortValue()) : null;
        }
        catch (ClassCastException e) {
            if (value2 instanceof CharSequence) {
                try {
                    return Short.valueOf(value2.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e(TAG, "Cannot parse Short value for " + value2 + " at key " + key);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for " + key + " to a Short: " + value2, e);
            return null;
        }
    }

    public Byte getAsByte(String key) {
        Object value2 = this.mMap.get(key);
        try {
            return value2 != null ? Byte.valueOf(((Number)value2).byteValue()) : null;
        }
        catch (ClassCastException e) {
            if (value2 instanceof CharSequence) {
                try {
                    return Byte.valueOf(value2.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e(TAG, "Cannot parse Byte value for " + value2 + " at key " + key);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for " + key + " to a Byte: " + value2, e);
            return null;
        }
    }

    public Double getAsDouble(String key) {
        Object value2 = this.mMap.get(key);
        try {
            return value2 != null ? Double.valueOf(((Number)value2).doubleValue()) : null;
        }
        catch (ClassCastException e) {
            if (value2 instanceof CharSequence) {
                try {
                    return Double.valueOf(value2.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e(TAG, "Cannot parse Double value for " + value2 + " at key " + key);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for " + key + " to a Double: " + value2, e);
            return null;
        }
    }

    public Float getAsFloat(String key) {
        Object value2 = this.mMap.get(key);
        try {
            return value2 != null ? Float.valueOf(((Number)value2).floatValue()) : null;
        }
        catch (ClassCastException e) {
            if (value2 instanceof CharSequence) {
                try {
                    return Float.valueOf(value2.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e(TAG, "Cannot parse Float value for " + value2 + " at key " + key);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for " + key + " to a Float: " + value2, e);
            return null;
        }
    }

    public Boolean getAsBoolean(String key) {
        Object value2 = this.mMap.get(key);
        try {
            return (Boolean)value2;
        }
        catch (ClassCastException e) {
            if (value2 instanceof CharSequence) {
                return Boolean.valueOf(value2.toString()) != false || "1".equals(value2);
            }
            if (value2 instanceof Number) {
                return ((Number)value2).intValue() != 0;
            }
            Log.e(TAG, "Cannot cast value for " + key + " to a Boolean: " + value2, e);
            return null;
        }
    }

    public byte[] getAsByteArray(String key) {
        Object value2 = this.mMap.get(key);
        if (value2 instanceof byte[]) {
            return (byte[])value2;
        }
        return null;
    }

    public Set<Map.Entry<String, Object>> valueSet() {
        return this.mMap.entrySet();
    }

    public Set<String> keySet() {
        return this.mMap.keySet();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mMap.size());
        parcel.writeArrayMap(this.mMap);
    }

    @Deprecated
    @UnsupportedAppUsage
    public void putStringArrayList(String key, ArrayList<String> value2) {
        this.mMap.put(key, value2);
    }

    @Deprecated
    @UnsupportedAppUsage
    public ArrayList<String> getStringArrayList(String key) {
        return (ArrayList)this.mMap.get(key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String name : this.mMap.keySet()) {
            String value2 = this.getAsString(name);
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(name + "=" + value2);
        }
        return sb.toString();
    }

    public static boolean isSupportedValue(Object value2) {
        if (value2 == null) {
            return true;
        }
        if (value2 instanceof String) {
            return true;
        }
        if (value2 instanceof Byte) {
            return true;
        }
        if (value2 instanceof Short) {
            return true;
        }
        if (value2 instanceof Integer) {
            return true;
        }
        if (value2 instanceof Long) {
            return true;
        }
        if (value2 instanceof Float) {
            return true;
        }
        if (value2 instanceof Double) {
            return true;
        }
        if (value2 instanceof Boolean) {
            return true;
        }
        return value2 instanceof byte[];
    }
}

