/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.app.compat.CompatChanges;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.pm.ComponentInfo;
import android.content.pm.ConstrainDisplayApisConfig;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.Printer;
import com.android.internal.util.Parcelling;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;

public class ActivityInfo
extends ComponentInfo
implements Parcelable {
    private static final Parcelling.BuiltIn.ForStringSet sForStringSet = Parcelling.Cache.getOrCreate(Parcelling.BuiltIn.ForStringSet.class);
    public int theme;
    public static final int LAUNCH_MULTIPLE = 0;
    public static final int LAUNCH_SINGLE_TOP = 1;
    public static final int LAUNCH_SINGLE_TASK = 2;
    public static final int LAUNCH_SINGLE_INSTANCE = 3;
    public static final int LAUNCH_SINGLE_INSTANCE_PER_TASK = 4;
    public int launchMode;
    public static final int DOCUMENT_LAUNCH_NONE = 0;
    public static final int DOCUMENT_LAUNCH_INTO_EXISTING = 1;
    public static final int DOCUMENT_LAUNCH_ALWAYS = 2;
    public static final int DOCUMENT_LAUNCH_NEVER = 3;
    public int documentLaunchMode;
    public static final int PERSIST_ROOT_ONLY = 0;
    public static final int PERSIST_NEVER = 1;
    public static final int PERSIST_ACROSS_REBOOTS = 2;
    public int persistableMode;
    public int maxRecents;
    public String permission;
    public String taskAffinity;
    public String targetActivity;
    public String launchToken;
    public static final int RESIZE_MODE_UNRESIZEABLE = 0;
    public static final int RESIZE_MODE_RESIZEABLE_VIA_SDK_VERSION = 1;
    public static final int RESIZE_MODE_RESIZEABLE = 2;
    public static final int RESIZE_MODE_RESIZEABLE_AND_PIPABLE_DEPRECATED = 3;
    public static final int RESIZE_MODE_FORCE_RESIZEABLE = 4;
    public static final int RESIZE_MODE_FORCE_RESIZABLE_LANDSCAPE_ONLY = 5;
    public static final int RESIZE_MODE_FORCE_RESIZABLE_PORTRAIT_ONLY = 6;
    public static final int RESIZE_MODE_FORCE_RESIZABLE_PRESERVE_ORIENTATION = 7;
    @UnsupportedAppUsage
    public int resizeMode = 2;
    private float mMaxAspectRatio;
    private float mMinAspectRatio;
    public boolean supportsSizeChanges;
    public String requestedVrComponent;
    public static final int COLOR_MODE_DEFAULT = 0;
    public static final int COLOR_MODE_WIDE_COLOR_GAMUT = 1;
    public static final int COLOR_MODE_HDR = 2;
    public static final int COLOR_MODE_A8 = 4;
    public int colorMode = 0;
    public static final int FLAG_MULTIPROCESS = 1;
    public static final int FLAG_FINISH_ON_TASK_LAUNCH = 2;
    public static final int FLAG_CLEAR_TASK_ON_LAUNCH = 4;
    public static final int FLAG_ALWAYS_RETAIN_TASK_STATE = 8;
    public static final int FLAG_STATE_NOT_NEEDED = 16;
    public static final int FLAG_EXCLUDE_FROM_RECENTS = 32;
    public static final int FLAG_ALLOW_TASK_REPARENTING = 64;
    public static final int FLAG_NO_HISTORY = 128;
    public static final int FLAG_FINISH_ON_CLOSE_SYSTEM_DIALOGS = 256;
    public static final int FLAG_HARDWARE_ACCELERATED = 512;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int FLAG_SHOW_FOR_ALL_USERS = 1024;
    public static final int FLAG_IMMERSIVE = 2048;
    public static final int FLAG_RELINQUISH_TASK_IDENTITY = 4096;
    public static final int FLAG_AUTO_REMOVE_FROM_RECENTS = 8192;
    public static final int FLAG_RESUME_WHILE_PAUSING = 16384;
    public static final int FLAG_ENABLE_VR_MODE = 32768;
    public static final int FLAG_CAN_DISPLAY_ON_REMOTE_DEVICES = 65536;
    public static final int FLAG_ALWAYS_FOCUSABLE = 262144;
    public static final int FLAG_VISIBLE_TO_INSTANT_APP = 0x100000;
    public static final int FLAG_IMPLICITLY_VISIBLE_TO_INSTANT_APP = 0x200000;
    public static final int FLAG_SUPPORTS_PICTURE_IN_PICTURE = 0x400000;
    public static final int FLAG_SHOW_WHEN_LOCKED = 0x800000;
    public static final int FLAG_TURN_SCREEN_ON = 0x1000000;
    public static final int FLAG_PREFER_MINIMAL_POST_PROCESSING = 0x2000000;
    public static final int FLAG_ALLOW_UNTRUSTED_ACTIVITY_EMBEDDING = 0x10000000;
    public static final int FLAG_SYSTEM_USER_ONLY = 0x20000000;
    public static final int FLAG_SINGLE_USER = 0x40000000;
    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int FLAG_ALLOW_EMBEDDED = Integer.MIN_VALUE;
    public int flags;
    public static final int FLAG_INHERIT_SHOW_WHEN_LOCKED = 1;
    public static final int PRIVATE_FLAG_HOME_TRANSITION_SOUND = 2;
    public int privateFlags;
    public static final int SCREEN_ORIENTATION_UNSET = -2;
    public static final int SCREEN_ORIENTATION_UNSPECIFIED = -1;
    public static final int SCREEN_ORIENTATION_LANDSCAPE = 0;
    public static final int SCREEN_ORIENTATION_PORTRAIT = 1;
    public static final int SCREEN_ORIENTATION_USER = 2;
    public static final int SCREEN_ORIENTATION_BEHIND = 3;
    public static final int SCREEN_ORIENTATION_SENSOR = 4;
    public static final int SCREEN_ORIENTATION_NOSENSOR = 5;
    public static final int SCREEN_ORIENTATION_SENSOR_LANDSCAPE = 6;
    public static final int SCREEN_ORIENTATION_SENSOR_PORTRAIT = 7;
    public static final int SCREEN_ORIENTATION_REVERSE_LANDSCAPE = 8;
    public static final int SCREEN_ORIENTATION_REVERSE_PORTRAIT = 9;
    public static final int SCREEN_ORIENTATION_FULL_SENSOR = 10;
    public static final int SCREEN_ORIENTATION_USER_LANDSCAPE = 11;
    public static final int SCREEN_ORIENTATION_USER_PORTRAIT = 12;
    public static final int SCREEN_ORIENTATION_FULL_USER = 13;
    public static final int SCREEN_ORIENTATION_LOCKED = 14;
    public int screenOrientation = -1;
    public static final int CONFIG_MCC = 1;
    public static final int CONFIG_MNC = 2;
    public static final int CONFIG_LOCALE = 4;
    public static final int CONFIG_TOUCHSCREEN = 8;
    public static final int CONFIG_KEYBOARD = 16;
    public static final int CONFIG_KEYBOARD_HIDDEN = 32;
    public static final int CONFIG_NAVIGATION = 64;
    public static final int CONFIG_ORIENTATION = 128;
    public static final int CONFIG_SCREEN_LAYOUT = 256;
    public static final int CONFIG_UI_MODE = 512;
    public static final int CONFIG_SCREEN_SIZE = 1024;
    public static final int CONFIG_SMALLEST_SCREEN_SIZE = 2048;
    public static final int CONFIG_DENSITY = 4096;
    public static final int CONFIG_LAYOUT_DIRECTION = 8192;
    public static final int CONFIG_COLOR_MODE = 16384;
    public static final int CONFIG_ASSETS_PATHS = Integer.MIN_VALUE;
    public static final int CONFIG_FONT_SCALE = 0x40000000;
    public static final int CONFIG_WINDOW_CONFIGURATION = 0x20000000;
    public static final int CONFIG_FONT_WEIGHT_ADJUSTMENT = 0x10000000;
    public static int[] CONFIG_NATIVE_BITS = new int[]{2, 1, 4, 8, 16, 32, 64, 128, 2048, 4096, 512, 8192, 256, 16384, 65536};
    public static final long FORCE_RESIZE_APP = 174042936L;
    public static final long FORCE_NON_RESIZE_APP = 181136395L;
    public static final int SIZE_CHANGES_UNSUPPORTED_METADATA = 0;
    public static final int SIZE_CHANGES_UNSUPPORTED_OVERRIDE = 1;
    public static final int SIZE_CHANGES_SUPPORTED_METADATA = 2;
    public static final int SIZE_CHANGES_SUPPORTED_OVERRIDE = 3;
    public static final long NEVER_SANDBOX_DISPLAY_APIS = 184838306L;
    public static final long ALWAYS_SANDBOX_DISPLAY_APIS = 185004937L;
    public static final long OVERRIDE_MIN_ASPECT_RATIO = 174042980L;
    public static final long OVERRIDE_MIN_ASPECT_RATIO_PORTRAIT_ONLY = 203647190L;
    public static final long OVERRIDE_MIN_ASPECT_RATIO_MEDIUM = 180326845L;
    public static final float OVERRIDE_MIN_ASPECT_RATIO_MEDIUM_VALUE = 1.5f;
    public static final long OVERRIDE_MIN_ASPECT_RATIO_LARGE = 180326787L;
    public static final float OVERRIDE_MIN_ASPECT_RATIO_LARGE_VALUE = 1.7777778f;
    private static final long CHECK_MIN_WIDTH_HEIGHT_FOR_MULTI_WINDOW = 197654537L;
    private Set<String> mKnownActivityEmbeddingCerts;
    public int configChanges;
    public int softInputMode;
    public int uiOptions = 0;
    public static final int UIOPTION_SPLIT_ACTION_BAR_WHEN_NARROW = 1;
    public String parentActivityName;
    public int rotationAnimation = -1;
    public static final int LOCK_TASK_LAUNCH_MODE_DEFAULT = 0;
    public static final int LOCK_TASK_LAUNCH_MODE_NEVER = 1;
    public static final int LOCK_TASK_LAUNCH_MODE_ALWAYS = 2;
    public static final int LOCK_TASK_LAUNCH_MODE_IF_ALLOWLISTED = 3;
    public int lockTaskLaunchMode;
    public WindowLayout windowLayout;
    public static final Parcelable.Creator<ActivityInfo> CREATOR = new Parcelable.Creator<ActivityInfo>(){

        @Override
        public ActivityInfo createFromParcel(Parcel source) {
            return new ActivityInfo(source);
        }

        public ActivityInfo[] newArray(int size) {
            return new ActivityInfo[size];
        }
    };

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static int activityInfoConfigJavaToNative(int input) {
        int output = 0;
        for (int i = 0; i < CONFIG_NATIVE_BITS.length; ++i) {
            if ((input & 1 << i) == 0) continue;
            output |= CONFIG_NATIVE_BITS[i];
        }
        return output;
    }

    public static int activityInfoConfigNativeToJava(int input) {
        int output = 0;
        for (int i = 0; i < CONFIG_NATIVE_BITS.length; ++i) {
            if ((input & CONFIG_NATIVE_BITS[i]) == 0) continue;
            output |= 1 << i;
        }
        return output;
    }

    public int getRealConfigChanged() {
        return this.applicationInfo.targetSdkVersion < 13 ? this.configChanges | 0x400 | 0x800 : this.configChanges;
    }

    public static String lockTaskLaunchModeToString(int lockTaskLaunchMode) {
        switch (lockTaskLaunchMode) {
            case 0: {
                return "LOCK_TASK_LAUNCH_MODE_DEFAULT";
            }
            case 1: {
                return "LOCK_TASK_LAUNCH_MODE_NEVER";
            }
            case 2: {
                return "LOCK_TASK_LAUNCH_MODE_ALWAYS";
            }
            case 3: {
                return "LOCK_TASK_LAUNCH_MODE_IF_ALLOWLISTED";
            }
        }
        return "unknown=" + lockTaskLaunchMode;
    }

    public ActivityInfo() {
    }

    public ActivityInfo(ActivityInfo orig) {
        super(orig);
        this.theme = orig.theme;
        this.launchMode = orig.launchMode;
        this.documentLaunchMode = orig.documentLaunchMode;
        this.permission = orig.permission;
        this.mKnownActivityEmbeddingCerts = orig.mKnownActivityEmbeddingCerts;
        this.taskAffinity = orig.taskAffinity;
        this.targetActivity = orig.targetActivity;
        this.flags = orig.flags;
        this.privateFlags = orig.privateFlags;
        this.screenOrientation = orig.screenOrientation;
        this.configChanges = orig.configChanges;
        this.softInputMode = orig.softInputMode;
        this.uiOptions = orig.uiOptions;
        this.parentActivityName = orig.parentActivityName;
        this.maxRecents = orig.maxRecents;
        this.lockTaskLaunchMode = orig.lockTaskLaunchMode;
        this.windowLayout = orig.windowLayout;
        this.resizeMode = orig.resizeMode;
        this.requestedVrComponent = orig.requestedVrComponent;
        this.rotationAnimation = orig.rotationAnimation;
        this.colorMode = orig.colorMode;
        this.mMaxAspectRatio = orig.mMaxAspectRatio;
        this.mMinAspectRatio = orig.mMinAspectRatio;
        this.supportsSizeChanges = orig.supportsSizeChanges;
    }

    public int getThemeResource() {
        return this.theme != 0 ? this.theme : this.applicationInfo.theme;
    }

    private String persistableModeToString() {
        switch (this.persistableMode) {
            case 0: {
                return "PERSIST_ROOT_ONLY";
            }
            case 1: {
                return "PERSIST_NEVER";
            }
            case 2: {
                return "PERSIST_ACROSS_REBOOTS";
            }
        }
        return "UNKNOWN=" + this.persistableMode;
    }

    public boolean hasFixedAspectRatio(int orientation2) {
        return this.getMaxAspectRatio() != 0.0f || this.getMinAspectRatio(orientation2) != 0.0f;
    }

    public boolean isFixedOrientation() {
        return this.isFixedOrientationLandscape() || this.isFixedOrientationPortrait() || this.screenOrientation == 14;
    }

    boolean isFixedOrientationLandscape() {
        return ActivityInfo.isFixedOrientationLandscape(this.screenOrientation);
    }

    public static boolean isFixedOrientationLandscape(int orientation2) {
        return orientation2 == 0 || orientation2 == 6 || orientation2 == 8 || orientation2 == 11;
    }

    boolean isFixedOrientationPortrait() {
        return ActivityInfo.isFixedOrientationPortrait(this.screenOrientation);
    }

    public static boolean isFixedOrientationPortrait(int orientation2) {
        return orientation2 == 1 || orientation2 == 7 || orientation2 == 9 || orientation2 == 12;
    }

    public static int reverseOrientation(int orientation2) {
        switch (orientation2) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 9;
            }
            case 9: {
                return 8;
            }
            case 11: {
                return 12;
            }
            case 12: {
                return 11;
            }
        }
        return orientation2;
    }

    @UnsupportedAppUsage
    public boolean supportsPictureInPicture() {
        return (this.flags & 0x400000) != 0;
    }

    public int supportsSizeChanges() {
        if (this.isChangeEnabled(181136395L)) {
            return 1;
        }
        if (this.supportsSizeChanges) {
            return 2;
        }
        if (this.isChangeEnabled(174042936L)) {
            return 3;
        }
        return 0;
    }

    public boolean neverSandboxDisplayApis(ConstrainDisplayApisConfig constrainDisplayApisConfig) {
        return this.isChangeEnabled(184838306L) || constrainDisplayApisConfig.getNeverConstrainDisplayApis(this.applicationInfo);
    }

    public boolean alwaysSandboxDisplayApis(ConstrainDisplayApisConfig constrainDisplayApisConfig) {
        return this.isChangeEnabled(185004937L) || constrainDisplayApisConfig.getAlwaysConstrainDisplayApis(this.applicationInfo);
    }

    public void setMaxAspectRatio(float maxAspectRatio) {
        this.mMaxAspectRatio = maxAspectRatio >= 0.0f ? maxAspectRatio : 0.0f;
    }

    public float getMaxAspectRatio() {
        return this.mMaxAspectRatio;
    }

    public void setMinAspectRatio(float minAspectRatio) {
        this.mMinAspectRatio = minAspectRatio >= 0.0f ? minAspectRatio : 0.0f;
    }

    public float getMinAspectRatio(int orientation2) {
        if (this.applicationInfo == null || !this.isChangeEnabled(174042980L) || this.isChangeEnabled(203647190L) && !ActivityInfo.isFixedOrientationPortrait(orientation2)) {
            return this.mMinAspectRatio;
        }
        if (this.isChangeEnabled(180326787L)) {
            return Math.max(1.7777778f, this.mMinAspectRatio);
        }
        if (this.isChangeEnabled(180326845L)) {
            return Math.max(1.5f, this.mMinAspectRatio);
        }
        return this.mMinAspectRatio;
    }

    public Set<String> getKnownActivityEmbeddingCerts() {
        return this.mKnownActivityEmbeddingCerts == null ? Collections.emptySet() : this.mKnownActivityEmbeddingCerts;
    }

    public void setKnownActivityEmbeddingCerts(Set<String> knownActivityEmbeddingCerts) {
        this.mKnownActivityEmbeddingCerts = new ArraySet<String>();
        for (String knownCert : knownActivityEmbeddingCerts) {
            this.mKnownActivityEmbeddingCerts.add(knownCert.toUpperCase(Locale.US));
        }
    }

    private boolean isChangeEnabled(long changeId) {
        return CompatChanges.isChangeEnabled(changeId, this.applicationInfo.packageName, UserHandle.getUserHandleForUid(this.applicationInfo.uid));
    }

    public float getManifestMinAspectRatio() {
        return this.mMinAspectRatio;
    }

    @UnsupportedAppUsage
    public static boolean isResizeableMode(int mode) {
        return mode == 2 || mode == 4 || mode == 6 || mode == 5 || mode == 7 || mode == 1;
    }

    public static boolean isPreserveOrientationMode(int mode) {
        return mode == 6 || mode == 5 || mode == 7;
    }

    public static String resizeModeToString(int mode) {
        switch (mode) {
            case 0: {
                return "RESIZE_MODE_UNRESIZEABLE";
            }
            case 1: {
                return "RESIZE_MODE_RESIZEABLE_VIA_SDK_VERSION";
            }
            case 2: {
                return "RESIZE_MODE_RESIZEABLE";
            }
            case 4: {
                return "RESIZE_MODE_FORCE_RESIZEABLE";
            }
            case 6: {
                return "RESIZE_MODE_FORCE_RESIZABLE_PORTRAIT_ONLY";
            }
            case 5: {
                return "RESIZE_MODE_FORCE_RESIZABLE_LANDSCAPE_ONLY";
            }
            case 7: {
                return "RESIZE_MODE_FORCE_RESIZABLE_PRESERVE_ORIENTATION";
            }
        }
        return "unknown=" + mode;
    }

    public static String sizeChangesSupportModeToString(int mode) {
        switch (mode) {
            case 0: {
                return "SIZE_CHANGES_UNSUPPORTED_METADATA";
            }
            case 1: {
                return "SIZE_CHANGES_UNSUPPORTED_OVERRIDE";
            }
            case 2: {
                return "SIZE_CHANGES_SUPPORTED_METADATA";
            }
            case 3: {
                return "SIZE_CHANGES_SUPPORTED_OVERRIDE";
            }
        }
        return "unknown=" + mode;
    }

    public boolean shouldCheckMinWidthHeightForMultiWindow() {
        return this.isChangeEnabled(197654537L);
    }

    public void dump(Printer pw, String prefix) {
        this.dump(pw, prefix, 3);
    }

    public void dump(Printer pw, String prefix, int dumpFlags) {
        float minAspectRatio;
        super.dumpFront(pw, prefix);
        if (this.permission != null) {
            pw.println(prefix + "permission=" + this.permission);
        }
        if ((dumpFlags & 1) != 0) {
            pw.println(prefix + "taskAffinity=" + this.taskAffinity + " targetActivity=" + this.targetActivity + " persistableMode=" + this.persistableModeToString());
        }
        if (this.launchMode != 0 || this.flags != 0 || this.privateFlags != 0 || this.theme != 0) {
            pw.println(prefix + "launchMode=" + this.launchMode + " flags=0x" + Integer.toHexString(this.flags) + " privateFlags=0x" + Integer.toHexString(this.privateFlags) + " theme=0x" + Integer.toHexString(this.theme));
        }
        if (this.screenOrientation != -1 || this.configChanges != 0 || this.softInputMode != 0) {
            pw.println(prefix + "screenOrientation=" + this.screenOrientation + " configChanges=0x" + Integer.toHexString(this.configChanges) + " softInputMode=0x" + Integer.toHexString(this.softInputMode));
        }
        if (this.uiOptions != 0) {
            pw.println(prefix + " uiOptions=0x" + Integer.toHexString(this.uiOptions));
        }
        if ((dumpFlags & 1) != 0) {
            pw.println(prefix + "lockTaskLaunchMode=" + ActivityInfo.lockTaskLaunchModeToString(this.lockTaskLaunchMode));
        }
        if (this.windowLayout != null) {
            pw.println(prefix + "windowLayout=" + this.windowLayout.width + "|" + this.windowLayout.widthFraction + ", " + this.windowLayout.height + "|" + this.windowLayout.heightFraction + ", " + this.windowLayout.gravity);
        }
        pw.println(prefix + "resizeMode=" + ActivityInfo.resizeModeToString(this.resizeMode));
        if (this.requestedVrComponent != null) {
            pw.println(prefix + "requestedVrComponent=" + this.requestedVrComponent);
        }
        if (this.getMaxAspectRatio() != 0.0f) {
            pw.println(prefix + "maxAspectRatio=" + this.getMaxAspectRatio());
        }
        if ((minAspectRatio = this.getMinAspectRatio(this.screenOrientation)) != 0.0f) {
            pw.println(prefix + "minAspectRatio=" + minAspectRatio);
            if (this.getManifestMinAspectRatio() != minAspectRatio) {
                pw.println(prefix + "getManifestMinAspectRatio=" + this.getManifestMinAspectRatio());
            }
        }
        if (this.supportsSizeChanges) {
            pw.println(prefix + "supportsSizeChanges=true");
        }
        if (this.mKnownActivityEmbeddingCerts != null) {
            pw.println(prefix + "knownActivityEmbeddingCerts=" + this.mKnownActivityEmbeddingCerts);
        }
        super.dumpBack(pw, prefix, dumpFlags);
    }

    public String toString() {
        return "ActivityInfo{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.name + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int parcelableFlags) {
        super.writeToParcel(dest, parcelableFlags);
        dest.writeInt(this.theme);
        dest.writeInt(this.launchMode);
        dest.writeInt(this.documentLaunchMode);
        dest.writeString8(this.permission);
        dest.writeString8(this.taskAffinity);
        dest.writeString8(this.targetActivity);
        dest.writeString8(this.launchToken);
        dest.writeInt(this.flags);
        dest.writeInt(this.privateFlags);
        dest.writeInt(this.screenOrientation);
        dest.writeInt(this.configChanges);
        dest.writeInt(this.softInputMode);
        dest.writeInt(this.uiOptions);
        dest.writeString8(this.parentActivityName);
        dest.writeInt(this.persistableMode);
        dest.writeInt(this.maxRecents);
        dest.writeInt(this.lockTaskLaunchMode);
        if (this.windowLayout != null) {
            dest.writeInt(1);
            this.windowLayout.writeToParcel(dest);
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.resizeMode);
        dest.writeString8(this.requestedVrComponent);
        dest.writeInt(this.rotationAnimation);
        dest.writeInt(this.colorMode);
        dest.writeFloat(this.mMaxAspectRatio);
        dest.writeFloat(this.mMinAspectRatio);
        dest.writeBoolean(this.supportsSizeChanges);
        sForStringSet.parcel(this.mKnownActivityEmbeddingCerts, dest, this.flags);
    }

    @UnsupportedAppUsage
    public static boolean isTranslucentOrFloating(TypedArray attributes) {
        boolean isTranslucent = attributes.getBoolean(5, false);
        boolean isFloating = attributes.getBoolean(4, false);
        return isFloating || isTranslucent;
    }

    public static String screenOrientationToString(int orientation2) {
        switch (orientation2) {
            case -2: {
                return "SCREEN_ORIENTATION_UNSET";
            }
            case -1: {
                return "SCREEN_ORIENTATION_UNSPECIFIED";
            }
            case 0: {
                return "SCREEN_ORIENTATION_LANDSCAPE";
            }
            case 1: {
                return "SCREEN_ORIENTATION_PORTRAIT";
            }
            case 2: {
                return "SCREEN_ORIENTATION_USER";
            }
            case 3: {
                return "SCREEN_ORIENTATION_BEHIND";
            }
            case 4: {
                return "SCREEN_ORIENTATION_SENSOR";
            }
            case 5: {
                return "SCREEN_ORIENTATION_NOSENSOR";
            }
            case 6: {
                return "SCREEN_ORIENTATION_SENSOR_LANDSCAPE";
            }
            case 7: {
                return "SCREEN_ORIENTATION_SENSOR_PORTRAIT";
            }
            case 8: {
                return "SCREEN_ORIENTATION_REVERSE_LANDSCAPE";
            }
            case 9: {
                return "SCREEN_ORIENTATION_REVERSE_PORTRAIT";
            }
            case 10: {
                return "SCREEN_ORIENTATION_FULL_SENSOR";
            }
            case 11: {
                return "SCREEN_ORIENTATION_USER_LANDSCAPE";
            }
            case 12: {
                return "SCREEN_ORIENTATION_USER_PORTRAIT";
            }
            case 13: {
                return "SCREEN_ORIENTATION_FULL_USER";
            }
            case 14: {
                return "SCREEN_ORIENTATION_LOCKED";
            }
        }
        return Integer.toString(orientation2);
    }

    public static String colorModeToString(int colorMode) {
        switch (colorMode) {
            case 0: {
                return "COLOR_MODE_DEFAULT";
            }
            case 1: {
                return "COLOR_MODE_WIDE_COLOR_GAMUT";
            }
            case 2: {
                return "COLOR_MODE_HDR";
            }
            case 4: {
                return "COLOR_MODE_A8";
            }
        }
        return Integer.toString(colorMode);
    }

    private ActivityInfo(Parcel source) {
        super(source);
        this.theme = source.readInt();
        this.launchMode = source.readInt();
        this.documentLaunchMode = source.readInt();
        this.permission = source.readString8();
        this.taskAffinity = source.readString8();
        this.targetActivity = source.readString8();
        this.launchToken = source.readString8();
        this.flags = source.readInt();
        this.privateFlags = source.readInt();
        this.screenOrientation = source.readInt();
        this.configChanges = source.readInt();
        this.softInputMode = source.readInt();
        this.uiOptions = source.readInt();
        this.parentActivityName = source.readString8();
        this.persistableMode = source.readInt();
        this.maxRecents = source.readInt();
        this.lockTaskLaunchMode = source.readInt();
        if (source.readInt() == 1) {
            this.windowLayout = new WindowLayout(source);
        }
        this.resizeMode = source.readInt();
        this.requestedVrComponent = source.readString8();
        this.rotationAnimation = source.readInt();
        this.colorMode = source.readInt();
        this.mMaxAspectRatio = source.readFloat();
        this.mMinAspectRatio = source.readFloat();
        this.supportsSizeChanges = source.readBoolean();
        this.mKnownActivityEmbeddingCerts = sForStringSet.unparcel(source);
        if (this.mKnownActivityEmbeddingCerts.isEmpty()) {
            this.mKnownActivityEmbeddingCerts = null;
        }
    }

    public static class WindowLayout {
        public final int width;
        public final float widthFraction;
        public final int height;
        public final float heightFraction;
        public final int gravity;
        public final int minWidth;
        public final int minHeight;
        public String windowLayoutAffinity;

        public WindowLayout(int width2, float widthFraction, int height2, float heightFraction, int gravity, int minWidth, int minHeight) {
            this(width2, widthFraction, height2, heightFraction, gravity, minWidth, minHeight, null);
        }

        public WindowLayout(int width2, float widthFraction, int height2, float heightFraction, int gravity, int minWidth, int minHeight, String windowLayoutAffinity) {
            this.width = width2;
            this.widthFraction = widthFraction;
            this.height = height2;
            this.heightFraction = heightFraction;
            this.gravity = gravity;
            this.minWidth = minWidth;
            this.minHeight = minHeight;
            this.windowLayoutAffinity = windowLayoutAffinity;
        }

        public WindowLayout(Parcel source) {
            this.width = source.readInt();
            this.widthFraction = source.readFloat();
            this.height = source.readInt();
            this.heightFraction = source.readFloat();
            this.gravity = source.readInt();
            this.minWidth = source.readInt();
            this.minHeight = source.readInt();
            this.windowLayoutAffinity = source.readString8();
        }

        public boolean hasSpecifiedSize() {
            return this.width >= 0 || this.height >= 0 || this.widthFraction >= 0.0f || this.heightFraction >= 0.0f;
        }

        public void writeToParcel(Parcel dest) {
            dest.writeInt(this.width);
            dest.writeFloat(this.widthFraction);
            dest.writeInt(this.height);
            dest.writeFloat(this.heightFraction);
            dest.writeInt(this.gravity);
            dest.writeInt(this.minWidth);
            dest.writeInt(this.minHeight);
            dest.writeString8(this.windowLayoutAffinity);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SizeChangesSupportMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Config {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScreenOrientation {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ColorMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LaunchMode {
    }
}

