/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class CapabilityParams
implements Parcelable {
    private final String mName;
    private final String mPrimaryValue;
    private final List<String> mAliases;
    public static final Parcelable.Creator<CapabilityParams> CREATOR = new Parcelable.Creator<CapabilityParams>(){

        public CapabilityParams[] newArray(int size) {
            return new CapabilityParams[size];
        }

        @Override
        public CapabilityParams createFromParcel(Parcel in) {
            return new CapabilityParams(in);
        }
    };

    private CapabilityParams(String name, String primaryValue, Collection<String> aliases) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(primaryValue);
        this.mName = name;
        this.mPrimaryValue = primaryValue;
        this.mAliases = aliases == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(aliases));
    }

    CapabilityParams(CapabilityParams orig) {
        this(orig.mName, orig.mPrimaryValue, orig.mAliases);
    }

    private CapabilityParams(Builder builder2) {
        this(builder2.mKey, builder2.mPrimaryValue, builder2.mAliases);
    }

    private CapabilityParams(Parcel in) {
        this.mName = in.readString();
        this.mPrimaryValue = in.readString();
        ArrayList<String> values2 = new ArrayList<String>();
        in.readStringList(values2);
        this.mAliases = Collections.unmodifiableList(values2);
    }

    public String getName() {
        return this.mName;
    }

    public String getValue() {
        return this.mPrimaryValue;
    }

    public List<String> getAliases() {
        return new ArrayList<String>(this.mAliases);
    }

    List<String> getValues() {
        if (this.mAliases == null) {
            return new ArrayList<String>(Collections.singletonList(this.mPrimaryValue));
        }
        ArrayList<String> ret = new ArrayList<String>(this.mAliases.size() + 1);
        ret.add(this.mPrimaryValue);
        ret.addAll(this.mAliases);
        return ret;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CapabilityParams)) {
            return false;
        }
        CapabilityParams target = (CapabilityParams)obj;
        return this.mName.equals(target.mName) && this.mPrimaryValue.equals(target.mPrimaryValue) && this.mAliases.equals(target.mAliases);
    }

    public int hashCode() {
        return Objects.hash(this.mName, this.mPrimaryValue, this.mAliases);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mName);
        dest.writeString(this.mPrimaryValue);
        dest.writeStringList(this.mAliases);
    }

    public static class Builder {
        private final String mKey;
        private String mPrimaryValue;
        private Set<String> mAliases;

        public Builder(String key, String value2) {
            Objects.requireNonNull(key);
            if (TextUtils.isEmpty(value2)) {
                throw new IllegalArgumentException("Primary value cannot be empty or null");
            }
            this.mPrimaryValue = value2;
            this.mKey = key;
        }

        public Builder addAlias(String alias) {
            if (this.mAliases == null) {
                this.mAliases = new ArraySet<String>(1);
            }
            this.mAliases.add(alias);
            return this;
        }

        public CapabilityParams build() {
            return new CapabilityParams(this);
        }
    }
}

