/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.ApplicationInfo;
import android.provider.DeviceConfig;
import android.util.ArrayMap;
import android.util.Pair;
import android.util.Slog;
import com.android.internal.os.BackgroundThread;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ConstrainDisplayApisConfig {
    private static final String TAG = ConstrainDisplayApisConfig.class.getSimpleName();
    private static final String FLAG_NEVER_CONSTRAIN_DISPLAY_APIS = "never_constrain_display_apis";
    private static final String FLAG_NEVER_CONSTRAIN_DISPLAY_APIS_ALL_PACKAGES = "never_constrain_display_apis_all_packages";
    private static final String FLAG_ALWAYS_CONSTRAIN_DISPLAY_APIS = "always_constrain_display_apis";
    private boolean mNeverConstrainDisplayApisAllPackages;
    private ArrayMap<String, Pair<Long, Long>> mNeverConstrainConfigMap;
    private ArrayMap<String, Pair<Long, Long>> mAlwaysConstrainConfigMap;

    public ConstrainDisplayApisConfig() {
        this.updateCache();
        DeviceConfig.addOnPropertiesChangedListener("constrain_display_apis", BackgroundThread.getExecutor(), properties2 -> this.updateCache());
    }

    public boolean getNeverConstrainDisplayApis(ApplicationInfo applicationInfo) {
        if (this.mNeverConstrainDisplayApisAllPackages) {
            return true;
        }
        return ConstrainDisplayApisConfig.flagHasMatchingPackageEntry(this.mNeverConstrainConfigMap, applicationInfo);
    }

    public boolean getAlwaysConstrainDisplayApis(ApplicationInfo applicationInfo) {
        return ConstrainDisplayApisConfig.flagHasMatchingPackageEntry(this.mAlwaysConstrainConfigMap, applicationInfo);
    }

    private void updateCache() {
        this.mNeverConstrainDisplayApisAllPackages = DeviceConfig.getBoolean("constrain_display_apis", FLAG_NEVER_CONSTRAIN_DISPLAY_APIS_ALL_PACKAGES, false);
        String neverConstrainConfigStr = DeviceConfig.getString("constrain_display_apis", FLAG_NEVER_CONSTRAIN_DISPLAY_APIS, "");
        this.mNeverConstrainConfigMap = ConstrainDisplayApisConfig.buildConfigMap(neverConstrainConfigStr);
        String alwaysConstrainConfigStr = DeviceConfig.getString("constrain_display_apis", FLAG_ALWAYS_CONSTRAIN_DISPLAY_APIS, "");
        this.mAlwaysConstrainConfigMap = ConstrainDisplayApisConfig.buildConfigMap(alwaysConstrainConfigStr);
    }

    private static ArrayMap<String, Pair<Long, Long>> buildConfigMap(String configStr) {
        ArrayMap<String, Pair<Long, Long>> configMap = new ArrayMap<String, Pair<Long, Long>>();
        if (configStr.isEmpty()) {
            return configMap;
        }
        for (String packageEntryString : configStr.split(",")) {
            List<String> packageAndVersions = Arrays.asList(packageEntryString.split(":", 3));
            if (packageAndVersions.size() != 3) {
                Slog.w(TAG, "Invalid package entry in flag 'never/always_constrain_display_apis': " + packageEntryString);
                continue;
            }
            String packageName = packageAndVersions.get(0);
            String minVersionCodeStr = packageAndVersions.get(1);
            String maxVersionCodeStr = packageAndVersions.get(2);
            try {
                long minVersion = minVersionCodeStr.isEmpty() ? Long.MIN_VALUE : Long.parseLong(minVersionCodeStr);
                long maxVersion = maxVersionCodeStr.isEmpty() ? Long.MAX_VALUE : Long.parseLong(maxVersionCodeStr);
                Pair<Long, Long> minMaxVersionCodes = new Pair<Long, Long>(minVersion, maxVersion);
                configMap.put(packageName, minMaxVersionCodes);
            }
            catch (NumberFormatException e) {
                Slog.w(TAG, "Invalid APK version code in package entry: " + packageEntryString);
            }
        }
        return configMap;
    }

    private static boolean flagHasMatchingPackageEntry(Map<String, Pair<Long, Long>> configMap, ApplicationInfo applicationInfo) {
        if (configMap.isEmpty()) {
            return false;
        }
        if (!configMap.containsKey(applicationInfo.packageName)) {
            return false;
        }
        return ConstrainDisplayApisConfig.matchesApplicationInfo(configMap.get(applicationInfo.packageName), applicationInfo);
    }

    private static boolean matchesApplicationInfo(Pair<Long, Long> minMaxVersionCodes, ApplicationInfo applicationInfo) {
        return applicationInfo.longVersionCode >= (Long)minMaxVersionCodes.first && applicationInfo.longVersionCode <= (Long)minMaxVersionCodes.second;
    }
}

