/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.Activity;
import android.app.admin.DevicePolicyManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ICrossProfileApps;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import com.android.internal.util.UserIcons;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CrossProfileApps {
    public static final String ACTION_CAN_INTERACT_ACROSS_PROFILES_CHANGED = "android.content.pm.action.CAN_INTERACT_ACROSS_PROFILES_CHANGED";
    private final Context mContext;
    private final ICrossProfileApps mService;
    private final UserManager mUserManager;
    private final Resources mResources;

    public CrossProfileApps(Context context, ICrossProfileApps service) {
        this.mContext = context;
        this.mService = service;
        this.mUserManager = context.getSystemService(UserManager.class);
        this.mResources = context.getResources();
    }

    public void startMainActivity(ComponentName component2, UserHandle targetUser) {
        try {
            this.mService.startActivityAsUser(this.mContext.getIApplicationThread(), this.mContext.getPackageName(), this.mContext.getAttributionTag(), component2, targetUser.getIdentifier(), true, null, null);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void startMainActivity(ComponentName component2, UserHandle targetUser, Activity callingActivity, Bundle options) {
        try {
            this.mService.startActivityAsUser(this.mContext.getIApplicationThread(), this.mContext.getPackageName(), this.mContext.getAttributionTag(), component2, targetUser.getIdentifier(), true, callingActivity != null ? callingActivity.getActivityToken() : null, options);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_PROFILES", "android.permission.INTERACT_ACROSS_USERS"})
    public void startActivity(Intent intent, UserHandle targetUser, Activity callingActivity) {
        this.startActivity(intent, targetUser, callingActivity, null);
    }

    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_PROFILES", "android.permission.INTERACT_ACROSS_USERS"})
    public void startActivity(Intent intent, UserHandle targetUser, Activity callingActivity, Bundle options) {
        try {
            this.mService.startActivityAsUserByIntent(this.mContext.getIApplicationThread(), this.mContext.getPackageName(), this.mContext.getAttributionTag(), intent, targetUser.getIdentifier(), callingActivity != null ? callingActivity.getActivityToken() : null, options);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_PROFILES", "android.permission.START_CROSS_PROFILE_ACTIVITIES"})
    public void startActivity(ComponentName component2, UserHandle targetUser, Activity callingActivity, Bundle options) {
        try {
            this.mService.startActivityAsUser(this.mContext.getIApplicationThread(), this.mContext.getPackageName(), this.mContext.getAttributionTag(), component2, targetUser.getIdentifier(), false, callingActivity != null ? callingActivity.getActivityToken() : null, options);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_PROFILES", "android.permission.START_CROSS_PROFILE_ACTIVITIES"})
    public void startActivity(ComponentName component2, UserHandle targetUser) {
        try {
            this.mService.startActivityAsUser(this.mContext.getIApplicationThread(), this.mContext.getPackageName(), this.mContext.getAttributionTag(), component2, targetUser.getIdentifier(), false, null, null);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public List<UserHandle> getTargetUserProfiles() {
        try {
            return this.mService.getTargetUserProfiles(this.mContext.getPackageName());
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public CharSequence getProfileSwitchingLabel(UserHandle userHandle) {
        this.verifyCanAccessUser(userHandle);
        boolean isManagedProfile = this.mUserManager.isManagedProfile(userHandle.getIdentifier());
        DevicePolicyManager dpm = this.mContext.getSystemService(DevicePolicyManager.class);
        return dpm.getResources().getString(this.getUpdatableProfileSwitchingLabelId(isManagedProfile), () -> this.getDefaultProfileSwitchingLabel(isManagedProfile));
    }

    private String getUpdatableProfileSwitchingLabelId(boolean isManagedProfile) {
        return isManagedProfile ? "Core.SWITCH_TO_WORK_LABEL" : "Core.SWITCH_TO_PERSONAL_LABEL";
    }

    private String getDefaultProfileSwitchingLabel(boolean isManagedProfile) {
        int stringRes = isManagedProfile ? 17040663 : 17041687;
        return this.mResources.getString(stringRes);
    }

    public Drawable getProfileSwitchingIconDrawable(UserHandle userHandle) {
        this.verifyCanAccessUser(userHandle);
        boolean isManagedProfile = this.mUserManager.isManagedProfile(userHandle.getIdentifier());
        if (isManagedProfile) {
            return this.mContext.getPackageManager().getUserBadgeForDensityNoBackground(userHandle, 0);
        }
        return UserIcons.getDefaultUserIcon(this.mResources, 0, true);
    }

    public boolean canRequestInteractAcrossProfiles() {
        try {
            return this.mService.canRequestInteractAcrossProfiles(this.mContext.getPackageName());
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public boolean canInteractAcrossProfiles() {
        try {
            return this.mService.canInteractAcrossProfiles(this.mContext.getPackageName());
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public Intent createRequestInteractAcrossProfilesIntent() {
        if (!this.canRequestInteractAcrossProfiles()) {
            throw new SecurityException("The calling package can not request to interact across profiles.");
        }
        Intent settingsIntent = new Intent();
        settingsIntent.setAction("android.settings.MANAGE_CROSS_PROFILE_ACCESS");
        Uri packageUri = Uri.parse("package:" + this.mContext.getPackageName());
        settingsIntent.setData(packageUri);
        return settingsIntent;
    }

    @RequiresPermission(allOf={"android.permission.CONFIGURE_INTERACT_ACROSS_PROFILES", "android.permission.INTERACT_ACROSS_USERS"})
    public void setInteractAcrossProfilesAppOp(String packageName, int newMode) {
        try {
            this.mService.setInteractAcrossProfilesAppOp(packageName, newMode);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public boolean canConfigureInteractAcrossProfiles(String packageName) {
        try {
            return this.mService.canConfigureInteractAcrossProfiles(packageName);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public boolean canUserAttemptToConfigureInteractAcrossProfiles(String packageName) {
        try {
            return this.mService.canUserAttemptToConfigureInteractAcrossProfiles(packageName);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.CONFIGURE_INTERACT_ACROSS_PROFILES", "android.permission.INTERACT_ACROSS_USERS"})
    public void resetInteractAcrossProfilesAppOps(Collection<String> previousCrossProfilePackages, Set<String> newCrossProfilePackages) {
        if (previousCrossProfilePackages.isEmpty()) {
            return;
        }
        List<String> unsetCrossProfilePackages = previousCrossProfilePackages.stream().filter(packageName -> !newCrossProfilePackages.contains(packageName)).collect(Collectors.toList());
        if (unsetCrossProfilePackages.isEmpty()) {
            return;
        }
        try {
            this.mService.resetInteractAcrossProfilesAppOps(unsetCrossProfilePackages);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.CONFIGURE_INTERACT_ACROSS_PROFILES", "android.permission.INTERACT_ACROSS_USERS"})
    public void clearInteractAcrossProfilesAppOps() {
        try {
            this.mService.clearInteractAcrossProfilesAppOps();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private void verifyCanAccessUser(UserHandle userHandle) {
        if (!this.getTargetUserProfiles().contains(userHandle)) {
            throw new SecurityException("Not allowed to access " + userHandle);
        }
    }
}

