/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.ParceledListSlice;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.UserHandle;

public interface IOnAppsChangedListener
extends IInterface {
    public void onPackageRemoved(UserHandle var1, String var2) throws RemoteException;

    public void onPackageAdded(UserHandle var1, String var2) throws RemoteException;

    public void onPackageChanged(UserHandle var1, String var2) throws RemoteException;

    public void onPackagesAvailable(UserHandle var1, String[] var2, boolean var3) throws RemoteException;

    public void onPackagesUnavailable(UserHandle var1, String[] var2, boolean var3) throws RemoteException;

    public void onPackagesSuspended(UserHandle var1, String[] var2, Bundle var3) throws RemoteException;

    public void onPackagesUnsuspended(UserHandle var1, String[] var2) throws RemoteException;

    public void onShortcutChanged(UserHandle var1, String var2, ParceledListSlice var3) throws RemoteException;

    public void onPackageLoadingProgressChanged(UserHandle var1, String var2, float var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IOnAppsChangedListener {
        public static final String DESCRIPTOR = "android.content.pm.IOnAppsChangedListener";
        static final int TRANSACTION_onPackageRemoved = 1;
        static final int TRANSACTION_onPackageAdded = 2;
        static final int TRANSACTION_onPackageChanged = 3;
        static final int TRANSACTION_onPackagesAvailable = 4;
        static final int TRANSACTION_onPackagesUnavailable = 5;
        static final int TRANSACTION_onPackagesSuspended = 6;
        static final int TRANSACTION_onPackagesUnsuspended = 7;
        static final int TRANSACTION_onShortcutChanged = 8;
        static final int TRANSACTION_onPackageLoadingProgressChanged = 9;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IOnAppsChangedListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IOnAppsChangedListener) {
                return (IOnAppsChangedListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onPackageRemoved";
                }
                case 2: {
                    return "onPackageAdded";
                }
                case 3: {
                    return "onPackageChanged";
                }
                case 4: {
                    return "onPackagesAvailable";
                }
                case 5: {
                    return "onPackagesUnavailable";
                }
                case 6: {
                    return "onPackagesSuspended";
                }
                case 7: {
                    return "onPackagesUnsuspended";
                }
                case 8: {
                    return "onShortcutChanged";
                }
                case 9: {
                    return "onPackageLoadingProgressChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.onPackageRemoved(_arg0, _arg1);
                    break;
                }
                case 2: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.onPackageAdded(_arg0, _arg1);
                    break;
                }
                case 3: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.onPackageChanged(_arg0, _arg1);
                    break;
                }
                case 4: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    String[] _arg1 = data.createStringArray();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onPackagesAvailable(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    String[] _arg1 = data.createStringArray();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onPackagesUnavailable(_arg0, _arg1, _arg2);
                    break;
                }
                case 6: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    String[] _arg1 = data.createStringArray();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onPackagesSuspended(_arg0, _arg1, _arg2);
                    break;
                }
                case 7: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    String[] _arg1 = data.createStringArray();
                    data.enforceNoDataAvail();
                    this.onPackagesUnsuspended(_arg0, _arg1);
                    break;
                }
                case 8: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    String _arg1 = data.readString();
                    ParceledListSlice _arg2 = data.readTypedObject(ParceledListSlice.CREATOR);
                    data.enforceNoDataAvail();
                    this.onShortcutChanged(_arg0, _arg1, _arg2);
                    break;
                }
                case 9: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    String _arg1 = data.readString();
                    float _arg2 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.onPackageLoadingProgressChanged(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 8;
        }

        private static class Proxy
        implements IOnAppsChangedListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackageRemoved(UserHandle user, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(user, 0);
                    _data.writeString(packageName);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackageAdded(UserHandle user, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(user, 0);
                    _data.writeString(packageName);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackageChanged(UserHandle user, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(user, 0);
                    _data.writeString(packageName);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackagesAvailable(UserHandle user, String[] packageNames, boolean replacing) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(user, 0);
                    _data.writeStringArray(packageNames);
                    _data.writeBoolean(replacing);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackagesUnavailable(UserHandle user, String[] packageNames, boolean replacing) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(user, 0);
                    _data.writeStringArray(packageNames);
                    _data.writeBoolean(replacing);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackagesSuspended(UserHandle user, String[] packageNames, Bundle launcherExtras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(user, 0);
                    _data.writeStringArray(packageNames);
                    _data.writeTypedObject(launcherExtras, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackagesUnsuspended(UserHandle user, String[] packageNames) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(user, 0);
                    _data.writeStringArray(packageNames);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onShortcutChanged(UserHandle user, String packageName, ParceledListSlice shortcuts) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(user, 0);
                    _data.writeString(packageName);
                    _data.writeTypedObject(shortcuts, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackageLoadingProgressChanged(UserHandle user, String packageName, float progress) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(user, 0);
                    _data.writeString(packageName);
                    _data.writeFloat(progress);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IOnAppsChangedListener {
        @Override
        public void onPackageRemoved(UserHandle user, String packageName) throws RemoteException {
        }

        @Override
        public void onPackageAdded(UserHandle user, String packageName) throws RemoteException {
        }

        @Override
        public void onPackageChanged(UserHandle user, String packageName) throws RemoteException {
        }

        @Override
        public void onPackagesAvailable(UserHandle user, String[] packageNames, boolean replacing) throws RemoteException {
        }

        @Override
        public void onPackagesUnavailable(UserHandle user, String[] packageNames, boolean replacing) throws RemoteException {
        }

        @Override
        public void onPackagesSuspended(UserHandle user, String[] packageNames, Bundle launcherExtras) throws RemoteException {
        }

        @Override
        public void onPackagesUnsuspended(UserHandle user, String[] packageNames) throws RemoteException {
        }

        @Override
        public void onShortcutChanged(UserHandle user, String packageName, ParceledListSlice shortcuts) throws RemoteException {
        }

        @Override
        public void onPackageLoadingProgressChanged(UserHandle user, String packageName, float progress) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

