/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ParceledListSlice;
import android.content.pm.ShortcutInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.text.TextUtils;
import com.android.internal.infra.AndroidFuture;
import java.util.ArrayList;
import java.util.List;

public interface IShortcutService
extends IInterface {
    public boolean setDynamicShortcuts(String var1, ParceledListSlice var2, int var3) throws RemoteException;

    public boolean addDynamicShortcuts(String var1, ParceledListSlice var2, int var3) throws RemoteException;

    public void removeDynamicShortcuts(String var1, List<String> var2, int var3) throws RemoteException;

    public void removeAllDynamicShortcuts(String var1, int var2) throws RemoteException;

    public boolean updateShortcuts(String var1, ParceledListSlice var2, int var3) throws RemoteException;

    public void requestPinShortcut(String var1, ShortcutInfo var2, IntentSender var3, int var4, AndroidFuture<String> var5) throws RemoteException;

    public void createShortcutResultIntent(String var1, ShortcutInfo var2, int var3, AndroidFuture<Intent> var4) throws RemoteException;

    public void disableShortcuts(String var1, List<String> var2, CharSequence var3, int var4, int var5) throws RemoteException;

    public void enableShortcuts(String var1, List<String> var2, int var3) throws RemoteException;

    public int getMaxShortcutCountPerActivity(String var1, int var2) throws RemoteException;

    public int getRemainingCallCount(String var1, int var2) throws RemoteException;

    public long getRateLimitResetTime(String var1, int var2) throws RemoteException;

    public int getIconMaxDimensions(String var1, int var2) throws RemoteException;

    public void reportShortcutUsed(String var1, String var2, int var3) throws RemoteException;

    public void resetThrottling() throws RemoteException;

    public void onApplicationActive(String var1, int var2) throws RemoteException;

    public byte[] getBackupPayload(int var1) throws RemoteException;

    public void applyRestore(byte[] var1, int var2) throws RemoteException;

    public boolean isRequestPinItemSupported(int var1, int var2) throws RemoteException;

    public ParceledListSlice getShareTargets(String var1, IntentFilter var2, int var3) throws RemoteException;

    public boolean hasShareTargets(String var1, String var2, int var3) throws RemoteException;

    public void removeLongLivedShortcuts(String var1, List<String> var2, int var3) throws RemoteException;

    public ParceledListSlice getShortcuts(String var1, int var2, int var3) throws RemoteException;

    public void pushDynamicShortcut(String var1, ShortcutInfo var2, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IShortcutService {
        public static final String DESCRIPTOR = "android.content.pm.IShortcutService";
        static final int TRANSACTION_setDynamicShortcuts = 1;
        static final int TRANSACTION_addDynamicShortcuts = 2;
        static final int TRANSACTION_removeDynamicShortcuts = 3;
        static final int TRANSACTION_removeAllDynamicShortcuts = 4;
        static final int TRANSACTION_updateShortcuts = 5;
        static final int TRANSACTION_requestPinShortcut = 6;
        static final int TRANSACTION_createShortcutResultIntent = 7;
        static final int TRANSACTION_disableShortcuts = 8;
        static final int TRANSACTION_enableShortcuts = 9;
        static final int TRANSACTION_getMaxShortcutCountPerActivity = 10;
        static final int TRANSACTION_getRemainingCallCount = 11;
        static final int TRANSACTION_getRateLimitResetTime = 12;
        static final int TRANSACTION_getIconMaxDimensions = 13;
        static final int TRANSACTION_reportShortcutUsed = 14;
        static final int TRANSACTION_resetThrottling = 15;
        static final int TRANSACTION_onApplicationActive = 16;
        static final int TRANSACTION_getBackupPayload = 17;
        static final int TRANSACTION_applyRestore = 18;
        static final int TRANSACTION_isRequestPinItemSupported = 19;
        static final int TRANSACTION_getShareTargets = 20;
        static final int TRANSACTION_hasShareTargets = 21;
        static final int TRANSACTION_removeLongLivedShortcuts = 22;
        static final int TRANSACTION_getShortcuts = 23;
        static final int TRANSACTION_pushDynamicShortcut = 24;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IShortcutService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IShortcutService) {
                return (IShortcutService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setDynamicShortcuts";
                }
                case 2: {
                    return "addDynamicShortcuts";
                }
                case 3: {
                    return "removeDynamicShortcuts";
                }
                case 4: {
                    return "removeAllDynamicShortcuts";
                }
                case 5: {
                    return "updateShortcuts";
                }
                case 6: {
                    return "requestPinShortcut";
                }
                case 7: {
                    return "createShortcutResultIntent";
                }
                case 8: {
                    return "disableShortcuts";
                }
                case 9: {
                    return "enableShortcuts";
                }
                case 10: {
                    return "getMaxShortcutCountPerActivity";
                }
                case 11: {
                    return "getRemainingCallCount";
                }
                case 12: {
                    return "getRateLimitResetTime";
                }
                case 13: {
                    return "getIconMaxDimensions";
                }
                case 14: {
                    return "reportShortcutUsed";
                }
                case 15: {
                    return "resetThrottling";
                }
                case 16: {
                    return "onApplicationActive";
                }
                case 17: {
                    return "getBackupPayload";
                }
                case 18: {
                    return "applyRestore";
                }
                case 19: {
                    return "isRequestPinItemSupported";
                }
                case 20: {
                    return "getShareTargets";
                }
                case 21: {
                    return "hasShareTargets";
                }
                case 22: {
                    return "removeLongLivedShortcuts";
                }
                case 23: {
                    return "getShortcuts";
                }
                case 24: {
                    return "pushDynamicShortcut";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    ParceledListSlice _arg1 = data.readTypedObject(ParceledListSlice.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.setDynamicShortcuts(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    ParceledListSlice _arg1 = data.readTypedObject(ParceledListSlice.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.addDynamicShortcuts(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    ArrayList<String> _arg1 = data.createStringArrayList();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeDynamicShortcuts(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeAllDynamicShortcuts(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    ParceledListSlice _arg1 = data.readTypedObject(ParceledListSlice.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.updateShortcuts(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    ShortcutInfo _arg1 = data.readTypedObject(ShortcutInfo.CREATOR);
                    IntentSender _arg2 = data.readTypedObject(IntentSender.CREATOR);
                    int _arg3 = data.readInt();
                    AndroidFuture _arg4 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestPinShortcut(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    ShortcutInfo _arg1 = data.readTypedObject(ShortcutInfo.CREATOR);
                    int _arg2 = data.readInt();
                    AndroidFuture _arg3 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.createShortcutResultIntent(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    ArrayList<String> _arg1 = data.createStringArrayList();
                    CharSequence _arg2 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.disableShortcuts(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    ArrayList<String> _arg1 = data.createStringArrayList();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.enableShortcuts(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getMaxShortcutCountPerActivity(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getRemainingCallCount(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    long _result = this.getRateLimitResetTime(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 13: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getIconMaxDimensions(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 14: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.reportShortcutUsed(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    this.resetThrottling();
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onApplicationActive(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    byte[] _result = this.getBackupPayload(_arg0);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 18: {
                    byte[] _arg0 = data.createByteArray();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.applyRestore(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isRequestPinItemSupported(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 20: {
                    String _arg0 = data.readString();
                    IntentFilter _arg1 = data.readTypedObject(IntentFilter.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.getShareTargets(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 21: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasShareTargets(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 22: {
                    String _arg0 = data.readString();
                    ArrayList<String> _arg1 = data.createStringArrayList();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeLongLivedShortcuts(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.getShortcuts(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 24: {
                    String _arg0 = data.readString();
                    ShortcutInfo _arg1 = data.readTypedObject(ShortcutInfo.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.pushDynamicShortcut(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 23;
        }

        private static class Proxy
        implements IShortcutService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setDynamicShortcuts(String packageName, ParceledListSlice shortcutInfoList, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(shortcutInfoList, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean addDynamicShortcuts(String packageName, ParceledListSlice shortcutInfoList, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(shortcutInfoList, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeDynamicShortcuts(String packageName, List<String> shortcutIds, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStringList(shortcutIds);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAllDynamicShortcuts(String packageName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean updateShortcuts(String packageName, ParceledListSlice shortcuts, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(shortcuts, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestPinShortcut(String packageName, ShortcutInfo shortcut, IntentSender resultIntent, int userId, AndroidFuture<String> ret) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(shortcut, 0);
                    _data.writeTypedObject(resultIntent, 0);
                    _data.writeInt(userId);
                    _data.writeTypedObject(ret, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createShortcutResultIntent(String packageName, ShortcutInfo shortcut, int userId, AndroidFuture<Intent> ret) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(shortcut, 0);
                    _data.writeInt(userId);
                    _data.writeTypedObject(ret, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableShortcuts(String packageName, List<String> shortcutIds, CharSequence disabledMessage, int disabledMessageResId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStringList(shortcutIds);
                    if (disabledMessage != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(disabledMessage, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(disabledMessageResId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableShortcuts(String packageName, List<String> shortcutIds, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStringList(shortcutIds);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMaxShortcutCountPerActivity(String packageName, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRemainingCallCount(String packageName, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getRateLimitResetTime(String packageName, int userId) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getIconMaxDimensions(String packageName, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportShortcutUsed(String packageName, String shortcutId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(shortcutId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetThrottling() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onApplicationActive(String packageName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getBackupPayload(int user) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(user);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void applyRestore(byte[] payload, int user) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(payload);
                    _data.writeInt(user);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRequestPinItemSupported(int user, int requestType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(user);
                    _data.writeInt(requestType);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getShareTargets(String packageName, IntentFilter filter2, int userId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(filter2, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasShareTargets(String packageName, String packageToCheck, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(packageToCheck);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeLongLivedShortcuts(String packageName, List<String> shortcutIds, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStringList(shortcutIds);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getShortcuts(String packageName, int matchFlags, int userId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(matchFlags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pushDynamicShortcut(String packageName, ShortcutInfo shortcut, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(shortcut, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IShortcutService {
        @Override
        public boolean setDynamicShortcuts(String packageName, ParceledListSlice shortcutInfoList, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean addDynamicShortcuts(String packageName, ParceledListSlice shortcutInfoList, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void removeDynamicShortcuts(String packageName, List<String> shortcutIds, int userId) throws RemoteException {
        }

        @Override
        public void removeAllDynamicShortcuts(String packageName, int userId) throws RemoteException {
        }

        @Override
        public boolean updateShortcuts(String packageName, ParceledListSlice shortcuts, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void requestPinShortcut(String packageName, ShortcutInfo shortcut, IntentSender resultIntent, int userId, AndroidFuture<String> ret) throws RemoteException {
        }

        @Override
        public void createShortcutResultIntent(String packageName, ShortcutInfo shortcut, int userId, AndroidFuture<Intent> ret) throws RemoteException {
        }

        @Override
        public void disableShortcuts(String packageName, List<String> shortcutIds, CharSequence disabledMessage, int disabledMessageResId, int userId) throws RemoteException {
        }

        @Override
        public void enableShortcuts(String packageName, List<String> shortcutIds, int userId) throws RemoteException {
        }

        @Override
        public int getMaxShortcutCountPerActivity(String packageName, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public int getRemainingCallCount(String packageName, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public long getRateLimitResetTime(String packageName, int userId) throws RemoteException {
            return 0L;
        }

        @Override
        public int getIconMaxDimensions(String packageName, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public void reportShortcutUsed(String packageName, String shortcutId, int userId) throws RemoteException {
        }

        @Override
        public void resetThrottling() throws RemoteException {
        }

        @Override
        public void onApplicationActive(String packageName, int userId) throws RemoteException {
        }

        @Override
        public byte[] getBackupPayload(int user) throws RemoteException {
            return null;
        }

        @Override
        public void applyRestore(byte[] payload, int user) throws RemoteException {
        }

        @Override
        public boolean isRequestPinItemSupported(int user, int requestType) throws RemoteException {
            return false;
        }

        @Override
        public ParceledListSlice getShareTargets(String packageName, IntentFilter filter2, int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean hasShareTargets(String packageName, String packageToCheck, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void removeLongLivedShortcuts(String packageName, List<String> shortcutIds, int userId) throws RemoteException {
        }

        @Override
        public ParceledListSlice getShortcuts(String packageName, int matchFlags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void pushDynamicShortcut(String packageName, ShortcutInfo shortcut, int userId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

