/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.overlay;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OverlayPaths {
    private final List<String> mResourceDirs = new ArrayList<String>();
    private final List<String> mOverlayPaths = new ArrayList<String>();

    public boolean isEmpty() {
        return this.mResourceDirs.isEmpty() && this.mOverlayPaths.isEmpty();
    }

    private OverlayPaths() {
    }

    public List<String> getResourceDirs() {
        return this.mResourceDirs;
    }

    public List<String> getOverlayPaths() {
        return this.mOverlayPaths;
    }

    public String toString() {
        return "OverlayPaths { resourceDirs = " + this.mResourceDirs + ", overlayPaths = " + this.mOverlayPaths + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverlayPaths that = (OverlayPaths)o;
        return Objects.equals(this.mResourceDirs, that.mResourceDirs) && Objects.equals(this.mOverlayPaths, that.mOverlayPaths);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mResourceDirs);
        _hash = 31 * _hash + Objects.hashCode(this.mOverlayPaths);
        return _hash;
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder {
        final OverlayPaths mPaths = new OverlayPaths();

        public Builder addNonApkPath(String idmapPath) {
            this.mPaths.mOverlayPaths.add(idmapPath);
            return this;
        }

        public Builder addApkPath(String overlayPath) {
            Builder.addUniquePath(this.mPaths.mResourceDirs, overlayPath);
            Builder.addUniquePath(this.mPaths.mOverlayPaths, overlayPath);
            return this;
        }

        public Builder addAll(OverlayPaths other) {
            if (other != null) {
                for (String path : other.getResourceDirs()) {
                    Builder.addUniquePath(this.mPaths.mResourceDirs, path);
                }
                for (String path : other.getOverlayPaths()) {
                    Builder.addUniquePath(this.mPaths.mOverlayPaths, path);
                }
            }
            return this;
        }

        public OverlayPaths build() {
            return this.mPaths;
        }

        private static void addUniquePath(List<String> paths, String path) {
            if (!paths.contains(path)) {
                paths.add(path);
            }
        }
    }
}

