/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing;

import android.content.pm.SigningDetails;
import android.content.pm.VerifierInfo;
import android.content.pm.parsing.ApkLite;
import android.content.pm.parsing.FrameworkParsingPackageUtils;
import android.content.pm.parsing.PackageLite;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.res.ApkAssets;
import android.content.res.XmlResourceParser;
import android.os.Trace;
import android.os._Original_Build;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AttributeSet;
import android.util.Pair;
import android.util.Slog;
import com.android.internal.util.ArrayUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParserException;

public class ApkLiteParseUtils {
    private static final String TAG = "ApkLiteParseUtils";
    private static final int PARSE_DEFAULT_INSTALL_LOCATION = -1;
    private static final Comparator<String> sSplitNameComparator = new SplitNameComparator();
    public static final String APK_FILE_EXTENSION = ".apk";
    private static final String ANDROID_RES_NAMESPACE = "http://schemas.android.com/apk/res/android";
    private static final int DEFAULT_MIN_SDK_VERSION = 1;
    private static final int DEFAULT_TARGET_SDK_VERSION = 0;
    public static final String ANDROID_MANIFEST_FILENAME = "AndroidManifest.xml";
    private static final int PARSE_IS_SYSTEM_DIR = 16;
    private static final int PARSE_COLLECT_CERTIFICATES = 32;
    private static final int PARSE_FRAMEWORK_RES_SPLITS = 256;
    private static final String TAG_APPLICATION = "application";
    private static final String TAG_PACKAGE_VERIFIER = "package-verifier";
    private static final String TAG_PROFILEABLE = "profileable";
    private static final String TAG_RECEIVER = "receiver";
    private static final String TAG_OVERLAY = "overlay";
    private static final String TAG_USES_SDK = "uses-sdk";
    private static final String TAG_USES_SPLIT = "uses-split";
    private static final String TAG_MANIFEST = "manifest";
    private static final String TAG_SDK_LIBRARY = "sdk-library";
    private static final int SDK_VERSION = _Original_Build.VERSION.SDK_INT;
    private static final String[] SDK_CODENAMES = _Original_Build.VERSION.ACTIVE_CODENAMES;

    public static ParseResult<PackageLite> parsePackageLite(ParseInput input, File packageFile, int flags) {
        if (packageFile.isDirectory()) {
            return ApkLiteParseUtils.parseClusterPackageLite(input, packageFile, null, flags);
        }
        return ApkLiteParseUtils.parseMonolithicPackageLite(input, packageFile, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseResult<PackageLite> parseMonolithicPackageLite(ParseInput input, File packageFile, int flags) {
        Trace.traceBegin(262144L, "parseApkLite");
        try {
            ParseResult<ApkLite> result = ApkLiteParseUtils.parseApkLite(input, packageFile, flags);
            if (result.isError()) {
                ParseResult<PackageLite> parseResult = input.error(result);
                return parseResult;
            }
            ApkLite baseApk = result.getResult();
            String packagePath = packageFile.getAbsolutePath();
            ParseResult<PackageLite> parseResult = input.success(new PackageLite(packagePath, baseApk.getPath(), baseApk, null, null, null, null, null, null, baseApk.getTargetSdkVersion(), null, null));
            return parseResult;
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseResult<PackageLite> parseClusterPackageLite(ParseInput input, File packageDirOrApk, List<File> frameworkSplits, int flags) {
        File[] files;
        boolean parsingFrameworkSplits;
        boolean bl = parsingFrameworkSplits = (flags & 0x100) != 0;
        if (parsingFrameworkSplits) {
            if (ArrayUtils.isEmpty(frameworkSplits)) {
                return input.error(-100, "No packages found in split");
            }
            files = frameworkSplits.toArray(new File[frameworkSplits.size() + 1]);
            files[files.length - 1] = packageDirOrApk;
        } else {
            files = packageDirOrApk.listFiles();
            if (ArrayUtils.isEmpty(files)) {
                return input.error(-100, "No packages found in split");
            }
            if (files.length == 1 && files[0].isDirectory()) {
                return ApkLiteParseUtils.parseClusterPackageLite(input, files[0], frameworkSplits, flags);
            }
        }
        if (parsingFrameworkSplits) {
            flags &= 0xFFFFFFDF;
        }
        String packageName = null;
        int versionCode = 0;
        ApkLite baseApk = null;
        ArrayMap<String, ApkLite> apks = new ArrayMap<String, ApkLite>();
        Trace.traceBegin(262144L, "parseApkLite");
        try {
            for (File file2 : files) {
                if (!ApkLiteParseUtils.isApkFile(file2)) continue;
                ParseResult<ApkLite> result = ApkLiteParseUtils.parseApkLite(input, file2, flags);
                if (result.isError()) {
                    ParseResult<PackageLite> parseResult = input.error(result);
                    return parseResult;
                }
                ApkLite lite = result.getResult();
                if (parsingFrameworkSplits && file2 == files[files.length - 1]) {
                    baseApk = lite;
                    break;
                }
                if (packageName == null) {
                    packageName = lite.getPackageName();
                    versionCode = lite.getVersionCode();
                } else {
                    if (!packageName.equals(lite.getPackageName())) {
                        ParseResult<PackageLite> parseResult = input.error(-101, "Inconsistent package " + lite.getPackageName() + " in " + file2 + "; expected " + packageName);
                        return parseResult;
                    }
                    if (!parsingFrameworkSplits && versionCode != lite.getVersionCode()) {
                        ParseResult<PackageLite> parseResult = input.error(-101, "Inconsistent version " + lite.getVersionCode() + " in " + file2 + "; expected " + versionCode);
                        return parseResult;
                    }
                }
                if (apks.put(lite.getSplitName(), lite) == null) continue;
                ParseResult<PackageLite> parseResult = input.error(-101, "Split name " + lite.getSplitName() + " defined more than once; most recent was " + file2);
                return parseResult;
            }
            if (!parsingFrameworkSplits) {
                baseApk = (ApkLite)apks.remove(null);
            }
        }
        finally {
            Trace.traceEnd(262144L);
        }
        return ApkLiteParseUtils.composePackageLiteFromApks(input, packageDirOrApk, baseApk, apks);
    }

    public static ParseResult<PackageLite> composePackageLiteFromApks(ParseInput input, File packageDir, ApkLite baseApk, ArrayMap<String, ApkLite> splitApks) {
        return ApkLiteParseUtils.composePackageLiteFromApks(input, packageDir, baseApk, splitApks, false);
    }

    public static ParseResult<PackageLite> composePackageLiteFromApks(ParseInput input, File packageDir, ApkLite baseApk, ArrayMap<String, ApkLite> splitApks, boolean apkRenamed) {
        if (baseApk == null) {
            return input.error(-101, "Missing base APK in " + packageDir);
        }
        int size = ArrayUtils.size(splitApks);
        String[] splitNames = null;
        Set[] requiredSplitTypes = null;
        Set[] splitTypes = null;
        boolean[] isFeatureSplits = null;
        String[] usesSplitNames = null;
        String[] configForSplits = null;
        String[] splitCodePaths = null;
        int[] splitRevisionCodes = null;
        if (size > 0) {
            splitNames = new String[size];
            requiredSplitTypes = new Set[size];
            splitTypes = new Set[size];
            isFeatureSplits = new boolean[size];
            usesSplitNames = new String[size];
            configForSplits = new String[size];
            splitCodePaths = new String[size];
            splitRevisionCodes = new int[size];
            splitNames = splitApks.keySet().toArray(splitNames);
            Arrays.sort(splitNames, sSplitNameComparator);
            for (int i = 0; i < size; ++i) {
                ApkLite apk = splitApks.get(splitNames[i]);
                requiredSplitTypes[i] = apk.getRequiredSplitTypes();
                splitTypes[i] = apk.getSplitTypes();
                usesSplitNames[i] = apk.getUsesSplitName();
                isFeatureSplits[i] = apk.isFeatureSplit();
                configForSplits[i] = apk.getConfigForSplit();
                splitCodePaths[i] = apkRenamed ? new File(packageDir, ApkLiteParseUtils.splitNameToFileName(apk)).getAbsolutePath() : apk.getPath();
                splitRevisionCodes[i] = apk.getRevisionCode();
            }
        }
        String codePath = packageDir.getAbsolutePath();
        String baseCodePath = apkRenamed ? new File(packageDir, ApkLiteParseUtils.splitNameToFileName(baseApk)).getAbsolutePath() : baseApk.getPath();
        return input.success(new PackageLite(codePath, baseCodePath, baseApk, splitNames, isFeatureSplits, usesSplitNames, configForSplits, splitCodePaths, splitRevisionCodes, baseApk.getTargetSdkVersion(), requiredSplitTypes, splitTypes));
    }

    public static String splitNameToFileName(ApkLite apk) {
        Objects.requireNonNull(apk);
        String fileName = apk.getSplitName() == null ? "base" : "split_" + apk.getSplitName();
        return fileName + APK_FILE_EXTENSION;
    }

    public static ParseResult<ApkLite> parseApkLite(ParseInput input, File apkFile, int flags) {
        return ApkLiteParseUtils.parseApkLiteInner(input, apkFile, null, null, flags);
    }

    public static ParseResult<ApkLite> parseApkLite(ParseInput input, FileDescriptor fd, String debugPathName, int flags) {
        return ApkLiteParseUtils.parseApkLiteInner(input, null, fd, debugPathName, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static ParseResult<ApkLite> parseApkLiteInner(ParseInput input, File apkFile, FileDescriptor fd, String debugPathName, int flags) {
        block27: {
            apkPath = fd != null ? debugPathName : apkFile.getAbsolutePath();
            parser = null;
            apkAssets = null;
            try {
                apkAssets = fd != null ? ApkAssets.loadFromFd(fd, debugPathName, 0, null) : ApkAssets.loadFromPath(apkPath);
            }
            catch (IOException e) {
                var9_11 = input.error(-100, "Failed to parse " + apkPath, e);
                IoUtils.closeQuietly(parser);
                if (apkAssets != null) {
                    try {
                        apkAssets.close();
                    }
                    catch (Throwable var10_15) {
                        // empty catch block
                    }
                }
                return var9_11;
            }
            parser = apkAssets.openXml("AndroidManifest.xml");
            if ((flags & 32) == 0) ** GOTO lbl46
            skipVerify = (flags & 16) != 0;
            Trace.traceBegin(262144L, "collectCertificates");
            result = FrameworkParsingPackageUtils.getSigningDetails(input, apkFile.getAbsolutePath(), skipVerify, false, SigningDetails.UNKNOWN, 0);
            if (!result.isError()) break block27;
            var11_19 = input.error(result);
            Trace.traceEnd(262144L);
            IoUtils.closeQuietly(parser);
            if (apkAssets != null) {
                try {
                    apkAssets.close();
                }
                catch (Throwable var12_20) {
                    // empty catch block
                }
            }
            return var11_19;
        }
        try {
            signingDetails = result.getResult();
            {
                catch (Throwable var13_21) {
                    throw var13_21;
                }
            }
            finally {
                Trace.traceEnd(262144L);
            }
lbl46:
            // 1 sources

            signingDetails = SigningDetails.UNKNOWN;
            var9_13 = ApkLiteParseUtils.parseApkLite(input, apkPath, parser, signingDetails, flags);
        }
        catch (IOException | RuntimeException | XmlPullParserException e) {
            try {
                Slog.w("ApkLiteParseUtils", "Failed to parse " + apkPath, e);
                var9_14 = input.error(-102, "Failed to parse " + apkPath, (Exception)e);
            }
            catch (Throwable var14_22) {
                IoUtils.closeQuietly(parser);
                if (apkAssets != null) {
                    try {
                        apkAssets.close();
                    }
                    catch (Throwable var15_23) {
                        // empty catch block
                    }
                }
                throw var14_22;
            }
            IoUtils.closeQuietly(parser);
            if (apkAssets != null) {
                try {
                    apkAssets.close();
                }
                catch (Throwable var10_18) {
                    // empty catch block
                }
            }
            return var9_14;
        }
        IoUtils.closeQuietly(parser);
        if (apkAssets != null) {
            try {
                apkAssets.close();
            }
            catch (Throwable var10_17) {
                // empty catch block
            }
        }
        return var9_13;
    }

    private static ParseResult<ApkLite> parseApkLite(ParseInput input, String codePath, XmlResourceParser parser, SigningDetails signingDetails, int flags) throws IOException, XmlPullParserException {
        int type;
        ParseResult<Pair<String, String>> result = ApkLiteParseUtils.parsePackageSplitNames(input, parser);
        if (result.isError()) {
            return input.error(result);
        }
        Pair<String, String> packageSplit = result.getResult();
        ParseResult<Pair<Set<String>, Set<String>>> requiredSplitTypesResult = ApkLiteParseUtils.parseRequiredSplitTypes(input, parser);
        if (requiredSplitTypesResult.isError()) {
            return input.error(result);
        }
        Pair<Set<String>, Set<String>> requiredSplitTypes = requiredSplitTypesResult.getResult();
        int installLocation = parser.getAttributeIntValue(ANDROID_RES_NAMESPACE, "installLocation", -1);
        int versionCode = parser.getAttributeIntValue(ANDROID_RES_NAMESPACE, "versionCode", 0);
        int versionCodeMajor = parser.getAttributeIntValue(ANDROID_RES_NAMESPACE, "versionCodeMajor", 0);
        int revisionCode = parser.getAttributeIntValue(ANDROID_RES_NAMESPACE, "revisionCode", 0);
        boolean coreApp = parser.getAttributeBooleanValue(null, "coreApp", false);
        boolean isolatedSplits = parser.getAttributeBooleanValue(ANDROID_RES_NAMESPACE, "isolatedSplits", false);
        boolean isFeatureSplit = parser.getAttributeBooleanValue(ANDROID_RES_NAMESPACE, "isFeatureSplit", false);
        boolean isSplitRequired = parser.getAttributeBooleanValue(ANDROID_RES_NAMESPACE, "isSplitRequired", false);
        String configForSplit = parser.getAttributeValue(null, "configForSplit");
        int targetSdkVersion = 0;
        int minSdkVersion = 1;
        boolean debuggable = false;
        boolean profilableByShell = false;
        boolean multiArch = false;
        boolean use32bitAbi = false;
        boolean extractNativeLibs = true;
        boolean useEmbeddedDex = false;
        String usesSplitName = null;
        String targetPackage = null;
        boolean overlayIsStatic = false;
        int overlayPriority = 0;
        int rollbackDataPolicy = 0;
        String requiredSystemPropertyName = null;
        String requiredSystemPropertyValue = null;
        boolean hasDeviceAdminReceiver = false;
        boolean isSdkLibrary = false;
        int searchDepth = parser.getDepth() + 1;
        ArrayList<VerifierInfo> verifiers = new ArrayList<VerifierInfo>();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() >= searchDepth)) {
            ParseResult<Integer> targetResult;
            if (type == 3 || type == 4 || parser.getDepth() != searchDepth) continue;
            if (TAG_PACKAGE_VERIFIER.equals(parser.getName())) {
                VerifierInfo verifier = ApkLiteParseUtils.parseVerifier(parser);
                if (verifier == null) continue;
                verifiers.add(verifier);
                continue;
            }
            if (TAG_APPLICATION.equals(parser.getName())) {
                int innerType;
                debuggable = parser.getAttributeBooleanValue(ANDROID_RES_NAMESPACE, "debuggable", false);
                multiArch = parser.getAttributeBooleanValue(ANDROID_RES_NAMESPACE, "multiArch", false);
                use32bitAbi = parser.getAttributeBooleanValue(ANDROID_RES_NAMESPACE, "use32bitAbi", false);
                extractNativeLibs = parser.getAttributeBooleanValue(ANDROID_RES_NAMESPACE, "extractNativeLibs", true);
                useEmbeddedDex = parser.getAttributeBooleanValue(ANDROID_RES_NAMESPACE, "useEmbeddedDex", false);
                rollbackDataPolicy = parser.getAttributeIntValue(ANDROID_RES_NAMESPACE, "rollbackDataPolicy", 0);
                String permission2 = parser.getAttributeValue(ANDROID_RES_NAMESPACE, "permission");
                boolean hasBindDeviceAdminPermission = "android.permission.BIND_DEVICE_ADMIN".equals(permission2);
                int innerDepth = parser.getDepth();
                while ((innerType = parser.next()) != 1 && (innerType != 3 || parser.getDepth() > innerDepth)) {
                    if (innerType == 3 || innerType == 4 || parser.getDepth() != innerDepth + 1) continue;
                    if (TAG_PROFILEABLE.equals(parser.getName())) {
                        profilableByShell = parser.getAttributeBooleanValue(ANDROID_RES_NAMESPACE, "shell", profilableByShell);
                        continue;
                    }
                    if (TAG_RECEIVER.equals(parser.getName())) {
                        hasDeviceAdminReceiver |= ApkLiteParseUtils.isDeviceAdminReceiver(parser, hasBindDeviceAdminPermission);
                        continue;
                    }
                    if (!TAG_SDK_LIBRARY.equals(parser.getName())) continue;
                    isSdkLibrary = true;
                }
                continue;
            }
            if (TAG_OVERLAY.equals(parser.getName())) {
                requiredSystemPropertyName = parser.getAttributeValue(ANDROID_RES_NAMESPACE, "requiredSystemPropertyName");
                requiredSystemPropertyValue = parser.getAttributeValue(ANDROID_RES_NAMESPACE, "requiredSystemPropertyValue");
                targetPackage = parser.getAttributeValue(ANDROID_RES_NAMESPACE, "targetPackage");
                overlayIsStatic = parser.getAttributeBooleanValue(ANDROID_RES_NAMESPACE, "isStatic", false);
                overlayPriority = parser.getAttributeIntValue(ANDROID_RES_NAMESPACE, "priority", 0);
                continue;
            }
            if (TAG_USES_SPLIT.equals(parser.getName())) {
                if (usesSplitName != null) {
                    Slog.w(TAG, "Only one <uses-split> permitted. Ignoring others.");
                    continue;
                }
                usesSplitName = parser.getAttributeValue(ANDROID_RES_NAMESPACE, "name");
                if (usesSplitName != null) continue;
                return input.error(-108, "<uses-split> tag requires 'android:name' attribute");
            }
            if (!TAG_USES_SDK.equals(parser.getName())) continue;
            String minSdkVersionString = parser.getAttributeValue(ANDROID_RES_NAMESPACE, "minSdkVersion");
            String targetSdkVersionString = parser.getAttributeValue(ANDROID_RES_NAMESPACE, "targetSdkVersion");
            int minVer = 1;
            String minCode = null;
            boolean minAssigned = false;
            int targetVer = 0;
            String targetCode = null;
            if (!TextUtils.isEmpty(minSdkVersionString)) {
                try {
                    minVer = Integer.parseInt(minSdkVersionString);
                    minAssigned = true;
                }
                catch (NumberFormatException ignored) {
                    minCode = minSdkVersionString;
                    boolean bl = minAssigned = !TextUtils.isEmpty(minCode);
                }
            }
            if (!TextUtils.isEmpty(targetSdkVersionString)) {
                try {
                    targetVer = Integer.parseInt(targetSdkVersionString);
                }
                catch (NumberFormatException ignored) {
                    targetCode = targetSdkVersionString;
                    if (!minAssigned) {
                        minCode = targetCode;
                    }
                }
            } else {
                targetVer = minVer;
                targetCode = minCode;
            }
            boolean allowUnknownCodenames = false;
            if ((flags & 0x200) != 0) {
                allowUnknownCodenames = true;
            }
            if ((targetResult = FrameworkParsingPackageUtils.computeTargetSdkVersion(targetVer, targetCode, SDK_CODENAMES, input, allowUnknownCodenames)).isError()) {
                return input.error(targetResult);
            }
            targetSdkVersion = targetResult.getResult();
            ParseResult<Integer> minResult = FrameworkParsingPackageUtils.computeMinSdkVersion(minVer, minCode, SDK_VERSION, SDK_CODENAMES, input);
            if (minResult.isError()) {
                return input.error(minResult);
            }
            minSdkVersion = minResult.getResult();
        }
        if ((flags & 0x80) == 0 && !FrameworkParsingPackageUtils.checkRequiredSystemProperties(requiredSystemPropertyName, requiredSystemPropertyValue)) {
            String message = "Skipping target and overlay pair " + targetPackage + " and " + codePath + ": overlay ignored due to required system property: " + requiredSystemPropertyName + " with value: " + requiredSystemPropertyValue;
            Slog.i(TAG, message);
            return input.skip(message);
        }
        return input.success(new ApkLite(codePath, (String)packageSplit.first, (String)packageSplit.second, isFeatureSplit, configForSplit, usesSplitName, isSplitRequired, versionCode, versionCodeMajor, revisionCode, installLocation, verifiers, signingDetails, coreApp, debuggable, profilableByShell, multiArch, use32bitAbi, useEmbeddedDex, extractNativeLibs, isolatedSplits, targetPackage, overlayIsStatic, overlayPriority, requiredSystemPropertyName, requiredSystemPropertyValue, minSdkVersion, targetSdkVersion, rollbackDataPolicy, (Set)requiredSplitTypes.first, (Set)requiredSplitTypes.second, hasDeviceAdminReceiver, isSdkLibrary));
    }

    private static boolean isDeviceAdminReceiver(XmlResourceParser parser, boolean applicationHasBindDeviceAdminPermission) throws XmlPullParserException, IOException {
        int type;
        String permission2 = parser.getAttributeValue(ANDROID_RES_NAMESPACE, "permission");
        if (!applicationHasBindDeviceAdminPermission && !"android.permission.BIND_DEVICE_ADMIN".equals(permission2)) {
            return false;
        }
        boolean hasDeviceAdminReceiver = false;
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            String name;
            if (type == 3 || type == 4 || parser.getDepth() != depth + 1 || hasDeviceAdminReceiver || !"meta-data".equals(parser.getName()) || !"android.app.device_admin".equals(name = parser.getAttributeValue(ANDROID_RES_NAMESPACE, "name"))) continue;
            hasDeviceAdminReceiver = true;
        }
        return hasDeviceAdminReceiver;
    }

    public static ParseResult<Pair<String, String>> parsePackageSplitNames(ParseInput input, XmlResourceParser parser) throws IOException, XmlPullParserException {
        ParseResult nameResult;
        int type;
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            return input.error(-108, "No start tag found");
        }
        if (!parser.getName().equals(TAG_MANIFEST)) {
            return input.error(-108, "No <manifest> tag");
        }
        String packageName = parser.getAttributeValue(null, "package");
        if (!"android".equals(packageName) && (nameResult = FrameworkParsingPackageUtils.validateName(input, packageName, true, true)).isError()) {
            return input.error(-106, "Invalid manifest package: " + nameResult.getErrorMessage());
        }
        String splitName = parser.getAttributeValue(null, "split");
        if (splitName != null) {
            if (splitName.length() == 0) {
                splitName = null;
            } else {
                ParseResult nameResult2 = FrameworkParsingPackageUtils.validateName(input, splitName, false, false);
                if (nameResult2.isError()) {
                    return input.error(-106, "Invalid manifest split: " + nameResult2.getErrorMessage());
                }
            }
        }
        return input.success(Pair.create(packageName.intern(), splitName != null ? splitName.intern() : splitName));
    }

    public static ParseResult<Pair<Set<String>, Set<String>>> parseRequiredSplitTypes(ParseInput input, XmlResourceParser parser) {
        ParseResult<Set<String>> result;
        Set<String> requiredSplitTypes = null;
        Set<String> splitTypes = null;
        String value2 = parser.getAttributeValue(ANDROID_RES_NAMESPACE, "requiredSplitTypes");
        if (!TextUtils.isEmpty(value2)) {
            result = ApkLiteParseUtils.separateAndValidateSplitTypes(input, value2);
            if (result.isError()) {
                return input.error(result);
            }
            requiredSplitTypes = result.getResult();
        }
        if (!TextUtils.isEmpty(value2 = parser.getAttributeValue(ANDROID_RES_NAMESPACE, "splitTypes"))) {
            result = ApkLiteParseUtils.separateAndValidateSplitTypes(input, value2);
            if (result.isError()) {
                return input.error(result);
            }
            splitTypes = result.getResult();
        }
        return input.success(Pair.create(requiredSplitTypes, splitTypes));
    }

    private static ParseResult<Set<String>> separateAndValidateSplitTypes(ParseInput input, String values2) {
        ArraySet<String> ret = new ArraySet<String>();
        for (String value2 : values2.trim().split(",")) {
            String type = value2.trim();
            ParseResult nameResult = FrameworkParsingPackageUtils.validateName(input, type, false, true);
            if (nameResult.isError()) {
                return input.error(-108, "Invalid manifest split types: " + nameResult.getErrorMessage());
            }
            if (ret.add(type)) continue;
            Slog.w(TAG, type + " was defined multiple times");
        }
        return input.success(ret);
    }

    public static VerifierInfo parseVerifier(AttributeSet attrs) {
        String packageName = attrs.getAttributeValue(ANDROID_RES_NAMESPACE, "name");
        String encodedPublicKey = attrs.getAttributeValue(ANDROID_RES_NAMESPACE, "publicKey");
        if (packageName == null || packageName.length() == 0) {
            Slog.i(TAG, "verifier package name was null; skipping");
            return null;
        }
        PublicKey publicKey = FrameworkParsingPackageUtils.parsePublicKey(encodedPublicKey);
        if (publicKey == null) {
            Slog.i(TAG, "Unable to parse verifier public key for " + packageName);
            return null;
        }
        return new VerifierInfo(packageName, publicKey);
    }

    public static boolean isApkFile(File file2) {
        return ApkLiteParseUtils.isApkPath(file2.getName());
    }

    public static boolean isApkPath(String path) {
        return path.endsWith(APK_FILE_EXTENSION);
    }

    private static class SplitNameComparator
    implements Comparator<String> {
        private SplitNameComparator() {
        }

        @Override
        public int compare(String lhs, String rhs) {
            if (lhs == null) {
                return -1;
            }
            if (rhs == null) {
                return 1;
            }
            return lhs.compareTo(rhs);
        }
    }
}

