/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.ComplexColor;
import android.content.res.ConstantState;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.MathUtils;
import android.util.SparseArray;
import android.util.StateSet;
import android.util.Xml;
import com.android.internal.R;
import com.android.internal.graphics.ColorUtils;
import com.android.internal.graphics.cam.Cam;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import com.android.tools.layoutlib.java.Reference_Delegate;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ColorStateList
extends ComplexColor
implements Parcelable {
    private static final String TAG = "ColorStateList";
    private static final int DEFAULT_COLOR = -65536;
    private static final int[][] EMPTY = new int[][]{new int[0]};
    private static final SparseArray<WeakReference<ColorStateList>> sCache = new SparseArray();
    @UnsupportedAppUsage
    private ColorStateListFactory mFactory;
    private int[][] mThemeAttrs;
    private int mChangingConfigurations;
    @UnsupportedAppUsage
    private int[][] mStateSpecs;
    @UnsupportedAppUsage
    private int[] mColors;
    @UnsupportedAppUsage
    private int mDefaultColor;
    private boolean mIsOpaque;
    public static final Parcelable.Creator<ColorStateList> CREATOR = new Parcelable.Creator<ColorStateList>(){

        public ColorStateList[] newArray(int size) {
            return new ColorStateList[size];
        }

        @Override
        public ColorStateList createFromParcel(Parcel source) {
            int N = source.readInt();
            int[][] stateSpecs = new int[N][];
            for (int i = 0; i < N; ++i) {
                stateSpecs[i] = source.createIntArray();
            }
            int[] colors = source.createIntArray();
            return new ColorStateList(stateSpecs, colors);
        }
    };

    @UnsupportedAppUsage
    private ColorStateList() {
    }

    public ColorStateList(int[][] states, int[] colors) {
        this.mStateSpecs = states;
        this.mColors = colors;
        this.onColorsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorStateList valueOf(int color2) {
        SparseArray<WeakReference<ColorStateList>> sparseArray = sCache;
        synchronized (sparseArray) {
            int index = sCache.indexOfKey(color2);
            if (index >= 0) {
                ColorStateList cached = (ColorStateList)sCache.valueAt(index).get();
                if (cached != null) {
                    return cached;
                }
                sCache.removeAt(index);
            }
            int N = sCache.size();
            for (int i = N - 1; i >= 0; --i) {
                if (!Reference_Delegate.refersTo(sCache.valueAt(i), null)) continue;
                sCache.removeAt(i);
            }
            ColorStateList csl = new ColorStateList(EMPTY, new int[]{color2});
            sCache.put(color2, new WeakReference<ColorStateList>(csl));
            return csl;
        }
    }

    private ColorStateList(ColorStateList orig) {
        if (orig != null) {
            this.mChangingConfigurations = orig.mChangingConfigurations;
            this.mStateSpecs = orig.mStateSpecs;
            this.mDefaultColor = orig.mDefaultColor;
            this.mIsOpaque = orig.mIsOpaque;
            this.mThemeAttrs = (int[][])orig.mThemeAttrs.clone();
            this.mColors = (int[])orig.mColors.clone();
        }
    }

    @Deprecated
    public static ColorStateList createFromXml(Resources r, XmlPullParser parser) throws XmlPullParserException, IOException {
        return ColorStateList.createFromXml(r, parser, null);
    }

    public static ColorStateList createFromXml(Resources r, XmlPullParser parser, Resources.Theme theme) throws XmlPullParserException, IOException {
        int type;
        AttributeSet attrs = Xml.asAttributeSet(parser);
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        return ColorStateList.createFromXmlInner(r, parser, attrs, theme);
    }

    static ColorStateList createFromXmlInner(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        String name = parser.getName();
        if (!name.equals("selector")) {
            throw new XmlPullParserException(parser.getPositionDescription() + ": invalid color state list tag " + name);
        }
        ColorStateList colorStateList = new ColorStateList();
        colorStateList.inflate(r, parser, attrs, theme);
        return colorStateList;
    }

    public ColorStateList withAlpha(int alpha) {
        int[] colors = new int[this.mColors.length];
        int len = colors.length;
        for (int i = 0; i < len; ++i) {
            colors[i] = this.mColors[i] & 0xFFFFFF | alpha << 24;
        }
        return new ColorStateList(this.mStateSpecs, colors);
    }

    public ColorStateList withLStar(float lStar) {
        int[] colors = new int[this.mColors.length];
        int len = colors.length;
        for (int i = 0; i < len; ++i) {
            colors[i] = this.modulateColor(this.mColors[i], 1.0f, lStar);
        }
        return new ColorStateList(this.mStateSpecs, colors);
    }

    private void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        int innerDepth = parser.getDepth() + 1;
        int changingConfigurations = 0;
        int defaultColor = -65536;
        boolean hasUnresolvedAttrs = false;
        int[][] stateSpecList = ArrayUtils.newUnpaddedArray(int[].class, 20);
        Object themeAttrsList = new int[stateSpecList.length][];
        int[] colorList = new int[stateSpecList.length];
        int listSize = 0;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            TypedArray a = Resources.obtainAttributes(r, theme, attrs, R.styleable.ColorStateListItem);
            int[] themeAttrs = a.extractThemeAttrs();
            int baseColor = a.getColor(0, -65281);
            float alphaMod = a.getFloat(1, 1.0f);
            float lStar = a.getFloat(2, -1.0f);
            changingConfigurations |= a.getChangingConfigurations();
            a.recycle();
            int j = 0;
            int numAttrs = attrs.getAttributeCount();
            int[] stateSpec = new int[numAttrs];
            block4: for (int i = 0; i < numAttrs; ++i) {
                int stateResId = attrs.getAttributeNameResource(i);
                if (stateResId == 16844359) continue;
                switch (stateResId) {
                    case 16843173: 
                    case 16843551: {
                        continue block4;
                    }
                    default: {
                        stateSpec[j++] = attrs.getAttributeBooleanValue(i, false) ? stateResId : -stateResId;
                    }
                }
            }
            stateSpec = StateSet.trimStateSet(stateSpec, j);
            int color2 = this.modulateColor(baseColor, alphaMod, lStar);
            if (listSize == 0 || stateSpec.length == 0) {
                defaultColor = color2;
            }
            if (themeAttrs != null) {
                hasUnresolvedAttrs = true;
            }
            colorList = GrowingArrayUtils.append(colorList, listSize, color2);
            themeAttrsList = GrowingArrayUtils.append(themeAttrsList, listSize, themeAttrs);
            stateSpecList = GrowingArrayUtils.append(stateSpecList, listSize, stateSpec);
            ++listSize;
        }
        this.mChangingConfigurations = changingConfigurations;
        this.mDefaultColor = defaultColor;
        if (hasUnresolvedAttrs) {
            this.mThemeAttrs = new int[listSize][];
            System.arraycopy(themeAttrsList, 0, this.mThemeAttrs, 0, listSize);
        } else {
            this.mThemeAttrs = null;
        }
        this.mColors = new int[listSize];
        this.mStateSpecs = new int[listSize][];
        System.arraycopy(colorList, 0, this.mColors, 0, listSize);
        System.arraycopy(stateSpecList, 0, this.mStateSpecs, 0, listSize);
        this.onColorsChanged();
    }

    @Override
    @UnsupportedAppUsage
    public boolean canApplyTheme() {
        return this.mThemeAttrs != null;
    }

    private void applyTheme(Resources.Theme t) {
        if (this.mThemeAttrs == null) {
            return;
        }
        boolean hasUnresolvedAttrs = false;
        int[][] themeAttrsList = this.mThemeAttrs;
        int N = themeAttrsList.length;
        for (int i = 0; i < N; ++i) {
            if (themeAttrsList[i] == null) continue;
            TypedArray a = t.resolveAttributes(themeAttrsList[i], R.styleable.ColorStateListItem);
            float defaultAlphaMod = themeAttrsList[i][0] != 0 ? (float)Color.alpha(this.mColors[i]) / 255.0f : 1.0f;
            themeAttrsList[i] = a.extractThemeAttrs(themeAttrsList[i]);
            if (themeAttrsList[i] != null) {
                hasUnresolvedAttrs = true;
            }
            int baseColor = a.getColor(0, this.mColors[i]);
            float alphaMod = a.getFloat(1, defaultAlphaMod);
            float lStar = a.getFloat(2, -1.0f);
            this.mColors[i] = this.modulateColor(baseColor, alphaMod, lStar);
            this.mChangingConfigurations |= a.getChangingConfigurations();
            a.recycle();
        }
        if (!hasUnresolvedAttrs) {
            this.mThemeAttrs = null;
        }
        this.onColorsChanged();
    }

    @Override
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public ColorStateList obtainForTheme(Resources.Theme t) {
        if (t == null || !this.canApplyTheme()) {
            return this;
        }
        ColorStateList clone = new ColorStateList(this);
        clone.applyTheme(t);
        return clone;
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mChangingConfigurations;
    }

    private int modulateColor(int baseColor, float alphaMod, float lStar) {
        boolean validLStar;
        boolean bl = validLStar = lStar >= 0.0f && lStar <= 100.0f;
        if (alphaMod == 1.0f && !validLStar) {
            return baseColor;
        }
        int baseAlpha = Color.alpha(baseColor);
        int alpha = MathUtils.constrain((int)((float)baseAlpha * alphaMod + 0.5f), 0, 255);
        if (validLStar) {
            Cam baseCam = ColorUtils.colorToCAM(baseColor);
            baseColor = ColorUtils.CAMToColor(baseCam.getHue(), baseCam.getChroma(), lStar);
        }
        return baseColor & 0xFFFFFF | alpha << 24;
    }

    @Override
    public boolean isStateful() {
        return this.mStateSpecs.length >= 1 && this.mStateSpecs[0].length > 0;
    }

    public boolean hasFocusStateSpecified() {
        return StateSet.containsAttribute(this.mStateSpecs, 16842908);
    }

    public boolean isOpaque() {
        return this.mIsOpaque;
    }

    public int getColorForState(int[] stateSet, int defaultColor) {
        int setLength = this.mStateSpecs.length;
        for (int i = 0; i < setLength; ++i) {
            int[] stateSpec = this.mStateSpecs[i];
            if (!StateSet.stateSetMatches(stateSpec, stateSet)) continue;
            return this.mColors[i];
        }
        return defaultColor;
    }

    @Override
    public int getDefaultColor() {
        return this.mDefaultColor;
    }

    @UnsupportedAppUsage
    public int[][] getStates() {
        return this.mStateSpecs;
    }

    @UnsupportedAppUsage
    public int[] getColors() {
        return this.mColors;
    }

    public boolean hasState(int state) {
        for (int[] states : this.mStateSpecs) {
            int stateCount = states.length;
            for (int stateIndex = 0; stateIndex < stateCount; ++stateIndex) {
                if (states[stateIndex] != state && states[stateIndex] != ~state) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "ColorStateList{mThemeAttrs=" + Arrays.deepToString((Object[])this.mThemeAttrs) + "mChangingConfigurations=" + this.mChangingConfigurations + "mStateSpecs=" + Arrays.deepToString((Object[])this.mStateSpecs) + "mColors=" + Arrays.toString(this.mColors) + "mDefaultColor=" + this.mDefaultColor + '}';
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private void onColorsChanged() {
        int defaultColor = -65536;
        boolean isOpaque = true;
        int[][] states = this.mStateSpecs;
        int[] colors = this.mColors;
        int N = states.length;
        if (N > 0) {
            int i;
            defaultColor = colors[0];
            for (i = N - 1; i > 0; --i) {
                if (states[i].length != 0) continue;
                defaultColor = colors[i];
                break;
            }
            for (i = 0; i < N; ++i) {
                if (Color.alpha(colors[i]) == 255) continue;
                isOpaque = false;
                break;
            }
        }
        this.mDefaultColor = defaultColor;
        this.mIsOpaque = isOpaque;
    }

    @Override
    public ConstantState<ComplexColor> getConstantState() {
        if (this.mFactory == null) {
            this.mFactory = new ColorStateListFactory(this);
        }
        return this.mFactory;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (this.canApplyTheme()) {
            Log.w(TAG, "Wrote partially-resolved ColorStateList to parcel!");
        }
        int N = this.mStateSpecs.length;
        dest.writeInt(N);
        for (int i = 0; i < N; ++i) {
            dest.writeIntArray(this.mStateSpecs[i]);
        }
        dest.writeIntArray(this.mColors);
    }

    private static class ColorStateListFactory
    extends ConstantState<ComplexColor> {
        private final ColorStateList mSrc;

        @UnsupportedAppUsage
        public ColorStateListFactory(ColorStateList src) {
            this.mSrc = src;
        }

        @Override
        public int getChangingConfigurations() {
            return this.mSrc.mChangingConfigurations;
        }

        @Override
        public ColorStateList newInstance() {
            return this.mSrc;
        }

        @Override
        public ColorStateList newInstance(Resources res, Resources.Theme theme) {
            return this.mSrc.obtainForTheme(theme);
        }
    }
}

