/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.animation.Animator;
import android.animation.StateListAnimator;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.pm.ActivityInfo;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.CompatibilityInfo;
import android.content.res.ComplexColor;
import android.content.res.Configuration;
import android.content.res.ConfigurationBoundResourceCache;
import android.content.res.ConstantState;
import android.content.res.DrawableCache;
import android.content.res.FontResourcesParser;
import android.content.res.GradientColor;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.graphics.ImageDecoder;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.ColorStateListDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.icu.text.PluralRules;
import android.os.LocaleList;
import android.os.Trace;
import android.os._Original_Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.TypedValue;
import android.util.Xml;
import android.view.DisplayAdjustments;
import com.android.internal.util.GrowingArrayUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Locale;
import libcore.util.NativeAllocationRegistry;
import org.xmlpull.v1.XmlPullParserException;

public class ResourcesImpl {
    static final String TAG = "Resources";
    private static final boolean DEBUG_LOAD = false;
    private static final boolean DEBUG_CONFIG = false;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private static final boolean TRACE_FOR_PRELOAD = false;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private static final boolean TRACE_FOR_MISS_PRELOAD = false;
    private static final int ID_OTHER = 0x1000004;
    private static final Object sSync = new Object();
    private static boolean sPreloaded;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private boolean mPreloading;
    @UnsupportedAppUsage
    private static final LongSparseArray<Drawable.ConstantState>[] sPreloadedDrawables;
    @UnsupportedAppUsage
    private static final LongSparseArray<Drawable.ConstantState> sPreloadedColorDrawables;
    @UnsupportedAppUsage
    private static final LongSparseArray<ConstantState<ComplexColor>> sPreloadedComplexColors;
    @UnsupportedAppUsage
    private final Object mAccessLock = new Object();
    private final Configuration mTmpConfig = new Configuration();
    @UnsupportedAppUsage
    private final DrawableCache mDrawableCache = new DrawableCache();
    @UnsupportedAppUsage
    private final DrawableCache mColorDrawableCache = new DrawableCache();
    private final ConfigurationBoundResourceCache<ComplexColor> mComplexColorCache = new ConfigurationBoundResourceCache();
    @UnsupportedAppUsage
    private final ConfigurationBoundResourceCache<Animator> mAnimatorCache = new ConfigurationBoundResourceCache();
    @UnsupportedAppUsage
    private final ConfigurationBoundResourceCache<StateListAnimator> mStateListAnimatorCache = new ConfigurationBoundResourceCache();
    private final ThreadLocal<LookupStack> mLookupStack = ThreadLocal.withInitial(() -> new LookupStack());
    private static final int XML_BLOCK_CACHE_SIZE = 4;
    private int mLastCachedXmlBlockIndex = -1;
    private final int[] mCachedXmlBlockCookies = new int[4];
    private final String[] mCachedXmlBlockFiles = new String[4];
    private final XmlBlock[] mCachedXmlBlocks = new XmlBlock[4];
    @UnsupportedAppUsage
    final AssetManager mAssets;
    private final DisplayMetrics mMetrics = new DisplayMetrics();
    private final DisplayAdjustments mDisplayAdjustments;
    private PluralRules mPluralRule;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private final Configuration mConfiguration = new Configuration();
    private static final NativeAllocationRegistry sThemeRegistry;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public ResourcesImpl(AssetManager assets, DisplayMetrics metrics, Configuration config, DisplayAdjustments displayAdjustments) {
        this.mAssets = assets;
        this.mMetrics.setToDefaults();
        this.mDisplayAdjustments = displayAdjustments;
        this.mConfiguration.setToDefaults();
        this.updateConfiguration(config, metrics, displayAdjustments.getCompatibilityInfo());
    }

    public DisplayAdjustments getDisplayAdjustments() {
        return this.mDisplayAdjustments;
    }

    @UnsupportedAppUsage
    public AssetManager getAssets() {
        return this.mAssets;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    DisplayMetrics getDisplayMetrics() {
        return this.mMetrics;
    }

    Configuration getConfiguration() {
        return this.mConfiguration;
    }

    Configuration[] getSizeConfigurations() {
        return this.mAssets.getSizeConfigurations();
    }

    CompatibilityInfo getCompatibilityInfo() {
        return this.mDisplayAdjustments.getCompatibilityInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluralRules getPluralRule() {
        Object object = sSync;
        synchronized (object) {
            if (this.mPluralRule == null) {
                this.mPluralRule = PluralRules.forLocale(this.mConfiguration.getLocales().get(0));
            }
            return this.mPluralRule;
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void getValue(int id2, TypedValue outValue, boolean resolveRefs) throws Resources.NotFoundException {
        boolean found = this.mAssets.getResourceValue(id2, 0, outValue, resolveRefs);
        if (found) {
            return;
        }
        throw new Resources.NotFoundException("Resource ID #0x" + Integer.toHexString(id2));
    }

    void getValueForDensity(int id2, int density, TypedValue outValue, boolean resolveRefs) throws Resources.NotFoundException {
        boolean found = this.mAssets.getResourceValue(id2, density, outValue, resolveRefs);
        if (found) {
            return;
        }
        throw new Resources.NotFoundException("Resource ID #0x" + Integer.toHexString(id2));
    }

    void getValue(String name, TypedValue outValue, boolean resolveRefs) throws Resources.NotFoundException {
        int id2 = this.getIdentifier(name, "string", null);
        if (id2 != 0) {
            this.getValue(id2, outValue, resolveRefs);
            return;
        }
        throw new Resources.NotFoundException("String resource name " + name);
    }

    int getIdentifier(String name, String defType, String defPackage) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        try {
            return Integer.parseInt(name);
        }
        catch (Exception exception) {
            return this.mAssets.getResourceIdentifier(name, defType, defPackage);
        }
    }

    String getResourceName(int resid) throws Resources.NotFoundException {
        String str = this.mAssets.getResourceName(resid);
        if (str != null) {
            return str;
        }
        throw new Resources.NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    String getResourcePackageName(int resid) throws Resources.NotFoundException {
        String str = this.mAssets.getResourcePackageName(resid);
        if (str != null) {
            return str;
        }
        throw new Resources.NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    String getResourceTypeName(int resid) throws Resources.NotFoundException {
        String str = this.mAssets.getResourceTypeName(resid);
        if (str != null) {
            return str;
        }
        throw new Resources.NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    String getResourceEntryName(int resid) throws Resources.NotFoundException {
        String str = this.mAssets.getResourceEntryName(resid);
        if (str != null) {
            return str;
        }
        throw new Resources.NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    String getLastResourceResolution() throws Resources.NotFoundException {
        String str = this.mAssets.getLastResourceResolution();
        if (str != null) {
            return str;
        }
        throw new Resources.NotFoundException("Associated AssetManager hasn't resolved a resource");
    }

    CharSequence getQuantityText(int id2, int quantity) throws Resources.NotFoundException {
        PluralRules rule = this.getPluralRule();
        CharSequence res = this.mAssets.getResourceBagText(id2, ResourcesImpl.attrForQuantityCode(rule.select(quantity)));
        if (res != null) {
            return res;
        }
        res = this.mAssets.getResourceBagText(id2, 0x1000004);
        if (res != null) {
            return res;
        }
        throw new Resources.NotFoundException("Plural resource ID #0x" + Integer.toHexString(id2) + " quantity=" + quantity + " item=" + rule.select(quantity));
    }

    private static int attrForQuantityCode(String quantityCode) {
        switch (quantityCode) {
            case "zero": {
                return 0x1000005;
            }
            case "one": {
                return 0x1000006;
            }
            case "two": {
                return 0x1000007;
            }
            case "few": {
                return 0x1000008;
            }
            case "many": {
                return 0x1000009;
            }
        }
        return 0x1000004;
    }

    AssetFileDescriptor openRawResourceFd(int id2, TypedValue tempValue) throws Resources.NotFoundException {
        this.getValue(id2, tempValue, true);
        try {
            return this.mAssets.openNonAssetFd(tempValue.assetCookie, tempValue.string.toString());
        }
        catch (Exception e) {
            throw new Resources.NotFoundException("File " + tempValue.string.toString() + " from resource ID #0x" + Integer.toHexString(id2), e);
        }
    }

    InputStream openRawResource(int id2, TypedValue value2) throws Resources.NotFoundException {
        this.getValue(id2, value2, true);
        try {
            return this.mAssets.openNonAsset(value2.assetCookie, value2.string.toString(), 2);
        }
        catch (Exception e) {
            Resources.NotFoundException rnf = new Resources.NotFoundException("File " + (value2.string == null ? "(null)" : value2.string.toString()) + " from resource ID #0x" + Integer.toHexString(id2));
            rnf.initCause(e);
            throw rnf;
        }
    }

    ConfigurationBoundResourceCache<Animator> getAnimatorCache() {
        return this.mAnimatorCache;
    }

    ConfigurationBoundResourceCache<StateListAnimator> getStateListAnimatorCache() {
        return this.mStateListAnimatorCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfiguration(Configuration config, DisplayMetrics metrics, CompatibilityInfo compat) {
        Trace.traceBegin(8192L, "ResourcesImpl#updateConfiguration");
        try {
            Object object = this.mAccessLock;
            synchronized (object) {
                int height2;
                int width2;
                if (compat != null) {
                    this.mDisplayAdjustments.setCompatibilityInfo(compat);
                }
                if (metrics != null) {
                    this.mMetrics.setTo(metrics);
                }
                this.mDisplayAdjustments.getCompatibilityInfo().applyToDisplayMetrics(this.mMetrics);
                int configChanges = this.calcConfigChanges(config);
                LocaleList locales = this.mConfiguration.getLocales();
                if (locales.isEmpty()) {
                    locales = LocaleList.getDefault();
                    this.mConfiguration.setLocales(locales);
                }
                if ((configChanges & 4) != 0 && locales.size() > 1) {
                    Locale bestLocale;
                    String[] availableLocales = this.mAssets.getNonSystemLocales();
                    if (LocaleList.isPseudoLocalesOnly(availableLocales) && LocaleList.isPseudoLocalesOnly(availableLocales = this.mAssets.getLocales())) {
                        availableLocales = null;
                    }
                    if (availableLocales != null && (bestLocale = locales.getFirstMatchWithEnglishSupported(availableLocales)) != null && bestLocale != locales.get(0)) {
                        this.mConfiguration.setLocales(new LocaleList(bestLocale, locales));
                    }
                }
                if (this.mConfiguration.densityDpi != 0) {
                    this.mMetrics.densityDpi = this.mConfiguration.densityDpi;
                    this.mMetrics.density = (float)this.mConfiguration.densityDpi * 0.00625f;
                }
                this.mMetrics.scaledDensity = this.mMetrics.density * (this.mConfiguration.fontScale != 0.0f ? this.mConfiguration.fontScale : 1.0f);
                if (this.mMetrics.widthPixels >= this.mMetrics.heightPixels) {
                    width2 = this.mMetrics.widthPixels;
                    height2 = this.mMetrics.heightPixels;
                } else {
                    width2 = this.mMetrics.heightPixels;
                    height2 = this.mMetrics.widthPixels;
                }
                int keyboardHidden = this.mConfiguration.keyboardHidden == 1 && this.mConfiguration.hardKeyboardHidden == 2 ? 3 : this.mConfiguration.keyboardHidden;
                this.mAssets.setConfiguration(this.mConfiguration.mcc, this.mConfiguration.mnc, ResourcesImpl.adjustLanguageTag(this.mConfiguration.getLocales().get(0).toLanguageTag()), this.mConfiguration.orientation, this.mConfiguration.touchscreen, this.mConfiguration.densityDpi, this.mConfiguration.keyboard, keyboardHidden, this.mConfiguration.navigation, width2, height2, this.mConfiguration.smallestScreenWidthDp, this.mConfiguration.screenWidthDp, this.mConfiguration.screenHeightDp, this.mConfiguration.screenLayout, this.mConfiguration.uiMode, this.mConfiguration.colorMode, _Original_Build.VERSION.RESOURCES_SDK_INT);
                this.mDrawableCache.onConfigurationChange(configChanges);
                this.mColorDrawableCache.onConfigurationChange(configChanges);
                this.mComplexColorCache.onConfigurationChange(configChanges);
                this.mAnimatorCache.onConfigurationChange(configChanges);
                this.mStateListAnimatorCache.onConfigurationChange(configChanges);
                this.flushLayoutCache();
            }
            object = sSync;
            synchronized (object) {
                if (this.mPluralRule != null) {
                    this.mPluralRule = PluralRules.forLocale(this.mConfiguration.getLocales().get(0));
                }
            }
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    public int calcConfigChanges(Configuration config) {
        if (config == null) {
            return -1;
        }
        this.mTmpConfig.setTo(config);
        int density = config.densityDpi;
        if (density == 0) {
            density = this.mMetrics.noncompatDensityDpi;
        }
        this.mDisplayAdjustments.getCompatibilityInfo().applyToConfiguration(density, this.mTmpConfig);
        if (this.mTmpConfig.getLocales().isEmpty()) {
            this.mTmpConfig.setLocales(LocaleList.getDefault());
        }
        return this.mConfiguration.updateFrom(this.mTmpConfig);
    }

    private static String adjustLanguageTag(String languageTag) {
        String adjustedLanguage;
        String remainder;
        String language;
        int separator = languageTag.indexOf(45);
        if (separator == -1) {
            language = languageTag;
            remainder = "";
        } else {
            language = languageTag.substring(0, separator);
            remainder = languageTag.substring(separator);
        }
        switch (language) {
            case "id": {
                adjustedLanguage = "in";
                break;
            }
            case "yi": {
                adjustedLanguage = "ji";
                break;
            }
            case "he": {
                adjustedLanguage = "iw";
                break;
            }
            default: {
                adjustedLanguage = language;
            }
        }
        return adjustedLanguage + remainder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushLayoutCache() {
        XmlBlock[] xmlBlockArray = this.mCachedXmlBlocks;
        synchronized (this.mCachedXmlBlocks) {
            Arrays.fill(this.mCachedXmlBlockCookies, 0);
            Arrays.fill(this.mCachedXmlBlockFiles, null);
            Object[] cachedXmlBlocks = this.mCachedXmlBlocks;
            for (int i = 0; i < 4; ++i) {
                XmlBlock oldBlock = cachedXmlBlocks[i];
                if (oldBlock == null) continue;
                oldBlock.close();
            }
            Arrays.fill(cachedXmlBlocks, null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllCaches() {
        Object object = this.mAccessLock;
        synchronized (object) {
            this.mDrawableCache.clear();
            this.mColorDrawableCache.clear();
            this.mComplexColorCache.clear();
            this.mAnimatorCache.clear();
            this.mStateListAnimatorCache.clear();
            this.flushLayoutCache();
        }
    }

    Drawable loadDrawable(Resources wrapper, TypedValue value2, int id2, int density, Resources.Theme theme) throws Resources.NotFoundException {
        boolean useCache;
        boolean bl = useCache = density == 0 || value2.density == this.mMetrics.densityDpi;
        if (density > 0 && value2.density > 0 && value2.density != 65535) {
            value2.density = value2.density == density ? this.mMetrics.densityDpi : value2.density * this.mMetrics.densityDpi / density;
        }
        try {
            boolean canApplyTheme;
            Drawable cachedDrawable;
            long key;
            DrawableCache caches;
            boolean isColorDrawable;
            if (value2.type >= 28 && value2.type <= 31) {
                isColorDrawable = true;
                caches = this.mColorDrawableCache;
                key = value2.data;
            } else {
                isColorDrawable = false;
                caches = this.mDrawableCache;
                key = (long)value2.assetCookie << 32 | (long)value2.data;
            }
            if (!this.mPreloading && useCache && (cachedDrawable = caches.getInstance(key, wrapper, theme)) != null) {
                cachedDrawable.setChangingConfigurations(value2.changingConfigurations);
                return cachedDrawable;
            }
            Drawable.ConstantState cs = isColorDrawable ? sPreloadedColorDrawables.get(key) : sPreloadedDrawables[this.mConfiguration.getLayoutDirection()].get(key);
            boolean needsNewDrawableAfterCache = false;
            Drawable dr = cs != null ? cs.newDrawable(wrapper) : (isColorDrawable ? new ColorDrawable(value2.data) : this.loadDrawableForCookie(wrapper, value2, id2, density));
            if (dr instanceof DrawableContainer) {
                needsNewDrawableAfterCache = true;
            }
            boolean bl2 = canApplyTheme = dr != null && dr.canApplyTheme();
            if (canApplyTheme && theme != null) {
                dr = dr.mutate();
                dr.applyTheme(theme);
                dr.clearMutated();
            }
            if (dr != null) {
                dr.setChangingConfigurations(value2.changingConfigurations);
                if (useCache) {
                    Drawable.ConstantState state;
                    this.cacheDrawable(value2, isColorDrawable, caches, theme, canApplyTheme, key, dr);
                    if (needsNewDrawableAfterCache && (state = dr.getConstantState()) != null) {
                        dr = state.newDrawable(wrapper);
                    }
                }
            }
            return dr;
        }
        catch (Exception e) {
            String name;
            try {
                name = this.getResourceName(id2);
            }
            catch (Resources.NotFoundException e2) {
                name = "(missing name)";
            }
            Resources.NotFoundException nfe = new Resources.NotFoundException("Drawable " + name + " with resource ID #0x" + Integer.toHexString(id2), e);
            nfe.setStackTrace(new StackTraceElement[0]);
            throw nfe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheDrawable(TypedValue value2, boolean isColorDrawable, DrawableCache caches, Resources.Theme theme, boolean usesTheme, long key, Drawable dr) {
        Drawable.ConstantState cs = dr.getConstantState();
        if (cs == null) {
            return;
        }
        if (this.mPreloading) {
            int changingConfigs = cs.getChangingConfigurations();
            if (isColorDrawable) {
                if (this.verifyPreloadConfig(changingConfigs, 0, value2.resourceId, "drawable")) {
                    sPreloadedColorDrawables.put(key, cs);
                }
            } else if (this.verifyPreloadConfig(changingConfigs, 8192, value2.resourceId, "drawable")) {
                if ((changingConfigs & 0x2000) == 0) {
                    sPreloadedDrawables[0].put(key, cs);
                    sPreloadedDrawables[1].put(key, cs);
                } else {
                    sPreloadedDrawables[this.mConfiguration.getLayoutDirection()].put(key, cs);
                }
            }
        } else {
            Object object = this.mAccessLock;
            synchronized (object) {
                caches.put(key, theme, cs, usesTheme);
            }
        }
    }

    private boolean verifyPreloadConfig(int changingConfigurations, int allowVarying, int resourceId, String name) {
        if ((changingConfigurations & 0xBFFFEFFF & ~allowVarying) != 0) {
            String resName;
            try {
                resName = this.getResourceName(resourceId);
            }
            catch (Resources.NotFoundException e) {
                resName = "?";
            }
            Log.w(TAG, "Preloaded " + name + " resource #0x" + Integer.toHexString(resourceId) + " (" + resName + ") that varies with configuration!!");
            return false;
        }
        return true;
    }

    private Drawable decodeImageDrawable(AssetManager.AssetInputStream ais, Resources wrapper, TypedValue value2) {
        ImageDecoder.AssetInputStreamSource src = new ImageDecoder.AssetInputStreamSource(ais, wrapper, value2);
        try {
            return ImageDecoder.decodeDrawable(src, (decoder, info, s) -> decoder.setAllocator(1));
        }
        catch (IOException ioe) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Drawable loadDrawableForCookie(Resources wrapper, TypedValue value2, int id2, int density) {
        Drawable dr;
        if (value2.string == null) {
            throw new Resources.NotFoundException("Resource \"" + this.getResourceName(id2) + "\" (" + Integer.toHexString(id2) + ") is not a Drawable (color or path): " + value2);
        }
        String file2 = value2.string.toString();
        Trace.traceBegin(8192L, file2);
        LookupStack stack = this.mLookupStack.get();
        try {
            if (stack.contains(id2)) {
                throw new Exception("Recursive reference in drawable");
            }
            stack.push(id2);
            try {
                if (file2.endsWith(".xml")) {
                    String typeName = this.getResourceTypeName(id2);
                    dr = typeName != null && typeName.equals("color") ? this.loadColorOrXmlDrawable(wrapper, value2, id2, density, file2) : this.loadXmlDrawable(wrapper, value2, id2, density, file2);
                } else {
                    InputStream is = this.mAssets.openNonAsset(value2.assetCookie, file2, 2);
                    AssetManager.AssetInputStream ais = (AssetManager.AssetInputStream)is;
                    dr = this.decodeImageDrawable(ais, wrapper, value2);
                }
            }
            finally {
                stack.pop();
            }
        }
        catch (Exception | StackOverflowError e) {
            Trace.traceEnd(8192L);
            Resources.NotFoundException rnf = new Resources.NotFoundException("File " + file2 + " from drawable resource ID #0x" + Integer.toHexString(id2));
            rnf.initCause(e);
            throw rnf;
        }
        Trace.traceEnd(8192L);
        return dr;
    }

    private Drawable loadColorOrXmlDrawable(Resources wrapper, TypedValue value2, int id2, int density, String file2) {
        try {
            ColorStateList csl = this.loadColorStateList(wrapper, value2, id2, null);
            return new ColorStateListDrawable(csl);
        }
        catch (Resources.NotFoundException originalException) {
            try {
                return this.loadXmlDrawable(wrapper, value2, id2, density, file2);
            }
            catch (Exception ignored) {
                throw originalException;
            }
        }
    }

    private Drawable loadXmlDrawable(Resources wrapper, TypedValue value2, int id2, int density, String file2) throws IOException, XmlPullParserException {
        try (XmlResourceParser rp = this.loadXmlResourceParser(file2, id2, value2.assetCookie, "drawable");){
            Drawable drawable2 = Drawable.createFromXmlForDensity(wrapper, rp, density, null);
            return drawable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Typeface loadFont(Resources wrapper, TypedValue value2, int id2) {
        if (value2.string == null) {
            throw new Resources.NotFoundException("Resource \"" + this.getResourceName(id2) + "\" (" + Integer.toHexString(id2) + ") is not a Font: " + value2);
        }
        String file2 = value2.string.toString();
        if (!file2.startsWith("res/")) {
            return null;
        }
        Typeface cached = Typeface.findFromCache(this.mAssets, file2);
        if (cached != null) {
            return cached;
        }
        Trace.traceBegin(8192L, file2);
        try {
            if (file2.endsWith("xml")) {
                XmlResourceParser rp = this.loadXmlResourceParser(file2, id2, value2.assetCookie, "font");
                FontResourcesParser.FamilyResourceEntry familyEntry = FontResourcesParser.parse(rp, wrapper);
                if (familyEntry == null) {
                    Typeface typeface = null;
                    return typeface;
                }
                Typeface typeface = Typeface.createFromResources(familyEntry, this.mAssets, file2);
                return typeface;
            }
            Typeface rp = new Typeface.Builder(this.mAssets, file2, false, value2.assetCookie).build();
            return rp;
        }
        catch (XmlPullParserException e) {
            Log.e(TAG, "Failed to parse xml resource " + file2, e);
        }
        catch (IOException e) {
            Log.e(TAG, "Failed to read xml resource " + file2, e);
        }
        finally {
            Trace.traceEnd(8192L);
        }
        return null;
    }

    private ComplexColor loadComplexColorFromName(Resources wrapper, Resources.Theme theme, TypedValue value2, int id2) {
        ConfigurationBoundResourceCache<ComplexColor> cache = this.mComplexColorCache;
        long key = (long)value2.assetCookie << 32 | (long)value2.data;
        ComplexColor complexColor = cache.getInstance(key, wrapper, theme);
        if (complexColor != null) {
            return complexColor;
        }
        ConstantState<ComplexColor> factory = sPreloadedComplexColors.get(key);
        if (factory != null) {
            complexColor = factory.newInstance(wrapper, theme);
        }
        if (complexColor == null) {
            complexColor = this.loadComplexColorForCookie(wrapper, value2, id2, theme);
        }
        if (complexColor != null) {
            complexColor.setBaseChangingConfigurations(value2.changingConfigurations);
            if (this.mPreloading) {
                if (this.verifyPreloadConfig(complexColor.getChangingConfigurations(), 0, value2.resourceId, "color")) {
                    sPreloadedComplexColors.put(key, complexColor.getConstantState());
                }
            } else {
                cache.put(key, theme, complexColor.getConstantState());
            }
        }
        return complexColor;
    }

    ComplexColor loadComplexColor(Resources wrapper, TypedValue value2, int id2, Resources.Theme theme) {
        ComplexColor complexColor;
        long key = (long)value2.assetCookie << 32 | (long)value2.data;
        if (value2.type >= 28 && value2.type <= 31) {
            return this.getColorStateListFromInt(value2, key);
        }
        String file2 = value2.string.toString();
        if (file2.endsWith(".xml")) {
            try {
                complexColor = this.loadComplexColorFromName(wrapper, theme, value2, id2);
            }
            catch (Exception e) {
                Resources.NotFoundException rnf = new Resources.NotFoundException("File " + file2 + " from complex color resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(e);
                throw rnf;
            }
        } else {
            throw new Resources.NotFoundException("File " + file2 + " from drawable resource ID #0x" + Integer.toHexString(id2) + ": .xml extension required");
        }
        return complexColor;
    }

    ColorStateList loadColorStateList(Resources wrapper, TypedValue value2, int id2, Resources.Theme theme) throws Resources.NotFoundException {
        long key = (long)value2.assetCookie << 32 | (long)value2.data;
        if (value2.type >= 28 && value2.type <= 31) {
            return this.getColorStateListFromInt(value2, key);
        }
        ComplexColor complexColor = this.loadComplexColorFromName(wrapper, theme, value2, id2);
        if (complexColor != null && complexColor instanceof ColorStateList) {
            return (ColorStateList)complexColor;
        }
        throw new Resources.NotFoundException("Can't find ColorStateList from drawable resource ID #0x" + Integer.toHexString(id2));
    }

    private ColorStateList getColorStateListFromInt(TypedValue value2, long key) {
        ConstantState<ComplexColor> factory = sPreloadedComplexColors.get(key);
        if (factory != null) {
            return (ColorStateList)factory.newInstance();
        }
        ColorStateList csl = ColorStateList.valueOf(value2.data);
        if (this.mPreloading && this.verifyPreloadConfig(value2.changingConfigurations, 0, value2.resourceId, "color")) {
            sPreloadedComplexColors.put(key, csl.getConstantState());
        }
        return csl;
    }

    private ComplexColor loadComplexColorForCookie(Resources wrapper, TypedValue value2, int id2, Resources.Theme theme) {
        if (value2.string == null) {
            throw new UnsupportedOperationException("Can't convert to ComplexColor: type=0x" + value2.type);
        }
        String file2 = value2.string.toString();
        ComplexColor complexColor = null;
        Trace.traceBegin(8192L, file2);
        if (file2.endsWith(".xml")) {
            try {
                int type;
                XmlResourceParser parser = this.loadXmlResourceParser(file2, id2, value2.assetCookie, "ComplexColor");
                AttributeSet attrs = Xml.asAttributeSet(parser);
                while ((type = parser.next()) != 2 && type != 1) {
                }
                if (type != 2) {
                    throw new XmlPullParserException("No start tag found");
                }
                String name = parser.getName();
                if (name.equals("gradient")) {
                    complexColor = GradientColor.createFromXmlInner(wrapper, parser, attrs, theme);
                } else if (name.equals("selector")) {
                    complexColor = ColorStateList.createFromXmlInner(wrapper, parser, attrs, theme);
                }
                parser.close();
            }
            catch (Exception e) {
                Trace.traceEnd(8192L);
                Resources.NotFoundException rnf = new Resources.NotFoundException("File " + file2 + " from ComplexColor resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(e);
                throw rnf;
            }
        } else {
            Trace.traceEnd(8192L);
            throw new Resources.NotFoundException("File " + file2 + " from drawable resource ID #0x" + Integer.toHexString(id2) + ": .xml extension required");
        }
        Trace.traceEnd(8192L);
        return complexColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XmlResourceParser loadXmlResourceParser(String file2, int id2, int assetCookie, String type) throws Resources.NotFoundException {
        if (id2 != 0) {
            try {
                XmlBlock[] xmlBlockArray = this.mCachedXmlBlocks;
                synchronized (this.mCachedXmlBlocks) {
                    int[] cachedXmlBlockCookies = this.mCachedXmlBlockCookies;
                    String[] cachedXmlBlockFiles = this.mCachedXmlBlockFiles;
                    XmlBlock[] cachedXmlBlocks = this.mCachedXmlBlocks;
                    int num = cachedXmlBlockFiles.length;
                    for (int i = 0; i < num; ++i) {
                        if (cachedXmlBlockCookies[i] != assetCookie || cachedXmlBlockFiles[i] == null || !cachedXmlBlockFiles[i].equals(file2)) continue;
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return cachedXmlBlocks[i].newParser(id2);
                    }
                    XmlBlock block = this.mAssets.openXmlBlockAsset(assetCookie, file2);
                    if (block != null) {
                        int pos;
                        this.mLastCachedXmlBlockIndex = pos = (this.mLastCachedXmlBlockIndex + 1) % num;
                        XmlBlock oldBlock = cachedXmlBlocks[pos];
                        if (oldBlock != null) {
                            oldBlock.close();
                        }
                        cachedXmlBlockCookies[pos] = assetCookie;
                        cachedXmlBlockFiles[pos] = file2;
                        cachedXmlBlocks[pos] = block;
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return block.newParser(id2);
                    }
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                Resources.NotFoundException rnf = new Resources.NotFoundException("File " + file2 + " from xml type " + type + " resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(e);
                throw rnf;
            }
        }
        {
            throw new Resources.NotFoundException("File " + file2 + " from xml type " + type + " resource ID #0x" + Integer.toHexString(id2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPreloading() {
        Object object = sSync;
        synchronized (object) {
            if (sPreloaded) {
                throw new IllegalStateException("Resources already preloaded");
            }
            sPreloaded = true;
            this.mPreloading = true;
            this.mConfiguration.densityDpi = DisplayMetrics.DENSITY_DEVICE;
            this.updateConfiguration(null, null, null);
        }
    }

    void finishPreloading() {
        if (this.mPreloading) {
            this.mPreloading = false;
            this.flushLayoutCache();
        }
    }

    static int getAttributeSetSourceResId(AttributeSet set) {
        if (set == null || !(set instanceof XmlBlock.Parser)) {
            return 0;
        }
        return ((XmlBlock.Parser)set).getSourceResId();
    }

    LongSparseArray<Drawable.ConstantState> getPreloadedDrawables() {
        return sPreloadedDrawables[0];
    }

    ThemeImpl newThemeImpl() {
        return new ThemeImpl();
    }

    void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "class=" + this.getClass());
        pw.println(prefix + "assets");
        this.mAssets.dump(pw, prefix + "  ");
    }

    static {
        sPreloadedColorDrawables = new LongSparseArray();
        sPreloadedComplexColors = new LongSparseArray();
        sPreloadedDrawables = new LongSparseArray[2];
        ResourcesImpl.sPreloadedDrawables[0] = new LongSparseArray();
        ResourcesImpl.sPreloadedDrawables[1] = new LongSparseArray();
        sThemeRegistry = NativeAllocationRegistry.createMalloced(ResourcesImpl.class.getClassLoader(), AssetManager.getThemeFreeFunction());
    }

    private static class LookupStack {
        private int[] mIds = new int[4];
        private int mSize = 0;

        private LookupStack() {
        }

        public void push(int id2) {
            this.mIds = GrowingArrayUtils.append(this.mIds, this.mSize, id2);
            ++this.mSize;
        }

        public boolean contains(int id2) {
            for (int i = 0; i < this.mSize; ++i) {
                if (this.mIds[i] != id2) continue;
                return true;
            }
            return false;
        }

        public void pop() {
            --this.mSize;
        }
    }

    public class ThemeImpl {
        private final Resources.ThemeKey mKey = new Resources.ThemeKey();
        private AssetManager mAssets;
        private final long mTheme;
        private int mThemeResId = 0;

        ThemeImpl() {
            this.mAssets = ResourcesImpl.this.mAssets;
            this.mTheme = this.mAssets.createTheme();
            sThemeRegistry.registerNativeAllocation(this, this.mTheme);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.mAssets.releaseTheme(this.mTheme);
        }

        Resources.ThemeKey getKey() {
            return this.mKey;
        }

        long getNativeTheme() {
            return this.mTheme;
        }

        int getAppliedStyleResId() {
            return this.mThemeResId;
        }

        int getParentThemeIdentifier(int resId) {
            if (resId > 0) {
                return this.mAssets.getParentThemeIdentifier(resId);
            }
            return 0;
        }

        void applyStyle(int resId, boolean force) {
            this.mAssets.applyStyleToTheme(this.mTheme, resId, force);
            this.mThemeResId = resId;
            this.mKey.append(resId, force);
        }

        void setTo(ThemeImpl other) {
            this.mAssets.setThemeTo(this.mTheme, other.mAssets, other.mTheme);
            this.mThemeResId = other.mThemeResId;
            this.mKey.setTo(other.getKey());
        }

        TypedArray obtainStyledAttributes(Resources.Theme wrapper, AttributeSet set, int[] attrs, int defStyleAttr, int defStyleRes) {
            int len = attrs.length;
            TypedArray array2 = TypedArray.obtain(wrapper.getResources(), len);
            XmlBlock.Parser parser = (XmlBlock.Parser)set;
            this.mAssets.applyStyle(this.mTheme, defStyleAttr, defStyleRes, parser, attrs, array2.mDataAddress, array2.mIndicesAddress);
            array2.mTheme = wrapper;
            array2.mXml = parser;
            return array2;
        }

        TypedArray resolveAttributes(Resources.Theme wrapper, int[] values2, int[] attrs) {
            int len = attrs.length;
            if (values2 == null || len != values2.length) {
                throw new IllegalArgumentException("Base attribute values must the same length as attrs");
            }
            TypedArray array2 = TypedArray.obtain(wrapper.getResources(), len);
            this.mAssets.resolveAttrs(this.mTheme, 0, 0, values2, attrs, array2.mData, array2.mIndices);
            array2.mTheme = wrapper;
            array2.mXml = null;
            return array2;
        }

        boolean resolveAttribute(int resid, TypedValue outValue, boolean resolveRefs) {
            return this.mAssets.getThemeValue(this.mTheme, resid, outValue, resolveRefs);
        }

        int[] getAllAttributes() {
            return this.mAssets.getStyleAttributes(this.getAppliedStyleResId());
        }

        int getChangingConfigurations() {
            int nativeChangingConfig = AssetManager.nativeThemeGetChangingConfigurations(this.mTheme);
            return ActivityInfo.activityInfoConfigNativeToJava(nativeChangingConfig);
        }

        public void dump(int priority, String tag2, String prefix) {
            this.mAssets.dumpTheme(this.mTheme, priority, tag2, prefix);
        }

        String[] getTheme() {
            int n = this.mKey.mCount;
            String[] themes = new String[n * 2];
            int i = 0;
            int j = n - 1;
            while (i < themes.length) {
                int resId = this.mKey.mResId[j];
                boolean forced = this.mKey.mForce[j];
                try {
                    themes[i] = ResourcesImpl.this.getResourceName(resId);
                }
                catch (Resources.NotFoundException e) {
                    themes[i] = Integer.toHexString(i);
                }
                themes[i + 1] = forced ? "forced" : "not forced";
                i += 2;
                --j;
            }
            return themes;
        }

        void rebase() {
            this.rebase(this.mAssets);
        }

        void rebase(AssetManager newAssets) {
            this.mAssets = this.mAssets.rebaseTheme(this.mTheme, newAssets, this.mKey.mResId, this.mKey.mForce, this.mKey.mCount);
        }

        public int[] getAttributeResolutionStack(int defStyleAttr, int defStyleRes, int explicitStyleRes) {
            return this.mAssets.getAttributeResolutionStack(this.mTheme, defStyleAttr, defStyleRes, explicitStyleRes);
        }
    }
}

