/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.annotation.SystemApi;
import android.app.compat.CompatChanges;
import android.compat.annotation.UnsupportedAppUsage;
import android.database.IContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.Process;
import android.os.UserHandle;
import java.util.Arrays;
import java.util.Collection;

public abstract class ContentObserver {
    private static final long ADD_CONTENT_OBSERVER_FLAGS = 150939131L;
    private final Object mLock = new Object();
    private Transport mTransport;
    Handler mHandler;

    public ContentObserver(Handler handler) {
        this.mHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContentObserver getContentObserver() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTransport == null) {
                this.mTransport = new Transport(this);
            }
            return this.mTransport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public IContentObserver releaseContentObserver() {
        Object object = this.mLock;
        synchronized (object) {
            Transport oldTransport = this.mTransport;
            if (oldTransport != null) {
                oldTransport.releaseContentObserver();
                this.mTransport = null;
            }
            return oldTransport;
        }
    }

    public boolean deliverSelfNotifications() {
        return false;
    }

    public void onChange(boolean selfChange) {
    }

    public void onChange(boolean selfChange, Uri uri) {
        this.onChange(selfChange);
    }

    public void onChange(boolean selfChange, Uri uri, int flags) {
        this.onChange(selfChange, uri);
    }

    public void onChange(boolean selfChange, Collection<Uri> uris, int flags) {
        for (Uri uri : uris) {
            this.onChange(selfChange, uri, flags);
        }
    }

    @SystemApi
    public void onChange(boolean selfChange, Collection<Uri> uris, int flags, UserHandle user) {
        this.onChange(selfChange, uris, user.getIdentifier());
    }

    public void onChange(boolean selfChange, Collection<Uri> uris, int flags, int userId) {
        if (!CompatChanges.isChangeEnabled(150939131L) || Process.myUid() == 1000) {
            this.onChange(selfChange, uris, flags, UserHandle.of(userId));
        } else {
            this.onChange(selfChange, uris, flags);
        }
    }

    @Deprecated
    public void dispatchChange(boolean selfChange) {
        this.dispatchChange(selfChange, null);
    }

    public void dispatchChange(boolean selfChange, Uri uri) {
        this.dispatchChange(selfChange, uri, 0);
    }

    public void dispatchChange(boolean selfChange, Uri uri, int flags) {
        this.dispatchChange(selfChange, Arrays.asList(uri), flags);
    }

    public void dispatchChange(boolean selfChange, Collection<Uri> uris, int flags) {
        this.dispatchChange(selfChange, uris, flags, UserHandle.getCallingUserId());
    }

    public void dispatchChange(boolean selfChange, Collection<Uri> uris, int flags, int userId) {
        if (this.mHandler == null) {
            this.onChange(selfChange, uris, flags, userId);
        } else {
            this.mHandler.post(() -> this.onChange(selfChange, uris, flags, userId));
        }
    }

    private static class Transport
    extends IContentObserver.Stub {
        private ContentObserver mContentObserver;

        public Transport(ContentObserver contentObserver) {
            this.mContentObserver = contentObserver;
        }

        @Override
        public void onChange(boolean selfChange, Uri uri, int userId) {
            this.onChangeEtc(selfChange, new Uri[]{uri}, 0, userId);
        }

        @Override
        public void onChangeEtc(boolean selfChange, Uri[] uris, int flags, int userId) {
            ContentObserver contentObserver = this.mContentObserver;
            if (contentObserver != null) {
                contentObserver.dispatchChange(selfChange, Arrays.asList(uris), flags, userId);
            }
        }

        public void releaseContentObserver() {
            this.mContentObserver = null;
        }
    }
}

