/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.Resources;
import android.database.CharArrayBuffer;
import android.database.sqlite.SQLiteClosable;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.FastNative;
import dalvik.system.CloseGuard;

public class CursorWindow
extends SQLiteClosable
implements Parcelable {
    private static final String STATS_TAG = "CursorWindowStats";
    @UnsupportedAppUsage
    private static int sCursorWindowSize = -1;
    @UnsupportedAppUsage
    public long mWindowPtr;
    private int mStartPos;
    private final String mName;
    private final CloseGuard mCloseGuard = CloseGuard.get();
    public static final Parcelable.Creator<CursorWindow> CREATOR = new Parcelable.Creator<CursorWindow>(){

        @Override
        public CursorWindow createFromParcel(Parcel source) {
            return new CursorWindow(source);
        }

        public CursorWindow[] newArray(int size) {
            return new CursorWindow[size];
        }
    };

    private static long nativeCreate(String string2, int n) {
        return OverrideMethod.invokeL("android.database.CursorWindow#nativeCreate(Ljava/lang/String;I)J", true, null);
    }

    private static long nativeCreateFromParcel(Parcel parcel) {
        return OverrideMethod.invokeL("android.database.CursorWindow#nativeCreateFromParcel(Landroid/os/Parcel;)J", true, null);
    }

    private static void nativeDispose(long l) {
        OverrideMethod.invokeV("android.database.CursorWindow#nativeDispose(J)V", true, null);
    }

    private static void nativeWriteToParcel(long l, Parcel parcel) {
        OverrideMethod.invokeV("android.database.CursorWindow#nativeWriteToParcel(JLandroid/os/Parcel;)V", true, null);
    }

    private static String nativeGetName(long l) {
        return (String)OverrideMethod.invokeA("android.database.CursorWindow#nativeGetName(J)Ljava/lang/String;", true, null);
    }

    private static byte[] nativeGetBlob(long l, int n, int n2) {
        return (byte[])OverrideMethod.invokeA("android.database.CursorWindow#nativeGetBlob(JII)[B", true, null);
    }

    private static String nativeGetString(long l, int n, int n2) {
        return (String)OverrideMethod.invokeA("android.database.CursorWindow#nativeGetString(JII)Ljava/lang/String;", true, null);
    }

    private static void nativeCopyStringToBuffer(long l, int n, int n2, CharArrayBuffer charArrayBuffer) {
        OverrideMethod.invokeV("android.database.CursorWindow#nativeCopyStringToBuffer(JIILandroid/database/CharArrayBuffer;)V", true, null);
    }

    private static boolean nativePutBlob(long l, byte[] byArray, int n, int n2) {
        return OverrideMethod.invokeI("android.database.CursorWindow#nativePutBlob(J[BII)Z", true, null) != 0;
    }

    private static boolean nativePutString(long l, String string2, int n, int n2) {
        return OverrideMethod.invokeI("android.database.CursorWindow#nativePutString(JLjava/lang/String;II)Z", true, null) != 0;
    }

    @FastNative
    private static void nativeClear(long l) {
        OverrideMethod.invokeV("android.database.CursorWindow#nativeClear(J)V", true, null);
    }

    @FastNative
    private static int nativeGetNumRows(long l) {
        return OverrideMethod.invokeI("android.database.CursorWindow#nativeGetNumRows(J)I", true, null);
    }

    @FastNative
    private static boolean nativeSetNumColumns(long l, int n) {
        return OverrideMethod.invokeI("android.database.CursorWindow#nativeSetNumColumns(JI)Z", true, null) != 0;
    }

    @FastNative
    private static boolean nativeAllocRow(long l) {
        return OverrideMethod.invokeI("android.database.CursorWindow#nativeAllocRow(J)Z", true, null) != 0;
    }

    @FastNative
    private static void nativeFreeLastRow(long l) {
        OverrideMethod.invokeV("android.database.CursorWindow#nativeFreeLastRow(J)V", true, null);
    }

    @FastNative
    private static int nativeGetType(long l, int n, int n2) {
        return OverrideMethod.invokeI("android.database.CursorWindow#nativeGetType(JII)I", true, null);
    }

    @FastNative
    private static long nativeGetLong(long l, int n, int n2) {
        return OverrideMethod.invokeL("android.database.CursorWindow#nativeGetLong(JII)J", true, null);
    }

    @FastNative
    private static double nativeGetDouble(long l, int n, int n2) {
        return OverrideMethod.invokeD("android.database.CursorWindow#nativeGetDouble(JII)D", true, null);
    }

    @FastNative
    private static boolean nativePutLong(long l, long l2, int n, int n2) {
        return OverrideMethod.invokeI("android.database.CursorWindow#nativePutLong(JJII)Z", true, null) != 0;
    }

    @FastNative
    private static boolean nativePutDouble(long l, double d, int n, int n2) {
        return OverrideMethod.invokeI("android.database.CursorWindow#nativePutDouble(JDII)Z", true, null) != 0;
    }

    @FastNative
    private static boolean nativePutNull(long l, int n, int n2) {
        return OverrideMethod.invokeI("android.database.CursorWindow#nativePutNull(JII)Z", true, null) != 0;
    }

    public CursorWindow(String name) {
        this(name, CursorWindow.getCursorWindowSize());
    }

    public CursorWindow(String name, long windowSizeBytes) {
        if (windowSizeBytes < 0L) {
            throw new IllegalArgumentException("Window size cannot be less than 0");
        }
        this.mStartPos = 0;
        this.mName = name != null && name.length() != 0 ? name : "<unnamed>";
        this.mWindowPtr = CursorWindow.nativeCreate(this.mName, (int)windowSizeBytes);
        if (this.mWindowPtr == 0L) {
            throw new AssertionError();
        }
        this.mCloseGuard.open("CursorWindow.close");
    }

    @Deprecated
    public CursorWindow(boolean localWindow) {
        this((String)null);
    }

    private CursorWindow(Parcel source) {
        this.mStartPos = source.readInt();
        this.mWindowPtr = CursorWindow.nativeCreateFromParcel(source);
        if (this.mWindowPtr == 0L) {
            throw new AssertionError();
        }
        this.mName = CursorWindow.nativeGetName(this.mWindowPtr);
        this.mCloseGuard.open("CursorWindow.close");
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    private void dispose() {
        if (this.mCloseGuard != null) {
            this.mCloseGuard.close();
        }
        if (this.mWindowPtr != 0L) {
            CursorWindow.nativeDispose(this.mWindowPtr);
            this.mWindowPtr = 0L;
        }
    }

    public String getName() {
        return this.mName;
    }

    public void clear() {
        this.acquireReference();
        try {
            this.mStartPos = 0;
            CursorWindow.nativeClear(this.mWindowPtr);
        }
        finally {
            this.releaseReference();
        }
    }

    public int getStartPosition() {
        return this.mStartPos;
    }

    public void setStartPosition(int pos) {
        this.mStartPos = pos;
    }

    public int getNumRows() {
        this.acquireReference();
        try {
            int n = CursorWindow.nativeGetNumRows(this.mWindowPtr);
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean setNumColumns(int columnNum) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativeSetNumColumns(this.mWindowPtr, columnNum);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean allocRow() {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativeAllocRow(this.mWindowPtr);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public void freeLastRow() {
        this.acquireReference();
        try {
            CursorWindow.nativeFreeLastRow(this.mWindowPtr);
        }
        finally {
            this.releaseReference();
        }
    }

    @Deprecated
    public boolean isNull(int row, int column) {
        return this.getType(row, column) == 0;
    }

    @Deprecated
    public boolean isBlob(int row, int column) {
        int type = this.getType(row, column);
        return type == 4 || type == 0;
    }

    @Deprecated
    public boolean isLong(int row, int column) {
        return this.getType(row, column) == 1;
    }

    @Deprecated
    public boolean isFloat(int row, int column) {
        return this.getType(row, column) == 2;
    }

    @Deprecated
    public boolean isString(int row, int column) {
        int type = this.getType(row, column);
        return type == 3 || type == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getType(int row, int column) {
        this.acquireReference();
        try {
            int n = CursorWindow.nativeGetType(this.mWindowPtr, row - this.mStartPos, column);
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBlob(int row, int column) {
        this.acquireReference();
        try {
            byte[] byArray = CursorWindow.nativeGetBlob(this.mWindowPtr, row - this.mStartPos, column);
            return byArray;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int row, int column) {
        this.acquireReference();
        try {
            String string2 = CursorWindow.nativeGetString(this.mWindowPtr, row - this.mStartPos, column);
            return string2;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyStringToBuffer(int row, int column, CharArrayBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("CharArrayBuffer should not be null");
        }
        this.acquireReference();
        try {
            CursorWindow.nativeCopyStringToBuffer(this.mWindowPtr, row - this.mStartPos, column, buffer);
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int row, int column) {
        this.acquireReference();
        try {
            long l = CursorWindow.nativeGetLong(this.mWindowPtr, row - this.mStartPos, column);
            return l;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int row, int column) {
        this.acquireReference();
        try {
            double d = CursorWindow.nativeGetDouble(this.mWindowPtr, row - this.mStartPos, column);
            return d;
        }
        finally {
            this.releaseReference();
        }
    }

    public short getShort(int row, int column) {
        return (short)this.getLong(row, column);
    }

    public int getInt(int row, int column) {
        return (int)this.getLong(row, column);
    }

    public float getFloat(int row, int column) {
        return (float)this.getDouble(row, column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putBlob(byte[] value2, int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutBlob(this.mWindowPtr, value2, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putString(String value2, int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutString(this.mWindowPtr, value2, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putLong(long value2, int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutLong(this.mWindowPtr, value2, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putDouble(double value2, int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutDouble(this.mWindowPtr, value2, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putNull(int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutNull(this.mWindowPtr, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public static CursorWindow newFromParcel(Parcel p) {
        return CREATOR.createFromParcel(p);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.acquireReference();
        try {
            dest.writeInt(this.mStartPos);
            CursorWindow.nativeWriteToParcel(this.mWindowPtr, dest);
        }
        finally {
            this.releaseReference();
        }
        if ((flags & 1) != 0) {
            this.releaseReference();
        }
    }

    @Override
    protected void onAllReferencesReleased() {
        this.dispose();
    }

    private static int getCursorWindowSize() {
        if (sCursorWindowSize < 0) {
            sCursorWindowSize = Resources.getSystem().getInteger(17694773) * 1024;
        }
        return sCursorWindowSize;
    }

    public String toString() {
        return this.getName() + " {" + Long.toHexString(this.mWindowPtr) + "}";
    }
}

