/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.content.Context;
import android.filterfw.core.GLEnvironment;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;

public class FilterSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback {
    private static int STATE_ALLOCATED = 0;
    private static int STATE_CREATED = 1;
    private static int STATE_INITIALIZED = 2;
    private int mState = STATE_ALLOCATED;
    private SurfaceHolder.Callback mListener;
    private GLEnvironment mGLEnv;
    private int mFormat;
    private int mWidth;
    private int mHeight;
    private int mSurfaceId = -1;

    public FilterSurfaceView(Context context) {
        super(context);
        this.getHolder().addCallback(this);
    }

    public FilterSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.getHolder().addCallback(this);
    }

    public synchronized void bindToListener(SurfaceHolder.Callback listener2, GLEnvironment glEnv) {
        if (listener2 == null) {
            throw new NullPointerException("Attempting to bind null filter to SurfaceView!");
        }
        if (this.mListener != null && this.mListener != listener2) {
            throw new RuntimeException("Attempting to bind filter " + listener2 + " to SurfaceView with another open filter " + this.mListener + " attached already!");
        }
        this.mListener = listener2;
        if (this.mGLEnv != null && this.mGLEnv != glEnv) {
            this.mGLEnv.unregisterSurfaceId(this.mSurfaceId);
        }
        this.mGLEnv = glEnv;
        if (this.mState >= STATE_CREATED) {
            this.registerSurface();
            this.mListener.surfaceCreated(this.getHolder());
            if (this.mState == STATE_INITIALIZED) {
                this.mListener.surfaceChanged(this.getHolder(), this.mFormat, this.mWidth, this.mHeight);
            }
        }
    }

    public synchronized void unbind() {
        this.mListener = null;
    }

    public synchronized int getSurfaceId() {
        return this.mSurfaceId;
    }

    public synchronized GLEnvironment getGLEnv() {
        return this.mGLEnv;
    }

    @Override
    public synchronized void surfaceCreated(SurfaceHolder holder) {
        this.mState = STATE_CREATED;
        if (this.mGLEnv != null) {
            this.registerSurface();
        }
        if (this.mListener != null) {
            this.mListener.surfaceCreated(holder);
        }
    }

    @Override
    public synchronized void surfaceChanged(SurfaceHolder holder, int format, int width2, int height2) {
        this.mFormat = format;
        this.mWidth = width2;
        this.mHeight = height2;
        this.mState = STATE_INITIALIZED;
        if (this.mListener != null) {
            this.mListener.surfaceChanged(holder, format, width2, height2);
        }
    }

    @Override
    public synchronized void surfaceDestroyed(SurfaceHolder holder) {
        this.mState = STATE_ALLOCATED;
        if (this.mListener != null) {
            this.mListener.surfaceDestroyed(holder);
        }
        this.unregisterSurface();
    }

    private void registerSurface() {
        this.mSurfaceId = this.mGLEnv.registerSurface(this.getHolder().getSurface());
        if (this.mSurfaceId < 0) {
            throw new RuntimeException("Could not register Surface: " + this.getHolder().getSurface() + " in FilterSurfaceView!");
        }
    }

    private void unregisterSurface() {
        if (this.mGLEnv != null && this.mSurfaceId > 0) {
            this.mGLEnv.unregisterSurfaceId(this.mSurfaceId);
        }
    }
}

