/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.gesture.GestureStroke;
import android.gesture.GestureUtils;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.android.internal.lang.System_Delegate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class Gesture
implements Parcelable {
    private static final long GESTURE_ID_BASE = System_Delegate.currentTimeMillis();
    private static final int BITMAP_RENDERING_WIDTH = 2;
    private static final boolean BITMAP_RENDERING_ANTIALIAS = true;
    private static final boolean BITMAP_RENDERING_DITHER = true;
    private static final AtomicInteger sGestureCount = new AtomicInteger(0);
    private final RectF mBoundingBox = new RectF();
    private long mGestureID;
    private final ArrayList<GestureStroke> mStrokes = new ArrayList();
    public static final Parcelable.Creator<Gesture> CREATOR = new Parcelable.Creator<Gesture>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Gesture createFromParcel(Parcel in) {
            Gesture gesture = null;
            long gestureID = in.readLong();
            DataInputStream inStream = new DataInputStream(new ByteArrayInputStream(in.createByteArray()));
            try {
                gesture = Gesture.deserialize(inStream);
            }
            catch (IOException e) {
                Log.e("Gestures", "Error reading Gesture from parcel:", e);
            }
            finally {
                GestureUtils.closeStream(inStream);
            }
            if (gesture != null) {
                gesture.mGestureID = gestureID;
            }
            return gesture;
        }

        public Gesture[] newArray(int size) {
            return new Gesture[size];
        }
    };

    public Gesture() {
        this.mGestureID = GESTURE_ID_BASE + (long)sGestureCount.incrementAndGet();
    }

    public Object clone() {
        Gesture gesture = new Gesture();
        gesture.mBoundingBox.set(this.mBoundingBox.left, this.mBoundingBox.top, this.mBoundingBox.right, this.mBoundingBox.bottom);
        int count = this.mStrokes.size();
        for (int i = 0; i < count; ++i) {
            GestureStroke stroke = this.mStrokes.get(i);
            gesture.mStrokes.add((GestureStroke)stroke.clone());
        }
        return gesture;
    }

    public ArrayList<GestureStroke> getStrokes() {
        return this.mStrokes;
    }

    public int getStrokesCount() {
        return this.mStrokes.size();
    }

    public void addStroke(GestureStroke stroke) {
        this.mStrokes.add(stroke);
        this.mBoundingBox.union(stroke.boundingBox);
    }

    public float getLength() {
        int len = 0;
        ArrayList<GestureStroke> strokes = this.mStrokes;
        int count = strokes.size();
        for (int i = 0; i < count; ++i) {
            len = (int)((float)len + strokes.get((int)i).length);
        }
        return len;
    }

    public RectF getBoundingBox() {
        return this.mBoundingBox;
    }

    public Path toPath() {
        return this.toPath(null);
    }

    public Path toPath(Path path) {
        if (path == null) {
            path = new Path();
        }
        ArrayList<GestureStroke> strokes = this.mStrokes;
        int count = strokes.size();
        for (int i = 0; i < count; ++i) {
            path.addPath(strokes.get(i).getPath());
        }
        return path;
    }

    public Path toPath(int width2, int height2, int edge, int numSample) {
        return this.toPath(null, width2, height2, edge, numSample);
    }

    public Path toPath(Path path, int width2, int height2, int edge, int numSample) {
        if (path == null) {
            path = new Path();
        }
        ArrayList<GestureStroke> strokes = this.mStrokes;
        int count = strokes.size();
        for (int i = 0; i < count; ++i) {
            path.addPath(strokes.get(i).toPath(width2 - 2 * edge, height2 - 2 * edge, numSample));
        }
        return path;
    }

    void setID(long id2) {
        this.mGestureID = id2;
    }

    public long getID() {
        return this.mGestureID;
    }

    public Bitmap toBitmap(int width2, int height2, int edge, int numSample, int color2) {
        Bitmap bitmap = Bitmap.createBitmap(width2, height2, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.translate(edge, edge);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setDither(true);
        paint.setColor(color2);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeCap(Paint.Cap.ROUND);
        paint.setStrokeWidth(2.0f);
        ArrayList<GestureStroke> strokes = this.mStrokes;
        int count = strokes.size();
        for (int i = 0; i < count; ++i) {
            Path path = strokes.get(i).toPath(width2 - 2 * edge, height2 - 2 * edge, numSample);
            canvas.drawPath(path, paint);
        }
        return bitmap;
    }

    public Bitmap toBitmap(int width2, int height2, int inset, int color2) {
        Bitmap bitmap = Bitmap.createBitmap(width2, height2, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setDither(true);
        paint.setColor(color2);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeCap(Paint.Cap.ROUND);
        paint.setStrokeWidth(2.0f);
        Path path = this.toPath();
        RectF bounds2 = new RectF();
        path.computeBounds(bounds2, true);
        float sx = (float)(width2 - 2 * inset) / bounds2.width();
        float sy = (float)(height2 - 2 * inset) / bounds2.height();
        float scale = sx > sy ? sy : sx;
        paint.setStrokeWidth(2.0f / scale);
        path.offset(-bounds2.left + ((float)width2 - bounds2.width() * scale) / 2.0f, -bounds2.top + ((float)height2 - bounds2.height() * scale) / 2.0f);
        canvas.translate(inset, inset);
        canvas.scale(scale, scale);
        canvas.drawPath(path, paint);
        return bitmap;
    }

    void serialize(DataOutputStream out) throws IOException {
        ArrayList<GestureStroke> strokes = this.mStrokes;
        int count = strokes.size();
        out.writeLong(this.mGestureID);
        out.writeInt(count);
        for (int i = 0; i < count; ++i) {
            strokes.get(i).serialize(out);
        }
    }

    static Gesture deserialize(DataInputStream in) throws IOException {
        Gesture gesture = new Gesture();
        gesture.mGestureID = in.readLong();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            gesture.addStroke(GestureStroke.deserialize(in));
        }
        return gesture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.mGestureID);
        boolean result = false;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(32768);
        DataOutputStream outStream = new DataOutputStream(byteStream);
        try {
            this.serialize(outStream);
            result = true;
        }
        catch (IOException e) {
            Log.e("Gestures", "Error writing Gesture to parcel:", e);
        }
        finally {
            GestureUtils.closeStream(outStream);
            GestureUtils.closeStream(byteStream);
        }
        if (result) {
            out.writeByteArray(byteStream.toByteArray());
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

