/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.BaseRecordingCanvas;
import android.graphics.Bitmap;
import android.graphics.CanvasProperty;
import android.graphics.Paint;
import android.graphics.RenderNode;
import android.graphics.RuntimeShader;
import android.graphics.TextureLayer;
import android.os.SystemProperties;
import android.util.Pools;
import dalvik.annotation.optimization.CriticalNative;

public final class RecordingCanvas
extends BaseRecordingCanvas {
    private static final int POOL_LIMIT = 25;
    public static final int MAX_BITMAP_SIZE = RecordingCanvas.getPanelFrameSize();
    private static final Pools.SynchronizedPool<RecordingCanvas> sPool = new Pools.SynchronizedPool(25);
    public RenderNode mNode;
    private int mWidth;
    private int mHeight;

    private static int getPanelFrameSize() {
        int DefaultSize = 0x6400000;
        return Math.max(SystemProperties.getInt("ro.hwui.max_texture_allocation_size", 0x6400000), 0x6400000);
    }

    static RecordingCanvas obtain(RenderNode node, int width2, int height2) {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        RecordingCanvas canvas = sPool.acquire();
        if (canvas == null) {
            canvas = new RecordingCanvas(node, width2, height2);
        } else {
            RecordingCanvas.nResetDisplayListCanvas(canvas.mNativeCanvasWrapper, node.mNativeRenderNode, width2, height2);
        }
        canvas.mNode = node;
        canvas.mWidth = width2;
        canvas.mHeight = height2;
        return canvas;
    }

    void recycle() {
        this.mNode = null;
        sPool.release(this);
    }

    void finishRecording(RenderNode node) {
        RecordingCanvas.nFinishRecording(this.mNativeCanvasWrapper, node.mNativeRenderNode);
    }

    private RecordingCanvas(RenderNode node, int width2, int height2) {
        super(RecordingCanvas.nCreateDisplayListCanvas(node.mNativeRenderNode, width2, height2));
        this.mDensity = 0;
    }

    @Override
    public void setDensity(int density) {
    }

    @Override
    public boolean isHardwareAccelerated() {
        return true;
    }

    @Override
    public void setBitmap(Bitmap bitmap) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public int getMaximumBitmapWidth() {
        return RecordingCanvas.nGetMaximumTextureWidth();
    }

    @Override
    public int getMaximumBitmapHeight() {
        return RecordingCanvas.nGetMaximumTextureHeight();
    }

    @Override
    public void enableZ() {
        RecordingCanvas.nEnableZ(this.mNativeCanvasWrapper, true);
    }

    @Override
    public void disableZ() {
        RecordingCanvas.nEnableZ(this.mNativeCanvasWrapper, false);
    }

    public void drawWebViewFunctor(int functor) {
        RecordingCanvas.nDrawWebViewFunctor(this.mNativeCanvasWrapper, functor);
    }

    @Override
    public void drawRenderNode(RenderNode renderNode) {
        RecordingCanvas.nDrawRenderNode(this.mNativeCanvasWrapper, renderNode.mNativeRenderNode);
    }

    public void drawTextureLayer(TextureLayer layer) {
        RecordingCanvas.nDrawTextureLayer(this.mNativeCanvasWrapper, layer.getLayerHandle());
    }

    public void drawCircle(CanvasProperty<Float> cx, CanvasProperty<Float> cy, CanvasProperty<Float> radius, CanvasProperty<Paint> paint) {
        RecordingCanvas.nDrawCircle(this.mNativeCanvasWrapper, cx.getNativeContainer(), cy.getNativeContainer(), radius.getNativeContainer(), paint.getNativeContainer());
    }

    public void drawRipple(CanvasProperty<Float> cx, CanvasProperty<Float> cy, CanvasProperty<Float> radius, CanvasProperty<Paint> paint, CanvasProperty<Float> progress, CanvasProperty<Float> turbulencePhase, int color2, RuntimeShader shader) {
        RecordingCanvas.nDrawRipple(this.mNativeCanvasWrapper, cx.getNativeContainer(), cy.getNativeContainer(), radius.getNativeContainer(), paint.getNativeContainer(), progress.getNativeContainer(), turbulencePhase.getNativeContainer(), color2, shader.getNativeShaderBuilder());
    }

    public void drawRoundRect(CanvasProperty<Float> left, CanvasProperty<Float> top, CanvasProperty<Float> right2, CanvasProperty<Float> bottom2, CanvasProperty<Float> rx, CanvasProperty<Float> ry, CanvasProperty<Paint> paint) {
        RecordingCanvas.nDrawRoundRect(this.mNativeCanvasWrapper, left.getNativeContainer(), top.getNativeContainer(), right2.getNativeContainer(), bottom2.getNativeContainer(), rx.getNativeContainer(), ry.getNativeContainer(), paint.getNativeContainer());
    }

    @Override
    protected void throwIfCannotDraw(Bitmap bitmap) {
        super.throwIfCannotDraw(bitmap);
        int bitmapSize = bitmap.getByteCount();
        if (bitmapSize > MAX_BITMAP_SIZE) {
            throw new RuntimeException("Canvas: trying to draw too large(" + bitmapSize + "bytes) bitmap.");
        }
    }

    @CriticalNative
    private static native long nCreateDisplayListCanvas(long var0, int var2, int var3);

    @CriticalNative
    private static native void nResetDisplayListCanvas(long var0, long var2, int var4, int var5);

    @CriticalNative
    private static native int nGetMaximumTextureWidth();

    @CriticalNative
    private static native int nGetMaximumTextureHeight();

    @CriticalNative
    private static native void nEnableZ(long var0, boolean var2);

    @CriticalNative
    private static native void nFinishRecording(long var0, long var2);

    @CriticalNative
    private static native void nDrawRenderNode(long var0, long var2);

    @CriticalNative
    private static native void nDrawTextureLayer(long var0, long var2);

    @CriticalNative
    private static native void nDrawCircle(long var0, long var2, long var4, long var6, long var8);

    @CriticalNative
    private static native void nDrawRipple(long var0, long var2, long var4, long var6, long var8, long var10, long var12, int var14, long var15);

    @CriticalNative
    private static native void nDrawRoundRect(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    @CriticalNative
    private static native void nDrawWebViewFunctor(long var0, int var2);
}

