/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.BitmapShader;
import android.graphics.Color;
import android.graphics.ColorSpace;
import android.graphics.Shader;
import libcore.util.NativeAllocationRegistry;

public class RuntimeShader
extends Shader {
    private long mNativeInstanceRuntimeShaderBuilder;

    public RuntimeShader(String shader) {
        super(ColorSpace.get(ColorSpace.Named.SRGB));
        if (shader == null) {
            throw new NullPointerException("RuntimeShader requires a non-null AGSL string");
        }
        this.mNativeInstanceRuntimeShaderBuilder = RuntimeShader.nativeCreateBuilder(shader);
        NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mNativeInstanceRuntimeShaderBuilder);
    }

    public void setColorUniform(String uniformName, int color2) {
        this.setUniform(uniformName, Color.valueOf(color2).getComponents(), true);
    }

    public void setColorUniform(String uniformName, long color2) {
        Color exSRGB = Color.valueOf(color2).convert(ColorSpace.get(ColorSpace.Named.EXTENDED_SRGB));
        this.setUniform(uniformName, exSRGB.getComponents(), true);
    }

    public void setColorUniform(String uniformName, Color color2) {
        if (color2 == null) {
            throw new NullPointerException("The color parameter must not be null");
        }
        Color exSRGB = color2.convert(ColorSpace.get(ColorSpace.Named.EXTENDED_SRGB));
        this.setUniform(uniformName, exSRGB.getComponents(), true);
    }

    public void setFloatUniform(String uniformName, float value2) {
        this.setFloatUniform(uniformName, value2, 0.0f, 0.0f, 0.0f, 1);
    }

    public void setFloatUniform(String uniformName, float value1, float value2) {
        this.setFloatUniform(uniformName, value1, value2, 0.0f, 0.0f, 2);
    }

    public void setFloatUniform(String uniformName, float value1, float value2, float value3) {
        this.setFloatUniform(uniformName, value1, value2, value3, 0.0f, 3);
    }

    public void setFloatUniform(String uniformName, float value1, float value2, float value3, float value4) {
        this.setFloatUniform(uniformName, value1, value2, value3, value4, 4);
    }

    public void setFloatUniform(String uniformName, float[] values2) {
        this.setUniform(uniformName, values2, false);
    }

    private void setFloatUniform(String uniformName, float value1, float value2, float value3, float value4, int count) {
        if (uniformName == null) {
            throw new NullPointerException("The uniformName parameter must not be null");
        }
        RuntimeShader.nativeUpdateUniforms(this.mNativeInstanceRuntimeShaderBuilder, uniformName, value1, value2, value3, value4, count);
        this.discardNativeInstance();
    }

    private void setUniform(String uniformName, float[] values2, boolean isColor) {
        if (uniformName == null) {
            throw new NullPointerException("The uniformName parameter must not be null");
        }
        if (values2 == null) {
            throw new NullPointerException("The uniform values parameter must not be null");
        }
        RuntimeShader.nativeUpdateUniforms(this.mNativeInstanceRuntimeShaderBuilder, uniformName, values2, isColor);
        this.discardNativeInstance();
    }

    public void setIntUniform(String uniformName, int value2) {
        this.setIntUniform(uniformName, value2, 0, 0, 0, 1);
    }

    public void setIntUniform(String uniformName, int value1, int value2) {
        this.setIntUniform(uniformName, value1, value2, 0, 0, 2);
    }

    public void setIntUniform(String uniformName, int value1, int value2, int value3) {
        this.setIntUniform(uniformName, value1, value2, value3, 0, 3);
    }

    public void setIntUniform(String uniformName, int value1, int value2, int value3, int value4) {
        this.setIntUniform(uniformName, value1, value2, value3, value4, 4);
    }

    public void setIntUniform(String uniformName, int[] values2) {
        if (uniformName == null) {
            throw new NullPointerException("The uniformName parameter must not be null");
        }
        if (values2 == null) {
            throw new NullPointerException("The uniform values parameter must not be null");
        }
        RuntimeShader.nativeUpdateUniforms(this.mNativeInstanceRuntimeShaderBuilder, uniformName, values2);
        this.discardNativeInstance();
    }

    private void setIntUniform(String uniformName, int value1, int value2, int value3, int value4, int count) {
        if (uniformName == null) {
            throw new NullPointerException("The uniformName parameter must not be null");
        }
        RuntimeShader.nativeUpdateUniforms(this.mNativeInstanceRuntimeShaderBuilder, uniformName, value1, value2, value3, value4, count);
        this.discardNativeInstance();
    }

    public void setInputShader(String shaderName, Shader shader) {
        if (shaderName == null) {
            throw new NullPointerException("The shaderName parameter must not be null");
        }
        if (shader == null) {
            throw new NullPointerException("The shader parameter must not be null");
        }
        RuntimeShader.nativeUpdateShader(this.mNativeInstanceRuntimeShaderBuilder, shaderName, shader.getNativeInstance());
        this.discardNativeInstance();
    }

    public void setInputBuffer(String shaderName, BitmapShader shader) {
        if (shaderName == null) {
            throw new NullPointerException("The shaderName parameter must not be null");
        }
        if (shader == null) {
            throw new NullPointerException("The shader parameter must not be null");
        }
        RuntimeShader.nativeUpdateShader(this.mNativeInstanceRuntimeShaderBuilder, shaderName, shader.getNativeInstanceWithDirectSampling());
        this.discardNativeInstance();
    }

    @Override
    protected long createNativeInstance(long nativeMatrix, boolean filterFromPaint) {
        return RuntimeShader.nativeCreateShader(this.mNativeInstanceRuntimeShaderBuilder, nativeMatrix);
    }

    protected long getNativeShaderBuilder() {
        return this.mNativeInstanceRuntimeShaderBuilder;
    }

    private static native long nativeGetFinalizer();

    private static native long nativeCreateBuilder(String var0);

    private static native long nativeCreateShader(long var0, long var2);

    private static native void nativeUpdateUniforms(long var0, String var2, float[] var3, boolean var4);

    private static native void nativeUpdateUniforms(long var0, String var2, float var3, float var4, float var5, float var6, int var7);

    private static native void nativeUpdateUniforms(long var0, String var2, int[] var3);

    private static native void nativeUpdateUniforms(long var0, String var2, int var3, int var4, int var5, int var6, int var7);

    private static native void nativeUpdateShader(long var0, String var2, long var3);

    private static class NoImagePreloadHolder {
        public static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(RuntimeShader.class.getClassLoader(), RuntimeShader.nativeGetFinalizer());

        private NoImagePreloadHolder() {
        }
    }
}

