/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Rect;
import java.io.OutputStream;

public class YuvImage {
    private static final int WORKING_COMPRESS_STORAGE = 4096;
    private int mFormat;
    private byte[] mData;
    private int[] mStrides;
    private int mWidth;
    private int mHeight;

    public YuvImage(byte[] yuv, int format, int width2, int height2, int[] strides) {
        if (format != 17 && format != 20) {
            throw new IllegalArgumentException("only support ImageFormat.NV21 and ImageFormat.YUY2 for now");
        }
        if (width2 <= 0 || height2 <= 0) {
            throw new IllegalArgumentException("width and height must large than 0");
        }
        if (yuv == null) {
            throw new IllegalArgumentException("yuv cannot be null");
        }
        this.mStrides = strides == null ? this.calculateStrides(width2, format) : strides;
        this.mData = yuv;
        this.mFormat = format;
        this.mWidth = width2;
        this.mHeight = height2;
    }

    public boolean compressToJpeg(Rect rectangle, int quality, OutputStream stream) {
        Rect wholeImage = new Rect(0, 0, this.mWidth, this.mHeight);
        if (!wholeImage.contains(rectangle)) {
            throw new IllegalArgumentException("rectangle is not inside the image");
        }
        if (quality < 0 || quality > 100) {
            throw new IllegalArgumentException("quality must be 0..100");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream cannot be null");
        }
        this.adjustRectangle(rectangle);
        int[] offsets = this.calculateOffsets(rectangle.left, rectangle.top);
        return YuvImage.nativeCompressToJpeg(this.mData, this.mFormat, rectangle.width(), rectangle.height(), offsets, this.mStrides, quality, stream, new byte[4096]);
    }

    public byte[] getYuvData() {
        return this.mData;
    }

    public int getYuvFormat() {
        return this.mFormat;
    }

    public int[] getStrides() {
        return this.mStrides;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    int[] calculateOffsets(int left, int top) {
        int[] offsets = null;
        if (this.mFormat == 17) {
            offsets = new int[]{top * this.mStrides[0] + left, this.mHeight * this.mStrides[0] + top / 2 * this.mStrides[1] + left / 2 * 2};
            return offsets;
        }
        if (this.mFormat == 20) {
            offsets = new int[]{top * this.mStrides[0] + left / 2 * 4};
            return offsets;
        }
        return offsets;
    }

    private int[] calculateStrides(int width2, int format) {
        int[] strides = null;
        if (format == 17) {
            strides = new int[]{width2, width2};
            return strides;
        }
        if (format == 20) {
            strides = new int[]{width2 * 2};
            return strides;
        }
        return strides;
    }

    private void adjustRectangle(Rect rect) {
        int width2 = rect.width();
        int height2 = rect.height();
        if (this.mFormat == 17) {
            rect.left &= 0xFFFFFFFE;
            rect.top &= 0xFFFFFFFE;
            rect.right = rect.left + (width2 &= 0xFFFFFFFE);
            rect.bottom = rect.top + (height2 &= 0xFFFFFFFE);
        }
        if (this.mFormat == 20) {
            rect.left &= 0xFFFFFFFE;
            rect.right = rect.left + (width2 &= 0xFFFFFFFE);
        }
    }

    private static native boolean nativeCompressToJpeg(byte[] var0, int var1, int var2, int var3, int[] var4, int[] var5, int var6, OutputStream var7, byte[] var8);
}

