/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.animation;

import android.animation.TimeInterpolator;
import android.graphics.animation.HasNativeInterpolator;
import android.graphics.animation.NativeInterpolator;
import android.graphics.animation.NativeInterpolatorFactory;
import android.view.Choreographer;

@HasNativeInterpolator
public class FallbackLUTInterpolator
implements NativeInterpolator,
TimeInterpolator {
    private static final int MAX_SAMPLE_POINTS = 300;
    private TimeInterpolator mSourceInterpolator;
    private final float[] mLut;

    public FallbackLUTInterpolator(TimeInterpolator interpolator2, long duration) {
        this.mSourceInterpolator = interpolator2;
        this.mLut = FallbackLUTInterpolator.createLUT(interpolator2, duration);
    }

    private static float[] createLUT(TimeInterpolator interpolator2, long duration) {
        long frameIntervalNanos = Choreographer.getInstance().getFrameIntervalNanos();
        int animIntervalMs = (int)(frameIntervalNanos / 1000000L);
        int numAnimFrames = Math.max(2, (int)Math.ceil((double)duration / (double)animIntervalMs));
        numAnimFrames = Math.min(numAnimFrames, 300);
        float[] values2 = new float[numAnimFrames];
        float lastFrame = numAnimFrames - 1;
        for (int i = 0; i < numAnimFrames; ++i) {
            float inValue = (float)i / lastFrame;
            values2[i] = interpolator2.getInterpolation(inValue);
        }
        return values2;
    }

    @Override
    public long createNativeInterpolator() {
        return NativeInterpolatorFactory.createLutInterpolator(this.mLut);
    }

    public static long createNativeInterpolator(TimeInterpolator interpolator2, long duration) {
        float[] lut = FallbackLUTInterpolator.createLUT(interpolator2, duration);
        return NativeInterpolatorFactory.createLutInterpolator(lut);
    }

    @Override
    public float getInterpolation(float input) {
        return this.mSourceInterpolator.getInterpolation(input);
    }
}

