/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Insets;
import android.graphics.Outline;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.util.SparseArray;

public class DrawableContainer
extends Drawable
implements Drawable.Callback {
    private static final boolean DEBUG = false;
    private static final String TAG = "DrawableContainer";
    private static final boolean DEFAULT_DITHER = true;
    @UnsupportedAppUsage
    private DrawableContainerState mDrawableContainerState;
    private Rect mHotspotBounds;
    private Drawable mCurrDrawable;
    @UnsupportedAppUsage
    private Drawable mLastDrawable;
    private int mAlpha = 255;
    private boolean mHasAlpha;
    private int mCurIndex = -1;
    private int mLastIndex = -1;
    private boolean mMutated;
    private Runnable mAnimationRunnable;
    private long mEnterAnimationEnd;
    private long mExitAnimationEnd;
    private BlockInvalidateCallback mBlockInvalidateCallback;

    @Override
    public void draw(Canvas canvas) {
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.draw(canvas);
        }
        if (this.mLastDrawable != null) {
            this.mLastDrawable.draw(canvas);
        }
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mDrawableContainerState.getChangingConfigurations();
    }

    private boolean needsMirroring() {
        return this.isAutoMirrored() && this.getLayoutDirection() == 1;
    }

    @Override
    public boolean getPadding(Rect padding) {
        boolean result;
        Rect r = this.mDrawableContainerState.getConstantPadding();
        if (r != null) {
            padding.set(r);
            result = (r.left | r.top | r.bottom | r.right) != 0;
        } else {
            result = this.mCurrDrawable != null ? this.mCurrDrawable.getPadding(padding) : super.getPadding(padding);
        }
        if (this.needsMirroring()) {
            int right2;
            int left = padding.left;
            padding.left = right2 = padding.right;
            padding.right = left;
        }
        return result;
    }

    @Override
    public Insets getOpticalInsets() {
        if (this.mCurrDrawable != null) {
            return this.mCurrDrawable.getOpticalInsets();
        }
        return Insets.NONE;
    }

    @Override
    public void getOutline(Outline outline) {
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.getOutline(outline);
        }
    }

    @Override
    public void setAlpha(int alpha) {
        if (!this.mHasAlpha || this.mAlpha != alpha) {
            this.mHasAlpha = true;
            this.mAlpha = alpha;
            if (this.mCurrDrawable != null) {
                if (this.mEnterAnimationEnd == 0L) {
                    this.mCurrDrawable.setAlpha(alpha);
                } else {
                    this.animate(false);
                }
            }
        }
    }

    @Override
    public int getAlpha() {
        return this.mAlpha;
    }

    @Override
    public void setDither(boolean dither) {
        if (this.mDrawableContainerState.mDither != dither) {
            this.mDrawableContainerState.mDither = dither;
            if (this.mCurrDrawable != null) {
                this.mCurrDrawable.setDither(this.mDrawableContainerState.mDither);
            }
        }
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mDrawableContainerState.mHasColorFilter = true;
        if (this.mDrawableContainerState.mColorFilter != colorFilter) {
            this.mDrawableContainerState.mColorFilter = colorFilter;
            if (this.mCurrDrawable != null) {
                this.mCurrDrawable.setColorFilter(colorFilter);
            }
        }
    }

    @Override
    public void setTintList(ColorStateList tint) {
        this.mDrawableContainerState.mHasTintList = true;
        if (this.mDrawableContainerState.mTintList != tint) {
            this.mDrawableContainerState.mTintList = tint;
            if (this.mCurrDrawable != null) {
                this.mCurrDrawable.setTintList(tint);
            }
        }
    }

    @Override
    public void setTintBlendMode(BlendMode blendMode) {
        this.mDrawableContainerState.mHasTintMode = true;
        if (this.mDrawableContainerState.mBlendMode != blendMode) {
            this.mDrawableContainerState.mBlendMode = blendMode;
            if (this.mCurrDrawable != null) {
                this.mCurrDrawable.setTintBlendMode(blendMode);
            }
        }
    }

    public void setEnterFadeDuration(int ms) {
        this.mDrawableContainerState.mEnterFadeDuration = ms;
    }

    public void setExitFadeDuration(int ms) {
        this.mDrawableContainerState.mExitFadeDuration = ms;
    }

    @Override
    protected void onBoundsChange(Rect bounds2) {
        if (this.mLastDrawable != null) {
            this.mLastDrawable.setBounds(bounds2);
        }
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.setBounds(bounds2);
        }
    }

    @Override
    public boolean isStateful() {
        return this.mDrawableContainerState.isStateful();
    }

    @Override
    public boolean hasFocusStateSpecified() {
        if (this.mCurrDrawable != null) {
            return this.mCurrDrawable.hasFocusStateSpecified();
        }
        if (this.mLastDrawable != null) {
            return this.mLastDrawable.hasFocusStateSpecified();
        }
        return false;
    }

    @Override
    public void setAutoMirrored(boolean mirrored) {
        if (this.mDrawableContainerState.mAutoMirrored != mirrored) {
            this.mDrawableContainerState.mAutoMirrored = mirrored;
            if (this.mCurrDrawable != null) {
                this.mCurrDrawable.setAutoMirrored(this.mDrawableContainerState.mAutoMirrored);
            }
        }
    }

    @Override
    public boolean isAutoMirrored() {
        return this.mDrawableContainerState.mAutoMirrored;
    }

    @Override
    public void jumpToCurrentState() {
        boolean changed = false;
        if (this.mLastDrawable != null) {
            this.mLastDrawable.jumpToCurrentState();
            this.mLastDrawable = null;
            this.mLastIndex = -1;
            changed = true;
        }
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.jumpToCurrentState();
            if (this.mHasAlpha) {
                this.mCurrDrawable.setAlpha(this.mAlpha);
            }
        }
        if (this.mExitAnimationEnd != 0L) {
            this.mExitAnimationEnd = 0L;
            changed = true;
        }
        if (this.mEnterAnimationEnd != 0L) {
            this.mEnterAnimationEnd = 0L;
            changed = true;
        }
        if (changed) {
            this.invalidateSelf();
        }
    }

    @Override
    public void setHotspot(float x, float y) {
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.setHotspot(x, y);
        }
    }

    @Override
    public void setHotspotBounds(int left, int top, int right2, int bottom2) {
        if (this.mHotspotBounds == null) {
            this.mHotspotBounds = new Rect(left, top, right2, bottom2);
        } else {
            this.mHotspotBounds.set(left, top, right2, bottom2);
        }
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.setHotspotBounds(left, top, right2, bottom2);
        }
    }

    @Override
    public void getHotspotBounds(Rect outRect) {
        if (this.mHotspotBounds != null) {
            outRect.set(this.mHotspotBounds);
        } else {
            super.getHotspotBounds(outRect);
        }
    }

    @Override
    protected boolean onStateChange(int[] state) {
        if (this.mLastDrawable != null) {
            return this.mLastDrawable.setState(state);
        }
        if (this.mCurrDrawable != null) {
            return this.mCurrDrawable.setState(state);
        }
        return false;
    }

    @Override
    protected boolean onLevelChange(int level) {
        if (this.mLastDrawable != null) {
            return this.mLastDrawable.setLevel(level);
        }
        if (this.mCurrDrawable != null) {
            return this.mCurrDrawable.setLevel(level);
        }
        return false;
    }

    @Override
    public boolean onLayoutDirectionChanged(int layoutDirection) {
        return this.mDrawableContainerState.setLayoutDirection(layoutDirection, this.getCurrentIndex());
    }

    @Override
    public int getIntrinsicWidth() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantWidth();
        }
        return this.mCurrDrawable != null ? this.mCurrDrawable.getIntrinsicWidth() : -1;
    }

    @Override
    public int getIntrinsicHeight() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantHeight();
        }
        return this.mCurrDrawable != null ? this.mCurrDrawable.getIntrinsicHeight() : -1;
    }

    @Override
    public int getMinimumWidth() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantMinimumWidth();
        }
        return this.mCurrDrawable != null ? this.mCurrDrawable.getMinimumWidth() : 0;
    }

    @Override
    public int getMinimumHeight() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantMinimumHeight();
        }
        return this.mCurrDrawable != null ? this.mCurrDrawable.getMinimumHeight() : 0;
    }

    @Override
    public void invalidateDrawable(Drawable who) {
        if (this.mDrawableContainerState != null) {
            this.mDrawableContainerState.invalidateCache();
        }
        if (who == this.mCurrDrawable && this.getCallback() != null) {
            this.getCallback().invalidateDrawable(this);
        }
    }

    @Override
    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        if (who == this.mCurrDrawable && this.getCallback() != null) {
            this.getCallback().scheduleDrawable(this, what, when);
        }
    }

    @Override
    public void unscheduleDrawable(Drawable who, Runnable what) {
        if (who == this.mCurrDrawable && this.getCallback() != null) {
            this.getCallback().unscheduleDrawable(this, what);
        }
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (this.mLastDrawable != null) {
            this.mLastDrawable.setVisible(visible, restart);
        }
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.setVisible(visible, restart);
        }
        return changed;
    }

    @Override
    public int getOpacity() {
        return this.mCurrDrawable == null || !this.mCurrDrawable.isVisible() ? -2 : this.mDrawableContainerState.getOpacity();
    }

    public void setCurrentIndex(int index) {
        this.selectDrawable(index);
    }

    public int getCurrentIndex() {
        return this.mCurIndex;
    }

    public boolean selectDrawable(int index) {
        if (index == this.mCurIndex) {
            return false;
        }
        long now = SystemClock.uptimeMillis();
        if (this.mDrawableContainerState.mExitFadeDuration > 0) {
            if (this.mLastDrawable != null) {
                this.mLastDrawable.setVisible(false, false);
            }
            if (this.mCurrDrawable != null) {
                this.mLastDrawable = this.mCurrDrawable;
                this.mLastIndex = this.mCurIndex;
                this.mExitAnimationEnd = now + (long)this.mDrawableContainerState.mExitFadeDuration;
            } else {
                this.mLastDrawable = null;
                this.mLastIndex = -1;
                this.mExitAnimationEnd = 0L;
            }
        } else if (this.mCurrDrawable != null) {
            this.mCurrDrawable.setVisible(false, false);
        }
        if (index >= 0 && index < this.mDrawableContainerState.mNumChildren) {
            Drawable d;
            this.mCurrDrawable = d = this.mDrawableContainerState.getChild(index);
            this.mCurIndex = index;
            if (d != null) {
                if (this.mDrawableContainerState.mEnterFadeDuration > 0) {
                    this.mEnterAnimationEnd = now + (long)this.mDrawableContainerState.mEnterFadeDuration;
                }
                this.initializeDrawableForDisplay(d);
            }
        } else {
            this.mCurrDrawable = null;
            this.mCurIndex = -1;
        }
        if (this.mEnterAnimationEnd != 0L || this.mExitAnimationEnd != 0L) {
            if (this.mAnimationRunnable == null) {
                this.mAnimationRunnable = new Runnable(){

                    @Override
                    public void run() {
                        DrawableContainer.this.animate(true);
                        DrawableContainer.this.invalidateSelf();
                    }
                };
            } else {
                this.unscheduleSelf(this.mAnimationRunnable);
            }
            this.animate(true);
        }
        this.invalidateSelf();
        return true;
    }

    private void initializeDrawableForDisplay(Drawable d) {
        if (this.mBlockInvalidateCallback == null) {
            this.mBlockInvalidateCallback = new BlockInvalidateCallback();
        }
        d.setCallback(this.mBlockInvalidateCallback.wrap(d.getCallback()));
        try {
            if (this.mDrawableContainerState.mEnterFadeDuration <= 0 && this.mHasAlpha) {
                d.setAlpha(this.mAlpha);
            }
            if (this.mDrawableContainerState.mHasColorFilter) {
                d.setColorFilter(this.mDrawableContainerState.mColorFilter);
            } else {
                if (this.mDrawableContainerState.mHasTintList) {
                    d.setTintList(this.mDrawableContainerState.mTintList);
                }
                if (this.mDrawableContainerState.mHasTintMode) {
                    d.setTintBlendMode(this.mDrawableContainerState.mBlendMode);
                }
            }
            d.setVisible(this.isVisible(), true);
            d.setDither(this.mDrawableContainerState.mDither);
            d.setState(this.getState());
            d.setLevel(this.getLevel());
            d.setBounds(this.getBounds());
            d.setLayoutDirection(this.getLayoutDirection());
            d.setAutoMirrored(this.mDrawableContainerState.mAutoMirrored);
            Rect hotspotBounds = this.mHotspotBounds;
            if (hotspotBounds != null) {
                d.setHotspotBounds(hotspotBounds.left, hotspotBounds.top, hotspotBounds.right, hotspotBounds.bottom);
            }
        }
        finally {
            d.setCallback(this.mBlockInvalidateCallback.unwrap());
        }
    }

    void animate(boolean schedule) {
        int animAlpha;
        this.mHasAlpha = true;
        long now = SystemClock.uptimeMillis();
        boolean animating = false;
        if (this.mCurrDrawable != null) {
            if (this.mEnterAnimationEnd != 0L) {
                if (this.mEnterAnimationEnd <= now) {
                    this.mCurrDrawable.setAlpha(this.mAlpha);
                    this.mEnterAnimationEnd = 0L;
                } else {
                    animAlpha = (int)((this.mEnterAnimationEnd - now) * 255L) / this.mDrawableContainerState.mEnterFadeDuration;
                    this.mCurrDrawable.setAlpha((255 - animAlpha) * this.mAlpha / 255);
                    animating = true;
                }
            }
        } else {
            this.mEnterAnimationEnd = 0L;
        }
        if (this.mLastDrawable != null) {
            if (this.mExitAnimationEnd != 0L) {
                if (this.mExitAnimationEnd <= now) {
                    this.mLastDrawable.setVisible(false, false);
                    this.mLastDrawable = null;
                    this.mLastIndex = -1;
                    this.mExitAnimationEnd = 0L;
                } else {
                    animAlpha = (int)((this.mExitAnimationEnd - now) * 255L) / this.mDrawableContainerState.mExitFadeDuration;
                    this.mLastDrawable.setAlpha(animAlpha * this.mAlpha / 255);
                    animating = true;
                }
            }
        } else {
            this.mExitAnimationEnd = 0L;
        }
        if (schedule && animating) {
            this.scheduleSelf(this.mAnimationRunnable, now + 16L);
        }
    }

    @Override
    public Drawable getCurrent() {
        return this.mCurrDrawable;
    }

    protected void updateDensity(Resources res) {
        this.mDrawableContainerState.updateDensity(res);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        this.mDrawableContainerState.applyTheme(theme);
    }

    @Override
    public boolean canApplyTheme() {
        return this.mDrawableContainerState.canApplyTheme();
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        if (this.mDrawableContainerState.canConstantState()) {
            this.mDrawableContainerState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mDrawableContainerState;
        }
        return null;
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            DrawableContainerState clone = this.cloneConstantState();
            clone.mutate();
            this.setConstantState(clone);
            this.mMutated = true;
        }
        return this;
    }

    DrawableContainerState cloneConstantState() {
        return this.mDrawableContainerState;
    }

    @Override
    public void clearMutated() {
        super.clearMutated();
        this.mDrawableContainerState.clearMutated();
        this.mMutated = false;
    }

    protected void setConstantState(DrawableContainerState state) {
        this.mDrawableContainerState = state;
        if (this.mCurIndex >= 0) {
            this.mCurrDrawable = state.getChild(this.mCurIndex);
            if (this.mCurrDrawable != null) {
                this.initializeDrawableForDisplay(this.mCurrDrawable);
            }
        }
        this.mLastIndex = -1;
        this.mLastDrawable = null;
    }

    private static class BlockInvalidateCallback
    implements Drawable.Callback {
        private Drawable.Callback mCallback;

        private BlockInvalidateCallback() {
        }

        public BlockInvalidateCallback wrap(Drawable.Callback callback2) {
            this.mCallback = callback2;
            return this;
        }

        public Drawable.Callback unwrap() {
            Drawable.Callback callback2 = this.mCallback;
            this.mCallback = null;
            return callback2;
        }

        @Override
        public void invalidateDrawable(Drawable who) {
        }

        @Override
        public void scheduleDrawable(Drawable who, Runnable what, long when) {
            if (this.mCallback != null) {
                this.mCallback.scheduleDrawable(who, what, when);
            }
        }

        @Override
        public void unscheduleDrawable(Drawable who, Runnable what) {
            if (this.mCallback != null) {
                this.mCallback.unscheduleDrawable(who, what);
            }
        }
    }

    public static abstract class DrawableContainerState
    extends Drawable.ConstantState {
        final DrawableContainer mOwner;
        Resources mSourceRes;
        int mDensity = 160;
        int mChangingConfigurations;
        int mChildrenChangingConfigurations;
        SparseArray<Drawable.ConstantState> mDrawableFutures;
        @UnsupportedAppUsage
        Drawable[] mDrawables;
        int mNumChildren;
        boolean mVariablePadding = false;
        boolean mCheckedPadding;
        @UnsupportedAppUsage
        Rect mConstantPadding;
        boolean mConstantSize = false;
        boolean mCheckedConstantSize;
        int mConstantWidth;
        int mConstantHeight;
        int mConstantMinimumWidth;
        int mConstantMinimumHeight;
        boolean mCheckedOpacity;
        int mOpacity;
        boolean mCheckedStateful;
        boolean mStateful;
        boolean mCheckedConstantState;
        boolean mCanConstantState;
        boolean mDither = true;
        boolean mMutated;
        int mLayoutDirection;
        int mEnterFadeDuration = 0;
        int mExitFadeDuration = 0;
        boolean mAutoMirrored;
        ColorFilter mColorFilter;
        @UnsupportedAppUsage
        boolean mHasColorFilter;
        ColorStateList mTintList;
        BlendMode mBlendMode;
        boolean mHasTintList;
        boolean mHasTintMode;

        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        protected DrawableContainerState(DrawableContainerState orig, DrawableContainer owner, Resources res) {
            this.mOwner = owner;
            this.mSourceRes = res != null ? res : (orig != null ? orig.mSourceRes : null);
            this.mDensity = Drawable.resolveDensity(res, orig != null ? orig.mDensity : 0);
            if (orig != null) {
                this.mChangingConfigurations = orig.mChangingConfigurations;
                this.mChildrenChangingConfigurations = orig.mChildrenChangingConfigurations;
                this.mCheckedConstantState = true;
                this.mCanConstantState = true;
                this.mVariablePadding = orig.mVariablePadding;
                this.mConstantSize = orig.mConstantSize;
                this.mDither = orig.mDither;
                this.mMutated = orig.mMutated;
                this.mLayoutDirection = orig.mLayoutDirection;
                this.mEnterFadeDuration = orig.mEnterFadeDuration;
                this.mExitFadeDuration = orig.mExitFadeDuration;
                this.mAutoMirrored = orig.mAutoMirrored;
                this.mColorFilter = orig.mColorFilter;
                this.mHasColorFilter = orig.mHasColorFilter;
                this.mTintList = orig.mTintList;
                this.mBlendMode = orig.mBlendMode;
                this.mHasTintList = orig.mHasTintList;
                this.mHasTintMode = orig.mHasTintMode;
                if (orig.mDensity == this.mDensity) {
                    if (orig.mCheckedPadding) {
                        this.mConstantPadding = new Rect(orig.mConstantPadding);
                        this.mCheckedPadding = true;
                    }
                    if (orig.mCheckedConstantSize) {
                        this.mConstantWidth = orig.mConstantWidth;
                        this.mConstantHeight = orig.mConstantHeight;
                        this.mConstantMinimumWidth = orig.mConstantMinimumWidth;
                        this.mConstantMinimumHeight = orig.mConstantMinimumHeight;
                        this.mCheckedConstantSize = true;
                    }
                }
                if (orig.mCheckedOpacity) {
                    this.mOpacity = orig.mOpacity;
                    this.mCheckedOpacity = true;
                }
                if (orig.mCheckedStateful) {
                    this.mStateful = orig.mStateful;
                    this.mCheckedStateful = true;
                }
                Drawable[] origDr = orig.mDrawables;
                this.mDrawables = new Drawable[origDr.length];
                this.mNumChildren = orig.mNumChildren;
                SparseArray<Drawable.ConstantState> origDf = orig.mDrawableFutures;
                this.mDrawableFutures = origDf != null ? origDf.clone() : new SparseArray(this.mNumChildren);
                int N = this.mNumChildren;
                for (int i = 0; i < N; ++i) {
                    if (origDr[i] == null) continue;
                    Drawable.ConstantState cs = origDr[i].getConstantState();
                    if (cs != null) {
                        this.mDrawableFutures.put(i, cs);
                        continue;
                    }
                    this.mDrawables[i] = origDr[i];
                }
            } else {
                this.mDrawables = new Drawable[10];
                this.mNumChildren = 0;
            }
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations | this.mChildrenChangingConfigurations;
        }

        public int addChild(Drawable dr) {
            int pos = this.mNumChildren;
            if (pos >= this.mDrawables.length) {
                this.growArray(pos, pos + 10);
            }
            dr.mutate();
            dr.setVisible(false, true);
            dr.setCallback(this.mOwner);
            this.mDrawables[pos] = dr;
            ++this.mNumChildren;
            this.mChildrenChangingConfigurations |= dr.getChangingConfigurations();
            this.invalidateCache();
            this.mConstantPadding = null;
            this.mCheckedPadding = false;
            this.mCheckedConstantSize = false;
            this.mCheckedConstantState = false;
            return pos;
        }

        void invalidateCache() {
            this.mCheckedOpacity = false;
            this.mCheckedStateful = false;
        }

        int getCapacity() {
            return this.mDrawables.length;
        }

        private void createAllFutures() {
            if (this.mDrawableFutures != null) {
                int futureCount = this.mDrawableFutures.size();
                for (int keyIndex = 0; keyIndex < futureCount; ++keyIndex) {
                    int index = this.mDrawableFutures.keyAt(keyIndex);
                    Drawable.ConstantState cs = this.mDrawableFutures.valueAt(keyIndex);
                    this.mDrawables[index] = this.prepareDrawable(cs.newDrawable(this.mSourceRes));
                }
                this.mDrawableFutures = null;
            }
        }

        private Drawable prepareDrawable(Drawable child) {
            child.setLayoutDirection(this.mLayoutDirection);
            child = child.mutate();
            child.setCallback(this.mOwner);
            return child;
        }

        public int getChildCount() {
            return this.mNumChildren;
        }

        public Drawable[] getChildren() {
            this.createAllFutures();
            return this.mDrawables;
        }

        public Drawable getChild(int index) {
            int keyIndex;
            Drawable result = this.mDrawables[index];
            if (result != null) {
                return result;
            }
            if (this.mDrawableFutures != null && (keyIndex = this.mDrawableFutures.indexOfKey(index)) >= 0) {
                Drawable prepared;
                Drawable.ConstantState cs = this.mDrawableFutures.valueAt(keyIndex);
                this.mDrawables[index] = prepared = this.prepareDrawable(cs.newDrawable(this.mSourceRes));
                this.mDrawableFutures.removeAt(keyIndex);
                if (this.mDrawableFutures.size() == 0) {
                    this.mDrawableFutures = null;
                }
                return prepared;
            }
            return null;
        }

        boolean setLayoutDirection(int layoutDirection, int currentIndex) {
            boolean changed = false;
            int N = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            for (int i = 0; i < N; ++i) {
                if (drawables[i] == null) continue;
                boolean childChanged = drawables[i].setLayoutDirection(layoutDirection);
                if (i != currentIndex) continue;
                changed = childChanged;
            }
            this.mLayoutDirection = layoutDirection;
            return changed;
        }

        void updateDensity(Resources res) {
            if (res != null) {
                this.mSourceRes = res;
                int targetDensity = Drawable.resolveDensity(res, this.mDensity);
                int sourceDensity = this.mDensity;
                this.mDensity = targetDensity;
                if (sourceDensity != targetDensity) {
                    this.mCheckedConstantSize = false;
                    this.mCheckedPadding = false;
                }
            }
        }

        void applyTheme(Resources.Theme theme) {
            if (theme != null) {
                this.createAllFutures();
                int N = this.mNumChildren;
                Drawable[] drawables = this.mDrawables;
                for (int i = 0; i < N; ++i) {
                    if (drawables[i] == null || !drawables[i].canApplyTheme()) continue;
                    drawables[i].applyTheme(theme);
                    this.mChildrenChangingConfigurations |= drawables[i].getChangingConfigurations();
                }
                this.updateDensity(theme.getResources());
            }
        }

        @Override
        public boolean canApplyTheme() {
            int N = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            for (int i = 0; i < N; ++i) {
                Drawable.ConstantState future;
                Drawable d = drawables[i];
                if (!(d != null ? d.canApplyTheme() : (future = this.mDrawableFutures.get(i)) != null && future.canApplyTheme())) continue;
                return true;
            }
            return false;
        }

        private void mutate() {
            int N = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            for (int i = 0; i < N; ++i) {
                if (drawables[i] == null) continue;
                drawables[i].mutate();
            }
            this.mMutated = true;
        }

        void clearMutated() {
            int N = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            for (int i = 0; i < N; ++i) {
                if (drawables[i] == null) continue;
                drawables[i].clearMutated();
            }
            this.mMutated = false;
        }

        public void setVariablePadding(boolean variable) {
            this.mVariablePadding = variable;
        }

        public Rect getConstantPadding() {
            if (this.mVariablePadding) {
                return null;
            }
            if (this.mConstantPadding != null || this.mCheckedPadding) {
                return this.mConstantPadding;
            }
            this.createAllFutures();
            Rect r = null;
            Rect t = new Rect();
            int N = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            for (int i = 0; i < N; ++i) {
                if (!drawables[i].getPadding(t)) continue;
                if (r == null) {
                    r = new Rect(0, 0, 0, 0);
                }
                if (t.left > r.left) {
                    r.left = t.left;
                }
                if (t.top > r.top) {
                    r.top = t.top;
                }
                if (t.right > r.right) {
                    r.right = t.right;
                }
                if (t.bottom <= r.bottom) continue;
                r.bottom = t.bottom;
            }
            this.mCheckedPadding = true;
            this.mConstantPadding = r;
            return this.mConstantPadding;
        }

        public void setConstantSize(boolean constant) {
            this.mConstantSize = constant;
        }

        public boolean isConstantSize() {
            return this.mConstantSize;
        }

        public int getConstantWidth() {
            if (!this.mCheckedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantWidth;
        }

        public int getConstantHeight() {
            if (!this.mCheckedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantHeight;
        }

        public int getConstantMinimumWidth() {
            if (!this.mCheckedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantMinimumWidth;
        }

        public int getConstantMinimumHeight() {
            if (!this.mCheckedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantMinimumHeight;
        }

        protected void computeConstantSize() {
            this.mCheckedConstantSize = true;
            this.createAllFutures();
            int N = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            this.mConstantHeight = -1;
            this.mConstantWidth = -1;
            this.mConstantMinimumHeight = 0;
            this.mConstantMinimumWidth = 0;
            for (int i = 0; i < N; ++i) {
                Drawable dr = drawables[i];
                int s = dr.getIntrinsicWidth();
                if (s > this.mConstantWidth) {
                    this.mConstantWidth = s;
                }
                if ((s = dr.getIntrinsicHeight()) > this.mConstantHeight) {
                    this.mConstantHeight = s;
                }
                if ((s = dr.getMinimumWidth()) > this.mConstantMinimumWidth) {
                    this.mConstantMinimumWidth = s;
                }
                if ((s = dr.getMinimumHeight()) <= this.mConstantMinimumHeight) continue;
                this.mConstantMinimumHeight = s;
            }
        }

        public void setEnterFadeDuration(int duration) {
            this.mEnterFadeDuration = duration;
        }

        public int getEnterFadeDuration() {
            return this.mEnterFadeDuration;
        }

        public void setExitFadeDuration(int duration) {
            this.mExitFadeDuration = duration;
        }

        public int getExitFadeDuration() {
            return this.mExitFadeDuration;
        }

        public int getOpacity() {
            if (this.mCheckedOpacity) {
                return this.mOpacity;
            }
            this.createAllFutures();
            int N = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            int op = N > 0 ? drawables[0].getOpacity() : -2;
            for (int i = 1; i < N; ++i) {
                op = Drawable.resolveOpacity(op, drawables[i].getOpacity());
            }
            this.mOpacity = op;
            this.mCheckedOpacity = true;
            return op;
        }

        public boolean isStateful() {
            if (this.mCheckedStateful) {
                return this.mStateful;
            }
            this.createAllFutures();
            int N = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            boolean isStateful = false;
            for (int i = 0; i < N; ++i) {
                if (!drawables[i].isStateful()) continue;
                isStateful = true;
                break;
            }
            this.mStateful = isStateful;
            this.mCheckedStateful = true;
            return isStateful;
        }

        public void growArray(int oldSize, int newSize) {
            Drawable[] newDrawables = new Drawable[newSize];
            System.arraycopy(this.mDrawables, 0, newDrawables, 0, oldSize);
            this.mDrawables = newDrawables;
        }

        public synchronized boolean canConstantState() {
            if (this.mCheckedConstantState) {
                return this.mCanConstantState;
            }
            this.createAllFutures();
            this.mCheckedConstantState = true;
            int N = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            for (int i = 0; i < N; ++i) {
                if (drawables[i].getConstantState() != null) continue;
                this.mCanConstantState = false;
                return false;
            }
            this.mCanConstantState = true;
            return true;
        }
    }
}

