/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Picture;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;

public class PictureDrawable
extends Drawable {
    private Picture mPicture;

    public PictureDrawable(Picture picture) {
        this.mPicture = picture;
    }

    public Picture getPicture() {
        return this.mPicture;
    }

    public void setPicture(Picture picture) {
        this.mPicture = picture;
    }

    @Override
    public void draw(Canvas canvas) {
        if (this.mPicture != null) {
            Rect bounds2 = this.getBounds();
            canvas.save();
            canvas.clipRect(bounds2);
            canvas.translate(bounds2.left, bounds2.top);
            canvas.drawPicture(this.mPicture);
            canvas.restore();
        }
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mPicture != null ? this.mPicture.getWidth() : -1;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mPicture != null ? this.mPicture.getHeight() : -1;
    }

    @Override
    public int getOpacity() {
        return -3;
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
    }

    @Override
    public void setAlpha(int alpha) {
    }
}

