/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable.shapes;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.shapes.Shape;
import java.util.Objects;

public class PathShape
extends Shape {
    private final float mStdWidth;
    private final float mStdHeight;
    private Path mPath;
    private float mScaleX;
    private float mScaleY;

    public PathShape(Path path, float stdWidth, float stdHeight) {
        this.mPath = path;
        this.mStdWidth = stdWidth;
        this.mStdHeight = stdHeight;
    }

    @Override
    public void draw(Canvas canvas, Paint paint) {
        canvas.save();
        canvas.scale(this.mScaleX, this.mScaleY);
        canvas.drawPath(this.mPath, paint);
        canvas.restore();
    }

    @Override
    protected void onResize(float width2, float height2) {
        this.mScaleX = width2 / this.mStdWidth;
        this.mScaleY = height2 / this.mStdHeight;
    }

    @Override
    public PathShape clone() throws CloneNotSupportedException {
        PathShape shape2 = (PathShape)super.clone();
        shape2.mPath = new Path(this.mPath);
        return shape2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PathShape pathShape = (PathShape)o;
        return Float.compare(pathShape.mStdWidth, this.mStdWidth) == 0 && Float.compare(pathShape.mStdHeight, this.mStdHeight) == 0 && Float.compare(pathShape.mScaleX, this.mScaleX) == 0 && Float.compare(pathShape.mScaleY, this.mScaleY) == 0 && Objects.equals(this.mPath, pathShape.mPath);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Float.valueOf(this.mStdWidth), Float.valueOf(this.mStdHeight), this.mPath, Float.valueOf(this.mScaleX), Float.valueOf(this.mScaleY));
    }
}

