/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable.shapes;

import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.shapes.Shape;
import java.util.Objects;

public class RectShape
extends Shape {
    private RectF mRect = new RectF();

    @Override
    public void draw(Canvas canvas, Paint paint) {
        canvas.drawRect(this.mRect, paint);
    }

    @Override
    public void getOutline(Outline outline) {
        RectF rect = this.rect();
        outline.setRect((int)Math.ceil(rect.left), (int)Math.ceil(rect.top), (int)Math.floor(rect.right), (int)Math.floor(rect.bottom));
    }

    @Override
    protected void onResize(float width2, float height2) {
        this.mRect.set(0.0f, 0.0f, width2, height2);
    }

    protected RectF rect() {
        return this.mRect;
    }

    @Override
    public RectShape clone() throws CloneNotSupportedException {
        RectShape shape2 = (RectShape)super.clone();
        shape2.mRect = new RectF(this.mRect);
        return shape2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RectShape rectShape = (RectShape)o;
        return Objects.equals(this.mRect, rectShape.mRect);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mRect);
    }
}

